/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.addrbook.msoutlook.calendar;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import net.java.sip.communicator.plugin.addrbook.AddrBookActivator;
import net.java.sip.communicator.plugin.addrbook.msoutlook.calendar.CalendarServiceImpl;
import net.java.sip.communicator.plugin.addrbook.msoutlook.calendar.RecurringPattern;
import net.java.sip.communicator.service.calendar.CalendarService;

public class CalendarItemTimerTask {
    private final CalendarService.BusyStatusEnum state;
    private final Date startDate;
    private final Date endDate;
    private final String id;
    private final boolean executeNow;
    private final CalendarServiceImpl calendarService = AddrBookActivator.getCalendarService();
    private static Timer timer = new Timer();
    private RecurringPattern pattern;
    private TimerTask startTask = new TimerTask(){

        @Override
        public void run() {
            CalendarItemTimerTask.this.start();
        }
    };
    private TimerTask endTask = new TimerTask(){

        @Override
        public void run() {
            CalendarItemTimerTask.this.stop();
        }
    };

    public CalendarItemTimerTask(CalendarService.BusyStatusEnum state, Date startDate, Date endDate, String id, boolean executeNow, RecurringPattern pattern) {
        this.state = state;
        this.startDate = startDate;
        this.endDate = endDate;
        this.id = id;
        this.calendarService.addToTaskMap(id, this);
        this.executeNow = executeNow;
        this.pattern = pattern;
    }

    public RecurringPattern getPattern() {
        return this.pattern;
    }

    public String getId() {
        return this.id;
    }

    protected void start() {
        this.calendarService.addToCurrentItems(this);
        this.calendarService.updateStateFromCurrentItems();
    }

    protected void stop() {
        this.calendarService.removeFromTaskMap(this.id);
        this.calendarService.removeFromCurrentItems(this);
        this.calendarService.updateStateFromCurrentItems();
        if (this.pattern != null) {
            CalendarItemTimerTask nextTask = this.pattern.next(this.startDate, this.endDate);
            this.pattern = null;
            nextTask.scheduleTasks();
        }
    }

    public void scheduleTasks() {
        if (!this.executeNow) {
            timer.schedule(this.startTask, this.startDate);
        } else {
            this.startTask.run();
        }
        timer.schedule(this.endTask, this.endDate);
    }

    public void remove() {
        this.startTask.cancel();
        this.endTask.cancel();
        this.calendarService.removeFromTaskMap(this.id);
        this.calendarService.removeFromCurrentItems(this);
        this.calendarService.updateStateFromCurrentItems();
    }

    public CalendarService.BusyStatusEnum getStatus() {
        return this.state;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setPattern(RecurringPattern pattern) {
        this.pattern = pattern;
    }
}

