/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.jabberaccregwizz;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.java.sip.communicator.plugin.desktoputil.PasswordChangeDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.TrimTextField;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberAccRegWizzActivator;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberAccountCreationFormService;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberAccountRegistrationForm;
import net.java.sip.communicator.plugin.jabberaccregwizz.Resources;
import net.java.sip.communicator.plugin.jabberaccregwizz.ValidatingPanel;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetChangePassword;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.TransportProtocol;
import net.java.sip.communicator.util.Logger;

public class AccountPanel
extends TransparentPanel
implements DocumentListener,
ValidatingPanel {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(AccountPanel.class);
    private final JPanel userIDPassPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private final JPanel labelsPanel = new TransparentPanel();
    private final JPanel valuesPanel = new TransparentPanel();
    private final JLabel passLabel = new JLabel(Resources.getString("service.gui.PASSWORD"));
    private final JPanel emptyPanel = new TransparentPanel();
    final JTextField userIDField = new TrimTextField();
    private final JPasswordField passField = new JPasswordField();
    private final JCheckBox rememberPassBox = new SIPCommCheckBox(Resources.getString("service.gui.REMEMBER_PASSWORD"));
    private final JPanel changePasswordPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private final JButton changePasswordButton = new JButton(Resources.getString("plugin.jabberaccregwizz.CHANGE_PASSWORD"));
    private final JEditorPane changePasswordMessagePane = new JEditorPane();
    private final JabberAccountRegistrationForm parentForm;
    private final JRadioButton existingAccountButton;
    private final JRadioButton createAccountButton;
    private final JPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
    private Component registrationForm;
    private Component registerChoicePanel;

    public AccountPanel(JabberAccountRegistrationForm parentForm) {
        super((LayoutManager)new BorderLayout());
        this.parentForm = parentForm;
        this.parentForm.addValidatingPanel(this);
        JLabel userIDLabel = new JLabel(parentForm.getUsernameLabel());
        JLabel userIDExampleLabel = new JLabel(parentForm.getUsernameExample());
        this.labelsPanel.setLayout(new BoxLayout(this.labelsPanel, 1));
        this.valuesPanel.setLayout(new BoxLayout(this.valuesPanel, 1));
        this.userIDField.getDocument().addDocumentListener(this);
        this.rememberPassBox.setSelected(true);
        this.existingAccountButton = new JRadioButton(parentForm.getExistingAccountLabel());
        this.createAccountButton = new JRadioButton(parentForm.getCreateAccountLabel());
        userIDExampleLabel.setForeground(Color.GRAY);
        userIDExampleLabel.setFont(userIDExampleLabel.getFont().deriveFont(8));
        this.emptyPanel.setMaximumSize(new Dimension(40, 35));
        userIDExampleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.labelsPanel.add(userIDLabel);
        this.labelsPanel.add(this.emptyPanel);
        this.labelsPanel.add(this.passLabel);
        this.valuesPanel.add(this.userIDField);
        this.valuesPanel.add(userIDExampleLabel);
        this.valuesPanel.add(this.passField);
        this.userIDPassPanel.add((Component)this.labelsPanel, "West");
        this.userIDPassPanel.add((Component)this.valuesPanel, "Center");
        this.userIDPassPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.jabberaccregwizz.USERNAME_AND_PASSWORD")));
        TransparentPanel southPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        southPanel.add((Component)this.rememberPassBox, "West");
        String homeLinkString = parentForm.getHomeLinkLabel();
        if (homeLinkString != null && homeLinkString.length() > 0) {
            String homeLink = Resources.getSettingsString("service.gui.APPLICATION_WEB_SITE");
            southPanel.add(this.createHomeLink(homeLinkString, homeLink), "East");
        }
        this.userIDPassPanel.add((Component)southPanel, "South");
        this.changePasswordPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.jabberaccregwizz.CHANGE_PASSWORD")));
        this.changePasswordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JabberPasswordChangeDialog passwordChangeDialog = new JabberPasswordChangeDialog();
                passwordChangeDialog.setVisible(true);
            }
        });
        this.changePasswordMessagePane.setOpaque(false);
        this.changePasswordMessagePane.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 0));
        this.changePasswordMessagePane.setEditable(false);
        this.changePasswordPanel.add((Component)this.changePasswordMessagePane, "North");
        this.changePasswordPanel.add((Component)this.changePasswordButton, "South");
        this.changePasswordPanel.setVisible(false);
        this.add(this.mainPanel, "North");
    }

    private Component createRegisterChoicePanel() {
        TransparentPanel registerChoicePanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
        this.existingAccountButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AccountPanel.this.existingAccountButton.isSelected()) {
                    AccountPanel.this.mainPanel.remove(AccountPanel.this.registrationForm);
                    AccountPanel.this.mainPanel.add((Component)AccountPanel.this.userIDPassPanel, "Center");
                    Window window = SwingUtilities.getWindowAncestor((Component)((Object)AccountPanel.this));
                    if (window != null) {
                        window.pack();
                    }
                }
            }
        });
        this.createAccountButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AccountPanel.this.createAccountButton.isSelected()) {
                    AccountPanel.this.mainPanel.remove(AccountPanel.this.userIDPassPanel);
                    AccountPanel.this.mainPanel.add(AccountPanel.this.registrationForm, "Center");
                    SwingUtilities.getWindowAncestor((Component)((Object)AccountPanel.this)).pack();
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        this.existingAccountButton.setOpaque(false);
        this.createAccountButton.setOpaque(false);
        buttonGroup.add(this.existingAccountButton);
        buttonGroup.add(this.createAccountButton);
        registerChoicePanel.add(this.existingAccountButton);
        registerChoicePanel.add(this.createAccountButton);
        this.existingAccountButton.setSelected(true);
        return registerChoicePanel;
    }

    private Component createHomeLink(String homeLinkText, final String homeLink) {
        JLabel homeLinkLabel = new JLabel("<html><a href='" + homeLink + "'>" + homeLinkText + "</a></html>", 4);
        homeLinkLabel.setFont(homeLinkLabel.getFont().deriveFont(10.0f));
        homeLinkLabel.setCursor(new Cursor(12));
        homeLinkLabel.setToolTipText(Resources.getString("plugin.simpleaccregwizz.SPECIAL_SIGNUP"));
        homeLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                try {
                    JabberAccRegWizzActivator.getBrowserLauncher().openURL(homeLink);
                }
                catch (UnsupportedOperationException ex) {
                    logger.error((Object)"The web sign up is not supported.", (Throwable)ex);
                }
            }
        });
        return homeLinkLabel;
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.parentForm.setServerFieldAccordingToUIN(this.userIDField.getText());
        this.parentForm.reValidateInput();
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.parentForm.setServerFieldAccordingToUIN(this.userIDField.getText());
        this.parentForm.reValidateInput();
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
    }

    String getUsername() {
        return this.userIDField.getText();
    }

    void setUsername(String username) {
        this.userIDField.setText(username);
    }

    char[] getPassword() {
        return this.passField.getPassword();
    }

    void setPassword(String password) {
        this.passField.setText(password);
    }

    boolean isRememberPassword() {
        return this.rememberPassBox.isSelected();
    }

    void setRememberPassword(boolean isRemember) {
        this.rememberPassBox.setSelected(isRemember);
    }

    @Override
    public boolean isValidated() {
        return this.userIDField.getText() != null && this.userIDField.getText().length() > 0;
    }

    void setSimpleForm(boolean isSimpleForm) {
        JabberAccountCreationFormService createAccountService = this.parentForm.getCreateAccountService();
        this.mainPanel.removeAll();
        if (isSimpleForm) {
            if (createAccountService != null) {
                this.registrationForm = createAccountService.getForm();
                this.registerChoicePanel = this.createRegisterChoicePanel();
                this.mainPanel.add(this.registerChoicePanel, "North");
            } else {
                String createAccountString;
                TransparentPanel registerPanel = new TransparentPanel();
                registerPanel.setLayout(new BoxLayout((Container)registerPanel, 1));
                String createAccountInfoString = this.parentForm.getCreateAccountLabel();
                if (createAccountInfoString != null && createAccountInfoString.length() > 0) {
                    registerPanel.add(this.createRegisterArea(createAccountInfoString));
                }
                if ((createAccountString = this.parentForm.getCreateAccountButtonLabel()) != null && createAccountString.length() > 0) {
                    TransparentPanel buttonPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
                    buttonPanel.add(this.createRegisterButton(createAccountString));
                    registerPanel.add((Component)buttonPanel);
                }
                this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
                this.mainPanel.add(this.userIDPassPanel);
            }
        } else {
            this.mainPanel.add((Component)this.userIDPassPanel, "North");
            this.mainPanel.add((Component)this.changePasswordPanel, "South");
        }
    }

    boolean isCreateAccount() {
        return this.createAccountButton.isSelected();
    }

    private Component createRegisterArea(String text) {
        JEditorPane registerArea = new JEditorPane();
        registerArea.setAlignmentX(0.5f);
        registerArea.setOpaque(false);
        registerArea.setContentType("text/html");
        registerArea.setEditable(false);
        registerArea.setText(text);
        registerArea.putClientProperty("JEditorPane.honorDisplayProperties", true);
        registerArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    JabberAccRegWizzActivator.getBrowserLauncher().openURL(e.getURL().toString());
                }
            }
        });
        return registerArea;
    }

    private Component createRegisterButton(String text) {
        JButton registerButton = new JButton(text);
        registerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Reg OK");
                }
                if (AccountPanel.this.parentForm.isWebSignupSupported()) {
                    AccountPanel.this.parentForm.webSignup();
                }
            }
        });
        return registerButton;
    }

    public void showChangePasswordPanel(boolean show) {
        if (!show) {
            this.changePasswordPanel.setVisible(false);
            return;
        }
        ProtocolProviderService protocolProvider = this.parentForm.getWizard().getProtocolProvider();
        this.changePasswordButton.setEnabled(false);
        if (protocolProvider == null) {
            logger.warn((Object)"protocolProvider is null");
            this.changePasswordMessagePane.setText("Cannot change password for this account");
        } else if (!protocolProvider.isRegistered()) {
            this.changePasswordMessagePane.setText(Resources.getString("plugin.jabberaccregwizz.HAS_TO_BE_LOGGED_IN"));
        } else if (!((OperationSetChangePassword)protocolProvider.getOperationSet(OperationSetChangePassword.class)).supportsPasswordChange()) {
            this.changePasswordMessagePane.setText(Resources.getString("plugin.jabberaccregwizz.SERVER_NOT_SUPPORT_PASSWORD_CHANGE"));
        } else {
            this.changePasswordMessagePane.setVisible(false);
            this.changePasswordButton.setEnabled(true);
        }
        this.changePasswordPanel.setVisible(true);
    }

    private class JabberPasswordChangeDialog
    extends PasswordChangeDialog {
        private final ActionListener okButtonListener;

        public JabberPasswordChangeDialog() {
            super(false);
            this.okButtonListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newPass = JabberPasswordChangeDialog.this.getNewPassword();
                    ProtocolProviderService protocolProvider = AccountPanel.this.parentForm.getWizard().getProtocolProvider();
                    if (protocolProvider == null) {
                        logger.warn((Object)"protocolProvider is null in change password dialog");
                        JabberPasswordChangeDialog.this.displayPopupError("Could not change password");
                        return;
                    }
                    if (!protocolProvider.isRegistered()) {
                        JabberPasswordChangeDialog.this.displayPopupError(Resources.getString("plugin.jabberaccregwizz.HAS_TO_BE_LOGGED_IN"));
                        return;
                    }
                    if (protocolProvider.getTransportProtocol() != TransportProtocol.TLS) {
                        JabberPasswordChangeDialog.this.displayPopupError(Resources.getString("plugin.jabberaccregwizz.TLS_REQUIRED"));
                        return;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Trying to change password for jabber account " + protocolProvider.getAccountID().getAccountAddress()));
                    }
                    OperationSetChangePassword opset = (OperationSetChangePassword)protocolProvider.getOperationSet(OperationSetChangePassword.class);
                    try {
                        opset.changePassword(newPass);
                        if (AccountPanel.this.isRememberPassword()) {
                            try {
                                if (logger.isInfoEnabled()) {
                                    logger.info((Object)("Storing new password for account " + protocolProvider.getAccountID().getAccountAddress()));
                                }
                                JabberPasswordChangeDialog.this.storeNewPassword(newPass);
                            }
                            catch (IllegalArgumentException ex) {
                                logger.warn((Object)("Failed to store password for account " + protocolProvider.getAccountID().getAccountAddress()), (Throwable)ex);
                                JabberPasswordChangeDialog.this.displayPopupError(Resources.getString("plugin.jabberaccregwizz.PASSWORD_NOT_STORED"));
                            }
                        }
                        AccountPanel.this.passField.setText(newPass);
                        JabberPasswordChangeDialog.this.displayPopupInfo(Resources.getString("plugin.jabberaccregwizz.PASSWORD_CHANGED"));
                        JabberPasswordChangeDialog.this.dispose();
                    }
                    catch (IllegalStateException ex) {
                        JabberPasswordChangeDialog.this.displayPopupError(Resources.getString("plugin.jabberaccregwizz.HAS_TO_BE_LOGGED_IN"));
                    }
                    catch (OperationFailedException ex) {
                        JabberPasswordChangeDialog.this.displayPopupError(Resources.getString("plugin.jabberaccregwizz.SERVER_NOT_SUPPORT_PASSWORD_CHANGE"));
                    }
                }
            };
            this.setTitle(Resources.getString("plugin.jabberaccregwizz.CHANGE_PASSWORD"));
            this.setInfoText(Resources.getString("plugin.jabberaccregwizz.ENTER_NEW_PASSWORD"));
            this.getOkButton().addActionListener(this.okButtonListener);
        }

        void storeNewPassword(String newPass) throws IllegalArgumentException {
            AccountID accountID = AccountPanel.this.parentForm.getWizard().getProtocolProvider().getAccountID();
            ProtocolProviderFactory protocolProviderFactory = JabberAccRegWizzActivator.getJabberProtocolProviderFactory();
            protocolProviderFactory.storePassword(accountID, newPass);
        }
    }
}

