/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.io.messages;

import java.util.Arrays;
import javax.crypto.interfaces.DHPublicKey;
import net.java.otr4j.io.messages.AbstractEncodedMessage;
import net.java.otr4j.io.messages.MysteriousT;

public class DataMessage
extends AbstractEncodedMessage {
    public byte[] mac;
    public byte[] oldMACKeys;
    public int flags;
    public int senderKeyID;
    public int recipientKeyID;
    public DHPublicKey nextDH;
    public byte[] ctr;
    public byte[] encryptedMessage;

    public DataMessage(int protocolVersion, int flags, int senderKeyID, int recipientKeyID, DHPublicKey nextDH, byte[] ctr, byte[] encryptedMessage, byte[] mac, byte[] oldMacKeys) {
        super(3, protocolVersion);
        this.flags = flags;
        this.senderKeyID = senderKeyID;
        this.recipientKeyID = recipientKeyID;
        this.nextDH = nextDH;
        this.ctr = ctr;
        this.encryptedMessage = encryptedMessage;
        this.mac = mac;
        this.oldMACKeys = oldMacKeys;
    }

    public DataMessage(MysteriousT t, byte[] mac, byte[] oldMacKeys) {
        this(t.protocolVersion, t.flags, t.senderKeyID, t.recipientKeyID, t.nextDH, t.ctr, t.encryptedMessage, mac, oldMacKeys);
    }

    public MysteriousT getT() {
        return new MysteriousT(this.protocolVersion, this.senderInstanceTag, this.receiverInstanceTag, this.flags, this.senderKeyID, this.recipientKeyID, this.nextDH, this.ctr, this.encryptedMessage);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.ctr);
        result = 31 * result + Arrays.hashCode(this.encryptedMessage);
        result = 31 * result + this.flags;
        result = 31 * result + Arrays.hashCode(this.mac);
        result = 31 * result + (this.nextDH == null ? 0 : this.nextDH.hashCode());
        result = 31 * result + Arrays.hashCode(this.oldMACKeys);
        result = 31 * result + this.recipientKeyID;
        result = 31 * result + this.senderKeyID;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataMessage other = (DataMessage)obj;
        if (!Arrays.equals(this.ctr, other.ctr)) {
            return false;
        }
        if (!Arrays.equals(this.encryptedMessage, other.encryptedMessage)) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (!Arrays.equals(this.mac, other.mac)) {
            return false;
        }
        if (this.nextDH == null ? other.nextDH != null : !this.nextDH.equals(other.nextDH)) {
            return false;
        }
        if (!Arrays.equals(this.oldMACKeys, other.oldMACKeys)) {
            return false;
        }
        if (this.recipientKeyID != other.recipientKeyID) {
            return false;
        }
        return this.senderKeyID == other.senderKeyID;
    }
}

