/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUTextureViewDescriptor.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSGPUTextureAspect.h"
#include "JSGPUTextureFormat.h"
#include "JSGPUTextureViewDimension.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUTextureViewDescriptor convertDictionary<GPUTextureViewDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUTextureViewDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!labelValue.isUndefined()) {
        result.label = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue arrayLayerCountValue;
    if (isNullOrUndefined)
        arrayLayerCountValue = jsUndefined();
    else {
        arrayLayerCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "arrayLayerCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!arrayLayerCountValue.isUndefined()) {
        result.arrayLayerCount = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, arrayLayerCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue aspectValue;
    if (isNullOrUndefined)
        aspectValue = jsUndefined();
    else {
        aspectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "aspect"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!aspectValue.isUndefined()) {
        result.aspect = convert<IDLEnumeration<GPUTextureAspect>>(lexicalGlobalObject, aspectValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.aspect = GPUTextureAspect::All;
    JSValue baseArrayLayerValue;
    if (isNullOrUndefined)
        baseArrayLayerValue = jsUndefined();
    else {
        baseArrayLayerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "baseArrayLayer"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!baseArrayLayerValue.isUndefined()) {
        result.baseArrayLayer = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, baseArrayLayerValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.baseArrayLayer = 0;
    JSValue baseMipLevelValue;
    if (isNullOrUndefined)
        baseMipLevelValue = jsUndefined();
    else {
        baseMipLevelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "baseMipLevel"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!baseMipLevelValue.isUndefined()) {
        result.baseMipLevel = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, baseMipLevelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.baseMipLevel = 0;
    JSValue dimensionValue;
    if (isNullOrUndefined)
        dimensionValue = jsUndefined();
    else {
        dimensionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dimension"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dimensionValue.isUndefined()) {
        result.dimension = convert<IDLEnumeration<GPUTextureViewDimension>>(lexicalGlobalObject, dimensionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue mipLevelCountValue;
    if (isNullOrUndefined)
        mipLevelCountValue = jsUndefined();
    else {
        mipLevelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mipLevelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mipLevelCountValue.isUndefined()) {
        result.mipLevelCount = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, mipLevelCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

} // namespace WebCore
