/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSStyleDeclaration.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSCSSRule.h"
#include "JSCSSRuleList.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDeprecatedCSSOMValue.h"
#include "Quirks.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/ArrayPrototype.h>
#include <JavaScriptCore/BuiltinNames.h>
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/PropertyNameArray.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleDeclarationPrototypeFunction_item);
static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleDeclarationPrototypeFunction_getPropertyValue);
static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleDeclarationPrototypeFunction_getPropertyPriority);
static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleDeclarationPrototypeFunction_setProperty);
static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleDeclarationPrototypeFunction_removeProperty);
static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleDeclarationPrototypeFunction_getPropertyCSSValue);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleDeclarationConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleDeclaration_cssText);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSStyleDeclaration_cssText);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleDeclaration_cssRules);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleDeclaration_length);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleDeclaration_parentRule);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleDeclaration_cssFloat);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSStyleDeclaration_cssFloat);

class JSCSSStyleDeclarationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSStyleDeclarationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSStyleDeclarationPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSStyleDeclarationPrototype>(vm)) JSCSSStyleDeclarationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSStyleDeclarationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSStyleDeclarationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSStyleDeclarationPrototype, JSCSSStyleDeclarationPrototype::Base);

using JSCSSStyleDeclarationDOMConstructor = JSDOMConstructorNotConstructable<JSCSSStyleDeclaration>;

template<> const ClassInfo JSCSSStyleDeclarationDOMConstructor::s_info = { "CSSStyleDeclaration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleDeclarationDOMConstructor) };

template<> JSValue JSCSSStyleDeclarationDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCSSStyleDeclarationDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSStyleDeclaration"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSStyleDeclaration::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSStyleDeclarationPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclarationConstructor, 0 } },
    { "cssText"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_cssText, setJSCSSStyleDeclaration_cssText } },
    { "cssRules"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_cssRules, 0 } },
    { "length"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_length, 0 } },
    { "parentRule"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_parentRule, 0 } },
    { "cssFloat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_cssFloat, setJSCSSStyleDeclaration_cssFloat } },
    { "AppleColorFilter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "EpubCaptionSide"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "EpubHyphens"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "EpubTextCombine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "EpubTextEmphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "EpubTextEmphasisColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "EpubTextEmphasisStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "EpubTextOrientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "EpubTextTransform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "EpubWordBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "EpubWritingMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitAlignContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitAlignItems"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitAlignSelf"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitAlt"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitAnimation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitAnimationDelay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitAnimationDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitAnimationDuration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitAnimationFillMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitAnimationIterationCount"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitAnimationName"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitAnimationPlayState"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitAnimationTimingFunction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitAppearance"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBackdropFilter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBackfaceVisibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBackgroundClip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBackgroundOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBackgroundSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderAfterColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderAfterStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderAfterWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderBeforeColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderBeforeStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderBeforeWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderBottomLeftRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderBottomRightRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderEndColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderEndStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderEndWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderHorizontalSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderStartColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderStartStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderStartWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderTopLeftRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderTopRightRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBorderVerticalSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBoxAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBoxDecorationBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBoxDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBoxFlex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBoxFlexGroup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBoxLines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBoxOrdinalGroup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBoxOrient"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBoxPack"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBoxReflect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBoxShadow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitBoxSizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitClipPath"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumnAxis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumnBreakAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumnBreakBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumnBreakInside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumnCount"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumnFill"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumnGap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumnProgression"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumnRule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumnRuleColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumnRuleStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumnRuleWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumnSpan"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumnWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitColumns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitCursorVisibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitFilter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitFlex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitFlexBasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitFlexDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitFlexFlow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitFlexGrow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitFlexShrink"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitFlexWrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitFontKerning"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitFontSmoothing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitHyphenateCharacter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitHyphenateLimitAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitHyphenateLimitBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitHyphenateLimitLines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitHyphens"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitInitialLetter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitJustifyContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitJustifyItems"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitLineAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitLineBoxContain"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitLineBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitLineClamp"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitLineGrid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitLineSnap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitLocale"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitLogicalHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitLogicalWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMarginAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMarginBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMarginEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMarginStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMask"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskBoxImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskBoxImageOutset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskBoxImageRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskBoxImageSlice"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskBoxImageSource"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskBoxImageWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskClip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskComposite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskPositionX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskPositionY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaskSourceType"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaxLogicalHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMaxLogicalWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMinLogicalHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitMinLogicalWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitNbspMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitOpacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitOrder"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitPaddingAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitPaddingBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitPaddingEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitPaddingStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitPerspective"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitPerspectiveOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitPerspectiveOriginX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitPerspectiveOriginY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitPrintColorAdjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitRtlOrdering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitRubyPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitShapeImageThreshold"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitShapeMargin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitShapeOutside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTapHighlightColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextCombine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextDecoration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextDecorationColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextDecorationLine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextDecorationSkip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextDecorationStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextDecorationsInEffect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextEmphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextEmphasisColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextEmphasisPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextEmphasisStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextFillColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextOrientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextSecurity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextStroke"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextStrokeColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextStrokeWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextUnderlinePosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTextZoom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTransform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTransformOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTransformOriginX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTransformOriginY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTransformOriginZ"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTransformStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTransition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTransitionDelay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTransitionDuration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTransitionProperty"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitTransitionTimingFunction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitUserDrag"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitUserModify"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitUserSelect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "WebkitWritingMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "accentColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "additiveSymbols"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "alignContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "alignItems"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "alignSelf"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "alignTracks"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "alignmentBaseline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "all"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "alt"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "animation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "animationComposition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "animationDelay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "animationDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "animationDuration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "animationFillMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "animationIterationCount"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "animationName"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "animationPlayState"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "animationTimingFunction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "appearance"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "aspectRatio"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "backfaceVisibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "background"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "backgroundAttachment"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "backgroundBlendMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "backgroundClip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "backgroundColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "backgroundImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "backgroundOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "backgroundPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "backgroundPositionX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "backgroundPositionY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "backgroundRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "backgroundSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "basePalette"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "baselineShift"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "blockSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "blockStepInsert"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "blockStepSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "border"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBlockColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBlockEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBlockEndColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBlockEndStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBlockEndWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBlockStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBlockStartColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBlockStartStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBlockStartWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBlockStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBlockWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBottomColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBottomLeftRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBottomRightRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBottomStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderBottomWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderCollapse"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderEndEndRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderEndStartRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderImageOutset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderImageRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderImageSlice"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderImageSource"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderImageWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderInlineColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderInlineEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderInlineEndColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderInlineEndStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderInlineEndWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderInlineStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderInlineStartColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderInlineStartStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderInlineStartWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderInlineStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderInlineWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderLeft"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderLeftColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderLeftStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderLeftWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderRight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderRightColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderRightStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderRightWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderStartEndRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderStartStartRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderTop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderTopColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderTopLeftRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderTopRightRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderTopStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderTopWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "borderWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "boxShadow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "boxSizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "breakAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "breakBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "breakInside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "bufferedRendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "captionSide"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "caretColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "clear"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "clip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "clipPath"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "clipRule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "colorAdjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "colorInterpolation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "colorInterpolationFilters"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "colorScheme"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "columnCount"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "columnFill"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "columnGap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "columnRule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "columnRuleColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "columnRuleStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "columnRuleWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "columnSpan"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "columnWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "columns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "contain"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "containIntrinsicBlockSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "containIntrinsicHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "containIntrinsicInlineSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "containIntrinsicSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "containIntrinsicWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "container"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "containerName"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "containerType"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "content"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "contentVisibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "counterIncrement"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "counterReset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "cursor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "cx"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "cy"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "direction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "display"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "dominantBaseline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "emptyCells"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fallback"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fill"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fillOpacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fillRule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "filter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "flex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "flexBasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "flexDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "flexFlow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "flexGrow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "flexShrink"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "flexWrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "float"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "floodColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "floodOpacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "font"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontDisplay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontFamily"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontFeatureSettings"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontKerning"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontOpticalSizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontPalette"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontSizeAdjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontStretch"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontSynthesis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontSynthesisSmallCaps"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontSynthesisStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontSynthesisWeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontVariant"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontVariantAlternates"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontVariantCaps"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontVariantEastAsian"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontVariantLigatures"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontVariantNumeric"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontVariantPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontVariationSettings"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "fontWeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "glyphOrientationHorizontal"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "glyphOrientationVertical"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "grid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridArea"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridAutoColumns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridAutoFlow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridAutoRows"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridColumn"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridColumnEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridColumnGap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridColumnStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridGap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridRow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridRowEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridRowGap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridRowStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridTemplate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridTemplateAreas"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridTemplateColumns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "gridTemplateRows"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "hangingPunctuation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "hyphenateCharacter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "hyphens"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "imageOrientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "imageRendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "inherits"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "initialValue"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "inlineSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "inputSecurity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "inset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "insetBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "insetBlockEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "insetBlockStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "insetInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "insetInlineEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "insetInlineStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "isolation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "justifyContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "justifyItems"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "justifySelf"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "justifyTracks"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "kerning"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "letterSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "lightingColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "lineBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "lineHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "listStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "listStyleImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "listStylePosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "listStyleType"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "margin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "marginBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "marginBlockEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "marginBlockStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "marginBottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "marginInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "marginInlineEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "marginInlineStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "marginLeft"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "marginRight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "marginTop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "marginTrim"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "marker"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "markerEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "markerMid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "markerStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "mask"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "maskClip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "maskComposite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "maskImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "maskMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "maskOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "maskPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "maskRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "maskSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "maskType"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "masonryAutoFlow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "mathStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "maxBlockSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "maxHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "maxInlineSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "maxWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "minBlockSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "minHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "minInlineSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "minWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "mixBlendMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "negative"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "objectFit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "objectPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "offset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "offsetAnchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "offsetDistance"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "offsetPath"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "offsetPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "offsetRotate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "opacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "order"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "orphans"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "outline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "outlineColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "outlineOffset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "outlineStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "outlineWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "overflow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "overflowAnchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "overflowWrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "overflowX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "overflowY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "overrideColors"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "overscrollBehavior"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "overscrollBehaviorBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "overscrollBehaviorInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "overscrollBehaviorX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "overscrollBehaviorY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "pad"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "padding"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "paddingBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "paddingBlockEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "paddingBlockStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "paddingBottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "paddingInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "paddingInlineEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "paddingInlineStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "paddingLeft"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "paddingRight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "paddingTop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "page"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "pageBreakAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "pageBreakBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "pageBreakInside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "paintOrder"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "perspective"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "perspectiveOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "perspectiveOriginX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "perspectiveOriginY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "placeContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "placeItems"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "placeSelf"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "pointerEvents"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "prefix"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "printColorAdjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "quotes"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "r"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "range"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "resize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "rotate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "rowGap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "rx"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "ry"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scale"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollBehavior"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollMargin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollMarginBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollMarginBlockEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollMarginBlockStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollMarginBottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollMarginInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollMarginInlineEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollMarginInlineStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollMarginLeft"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollMarginRight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollMarginTop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollPadding"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollPaddingBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollPaddingBlockEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollPaddingBlockStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollPaddingBottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollPaddingInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollPaddingInlineEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollPaddingInlineStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollPaddingLeft"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollPaddingRight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollPaddingTop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollSnapAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollSnapMargin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollSnapMarginBottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollSnapMarginLeft"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollSnapMarginRight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollSnapMarginTop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollSnapStop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollSnapType"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollbarColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollbarGutter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "scrollbarWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "shapeImageThreshold"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "shapeMargin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "shapeOutside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "shapeRendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "sizeAdjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "speakAs"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "src"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "stopColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "stopOpacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "stroke"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "strokeColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "strokeDasharray"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "strokeDashoffset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "strokeLinecap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "strokeLinejoin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "strokeMiterlimit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "strokeOpacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "strokeWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "suffix"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "supportedColorSchemes"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "symbols"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "syntax"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "system"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "tabSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "tableLayout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textAlignLast"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textAnchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textAutospace"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textBoxEdge"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textBoxTrim"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textCombineUpright"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textDecoration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textDecorationColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textDecorationLine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textDecorationSkip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textDecorationSkipInk"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textDecorationStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textDecorationThickness"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textEmphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textEmphasisColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textEmphasisPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textEmphasisStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textGroupAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textIndent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textJustify"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textOrientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textOverflow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textRendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textShadow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textSpacingTrim"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textTransform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textUnderlineOffset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textUnderlinePosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "textWrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "touchAction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "transform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "transformBox"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "transformOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "transformOriginX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "transformOriginY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "transformOriginZ"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "transformStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "transition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "transitionDelay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "transitionDuration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "transitionProperty"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "transitionTimingFunction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "translate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "unicodeBidi"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "unicodeRange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "vectorEffect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "verticalAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "visibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "whiteSpace"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "whiteSpaceCollapse"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "widows"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "willChange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "wordBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "wordSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "wordWrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "writingMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "zIndex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "zoom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute } },
    { "webkitAlignContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitAlignItems"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitAlignSelf"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitAlt"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitAnimation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitAnimationDelay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitAnimationDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitAnimationDuration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitAnimationFillMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitAnimationIterationCount"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitAnimationName"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitAnimationPlayState"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitAnimationTimingFunction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitAppearance"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBackdropFilter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBackfaceVisibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBackgroundClip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBackgroundOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBackgroundSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderAfterColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderAfterStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderAfterWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderBeforeColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderBeforeStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderBeforeWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderBottomLeftRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderBottomRightRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderEndColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderEndStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderEndWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderHorizontalSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderStartColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderStartStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderStartWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderTopLeftRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderTopRightRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBorderVerticalSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBoxAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBoxDecorationBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBoxDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBoxFlex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBoxFlexGroup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBoxLines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBoxOrdinalGroup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBoxOrient"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBoxPack"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBoxReflect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBoxShadow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitBoxSizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitClipPath"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumnAxis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumnBreakAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumnBreakBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumnBreakInside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumnCount"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumnFill"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumnGap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumnProgression"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumnRule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumnRuleColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumnRuleStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumnRuleWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumnSpan"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumnWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitColumns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitCursorVisibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitFilter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitFlex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitFlexBasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitFlexDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitFlexFlow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitFlexGrow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitFlexShrink"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitFlexWrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitFontKerning"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitFontSmoothing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitHyphenateCharacter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitHyphenateLimitAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitHyphenateLimitBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitHyphenateLimitLines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitHyphens"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitInitialLetter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitJustifyContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitJustifyItems"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitLineAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitLineBoxContain"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitLineBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitLineClamp"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitLineGrid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitLineSnap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitLocale"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitLogicalHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitLogicalWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMarginAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMarginBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMarginEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMarginStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMask"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskBoxImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskBoxImageOutset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskBoxImageRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskBoxImageSlice"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskBoxImageSource"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskBoxImageWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskClip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskComposite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskPositionX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskPositionY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaskSourceType"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaxLogicalHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMaxLogicalWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMinLogicalHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitMinLogicalWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitNbspMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitOpacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitOrder"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitPaddingAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitPaddingBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitPaddingEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitPaddingStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitPerspective"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitPerspectiveOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitPerspectiveOriginX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitPerspectiveOriginY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitPrintColorAdjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitRtlOrdering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitRubyPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitShapeImageThreshold"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitShapeMargin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitShapeOutside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTapHighlightColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextCombine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextDecoration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextDecorationColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextDecorationLine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextDecorationSkip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextDecorationStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextDecorationsInEffect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextEmphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextEmphasisColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextEmphasisPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextEmphasisStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextFillColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextOrientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextSecurity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextStroke"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextStrokeColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextStrokeWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextUnderlinePosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTextZoom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTransform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTransformOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTransformOriginX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTransformOriginY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTransformOriginZ"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTransformStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTransition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTransitionDelay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTransitionDuration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTransitionProperty"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitTransitionTimingFunction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitUserDrag"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitUserModify"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitUserSelect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "webkitWritingMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute } },
    { "-apple-color-filter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-epub-caption-side"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-epub-hyphens"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-epub-text-combine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-epub-text-emphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-epub-text-emphasis-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-epub-text-emphasis-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-epub-text-orientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-epub-text-transform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-epub-word-break"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-epub-writing-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-align-content"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-align-items"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-align-self"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-alt"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-animation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-animation-delay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-animation-direction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-animation-duration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-animation-fill-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-animation-iteration-count"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-animation-name"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-animation-play-state"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-animation-timing-function"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-appearance"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-backdrop-filter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-backface-visibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-background-clip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-background-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-background-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-after"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-after-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-after-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-after-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-before"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-before-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-before-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-before-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-bottom-left-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-bottom-right-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-end-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-end-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-end-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-horizontal-spacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-image"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-start-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-start-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-start-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-top-left-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-top-right-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-border-vertical-spacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-box-align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-box-decoration-break"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-box-direction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-box-flex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-box-flex-group"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-box-lines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-box-ordinal-group"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-box-orient"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-box-pack"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-box-reflect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-box-shadow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-box-sizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-clip-path"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-column-axis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-column-break-after"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-column-break-before"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-column-break-inside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-column-count"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-column-fill"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-column-gap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-column-progression"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-column-rule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-column-rule-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-column-rule-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-column-rule-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-column-span"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-column-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-columns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-cursor-visibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-filter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-flex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-flex-basis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-flex-direction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-flex-flow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-flex-grow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-flex-shrink"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-flex-wrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-font-kerning"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-font-smoothing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-hyphenate-character"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-hyphenate-limit-after"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-hyphenate-limit-before"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-hyphenate-limit-lines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-hyphens"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-initial-letter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-justify-content"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-justify-items"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-line-align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-line-box-contain"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-line-break"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-line-clamp"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-line-grid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-line-snap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-locale"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-logical-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-logical-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-margin-after"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-margin-before"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-margin-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-margin-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-box-image"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-box-image-outset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-box-image-repeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-box-image-slice"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-box-image-source"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-box-image-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-clip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-composite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-image"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-position-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-position-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-repeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-mask-source-type"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-max-logical-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-max-logical-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-min-logical-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-min-logical-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-nbsp-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-opacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-order"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-padding-after"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-padding-before"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-padding-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-padding-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-perspective"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-perspective-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-perspective-origin-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-perspective-origin-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-print-color-adjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-rtl-ordering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-ruby-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-shape-image-threshold"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-shape-margin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-shape-outside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-tap-highlight-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-combine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-decoration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-decoration-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-decoration-line"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-decoration-skip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-decoration-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-decorations-in-effect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-emphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-emphasis-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-emphasis-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-emphasis-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-fill-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-orientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-security"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-stroke"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-stroke-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-stroke-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-underline-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-text-zoom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-transform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-transform-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-transform-origin-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-transform-origin-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-transform-origin-z"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-transform-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-transition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-transition-delay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-transition-duration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-transition-property"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-transition-timing-function"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-user-drag"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-user-modify"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-user-select"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "-webkit-writing-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "accent-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "additive-symbols"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "align-content"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "align-items"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "align-self"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "align-tracks"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "alignment-baseline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "animation-composition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "animation-delay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "animation-direction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "animation-duration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "animation-fill-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "animation-iteration-count"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "animation-name"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "animation-play-state"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "animation-timing-function"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "aspect-ratio"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "backface-visibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "background-attachment"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "background-blend-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "background-clip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "background-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "background-image"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "background-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "background-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "background-position-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "background-position-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "background-repeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "background-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "base-palette"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "baseline-shift"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "block-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "block-step-insert"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "block-step-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-block-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-block-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-block-end-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-block-end-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-block-end-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-block-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-block-start-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-block-start-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-block-start-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-block-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-block-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-bottom-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-bottom-left-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-bottom-right-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-bottom-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-bottom-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-collapse"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-end-end-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-end-start-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-image"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-image-outset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-image-repeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-image-slice"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-image-source"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-image-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-inline-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-inline-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-inline-end-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-inline-end-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-inline-end-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-inline-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-inline-start-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-inline-start-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-inline-start-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-inline-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-inline-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-left-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-left-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-left-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-right-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-right-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-right-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-spacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-start-end-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-start-start-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-top-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-top-left-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-top-right-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-top-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-top-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "border-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "box-shadow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "box-sizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "break-after"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "break-before"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "break-inside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "buffered-rendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "caption-side"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "caret-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "clip-path"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "clip-rule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "color-adjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "color-interpolation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "color-interpolation-filters"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "color-scheme"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "column-count"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "column-fill"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "column-gap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "column-rule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "column-rule-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "column-rule-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "column-rule-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "column-span"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "column-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "contain-intrinsic-block-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "contain-intrinsic-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "contain-intrinsic-inline-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "contain-intrinsic-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "contain-intrinsic-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "container-name"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "container-type"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "content-visibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "counter-increment"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "counter-reset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "dominant-baseline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "empty-cells"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "fill-opacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "fill-rule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "flex-basis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "flex-direction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "flex-flow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "flex-grow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "flex-shrink"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "flex-wrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "flood-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "flood-opacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-display"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-family"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-feature-settings"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-kerning"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-optical-sizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-palette"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-size-adjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-stretch"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-synthesis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-synthesis-small-caps"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-synthesis-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-synthesis-weight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-variant"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-variant-alternates"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-variant-caps"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-variant-east-asian"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-variant-ligatures"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-variant-numeric"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-variant-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-variation-settings"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "font-weight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "glyph-orientation-horizontal"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "glyph-orientation-vertical"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-area"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-auto-columns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-auto-flow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-auto-rows"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-column"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-column-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-column-gap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-column-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-gap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-row"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-row-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-row-gap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-row-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-template"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-template-areas"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-template-columns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "grid-template-rows"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "hanging-punctuation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "hyphenate-character"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "image-orientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "image-rendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "initial-value"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "inline-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "input-security"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "inset-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "inset-block-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "inset-block-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "inset-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "inset-inline-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "inset-inline-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "justify-content"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "justify-items"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "justify-self"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "justify-tracks"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "letter-spacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "lighting-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "line-break"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "line-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "list-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "list-style-image"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "list-style-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "list-style-type"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "margin-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "margin-block-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "margin-block-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "margin-bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "margin-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "margin-inline-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "margin-inline-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "margin-left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "margin-right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "margin-top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "margin-trim"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "marker-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "marker-mid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "marker-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "mask-clip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "mask-composite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "mask-image"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "mask-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "mask-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "mask-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "mask-repeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "mask-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "mask-type"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "masonry-auto-flow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "math-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "max-block-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "max-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "max-inline-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "max-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "min-block-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "min-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "min-inline-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "min-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "mix-blend-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "object-fit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "object-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "offset-anchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "offset-distance"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "offset-path"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "offset-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "offset-rotate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "outline-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "outline-offset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "outline-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "outline-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "overflow-anchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "overflow-wrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "overflow-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "overflow-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "override-colors"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "overscroll-behavior"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "overscroll-behavior-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "overscroll-behavior-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "overscroll-behavior-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "overscroll-behavior-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "padding-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "padding-block-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "padding-block-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "padding-bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "padding-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "padding-inline-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "padding-inline-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "padding-left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "padding-right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "padding-top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "page-break-after"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "page-break-before"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "page-break-inside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "paint-order"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "perspective-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "perspective-origin-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "perspective-origin-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "place-content"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "place-items"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "place-self"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "pointer-events"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "print-color-adjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "row-gap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-behavior"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-margin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-margin-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-margin-block-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-margin-block-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-margin-bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-margin-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-margin-inline-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-margin-inline-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-margin-left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-margin-right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-margin-top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-padding"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-padding-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-padding-block-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-padding-block-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-padding-bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-padding-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-padding-inline-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-padding-inline-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-padding-left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-padding-right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-padding-top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-snap-align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-snap-margin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-snap-margin-bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-snap-margin-left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-snap-margin-right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-snap-margin-top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-snap-stop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scroll-snap-type"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scrollbar-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scrollbar-gutter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "scrollbar-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "shape-image-threshold"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "shape-margin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "shape-outside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "shape-rendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "size-adjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "speak-as"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "stop-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "stop-opacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "stroke-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "stroke-dasharray"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "stroke-dashoffset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "stroke-linecap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "stroke-linejoin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "stroke-miterlimit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "stroke-opacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "stroke-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "supported-color-schemes"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "tab-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "table-layout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-align-last"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-anchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-autospace"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-box-edge"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-box-trim"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-combine-upright"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-decoration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-decoration-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-decoration-line"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-decoration-skip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-decoration-skip-ink"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-decoration-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-decoration-thickness"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-emphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-emphasis-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-emphasis-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-emphasis-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-group-align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-indent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-justify"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-orientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-overflow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-rendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-shadow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-spacing-trim"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-transform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-underline-offset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-underline-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "text-wrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "touch-action"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "transform-box"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "transform-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "transform-origin-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "transform-origin-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "transform-origin-z"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "transform-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "transition-delay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "transition-duration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "transition-property"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "transition-timing-function"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "unicode-bidi"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "unicode-range"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "vector-effect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "vertical-align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "white-space"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "white-space-collapse"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "will-change"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "word-break"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "word-spacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "word-wrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "writing-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "z-index"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute } },
    { "epubCaptionSide"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute } },
    { "epubHyphens"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute } },
    { "epubTextCombine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute } },
    { "epubTextEmphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute } },
    { "epubTextEmphasisColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute } },
    { "epubTextEmphasisStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute } },
    { "epubTextOrientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute } },
    { "epubTextTransform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute } },
    { "epubWordBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute } },
    { "epubWritingMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute } },
    { "item"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleDeclarationPrototypeFunction_item, 1 } },
    { "getPropertyValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleDeclarationPrototypeFunction_getPropertyValue, 1 } },
    { "getPropertyPriority"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleDeclarationPrototypeFunction_getPropertyPriority, 1 } },
    { "setProperty"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleDeclarationPrototypeFunction_setProperty, 2 } },
    { "removeProperty"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleDeclarationPrototypeFunction_removeProperty, 1 } },
    { "getPropertyCSSValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleDeclarationPrototypeFunction_getPropertyCSSValue, 1 } },
};

const ClassInfo JSCSSStyleDeclarationPrototype::s_info = { "CSSStyleDeclaration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleDeclarationPrototype) };

void JSCSSStyleDeclarationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSStyleDeclaration::info(), JSCSSStyleDeclarationPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().colorFilterEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "AppleColorFilter"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().accentColorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "accentColor"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCounterStyleAtRulesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "additiveSymbols"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().masonryTrackAlignmentEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "alignTracks"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().webAnimationsCompositeOperationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "animationComposition"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().aspectRatioEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "aspectRatio"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRhythmicSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "blockStepInsert"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRhythmicSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "blockStepSize"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainmentEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "contain"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainIntrinsicSizeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "containIntrinsicBlockSize"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainIntrinsicSizeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "containIntrinsicHeight"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainIntrinsicSizeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "containIntrinsicInlineSize"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainIntrinsicSizeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "containIntrinsicSize"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainIntrinsicSizeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "containIntrinsicWidth"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainerQueriesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "containerName"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainerQueriesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "containerType"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContentVisibilityEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "contentVisibility"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCounterStyleAtRulesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "fallback"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCustomPropertiesAndValuesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "inherits"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCustomPropertiesAndValuesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "initialValue"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssInputSecurityEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "inputSecurity"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().masonryTrackAlignmentEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "justifyTracks"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssMarginTrimEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "marginTrim"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().masonryEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "masonryAutoFlow"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCounterStyleAtRulesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "negative"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssMotionPathEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "offset"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssMotionPathEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "offsetAnchor"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssMotionPathEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "offsetDistance"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssMotionPathEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "offsetPath"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssMotionPathEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "offsetPosition"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssMotionPathEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "offsetRotate"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollAnchoringEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overflowAnchor"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscrollBehavior"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscrollBehaviorBlock"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscrollBehaviorInline"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscrollBehaviorX"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscrollBehaviorY"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCounterStyleAtRulesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "pad"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCounterStyleAtRulesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "prefix"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCounterStyleAtRulesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "range"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssIndividualTransformPropertiesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "rotate"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssIndividualTransformPropertiesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scale"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().CSSOMViewSmoothScrollingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollBehavior"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollbarColorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollbarColor"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollbarGutterEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollbarGutter"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollbarWidthEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollbarWidth"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssFontFaceSizeAdjustEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "sizeAdjust"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCounterStyleAtRulesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "suffix"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCounterStyleAtRulesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "symbols"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCustomPropertiesAndValuesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "syntax"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCounterStyleAtRulesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "system"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextAlignLastEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textAlignLast"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextSpacingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textAutospace"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextBoxTrimEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textBoxEdge"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextBoxTrimEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textBoxTrim"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextGroupAlignEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textGroupAlign"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextJustifyEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textJustify"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextSpacingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textSpacingTrim"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssWhiteSpaceLonghandsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textWrap"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssIndividualTransformPropertiesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "translate"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssWhiteSpaceLonghandsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "whiteSpaceCollapse"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().colorFilterEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "-apple-color-filter"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().accentColorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "accent-color"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCounterStyleAtRulesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "additive-symbols"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().masonryTrackAlignmentEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "align-tracks"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().webAnimationsCompositeOperationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "animation-composition"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().aspectRatioEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "aspect-ratio"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRhythmicSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "block-step-insert"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRhythmicSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "block-step-size"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainIntrinsicSizeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "contain-intrinsic-block-size"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainIntrinsicSizeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "contain-intrinsic-height"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainIntrinsicSizeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "contain-intrinsic-inline-size"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainIntrinsicSizeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "contain-intrinsic-size"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainIntrinsicSizeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "contain-intrinsic-width"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainerQueriesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "container-name"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContainerQueriesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "container-type"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssContentVisibilityEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "content-visibility"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCustomPropertiesAndValuesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "initial-value"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssInputSecurityEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "input-security"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().masonryTrackAlignmentEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "justify-tracks"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssMarginTrimEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "margin-trim"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().masonryEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "masonry-auto-flow"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssMotionPathEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "offset-anchor"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssMotionPathEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "offset-distance"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssMotionPathEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "offset-path"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssMotionPathEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "offset-position"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssMotionPathEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "offset-rotate"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollAnchoringEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overflow-anchor"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscroll-behavior"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscroll-behavior-block"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscroll-behavior-inline"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscroll-behavior-x"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscroll-behavior-y"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().CSSOMViewSmoothScrollingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scroll-behavior"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollbarColorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollbar-color"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollbarGutterEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollbar-gutter"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollbarWidthEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollbar-width"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssFontFaceSizeAdjustEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "size-adjust"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextAlignLastEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-align-last"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextSpacingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-autospace"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextBoxTrimEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-box-edge"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextBoxTrimEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-box-trim"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextGroupAlignEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-group-align"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextJustifyEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-justify"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextSpacingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-spacing-trim"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssWhiteSpaceLonghandsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-wrap"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssWhiteSpaceLonghandsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "white-space-collapse"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    putDirect(vm, vm.propertyNames->iteratorSymbol, globalObject()->arrayPrototype()->getDirect(vm, vm.propertyNames->builtinNames().valuesPrivateName()), static_cast<unsigned>(JSC::PropertyAttribute::DontEnum));
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSStyleDeclaration::s_info = { "CSSStyleDeclaration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleDeclaration) };

JSCSSStyleDeclaration::JSCSSStyleDeclaration(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSStyleDeclaration>&& impl)
    : JSDOMWrapper<CSSStyleDeclaration>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSStyleDeclaration>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSStyleDeclaration::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSStyleDeclarationPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSCSSStyleDeclarationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSStyleDeclaration::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSStyleDeclaration>(vm, globalObject);
}

JSValue JSCSSStyleDeclaration::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSStyleDeclarationDOMConstructor, DOMConstructorID::CSSStyleDeclaration>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCSSStyleDeclaration::destroy(JSC::JSCell* cell)
{
    JSCSSStyleDeclaration* thisObject = static_cast<JSCSSStyleDeclaration*>(cell);
    thisObject->JSCSSStyleDeclaration::~JSCSSStyleDeclaration();
}

bool JSCSSStyleDeclaration::legacyPlatformObjectGetOwnProperty(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot, bool ignoreNamedProperties)
{
    UNUSED_PARAM(ignoreNamedProperties);
    auto throwScope = DECLARE_THROW_SCOPE(JSC::getVM(lexicalGlobalObject));
    auto* thisObject = jsCast<JSCSSStyleDeclaration*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (auto index = parseIndex(propertyName)) {
        if (auto item = thisObject->wrapped().item(index.value()); LIKELY(!!item)) {
            auto value = toJS<IDLUSVString>(*lexicalGlobalObject, throwScope, WTFMove(item));
            RETURN_IF_EXCEPTION(throwScope, false);
            slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
            return true;
        }
    }
    return JSObject::getOwnPropertySlot(object, lexicalGlobalObject, propertyName, slot);
}

bool JSCSSStyleDeclaration::getOwnPropertySlot(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot)
{
    bool ignoreNamedProperties = false;
    return legacyPlatformObjectGetOwnProperty(object, lexicalGlobalObject, propertyName, slot, ignoreNamedProperties);
}

bool JSCSSStyleDeclaration::getOwnPropertySlotByIndex(JSObject* object, JSGlobalObject* lexicalGlobalObject, unsigned index, PropertySlot& slot)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* thisObject = jsCast<JSCSSStyleDeclaration*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (LIKELY(index <= MAX_ARRAY_INDEX)) {
        if (auto item = thisObject->wrapped().item(index); LIKELY(!!item)) {
            auto value = toJS<IDLUSVString>(*lexicalGlobalObject, throwScope, WTFMove(item));
            RETURN_IF_EXCEPTION(throwScope, false);
            slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
            return true;
        }
    }
    return JSObject::getOwnPropertySlotByIndex(object, lexicalGlobalObject, index, slot);
}

void JSCSSStyleDeclaration::getOwnPropertyNames(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyNameArray& propertyNames, DontEnumPropertiesMode mode)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSCSSStyleDeclaration*>(object);
    ASSERT_GC_OBJECT_INHERITS(object, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(vm, i));
    JSObject::getOwnPropertyNames(object, lexicalGlobalObject, propertyNames, mode);
}

bool JSCSSStyleDeclaration::put(JSCell* cell, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, JSValue value, PutPropertySlot& putPropertySlot)
{
    auto* thisObject = jsCast<JSCSSStyleDeclaration*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    if (UNLIKELY(thisObject != putPropertySlot.thisValue()))
        return JSObject::put(thisObject, lexicalGlobalObject, propertyName, value, putPropertySlot);

    // Temporary quirk for ungap/@custom-elements polyfill (rdar://problem/111008826), consider removing in 2025.
    if (auto* document = dynamicDowncast<Document>(jsDynamicCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())) {
        if (UNLIKELY(document->quirks().needsConfigurableIndexedPropertiesQuirk()))
            return JSObject::put(thisObject, lexicalGlobalObject, propertyName, value, putPropertySlot);
    }

    auto throwScope = DECLARE_THROW_SCOPE(lexicalGlobalObject->vm());

    throwScope.assertNoException();
    PropertyDescriptor ownDescriptor;
    PropertySlot slot(thisObject, PropertySlot::InternalMethodType::GetOwnProperty);;
    bool ignoreNamedProperties = true;
    bool hasOwnProperty = legacyPlatformObjectGetOwnProperty(thisObject, lexicalGlobalObject, propertyName, slot, ignoreNamedProperties);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (hasOwnProperty) {
        ownDescriptor.setPropertySlot(lexicalGlobalObject, propertyName, slot);
        RETURN_IF_EXCEPTION(throwScope, false);
    }
    RELEASE_AND_RETURN(throwScope, ordinarySetWithOwnDescriptor(lexicalGlobalObject, thisObject, propertyName, value, putPropertySlot.thisValue(), WTFMove(ownDescriptor), putPropertySlot.isStrictMode()));
}

bool JSCSSStyleDeclaration::putByIndex(JSCell* cell, JSGlobalObject* lexicalGlobalObject, unsigned index, JSValue value, bool shouldThrow)
{

    // Temporary quirk for ungap/@custom-elements polyfill (rdar://problem/111008826), consider removing in 2025.
    if (auto* document = dynamicDowncast<Document>(jsDynamicCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())) {
        if (UNLIKELY(document->quirks().needsConfigurableIndexedPropertiesQuirk()))
            return JSObject::putByIndex(cell, lexicalGlobalObject, index, value, shouldThrow);
    }

    auto* thisObject = jsCast<JSCSSStyleDeclaration*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    throwScope.assertNoException();
    auto propertyName = Identifier::from(vm, index);
    PutPropertySlot putPropertySlot(thisObject, shouldThrow);
    RELEASE_AND_RETURN(throwScope, ordinarySetSlow(lexicalGlobalObject, thisObject, propertyName, value, putPropertySlot.thisValue(), shouldThrow));
}

bool JSCSSStyleDeclaration::defineOwnProperty(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, const PropertyDescriptor& propertyDescriptor, bool shouldThrow)
{
    auto* thisObject = jsCast<JSCSSStyleDeclaration*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    auto throwScope = DECLARE_THROW_SCOPE(lexicalGlobalObject->vm());

    if (parseIndex(propertyName))
        return typeError(lexicalGlobalObject, throwScope, shouldThrow, "Cannot set indexed properties on this object"_s);

    PropertyDescriptor newPropertyDescriptor = propertyDescriptor;
    throwScope.release();
    return JSObject::defineOwnProperty(object, lexicalGlobalObject, propertyName, newPropertyDescriptor, shouldThrow);
}

bool JSCSSStyleDeclaration::deleteProperty(JSCell* cell, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, DeletePropertySlot& slot)
{
    auto& thisObject = *jsCast<JSCSSStyleDeclaration*>(cell);
    auto& impl = thisObject.wrapped();

    // Temporary quirk for ungap/@custom-elements polyfill (rdar://problem/111008826), consider removing in 2025.
    if (auto* document = dynamicDowncast<Document>(jsDynamicCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())) {
        if (UNLIKELY(document->quirks().needsConfigurableIndexedPropertiesQuirk()))
            return JSObject::deleteProperty(cell, lexicalGlobalObject, propertyName, slot);
    }

    if (auto index = parseIndex(propertyName))
        return !impl.isSupportedPropertyIndex(index.value());
    return JSObject::deleteProperty(cell, lexicalGlobalObject, propertyName, slot);
}

bool JSCSSStyleDeclaration::deletePropertyByIndex(JSCell* cell, JSGlobalObject* lexicalGlobalObject, unsigned index)
{
    UNUSED_PARAM(lexicalGlobalObject);
    auto& thisObject = *jsCast<JSCSSStyleDeclaration*>(cell);
    auto& impl = thisObject.wrapped();

    // Temporary quirk for ungap/@custom-elements polyfill (rdar://problem/111008826), consider removing in 2025.
    if (auto* document = dynamicDowncast<Document>(jsDynamicCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())) {
        if (UNLIKELY(document->quirks().needsConfigurableIndexedPropertiesQuirk()))
            return JSObject::deletePropertyByIndex(cell, lexicalGlobalObject, index);
    }

    return !impl.isSupportedPropertyIndex(index);
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleDeclarationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSStyleDeclarationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSStyleDeclaration::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttributeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.propertyValueForCamelCasedIDLAttribute(propertyNameToAtomString(propertyName)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::getPassingPropertyName<jsCSSStyleDeclaration_propertyValueForCamelCasedIDLAttributeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttributeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject, JSValue value, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPropertyValueForCamelCasedIDLAttribute(propertyNameToAtomString(propertyName), WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::setPassingPropertyName<setJSCSSStyleDeclaration_propertyValueForCamelCasedIDLAttributeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttributeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.propertyValueForWebKitCasedIDLAttribute(propertyNameToAtomString(propertyName)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::getPassingPropertyName<jsCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttributeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttributeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject, JSValue value, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPropertyValueForWebKitCasedIDLAttribute(propertyNameToAtomString(propertyName), WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::setPassingPropertyName<setJSCSSStyleDeclaration_propertyValueForWebKitCasedIDLAttributeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSStyleDeclaration_propertyValueForDashedIDLAttributeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.propertyValueForDashedIDLAttribute(propertyNameToAtomString(propertyName)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleDeclaration_propertyValueForDashedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::getPassingPropertyName<jsCSSStyleDeclaration_propertyValueForDashedIDLAttributeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSStyleDeclaration_propertyValueForDashedIDLAttributeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject, JSValue value, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPropertyValueForDashedIDLAttribute(propertyNameToAtomString(propertyName), WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSStyleDeclaration_propertyValueForDashedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::setPassingPropertyName<setJSCSSStyleDeclaration_propertyValueForDashedIDLAttributeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSStyleDeclaration_propertyValueForEpubCasedIDLAttributeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.propertyValueForEpubCasedIDLAttribute(propertyNameToAtomString(propertyName)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::getPassingPropertyName<jsCSSStyleDeclaration_propertyValueForEpubCasedIDLAttributeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSStyleDeclaration_propertyValueForEpubCasedIDLAttributeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject, JSValue value, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPropertyValueForEpubCasedIDLAttribute(propertyNameToAtomString(propertyName), WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSStyleDeclaration_propertyValueForEpubCasedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::setPassingPropertyName<setJSCSSStyleDeclaration_propertyValueForEpubCasedIDLAttributeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSStyleDeclaration_cssTextGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.cssText())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleDeclaration_cssText, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::get<jsCSSStyleDeclaration_cssTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSStyleDeclaration_cssTextSetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setCssText(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSStyleDeclaration_cssText, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::set<setJSCSSStyleDeclaration_cssTextSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSStyleDeclaration_cssRulesGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSRuleList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.cssRules())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleDeclaration_cssRules, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::get<jsCSSStyleDeclaration_cssRulesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSSStyleDeclaration_lengthGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.length())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleDeclaration_length, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::get<jsCSSStyleDeclaration_lengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSSStyleDeclaration_parentRuleGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<CSSRule>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.parentRule())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleDeclaration_parentRule, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::get<jsCSSStyleDeclaration_parentRuleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSSStyleDeclaration_cssFloatGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.cssFloat())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleDeclaration_cssFloat, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::get<jsCSSStyleDeclaration_cssFloatGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSStyleDeclaration_cssFloatSetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleDeclaration& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setCssFloat(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSStyleDeclaration_cssFloat, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleDeclaration>::set<setJSCSSStyleDeclaration_cssFloatSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsCSSStyleDeclarationPrototypeFunction_itemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleDeclaration>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUSVString>(*lexicalGlobalObject, throwScope, impl.item(WTFMove(index)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleDeclarationPrototypeFunction_item, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleDeclaration>::call<jsCSSStyleDeclarationPrototypeFunction_itemBody>(*lexicalGlobalObject, *callFrame, "item");
}

static inline JSC::EncodedJSValue jsCSSStyleDeclarationPrototypeFunction_getPropertyValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleDeclaration>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto property = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUSVString>(*lexicalGlobalObject, throwScope, impl.getPropertyValue(WTFMove(property)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleDeclarationPrototypeFunction_getPropertyValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleDeclaration>::call<jsCSSStyleDeclarationPrototypeFunction_getPropertyValueBody>(*lexicalGlobalObject, *callFrame, "getPropertyValue");
}

static inline JSC::EncodedJSValue jsCSSStyleDeclarationPrototypeFunction_getPropertyPriorityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleDeclaration>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto property = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUSVString>(*lexicalGlobalObject, throwScope, impl.getPropertyPriority(WTFMove(property)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleDeclarationPrototypeFunction_getPropertyPriority, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleDeclaration>::call<jsCSSStyleDeclarationPrototypeFunction_getPropertyPriorityBody>(*lexicalGlobalObject, *callFrame, "getPropertyPriority");
}

static inline JSC::EncodedJSValue jsCSSStyleDeclarationPrototypeFunction_setPropertyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleDeclaration>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto property = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto value = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto priority = argument2.value().isUndefined() ? emptyString() : convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setProperty(WTFMove(property), WTFMove(value), WTFMove(priority)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleDeclarationPrototypeFunction_setProperty, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleDeclaration>::call<jsCSSStyleDeclarationPrototypeFunction_setPropertyBody>(*lexicalGlobalObject, *callFrame, "setProperty");
}

static inline JSC::EncodedJSValue jsCSSStyleDeclarationPrototypeFunction_removePropertyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleDeclaration>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto property = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUSVString>(*lexicalGlobalObject, throwScope, impl.removeProperty(WTFMove(property)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleDeclarationPrototypeFunction_removeProperty, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleDeclaration>::call<jsCSSStyleDeclarationPrototypeFunction_removePropertyBody>(*lexicalGlobalObject, *callFrame, "removeProperty");
}

static inline JSC::EncodedJSValue jsCSSStyleDeclarationPrototypeFunction_getPropertyCSSValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleDeclaration>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto propertyName = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<DeprecatedCSSOMValue>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getPropertyCSSValue(WTFMove(propertyName)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleDeclarationPrototypeFunction_getPropertyCSSValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleDeclaration>::call<jsCSSStyleDeclarationPrototypeFunction_getPropertyCSSValueBody>(*lexicalGlobalObject, *callFrame, "getPropertyCSSValue");
}

JSC::GCClient::IsoSubspace* JSCSSStyleDeclaration::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSStyleDeclaration, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSStyleDeclaration.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSStyleDeclaration = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSStyleDeclaration.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSStyleDeclaration = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSCSSStyleDeclaration::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSCSSStyleDeclaration*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSCSSStyleDeclaration);

template<typename Visitor>
void JSCSSStyleDeclaration::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSCSSStyleDeclaration*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSCSSStyleDeclaration::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSCSSStyleDeclaration::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSCSSStyleDeclaration::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSStyleDeclaration*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSCSSStyleDeclarationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsCSSStyleDeclaration = jsCast<JSCSSStyleDeclaration*>(handle.slot()->asCell());
    auto& owner = jsCSSStyleDeclaration->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsCSSStyleDeclaration";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSCSSStyleDeclarationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCSSStyleDeclaration = static_cast<JSCSSStyleDeclaration*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCSSStyleDeclaration->wrapped(), jsCSSStyleDeclaration);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSStyleDeclaration>&& impl)
{
    return createWrapper<CSSStyleDeclaration>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSStyleDeclaration& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CSSStyleDeclaration* JSCSSStyleDeclaration::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSStyleDeclaration*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
