/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioScheduledSourceNode.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsAudioScheduledSourceNodePrototypeFunction_start);
static JSC_DECLARE_HOST_FUNCTION(jsAudioScheduledSourceNodePrototypeFunction_stop);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsAudioScheduledSourceNodeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioScheduledSourceNode_onended);
static JSC_DECLARE_CUSTOM_SETTER(setJSAudioScheduledSourceNode_onended);

class JSAudioScheduledSourceNodePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioScheduledSourceNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioScheduledSourceNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioScheduledSourceNodePrototype>(vm)) JSAudioScheduledSourceNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioScheduledSourceNodePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioScheduledSourceNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioScheduledSourceNodePrototype, JSAudioScheduledSourceNodePrototype::Base);

using JSAudioScheduledSourceNodeDOMConstructor = JSDOMConstructorNotConstructable<JSAudioScheduledSourceNode>;

template<> const ClassInfo JSAudioScheduledSourceNodeDOMConstructor::s_info = { "AudioScheduledSourceNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioScheduledSourceNodeDOMConstructor) };

template<> JSValue JSAudioScheduledSourceNodeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSAudioScheduledSourceNodeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AudioScheduledSourceNode"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSAudioScheduledSourceNode::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSAudioScheduledSourceNodePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioScheduledSourceNodeConstructor, 0 } },
    { "onended"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioScheduledSourceNode_onended, setJSAudioScheduledSourceNode_onended } },
    { "start"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioScheduledSourceNodePrototypeFunction_start, 0 } },
    { "stop"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioScheduledSourceNodePrototypeFunction_stop, 0 } },
};

const ClassInfo JSAudioScheduledSourceNodePrototype::s_info = { "AudioScheduledSourceNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioScheduledSourceNodePrototype) };

void JSAudioScheduledSourceNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioScheduledSourceNode::info(), JSAudioScheduledSourceNodePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSAudioScheduledSourceNode::s_info = { "AudioScheduledSourceNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioScheduledSourceNode) };

JSAudioScheduledSourceNode::JSAudioScheduledSourceNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioScheduledSourceNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, AudioScheduledSourceNode>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSAudioScheduledSourceNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSAudioScheduledSourceNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSAudioScheduledSourceNodePrototype::create(vm, &globalObject, structure);
}

JSObject* JSAudioScheduledSourceNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioScheduledSourceNode>(vm, globalObject);
}

JSValue JSAudioScheduledSourceNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioScheduledSourceNodeDOMConstructor, DOMConstructorID::AudioScheduledSourceNode>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioScheduledSourceNodeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioScheduledSourceNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioScheduledSourceNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsAudioScheduledSourceNode_onendedGetter(JSGlobalObject& lexicalGlobalObject, JSAudioScheduledSourceNode& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().endedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioScheduledSourceNode_onended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioScheduledSourceNode>::get<jsAudioScheduledSourceNode_onendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSAudioScheduledSourceNode_onendedSetter(JSGlobalObject& lexicalGlobalObject, JSAudioScheduledSourceNode& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().endedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSAudioScheduledSourceNode_onended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioScheduledSourceNode>::set<setJSAudioScheduledSourceNode_onendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsAudioScheduledSourceNodePrototypeFunction_startBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioScheduledSourceNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto when = argument0.value().isUndefined() ? 0 : convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.startLater(WTFMove(when)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioScheduledSourceNodePrototypeFunction_start, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioScheduledSourceNode>::call<jsAudioScheduledSourceNodePrototypeFunction_startBody>(*lexicalGlobalObject, *callFrame, "start");
}

static inline JSC::EncodedJSValue jsAudioScheduledSourceNodePrototypeFunction_stopBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioScheduledSourceNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto when = argument0.value().isUndefined() ? 0 : convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.stopLater(WTFMove(when)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioScheduledSourceNodePrototypeFunction_stop, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioScheduledSourceNode>::call<jsAudioScheduledSourceNodePrototypeFunction_stopBody>(*lexicalGlobalObject, *callFrame, "stop");
}

JSC::GCClient::IsoSubspace* JSAudioScheduledSourceNode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSAudioScheduledSourceNode, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForAudioScheduledSourceNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForAudioScheduledSourceNode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForAudioScheduledSourceNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForAudioScheduledSourceNode = std::forward<decltype(space)>(space); }
    );
}

void JSAudioScheduledSourceNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioScheduledSourceNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSAudioScheduledSourceNodeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsAudioScheduledSourceNode = jsCast<JSAudioScheduledSourceNode*>(handle.slot()->asCell());
    auto& wrapped = jsAudioScheduledSourceNode->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAudioScheduledSourceNodeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioScheduledSourceNode = static_cast<JSAudioScheduledSourceNode*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAudioScheduledSourceNode->wrapped(), jsAudioScheduledSourceNode);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioScheduledSourceNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore24AudioScheduledSourceNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioScheduledSourceNode>&& impl)
{

    if constexpr (std::is_polymorphic_v<AudioScheduledSourceNode>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7AudioScheduledSourceNode@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore24AudioScheduledSourceNodeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // AudioScheduledSourceNode has subclasses. If AudioScheduledSourceNode has subclasses that get passed
        // to toJS() we currently require AudioScheduledSourceNode you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<AudioScheduledSourceNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioScheduledSourceNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
