/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioBufferSourceOptions.h"

#include "JSAudioBuffer.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> AudioBufferSourceOptions convertDictionary<AudioBufferSourceOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    AudioBufferSourceOptions result;
    JSValue bufferValue;
    if (isNullOrUndefined)
        bufferValue = jsUndefined();
    else {
        bufferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buffer"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bufferValue.isUndefined()) {
        result.buffer = convert<IDLNullable<IDLInterface<AudioBuffer>>>(lexicalGlobalObject, bufferValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue detuneValue;
    if (isNullOrUndefined)
        detuneValue = jsUndefined();
    else {
        detuneValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detune"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!detuneValue.isUndefined()) {
        result.detune = convert<IDLFloat>(lexicalGlobalObject, detuneValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.detune = 0;
    JSValue loopValue;
    if (isNullOrUndefined)
        loopValue = jsUndefined();
    else {
        loopValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "loop"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!loopValue.isUndefined()) {
        result.loop = convert<IDLBoolean>(lexicalGlobalObject, loopValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.loop = false;
    JSValue loopEndValue;
    if (isNullOrUndefined)
        loopEndValue = jsUndefined();
    else {
        loopEndValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "loopEnd"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!loopEndValue.isUndefined()) {
        result.loopEnd = convert<IDLDouble>(lexicalGlobalObject, loopEndValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.loopEnd = 0;
    JSValue loopStartValue;
    if (isNullOrUndefined)
        loopStartValue = jsUndefined();
    else {
        loopStartValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "loopStart"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!loopStartValue.isUndefined()) {
        result.loopStart = convert<IDLDouble>(lexicalGlobalObject, loopStartValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.loopStart = 0;
    JSValue playbackRateValue;
    if (isNullOrUndefined)
        playbackRateValue = jsUndefined();
    else {
        playbackRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "playbackRate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!playbackRateValue.isUndefined()) {
        result.playbackRate = convert<IDLFloat>(lexicalGlobalObject, playbackRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.playbackRate = 1;
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
