/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.plaf;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreePath;
import javax.swing.tree.VariableHeightLayoutCache;

public class SIPCommTreeUI
extends BasicTreeUI
implements HierarchyListener,
TreeSelectionListener {
    private static JTree tree;
    private JViewport parentViewport;
    private VariableLayoutCache layoutCache;
    private int lastSelectedIndex;

    public static ComponentUI createUI(JComponent c) {
        return new SIPCommTreeUI();
    }

    @Override
    public void installUI(JComponent c) {
        if (c == null) {
            throw new NullPointerException("null component passed to BasicTreeUI.installUI()");
        }
        tree = (JTree)c;
        JViewport v = this.getFirstParentViewport(tree);
        if (v != null) {
            this.parentViewport = v;
        } else {
            tree.addHierarchyListener(this);
        }
        tree.getSelectionModel().addTreeSelectionListener(this);
        super.installUI(c);
    }

    private JViewport getFirstParentViewport(Container c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JViewport) {
            return (JViewport)c;
        }
        return this.getFirstParentViewport(c.getParent());
    }

    @Override
    public void uninstallUI(JComponent c) {
        tree.getSelectionModel().clearSelection();
        tree.getSelectionModel().removeTreeSelectionListener(this);
        tree.removeHierarchyListener(this);
        super.uninstallUI(c);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (e.getID() == 1400 && (e.getChangeFlags() & 1L) != 0L && e.getChangedParent() instanceof JViewport) {
            this.parentViewport = (JViewport)e.getChangedParent();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.selectionChanged(e.getOldLeadSelectionPath(), e.getNewLeadSelectionPath());
    }

    @Override
    protected void installDefaults() {
        if (tree.getBackground() == null || tree.getBackground() instanceof UIResource) {
            tree.setBackground(UIManager.getColor("Tree.background"));
        }
        if (this.getHashColor() == null || this.getHashColor() instanceof UIResource) {
            this.setHashColor(UIManager.getColor("Tree.hash"));
        }
        if (tree.getFont() == null || tree.getFont() instanceof UIResource) {
            tree.setFont(UIManager.getFont("Tree.font"));
        }
        this.setExpandedIcon(null);
        this.setCollapsedIcon(null);
        this.setLeftChildIndent(0);
        this.setRightChildIndent(0);
        LookAndFeel.installProperty(tree, "rowHeight", UIManager.get("Tree.rowHeight"));
        this.largeModel = tree.isLargeModel() && tree.getRowHeight() > 0;
        Object scrollsOnExpand = UIManager.get("Tree.scrollsOnExpand");
        if (scrollsOnExpand != null) {
            LookAndFeel.installProperty(tree, "scrollsOnExpand", scrollsOnExpand);
        }
        UIManager.getDefaults().put("Tree.paintLines", (Object)false);
        UIManager.getDefaults().put("Tree.lineTypeDashed", (Object)false);
    }

    @Override
    protected AbstractLayoutCache createLayoutCache() {
        this.layoutCache = new VariableLayoutCache();
        return this.layoutCache;
    }

    @Override
    protected void selectPathForEvent(TreePath path, MouseEvent event) {
        super.selectPathForEvent(path, event);
    }

    private void ensureTreeSize() {
        this.updateSize();
        tree.repaint();
    }

    public void selectionChanged(TreePath oldPath, TreePath newPath) {
        if (oldPath != null) {
            this.layoutCache.invalidatePathBounds(oldPath);
        }
        if (newPath != null) {
            this.layoutCache.invalidatePathBounds(newPath);
            this.lastSelectedIndex = tree.getRowForPath(newPath);
        } else {
            int nextRow = tree.getRowCount() > this.lastSelectedIndex ? this.lastSelectedIndex : tree.getRowCount() - 1;
            this.layoutCache.invalidatePathBounds(tree.getPathForRow(nextRow));
        }
        this.ensureTreeSize();
    }

    private class VariableLayoutCache
    extends VariableHeightLayoutCache {
        private VariableLayoutCache() {
        }

        @Override
        public Rectangle getBounds(TreePath path, Rectangle placeIn) {
            Rectangle rect = super.getBounds(path, placeIn);
            if (rect != null && SIPCommTreeUI.this.parentViewport != null) {
                rect.width = SIPCommTreeUI.this.parentViewport.getWidth() - 2;
            }
            return rect;
        }
    }
}

