/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.ldap;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.java.sip.communicator.impl.ldap.LdapActivator;
import net.java.sip.communicator.impl.ldap.LdapContactSourceService;
import net.java.sip.communicator.impl.ldap.LdapDirectorySettingsImpl;
import net.java.sip.communicator.plugin.desktoputil.AuthenticationWindow;
import net.java.sip.communicator.service.contactsource.AsyncContactQuery;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.GenericSourceContact;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.ldap.LdapDirectory;
import net.java.sip.communicator.service.ldap.LdapFactory;
import net.java.sip.communicator.service.ldap.LdapPersonFound;
import net.java.sip.communicator.service.ldap.LdapQuery;
import net.java.sip.communicator.service.ldap.LdapSearchSettings;
import net.java.sip.communicator.service.ldap.LdapService;
import net.java.sip.communicator.service.ldap.event.LdapEvent;
import net.java.sip.communicator.service.ldap.event.LdapListener;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.PhoneNumberI18nService;

public class LdapContactQuery
extends AsyncContactQuery<LdapContactSourceService> {
    public static final int LDAP_MAX_RESULTS = 40;
    private final int count;
    private LdapQuery ldapQuery = null;
    private final Object objLock = new Object();

    protected LdapContactQuery(LdapContactSourceService contactSource, Pattern query, int count) {
        super((ContactSourceService)contactSource, query);
        this.count = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        String queryStr = this.query.toString();
        if (queryStr.length() < 2) {
            return;
        }
        LdapService ldapService = LdapActivator.getLdapService();
        LdapFactory factory = ldapService.getFactory();
        this.ldapQuery = factory.createQuery(queryStr);
        LdapSearchSettings settings = factory.createSearchSettings();
        settings.setDelay(250);
        settings.setMaxResults(this.count);
        LdapListener caller = new LdapListener(){

            @Override
            public void ldapEventReceived(LdapEvent evt) {
                LdapContactQuery.this.processLdapResponse(evt);
            }
        };
        LdapDirectory ldapDir = ((LdapContactSourceService)this.getContactSource()).getLdapDirectory();
        if (ldapDir == null) {
            return;
        }
        ldapDir.searchPerson(this.ldapQuery, caller, settings);
        Object object = this.objLock;
        synchronized (object) {
            try {
                this.objLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void start() {
        boolean hasStarted = false;
        try {
            super.start();
            hasStarted = true;
        }
        finally {
            if (!hasStarted) {
                ((LdapContactSourceService)this.getContactSource()).removeQuery((ContactQuery)this);
            }
        }
    }

    private List<ContactDetail> getContactDetails(LdapPersonFound person) {
        ContactDetail detail;
        LinkedList<ContactDetail> ret = new LinkedList<ContactDetail>();
        Set<String> mailAddresses = person.getMail();
        Set<String> mobilePhones = person.getMobilePhone();
        Set<String> homePhones = person.getHomePhone();
        Set<String> workPhones = person.getWorkPhone();
        PhoneNumberI18nService phoneNumberI18nService = LdapActivator.getPhoneNumberI18nService();
        for (String mail : mailAddresses) {
            detail = new ContactDetail(mail, ContactDetail.Category.Email);
            detail.addSupportedOpSet(OperationSetPersistentPresence.class);
            ret.add(detail);
        }
        for (String homePhone : homePhones) {
            homePhone = phoneNumberI18nService.normalize(homePhone);
            detail = new ContactDetail(homePhone, ContactDetail.Category.Phone, new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Home});
            detail.addSupportedOpSet(OperationSetBasicTelephony.class);
            detail.addSupportedOpSet(OperationSetPersistentPresence.class);
            ret.add(detail);
        }
        for (String workPhone : workPhones) {
            workPhone = phoneNumberI18nService.normalize(workPhone);
            detail = new ContactDetail(workPhone, ContactDetail.Category.Phone, new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Work});
            detail.addSupportedOpSet(OperationSetBasicTelephony.class);
            detail.addSupportedOpSet(OperationSetPersistentPresence.class);
            ret.add(detail);
        }
        for (String mobilePhone : mobilePhones) {
            mobilePhone = phoneNumberI18nService.normalize(mobilePhone);
            detail = new ContactDetail(mobilePhone, ContactDetail.Category.Phone, new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Mobile});
            detail.addSupportedOpSet(OperationSetBasicTelephony.class);
            detail.addSupportedOpSet(OperationSetPersistentPresence.class);
            ret.add(detail);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLdapResponse(LdapEvent evt) {
        Object object;
        if (evt.getCause() == LdapEvent.LdapEventCause.SEARCH_ACHIEVED || evt.getCause() == LdapEvent.LdapEventCause.SEARCH_CANCELLED) {
            object = this.objLock;
            synchronized (object) {
                this.objLock.notify();
            }
        }
        if (evt.getCause() == LdapEvent.LdapEventCause.SEARCH_ERROR) {
            this.setStatus(2);
            object = this.objLock;
            synchronized (object) {
                this.objLock.notify();
            }
        }
        if (evt.getCause() == LdapEvent.LdapEventCause.NEW_SEARCH_RESULT) {
            LdapPersonFound person = (LdapPersonFound)evt.getContent();
            String displayName = null;
            if (person == null) {
                return;
            }
            displayName = person.getDisplayName() != null ? person.getDisplayName() : person.getFirstName() + " " + person.getSurname();
            List<ContactDetail> contactDetails = this.getContactDetails(person);
            if (!contactDetails.isEmpty()) {
                GenericSourceContact sourceContact = new GenericSourceContact(this.getContactSource(), displayName, contactDetails);
                try {
                    sourceContact.setImage(person.getPhoto());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    // empty catch block
                }
                if (person.getOrganization() != null) {
                    sourceContact.setDisplayDetails(person.getOrganization());
                }
                this.addQueryResult((SourceContact)sourceContact);
            }
        } else if (evt.getCause() == LdapEvent.LdapEventCause.SEARCH_AUTH_ERROR) {
            object = this.objLock;
            synchronized (object) {
                this.objLock.notify();
            }
            new Thread(){

                @Override
                public void run() {
                    LdapDirectorySettingsImpl ldapSettings = (LdapDirectorySettingsImpl)((LdapContactSourceService)LdapContactQuery.this.getContactSource()).getLdapDirectory().getSettings();
                    AuthenticationWindow authWindow = new AuthenticationWindow(ldapSettings.getUserName(), ldapSettings.getPassword().toCharArray(), ldapSettings.getName(), false, LdapActivator.getResourceService().getImage("service.gui.icons.AUTHORIZATION_ICON"), LdapActivator.getResourceService().getI18NString("impl.ldap.WRONG_CREDENTIALS", new String[]{ldapSettings.getName()}));
                    authWindow.setVisible(true);
                    if (!authWindow.isCanceled()) {
                        LdapDirectorySettingsImpl newSettings = new LdapDirectorySettingsImpl(ldapSettings);
                        LdapService ldapService = LdapActivator.getLdapService();
                        LdapFactory factory = ldapService.getFactory();
                        LdapDirectory ldapDir = ((LdapContactSourceService)LdapContactQuery.this.getContactSource()).getLdapDirectory();
                        LdapActivator.unregisterContactSource(ldapDir);
                        ldapService.getServerSet().removeServerWithName(ldapSettings.getName());
                        newSettings.setPassword(new String(authWindow.getPassword()));
                        ldapDir = factory.createServer(newSettings);
                        ldapService.getServerSet().addServer(ldapDir);
                        LdapActivator.registerContactSource(ldapDir);
                    }
                }
            }.start();
        }
    }

    protected void stopped(boolean completed) {
        try {
            super.stopped(completed);
        }
        finally {
            ((LdapContactSourceService)this.getContactSource()).stopped(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.ldapQuery != null) {
            this.ldapQuery.setState(LdapQuery.State.CANCELLED);
        }
        Object object = this.objLock;
        synchronized (object) {
            this.objLock.notify();
        }
        super.cancel();
    }
}

