/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import javax.sip.ClientTransaction;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.address.Address;
import javax.sip.header.ContentTypeHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.CallPeerMediaHandlerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallSipImpl;
import net.java.sip.communicator.impl.protocol.sip.MethodProcessorAdapter;
import net.java.sip.communicator.impl.protocol.sip.OperationSetBasicTelephonySipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipStackSharing;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.media.AbstractOperationSetVideoTelephony;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.QualityControl;
import org.jitsi.service.neomedia.QualityPreset;

public class OperationSetVideoTelephonySipImpl
extends AbstractOperationSetVideoTelephony<OperationSetBasicTelephonySipImpl, ProtocolProviderServiceSipImpl, CallSipImpl, CallPeerSipImpl> {
    private static final Logger logger = Logger.getLogger(OperationSetVideoTelephonySipImpl.class);

    public OperationSetVideoTelephonySipImpl(OperationSetBasicTelephonySipImpl basicTelephony) {
        super((OperationSetBasicTelephony)basicTelephony);
        ((ProtocolProviderServiceSipImpl)this.parentProvider).registerMethodProcessor("INFO", new PictureFastUpdateMethodProcessor());
    }

    public void setLocalVideoAllowed(Call call, boolean allowed) throws OperationFailedException {
        super.setLocalVideoAllowed(call, allowed);
        ((CallSipImpl)call).reInvite();
    }

    public Call createVideoCall(String uri) throws OperationFailedException, ParseException {
        return this.createVideoCall(uri, null);
    }

    public Call createVideoCall(Contact callee) throws OperationFailedException {
        return this.createVideoCall(callee, null);
    }

    public Call createVideoCall(String uri, QualityPreset qualityPreferences) throws OperationFailedException, ParseException {
        return this.createVideoCall(((ProtocolProviderServiceSipImpl)this.parentProvider).parseAddressString(uri), qualityPreferences);
    }

    private Call createVideoCall(Address toAddress, QualityPreset qualityPreferences) throws OperationFailedException {
        CallSipImpl call = ((OperationSetBasicTelephonySipImpl)this.basicTelephony).createOutgoingCall();
        call.setLocalVideoAllowed(true, this.getMediaUseCase());
        call.setInitialQualityPreferences(qualityPreferences);
        call.invite(toAddress, null);
        return call;
    }

    public Call createVideoCall(Contact callee, QualityPreset qualityPreferences) throws OperationFailedException {
        Address toAddress;
        try {
            toAddress = ((ProtocolProviderServiceSipImpl)this.parentProvider).parseAddressString(callee.getAddress());
        }
        catch (ParseException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new IllegalArgumentException(ex.getMessage());
        }
        return this.createVideoCall(toAddress, qualityPreferences);
    }

    public void answerVideoCallPeer(CallPeer peer) throws OperationFailedException {
        CallPeerSipImpl callPeer = (CallPeerSipImpl)peer;
        ((CallSipImpl)callPeer.getCall()).setLocalVideoAllowed(true, this.getMediaUseCase());
        callPeer.answer();
    }

    public QualityControl getQualityControl(CallPeer peer) {
        return ((CallPeerMediaHandlerSipImpl)((CallPeerSipImpl)peer).getMediaHandler()).getQualityControl();
    }

    private class PictureFastUpdateMethodProcessor
    extends MethodProcessorAdapter {
        private PictureFastUpdateMethodProcessor() {
        }

        private boolean isPictureFastUpdate(Request request) {
            String xml;
            ContentTypeHeader contentTypeHeader = (ContentTypeHeader)request.getHeader("Content-Type");
            if (contentTypeHeader == null) {
                return false;
            }
            if (!"application".equalsIgnoreCase(contentTypeHeader.getContentType())) {
                return false;
            }
            if (!"media_control+xml".equalsIgnoreCase(contentTypeHeader.getContentSubType())) {
                return false;
            }
            Object content = request.getContent();
            if (content == null) {
                return false;
            }
            if (content instanceof String) {
                xml = content.toString();
            } else if (content instanceof byte[]) {
                byte[] bytes = (byte[])content;
                try {
                    xml = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    xml = new String(bytes);
                }
            } else {
                return false;
            }
            if (xml == null) {
                return false;
            }
            return xml.contains("picture_fast_update");
        }

        @Override
        public boolean processRequest(RequestEvent requestEvent) {
            ServerTransaction serverTransaction;
            if (requestEvent == null) {
                return false;
            }
            Request request = requestEvent.getRequest();
            if (request == null) {
                return false;
            }
            if (!this.isPictureFastUpdate(request)) {
                return false;
            }
            try {
                serverTransaction = SipStackSharing.getOrCreateServerTransaction(requestEvent);
            }
            catch (Exception e) {
                logger.error((Object)"Error creating server transaction", (Throwable)e);
                return false;
            }
            if (serverTransaction == null) {
                return false;
            }
            CallPeerSipImpl callPeer = ((OperationSetBasicTelephonySipImpl)OperationSetVideoTelephonySipImpl.this.basicTelephony).getActiveCallsRepository().findCallPeer(serverTransaction.getDialog());
            if (callPeer == null) {
                return false;
            }
            try {
                return callPeer.processPictureFastUpdate(serverTransaction, request);
            }
            catch (OperationFailedException ofe) {
                return false;
            }
        }

        @Override
        public boolean processResponse(ResponseEvent responseEvent) {
            if (responseEvent == null) {
                return false;
            }
            Response response = responseEvent.getResponse();
            if (response == null) {
                return false;
            }
            ClientTransaction clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction == null) {
                return false;
            }
            Request request = clientTransaction.getRequest();
            if (request == null) {
                return false;
            }
            if (!this.isPictureFastUpdate(request)) {
                return false;
            }
            CallPeerSipImpl callPeer = ((OperationSetBasicTelephonySipImpl)OperationSetVideoTelephonySipImpl.this.basicTelephony).getActiveCallsRepository().findCallPeer(clientTransaction.getDialog());
            if (callPeer == null) {
                return false;
            }
            callPeer.processPictureFastUpdate(clientTransaction, response);
            return true;
        }
    }
}

