/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.thumbnail;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import net.java.sip.communicator.impl.protocol.jabber.extensions.thumbnail.ThumbnailElement;
import org.jitsi.util.Logger;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.jivesoftware.smackx.packet.StreamInitiation;
import org.jivesoftware.smackx.provider.DataFormProvider;
import org.xmlpull.v1.XmlPullParser;

public class FileElement
extends StreamInitiation.File
implements IQProvider {
    private static final Logger logger = Logger.getLogger(FileElement.class);
    private static final List<DateFormat> DATE_FORMATS = new ArrayList<DateFormat>();
    public static final String ELEMENT_NAME = "si";
    public static final String NAMESPACE = "http://jabber.org/protocol/si";
    private ThumbnailElement thumbnail;

    public FileElement() {
        this("", 0L);
    }

    public FileElement(StreamInitiation.File baseFile, ThumbnailElement thumbnail) {
        this(baseFile.getName(), baseFile.getSize());
        this.thumbnail = thumbnail;
    }

    public FileElement(String name, long size) {
        super(name, size);
    }

    public String toXML() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\" ");
        if (this.getName() != null) {
            buffer.append("name=\"").append(StringUtils.escapeForXML((String)this.getName())).append("\" ");
        }
        if (this.getSize() > 0L) {
            buffer.append("size=\"").append(this.getSize()).append("\" ");
        }
        if (this.getDate() != null) {
            buffer.append("date=\"").append(StringUtils.formatXEP0082Date((Date)this.getDate())).append("\" ");
        }
        if (this.getHash() != null) {
            buffer.append("hash=\"").append(this.getHash()).append("\" ");
        }
        if (this.getDesc() != null && this.getDesc().length() > 0 || this.isRanged() || this.thumbnail != null) {
            buffer.append(">");
            if (this.getDesc() != null && this.getDesc().length() > 0) {
                buffer.append("<desc>").append(StringUtils.escapeForXML((String)this.getDesc())).append("</desc>");
            }
            if (this.isRanged()) {
                buffer.append("<range/>");
            }
            if (this.thumbnail != null) {
                buffer.append(this.thumbnail.toXML());
            }
            buffer.append("</").append(this.getElementName()).append(">");
        } else {
            buffer.append("/>");
        }
        return buffer.toString();
    }

    public ThumbnailElement getThumbnailElement() {
        return this.thumbnail;
    }

    public void setThumbnailElement(ThumbnailElement thumbnail) {
        this.thumbnail = thumbnail;
    }

    public IQ parseIQ(XmlPullParser parser) throws Exception {
        boolean done = false;
        String id = parser.getAttributeValue("", "id");
        String mimeType = parser.getAttributeValue("", "mime-type");
        StreamInitiation initiation = new StreamInitiation();
        String name = null;
        String size = null;
        String hash = null;
        String date = null;
        String desc = null;
        ThumbnailElement thumbnail = null;
        boolean isRanged = false;
        DataForm form = null;
        DataFormProvider dataFormProvider = new DataFormProvider();
        while (!done) {
            int eventType = parser.next();
            String elementName = parser.getName();
            String namespace = parser.getNamespace();
            if (eventType == 2) {
                if (elementName.equals("file")) {
                    name = parser.getAttributeValue("", "name");
                    size = parser.getAttributeValue("", "size");
                    hash = parser.getAttributeValue("", "hash");
                    date = parser.getAttributeValue("", "date");
                    continue;
                }
                if (elementName.equals("desc")) {
                    desc = parser.nextText();
                    continue;
                }
                if (elementName.equals("range")) {
                    isRanged = true;
                    continue;
                }
                if (elementName.equals("x") && namespace.equals("jabber:x:data")) {
                    form = (DataForm)dataFormProvider.parseExtension(parser);
                    continue;
                }
                if (!elementName.equals("thumbnail")) continue;
                thumbnail = new ThumbnailElement(parser.getText());
                continue;
            }
            if (eventType != 3) continue;
            if (elementName.equals(ELEMENT_NAME)) {
                done = true;
                continue;
            }
            if (!elementName.equals("file") || name == null) continue;
            long fileSize = 0L;
            if (size != null && size.trim().length() != 0) {
                try {
                    fileSize = Long.parseLong(size);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"Received an invalid file size, continuing with fileSize set to 0", (Throwable)e);
                }
            }
            FileElement file = new FileElement(name, fileSize);
            file.setHash(hash);
            if (date != null) {
                boolean found = false;
                if (date.matches(".*?T\\d+:\\d+:\\d+(\\.\\d+)?(\\+|-)\\d+:\\d+")) {
                    int timeZoneColon = date.lastIndexOf(":");
                    date = date.substring(0, timeZoneColon) + date.substring(timeZoneColon + 1, date.length());
                }
                for (DateFormat fmt : DATE_FORMATS) {
                    try {
                        file.setDate(fmt.parse(date));
                        found = true;
                        break;
                    }
                    catch (ParseException parseException) {
                    }
                }
                if (!found) {
                    logger.warn((Object)("Unknown dateformat on incoming file transfer: " + date));
                }
            }
            if (thumbnail != null) {
                file.setThumbnailElement(thumbnail);
            }
            file.setDesc(desc);
            file.setRanged(isRanged);
            initiation.setFile((StreamInitiation.File)file);
        }
        initiation.setSesssionID(id);
        initiation.setMimeType(mimeType);
        initiation.setFeatureNegotiationForm(form);
        return initiation;
    }

    static {
        DATE_FORMATS.add(DelayInformation.XEP_0091_UTC_FORMAT);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMd'T'HH:mm:ss'Z'");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        DATE_FORMATS.add(fmt);
        fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        DATE_FORMATS.add(fmt);
        fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        DATE_FORMATS.add(fmt);
        DATE_FORMATS.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"));
        DATE_FORMATS.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
    }
}

