/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.ulaw;

import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.AudioFormatCompleter;
import net.sf.fmj.media.codec.audio.ulaw.MuLawDecoderUtil;
import net.sf.fmj.utility.LoggerSingleton;

public class Decoder
extends AbstractCodec {
    private static final Logger logger = LoggerSingleton.logger;
    protected Format[] outputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, -1, 1, 16, -1.0, Format.byteArray)};
    private static final boolean TRACE = false;

    public Decoder() {
        this.inputFormats = new Format[]{new AudioFormat("ULAW", -1.0, 8, 1, -1, 1, 8, -1.0, Format.byteArray)};
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return "ULAW Decoder";
    }

    @Override
    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.outputFormats;
        }
        if (!(input instanceof AudioFormat)) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + input);
            return new Format[]{null};
        }
        AudioFormat inputCast = (AudioFormat)input;
        if (!inputCast.getEncoding().equals("ULAW") || inputCast.getSampleSizeInBits() != 8 && inputCast.getSampleSizeInBits() != -1 || inputCast.getChannels() != 1 && inputCast.getChannels() != -1 || inputCast.getSigned() != 1 && inputCast.getSigned() != -1 || inputCast.getFrameSizeInBits() != 8 && inputCast.getFrameSizeInBits() != -1 || inputCast.getDataType() != null && inputCast.getDataType() != Format.byteArray) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + input);
            return new Format[]{null};
        }
        int endian = inputCast.getEndian();
        if (inputCast.getSampleSizeInBits() == 8) {
            endian = 0;
        }
        AudioFormat result = new AudioFormat("LINEAR", inputCast.getSampleRate(), 16, 1, endian, 1, 16, inputCast.getFrameRate(), Format.byteArray);
        return new Format[]{result};
    }

    @Override
    public void open() {
    }

    @Override
    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        byte[] outputBufferData = (byte[])outputBuffer.getData();
        if (outputBufferData == null || outputBufferData.length < inputBuffer.getLength() * 2) {
            outputBufferData = new byte[inputBuffer.getLength() * 2];
            outputBuffer.setData(outputBufferData);
        }
        boolean bigEndian = ((AudioFormat)this.outputFormat).getEndian() == 1;
        MuLawDecoderUtil.muLawDecode(bigEndian, (byte[])inputBuffer.getData(), inputBuffer.getOffset(), inputBuffer.getLength(), outputBufferData);
        outputBuffer.setLength(inputBuffer.getLength() * 2);
        outputBuffer.setOffset(0);
        outputBuffer.setFormat(this.outputFormat);
        boolean result = false;
        return 0;
    }

    @Override
    public Format setInputFormat(Format arg0) {
        return super.setInputFormat(arg0);
    }

    @Override
    public Format setOutputFormat(Format format) {
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        AudioFormat audioFormat = (AudioFormat)format;
        return super.setOutputFormat(AudioFormatCompleter.complete(audioFormat));
    }
}

