/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.generalconfig;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.win32.StdCallLibrary;
import java.io.File;
import net.java.sip.communicator.util.Logger;

public class WindowsStartup {
    private static final Logger logger = Logger.getLogger(WindowsStartup.class);
    private static String REGISTRY_STARTUP_KEY = "Software\\Microsoft\\Windows\\CurrentVersion\\Run";

    public static boolean isStartupEnabled(String appName) {
        return Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_STARTUP_KEY, (String)appName);
    }

    public static String getModuleFilename() {
        byte[] exePathName = new byte[512];
        WinNT.HANDLE process = Kernel32.INSTANCE.GetCurrentProcess();
        int result = PSAPI.INSTANCE.GetModuleFileNameExA(process, new Pointer(0L), exePathName, exePathName.length);
        return Native.toString((byte[])exePathName).substring(0, result);
    }

    public static void setAutostart(String appName, String workingDirectory, boolean isAutoStart) {
        if (isAutoStart) {
            int ix;
            String executableFileName = null;
            String filePath = WindowsStartup.getModuleFilename();
            if (filePath != null && filePath.length() > 0 && (ix = filePath.lastIndexOf(File.separatorChar)) > 0) {
                executableFileName = filePath.substring(ix + 1);
            }
            if (executableFileName == null) {
                logger.warn((Object)"Missing information for process, shortcut will be created any way using defaults.");
                executableFileName = appName.replaceAll(" ", "").replaceAll("_", "").replaceAll("-", "") + ".exe";
            }
            Advapi32Util.registrySetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_STARTUP_KEY, (String)appName, (String)(workingDirectory + File.separator + executableFileName));
        } else {
            try {
                Advapi32Util.registryDeleteValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_STARTUP_KEY, (String)appName);
            }
            catch (Throwable t) {
                logger.warn((Object)"Cannot remove startup key or don't exist", t);
            }
        }
    }

    public static interface PSAPI
    extends StdCallLibrary {
        public static final PSAPI INSTANCE = (PSAPI)Native.loadLibrary((String)"psapi", PSAPI.class);

        public int GetModuleFileNameExA(WinNT.HANDLE var1, Pointer var2, byte[] var3, int var4);
    }
}

