/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.busylampfield;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.plugin.busylampfield.BLFActivator;
import net.java.sip.communicator.plugin.busylampfield.BLFPresenceStatus;
import net.java.sip.communicator.plugin.busylampfield.BLFSourceContact;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.customcontactactions.ContactAction;
import net.java.sip.communicator.service.customcontactactions.ContactActionMenuItem;
import net.java.sip.communicator.service.customcontactactions.CustomContactActionsService;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyBLF;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleContext;

public class CustomActionsBLFSourceContact
implements CustomContactActionsService<SourceContact> {
    private final Logger logger = Logger.getLogger(CustomActionsBLFSourceContact.class);
    private final List<ContactAction<SourceContact>> actionsList = new LinkedList<ContactAction<SourceContact>>();

    public CustomActionsBLFSourceContact() {
        this.actionsList.add(new PickupAction());
    }

    public Class<SourceContact> getContactSourceClass() {
        return SourceContact.class;
    }

    public Iterator<ContactAction<SourceContact>> getCustomContactActions() {
        return this.actionsList.iterator();
    }

    public Iterator<ContactActionMenuItem<SourceContact>> getCustomContactActionsMenuItems() {
        return null;
    }

    private class PickupAction
    implements ContactAction<SourceContact> {
        private PickupAction() {
        }

        public void actionPerformed(final SourceContact actionSource, int x, int y) throws OperationFailedException {
            if (!(actionSource instanceof BLFSourceContact)) {
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        OperationSetTelephonyBLF.Line line = ((BLFSourceContact)actionSource).getLine();
                        OperationSetTelephonyBLF opset = (OperationSetTelephonyBLF)line.getProvider().getOperationSet(OperationSetTelephonyBLF.class);
                        opset.pickup(line);
                    }
                    catch (Exception ex) {
                        CustomActionsBLFSourceContact.this.logger.error((Object)"Error picking up call", (Throwable)ex);
                    }
                }
            }).start();
        }

        public byte[] getIcon() {
            return ResourceManagementServiceUtils.getService((BundleContext)BLFActivator.bundleContext).getImageInBytes("plugin.busylampfield.PICKUP_CALL");
        }

        public byte[] getRolloverIcon() {
            return ResourceManagementServiceUtils.getService((BundleContext)BLFActivator.bundleContext).getImageInBytes("plugin.busylampfield.PICKUP_CALL_ROLLOVER");
        }

        public byte[] getPressedIcon() {
            return ResourceManagementServiceUtils.getService((BundleContext)BLFActivator.bundleContext).getImageInBytes("plugin.busylampfield.PICKUP_CALL_PRESSED");
        }

        public String getToolTipText() {
            return ResourceManagementServiceUtils.getService((BundleContext)BLFActivator.bundleContext).getI18NString("plugin.busylampfield.PICKUP");
        }

        public boolean isVisible(SourceContact actionSource) {
            return actionSource.getPresenceStatus().equals((Object)BLFPresenceStatus.BLF_RINGING);
        }
    }
}

