/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chatroomslist.joinforms;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chatroomslist.joinforms.ChatRoomNamePanel;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.WizardContainer;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;

public class SearchChatRoomPanel
extends TransparentPanel
implements ActionListener,
DocumentListener {
    private final ChatRoomNamePanel namePanel = new ChatRoomNamePanel();
    private final JPanel mainPanel = new TransparentPanel();
    private final JPanel searchPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
    private final JTextArea searchTextArea = new JTextArea(GuiActivator.getResources().getI18NString("service.gui.SEARCH_FOR_CHAT_ROOMS_MSG"));
    private final JButton searchButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.SEARCH"));
    private final JPanel buttonPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
    private final JList chatRoomsList = new JList();
    private final JScrollPane chatRoomsScrollPane = new JScrollPane();
    private final WizardContainer wizardContainer;
    private ChatRoomProviderWrapper chatRoomProvider;
    List<String> serverRooms = null;

    public SearchChatRoomPanel(WizardContainer wizardContainer) {
        this.wizardContainer = wizardContainer;
        this.init();
    }

    public SearchChatRoomPanel(ChatRoomProviderWrapper provider) {
        this.chatRoomProvider = provider;
        this.wizardContainer = null;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.buttonPanel.add(this.searchButton);
        this.searchTextArea.setOpaque(false);
        this.searchTextArea.setEditable(false);
        this.searchTextArea.setLineWrap(true);
        this.searchTextArea.setWrapStyleWord(true);
        this.namePanel.addChatRoomNameListener(this);
        this.searchPanel.add(this.searchTextArea);
        this.searchPanel.add(this.buttonPanel);
        this.namePanel.setPreferredSize(new Dimension(520, 100));
        this.searchPanel.setPreferredSize(new Dimension(520, 150));
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        this.mainPanel.add((Component)((Object)this.namePanel));
        this.mainPanel.add(this.searchPanel);
        this.searchPanel.setBorder(BorderFactory.createTitledBorder(GuiActivator.getResources().getI18NString("service.gui.SEARCH")));
        this.searchButton.addActionListener(this);
        this.add(this.mainPanel, "North");
        this.chatRoomsScrollPane.setBorder(BorderFactory.createTitledBorder(GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOMS")));
        this.chatRoomsList.addListSelectionListener(new ChatRoomListSelectionListener());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.loadChatRoomsList();
    }

    public void loadChatRoomsList() {
        this.serverRooms = GuiActivator.getMUCService().getExistingChatRooms(this.chatRoomProvider);
        if (this.serverRooms != null) {
            if (this.serverRooms.size() == 0) {
                this.serverRooms.add(GuiActivator.getResources().getI18NString("service.gui.NO_AVAILABLE_ROOMS"));
            }
            this.chatRoomsList.setListData(new Vector<String>(this.serverRooms));
            this.chatRoomsList.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.chatRoomsScrollPane.setPreferredSize(new Dimension(500, 250));
            this.chatRoomsScrollPane.setOpaque(false);
            this.chatRoomsScrollPane.getViewport().add(this.chatRoomsList);
            this.mainPanel.add(this.chatRoomsScrollPane);
            if (this.wizardContainer != null) {
                this.wizardContainer.refresh();
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public String getChatRoomName() {
        return this.namePanel.getChatRoomName();
    }

    public void setChatRoomName(String chatRoomName) {
        this.namePanel.setChatRoomName(chatRoomName);
    }

    public void requestFocusInField() {
        this.namePanel.requestFocusInField();
    }

    public void setChatRoomProvider(ChatRoomProviderWrapper provider) {
        this.chatRoomProvider = provider;
        this.serverRooms = GuiActivator.getMUCService().getExistingChatRooms(this.chatRoomProvider);
    }

    public void addChatRoomNameListener(DocumentListener l) {
        this.namePanel.addChatRoomNameListener(l);
    }

    public void updateChatRoomList() {
        if (this.namePanel.getChatRoomName().length() > 0) {
            Vector<String> newCRL = new Vector<String>();
            if (this.serverRooms != null) {
                for (String s : this.serverRooms) {
                    if (!s.startsWith(this.namePanel.getChatRoomName())) continue;
                    newCRL.add(s);
                }
            }
            this.chatRoomsList.setListData(newCRL);
        } else {
            this.chatRoomsList.setListData(new Vector<String>(this.serverRooms));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateChatRoomList();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateChatRoomList();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateChatRoomList();
    }

    private class ChatRoomListSelectionListener
    implements ListSelectionListener {
        private ChatRoomListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || SearchChatRoomPanel.this.chatRoomsList.getSelectedIndex() == -1) {
                return;
            }
            SearchChatRoomPanel.this.namePanel.removeChatRoomNameListener(SearchChatRoomPanel.this);
            SearchChatRoomPanel.this.namePanel.setChatRoomName(SearchChatRoomPanel.this.chatRoomsList.getSelectedValue().toString());
            SearchChatRoomPanel.this.namePanel.addChatRoomNameListener(SearchChatRoomPanel.this);
        }
    }
}

