/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.configuration;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.slick.configuration.ConfigurationServiceLick;
import org.jitsi.service.configuration.ConfigPropertyVetoException;
import org.jitsi.service.configuration.ConfigVetoableChangeListener;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TestConfigurationService
extends TestCase {
    private ConfigurationService configurationService = null;
    private PropertyChangeEvent propertyChangeEvent = null;
    private static final String propertyName = "my.test.property";
    private static final String listenedPropertyName = "a.property.i.listen.to";
    private static final String propertyValue = "19200";
    private static final String propertyNewValue = "19201";
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            TestConfigurationService.this.propertyChangeEvent = event;
        }
    };
    ConfigVetoableChangeListener rudeVetoListener = new ConfigVetoableChangeListener(){

        public void vetoableChange(PropertyChangeEvent event) throws ConfigPropertyVetoException {
            throw new ConfigPropertyVetoException("Just for the fun of it", event);
        }
    };
    ConfigVetoableChangeListener gentleVetoListener = new ConfigVetoableChangeListener(){

        public void vetoableChange(PropertyChangeEvent event) throws ConfigPropertyVetoException {
            TestConfigurationService.this.propertyChangeEvent = event;
        }
    };

    public TestConfigurationService(String name) {
        super(name);
        BundleContext context = ConfigurationServiceLick.bc;
        ServiceReference ref = context.getServiceReference(ConfigurationService.class.getName());
        this.configurationService = (ConfigurationService)context.getService(ref);
    }

    protected void setUp() throws Exception {
        this.configurationService.setProperty(propertyName, null);
        this.configurationService.setProperty(listenedPropertyName, null);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.configurationService.removePropertyChangeListener(this.pListener);
        this.configurationService.removeVetoableChangeListener(this.rudeVetoListener);
        this.configurationService.removeVetoableChangeListener(this.gentleVetoListener);
        this.configurationService.setProperty(propertyName, null);
        this.configurationService.setProperty(listenedPropertyName, null);
        this.propertyChangeEvent = null;
        super.tearDown();
    }

    public void testSetGetProperty() throws PropertyVetoException {
        String propertyName = propertyName;
        String property = new String("my.test.property's value");
        this.configurationService.setProperty(propertyName, (Object)property);
        Object actualReturn = this.configurationService.getProperty(propertyName);
        TestConfigurationService.assertEquals((String)"a property was not properly stored", (Object)property, (Object)actualReturn);
    }

    public void testRemoveProperty() throws PropertyVetoException {
        String propertyName = "my.test.property.acc1234";
        String property = new String("my.test.property's value");
        this.configurationService.setProperty(propertyName, (Object)property);
        Object actualReturn = this.configurationService.getProperty(propertyName);
        TestConfigurationService.assertEquals((String)"a property was not properly stored", (Object)property, (Object)actualReturn);
        this.configurationService.removeProperty(propertyName);
        Object actualReturn2 = this.configurationService.getProperty(propertyName);
        TestConfigurationService.assertNull((String)"a property was not properly removed", (Object)actualReturn2);
    }

    public void testRemovePrefixedProperty() throws PropertyVetoException {
        String propertyName = "my.test.property.acc1234";
        String propertyPrefixName = "my.test.property.acc";
        String property = new String("my.test.property's value");
        this.configurationService.setProperty(propertyName, (Object)property);
        Object actualReturn = this.configurationService.getProperty(propertyName);
        TestConfigurationService.assertEquals((String)"a property was not properly stored", (Object)property, (Object)actualReturn);
        this.configurationService.removeProperty(propertyPrefixName);
        Object actualReturn2 = this.configurationService.getProperty(propertyName);
        TestConfigurationService.assertNull((String)"a property was not properly removed by prefix", (Object)actualReturn2);
    }

    public void testSystemPoperties() throws PropertyVetoException {
        String propertyName = "my.test.system.property";
        String property = new String("sys.value.1");
        this.configurationService.setProperty(propertyName, (Object)property, true);
        Object actualReturn = this.configurationService.getProperty(propertyName);
        TestConfigurationService.assertEquals((String)"a sys property was not properly stored", (Object)property, (Object)actualReturn);
        actualReturn = System.getProperty(propertyName);
        TestConfigurationService.assertEquals((String)"a property was not properly stored", (Object)property, (Object)actualReturn);
        property = new String("second.sys.value");
        System.setProperty(propertyName, property.toString());
        actualReturn = this.configurationService.getProperty(propertyName);
        TestConfigurationService.assertEquals((String)"a property was not properly stored", (Object)property, (Object)actualReturn);
        property = new String("third.sys.value");
        this.configurationService.setProperty(propertyName, (Object)property.toString());
        actualReturn = System.getProperty(propertyName);
        TestConfigurationService.assertEquals((String)"a property was not properly stored", (Object)property, (Object)actualReturn);
    }

    public void testGetString() throws PropertyVetoException {
        String propertyName = propertyName;
        Object property = new String("my.test.property's value");
        this.configurationService.setProperty(propertyName, property);
        String actualReturn = this.configurationService.getString(propertyName);
        TestConfigurationService.assertEquals((String)"getString failed to retrieve a property", (String)property.toString(), (String)actualReturn);
        property = new Integer(7121979);
        this.configurationService.setProperty(propertyName, property);
        actualReturn = this.configurationService.getString(propertyName);
        TestConfigurationService.assertEquals((String)"getString failed to retrieve a property", (String)property.toString(), (String)actualReturn);
        property = new String("\t\n ");
        this.configurationService.setProperty(propertyName, property);
        actualReturn = this.configurationService.getString(propertyName);
        TestConfigurationService.assertNull((String)"getString did not trim a white space only string", (Object)actualReturn);
    }

    public void testGetPropertyNamesByPrefix() throws PropertyVetoException {
        String prefix = "this.is.a.prefix";
        String exactPrefixProp1Name = prefix + ".PROP1";
        String exactPrefixProp2Name = prefix + ".PROP3";
        String longerPrefixProp3Name = prefix + ".which.is.longer.PROP3";
        String completeMismatchProp4Name = "and.hereis.one.other.prefix.PROP4";
        this.configurationService.setProperty(exactPrefixProp1Name, new Object());
        this.configurationService.setProperty(exactPrefixProp2Name, new Object());
        this.configurationService.setProperty(longerPrefixProp3Name, new Object());
        this.configurationService.setProperty(completeMismatchProp4Name, new Object());
        List propertyNames = this.configurationService.getPropertyNamesByPrefix(prefix, true);
        TestConfigurationService.assertTrue((String)("Returned list did not contain all property names.  MissingPropertyName: " + exactPrefixProp1Name), (boolean)propertyNames.contains(exactPrefixProp1Name));
        TestConfigurationService.assertTrue((String)("Returned list did not contain all property names.  MissingPropertyName: " + exactPrefixProp2Name), (boolean)propertyNames.contains(exactPrefixProp2Name));
        TestConfigurationService.assertEquals((String)("Returned list contains more properties than expected.  List was: " + propertyNames), (int)2, (int)propertyNames.size());
        propertyNames = this.configurationService.getPropertyNamesByPrefix(prefix, false);
        TestConfigurationService.assertTrue((String)("Returned list did not contain all property names.  MissingPropertyName: " + exactPrefixProp1Name), (boolean)propertyNames.contains(exactPrefixProp1Name));
        TestConfigurationService.assertTrue((String)("Returned list did not contain all property names.  MissingPropertyName: " + exactPrefixProp2Name), (boolean)propertyNames.contains(exactPrefixProp2Name));
        TestConfigurationService.assertTrue((String)("Returned list did not contain all property names.  MissingPropertyName: " + longerPrefixProp3Name), (boolean)propertyNames.contains(longerPrefixProp3Name));
        TestConfigurationService.assertEquals((String)("Returned list contains more properties than expected.  List was: " + propertyNames), (int)3, (int)propertyNames.size());
    }

    public void testMulticastEventNotification() {
        this.propertyChangeEvent = null;
        this.configurationService.addPropertyChangeListener(this.pListener);
        try {
            this.configurationService.setProperty(propertyName, (Object)propertyValue);
        }
        catch (ConfigPropertyVetoException ex) {
            TestConfigurationService.fail((String)("A PropertyVetoException came from nowhere. Exc=" + ex.getMessage()));
        }
        TestConfigurationService.assertNotNull((String)"No PropertyChangeEvent was delivered upon setProperty", (Object)this.propertyChangeEvent);
        TestConfigurationService.assertNull((String)"oldValue must be null", (Object)this.propertyChangeEvent.getOldValue());
        TestConfigurationService.assertEquals((String)"newValue is not the value we just set!", (Object)propertyValue, (Object)this.propertyChangeEvent.getNewValue());
        TestConfigurationService.assertEquals((String)"propertyName is not the value we just set!", (String)propertyName, (String)this.propertyChangeEvent.getPropertyName());
        this.propertyChangeEvent = null;
        try {
            this.configurationService.setProperty(propertyName, (Object)propertyNewValue);
        }
        catch (ConfigPropertyVetoException ex) {
            TestConfigurationService.fail((String)("A PropertyVetoException came from nowhere. Exc=" + ex.getMessage()));
        }
        TestConfigurationService.assertNotNull((String)"No PropertyChangeEvent was delivered upon setProperty", (Object)this.propertyChangeEvent);
        TestConfigurationService.assertEquals((String)"incorrect oldValue", (Object)propertyValue, (Object)this.propertyChangeEvent.getOldValue());
        TestConfigurationService.assertEquals((String)"newValue is not the value we just set!", (Object)propertyNewValue, (Object)this.propertyChangeEvent.getNewValue());
        this.propertyChangeEvent = null;
        this.configurationService.removePropertyChangeListener(this.pListener);
        try {
            this.configurationService.setProperty(propertyName, (Object)propertyValue);
        }
        catch (ConfigPropertyVetoException ex) {
            TestConfigurationService.fail((String)("A PropertyVetoException came from nowhere. Exc=" + ex.getMessage()));
        }
        TestConfigurationService.assertNull((String)"A PropertyChangeEvent after unregistering a listener.", (Object)this.propertyChangeEvent);
    }

    public void testMulticastEventNotificationToVetoableListeners() {
        String propertyValue = propertyValue;
        String propertyNewValue = propertyNewValue;
        this.propertyChangeEvent = null;
        this.configurationService.addVetoableChangeListener(this.gentleVetoListener);
        try {
            this.configurationService.setProperty(propertyName, (Object)propertyValue);
        }
        catch (ConfigPropertyVetoException ex) {
            TestConfigurationService.fail((String)("A PropertyVetoException came from nowhere. Exc=" + ex.getMessage()));
        }
        TestConfigurationService.assertNotNull((String)"No PropertyChangeEvent was delivered to VetoableListeners upon setProperty", (Object)this.propertyChangeEvent);
        TestConfigurationService.assertNull((String)"oldValue must be null", (Object)this.propertyChangeEvent.getOldValue());
        TestConfigurationService.assertEquals((String)"newValue is not the value we just set!", (Object)propertyValue, (Object)this.propertyChangeEvent.getNewValue());
        TestConfigurationService.assertEquals((String)"propertyName is not the value we just set!", (String)propertyName, (String)this.propertyChangeEvent.getPropertyName());
        this.propertyChangeEvent = null;
        try {
            this.configurationService.setProperty(propertyName, (Object)propertyNewValue);
        }
        catch (ConfigPropertyVetoException ex) {
            TestConfigurationService.fail((String)("A PropertyVetoException came from nowhere. Exc=" + ex.getMessage()));
        }
        TestConfigurationService.assertNotNull((String)"No PropertyChangeEvent was delivered to veto listener upon setProperty", (Object)this.propertyChangeEvent);
        TestConfigurationService.assertEquals((String)"incorrect oldValue", (Object)propertyValue, (Object)this.propertyChangeEvent.getOldValue());
        TestConfigurationService.assertEquals((String)"newValue is not the value we just set!", (Object)propertyNewValue, (Object)this.propertyChangeEvent.getNewValue());
        this.propertyChangeEvent = null;
        this.configurationService.removeVetoableChangeListener(this.gentleVetoListener);
        try {
            this.configurationService.setProperty(propertyName, (Object)propertyValue);
        }
        catch (ConfigPropertyVetoException ex) {
            TestConfigurationService.fail((String)("A PropertyVetoException came from nowhere. Exc=" + ex.getMessage()));
        }
        TestConfigurationService.assertNull((String)"A PropertyChangeEvent after unregistering a listener.", (Object)this.propertyChangeEvent);
    }

    public void testVetos() {
        this.propertyChangeEvent = null;
        this.configurationService.addVetoableChangeListener(this.rudeVetoListener);
        this.configurationService.addPropertyChangeListener(this.pListener);
        ConfigPropertyVetoException exception = null;
        try {
            this.configurationService.setProperty(propertyName, (Object)propertyValue);
        }
        catch (ConfigPropertyVetoException ex) {
            exception = ex;
        }
        TestConfigurationService.assertNotNull((String)"A vetoable change event was not dispatched or an exception was not let through.", (Object)((Object)exception));
        TestConfigurationService.assertNull((String)"A property change event was delivered even after the property change was vetoed.", (Object)this.propertyChangeEvent);
        TestConfigurationService.assertNull((String)"A property was changed even avfter vetoing the change.", (Object)this.configurationService.getProperty(propertyName));
        this.propertyChangeEvent = null;
        this.configurationService.removeVetoableChangeListener(this.rudeVetoListener);
        ConfigVetoableChangeListener vcListener = new ConfigVetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent event) {
                Assert.assertNull((String)"propertyChangeEvent was not null which means that it has bean delivered to the propertyChangeListener prior to being delivered to the vetoable change listener.", (Object)TestConfigurationService.this.propertyChangeEvent);
            }
        };
        try {
            this.configurationService.setProperty(propertyName, (Object)propertyNewValue);
        }
        catch (ConfigPropertyVetoException ex1) {
            ex1.printStackTrace();
            TestConfigurationService.fail((String)("unexpected veto exception. message:" + ex1.getMessage()));
        }
        this.configurationService.removeVetoableChangeListener(vcListener);
    }

    public void testSinglePropertyEventNotification() throws PropertyVetoException {
        String listenedPropertyValue = "19.2598";
        String listenedPropertyNewValue = "19.29581";
        this.configurationService.addPropertyChangeListener(listenedPropertyName, this.pListener);
        this.propertyChangeEvent = null;
        this.configurationService.setProperty(propertyName, (Object)propertyValue);
        TestConfigurationService.assertNull((String)"setting prop:my.test.property caused an event notif. to listener registered for prop:a.property.i.listen.to", (Object)this.propertyChangeEvent);
        this.configurationService.setProperty(listenedPropertyName, (Object)listenedPropertyValue);
        TestConfigurationService.assertNotNull((String)"No event was dispatched upon modification of prop:a.property.i.listen.to", (Object)this.propertyChangeEvent);
        TestConfigurationService.assertNull((String)"oldValue must be null", (Object)this.propertyChangeEvent.getOldValue());
        TestConfigurationService.assertEquals((String)"wrong newValue", (Object)listenedPropertyValue, (Object)this.propertyChangeEvent.getNewValue());
        this.propertyChangeEvent = null;
        this.configurationService.removePropertyChangeListener(this.pListener);
        this.configurationService.setProperty(listenedPropertyName, (Object)listenedPropertyNewValue);
        TestConfigurationService.assertNotNull((String)"No event was dispatched upon modification of prop:a.property.i.listen.to. The listener was wrongfully removed.", (Object)this.propertyChangeEvent);
        TestConfigurationService.assertEquals((String)"wrong oldValue", (Object)listenedPropertyValue, (Object)this.propertyChangeEvent.getOldValue());
        TestConfigurationService.assertEquals((String)"wrong newValue", (Object)listenedPropertyNewValue, (Object)this.propertyChangeEvent.getNewValue());
        this.propertyChangeEvent = null;
        this.configurationService.removePropertyChangeListener(listenedPropertyName, this.pListener);
        this.configurationService.setProperty(listenedPropertyName, (Object)propertyValue);
        TestConfigurationService.assertNull((String)"An event was wrongfully dispatched after removing a listener", (Object)this.propertyChangeEvent);
    }

    public void testSinglePropertyVetoEventNotification() throws PropertyVetoException {
        String listenedPropertyValue = "19.2598";
        String listenedPropertyNewValue = "19.29581";
        ConfigVetoableChangeListener vetoListener = new ConfigVetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent event) {
                TestConfigurationService.this.propertyChangeEvent = event;
            }
        };
        this.configurationService.addVetoableChangeListener(listenedPropertyName, vetoListener);
        this.propertyChangeEvent = null;
        this.configurationService.setProperty(propertyName, (Object)propertyValue);
        TestConfigurationService.assertNull((String)"setting prop:my.test.property caused an event notif. to listener registered for prop:a.property.i.listen.to", (Object)this.propertyChangeEvent);
        this.configurationService.setProperty(listenedPropertyName, (Object)listenedPropertyValue);
        TestConfigurationService.assertNotNull((String)"No event was dispatched upon modification of prop:a.property.i.listen.to", (Object)this.propertyChangeEvent);
        TestConfigurationService.assertNull((String)"oldValue must be null", (Object)this.propertyChangeEvent.getOldValue());
        TestConfigurationService.assertEquals((String)"wrong newValue", (Object)listenedPropertyValue, (Object)this.propertyChangeEvent.getNewValue());
        this.propertyChangeEvent = null;
        this.configurationService.removeVetoableChangeListener(vetoListener);
        this.configurationService.setProperty(listenedPropertyName, (Object)listenedPropertyNewValue);
        TestConfigurationService.assertNotNull((String)"No event was dispatched upon modification of prop:a.property.i.listen.to. The listener was wrongfully removed.", (Object)this.propertyChangeEvent);
        TestConfigurationService.assertEquals((String)"wrong oldValue", (Object)listenedPropertyValue, (Object)this.propertyChangeEvent.getOldValue());
        TestConfigurationService.assertEquals((String)"wrong newValue", (Object)listenedPropertyNewValue, (Object)this.propertyChangeEvent.getNewValue());
        this.propertyChangeEvent = null;
        this.configurationService.removeVetoableChangeListener(listenedPropertyName, vetoListener);
        this.configurationService.setProperty(listenedPropertyName, (Object)listenedPropertyValue);
        TestConfigurationService.assertNull((String)"An event was wrongfully dispatched after removing a listener", (Object)this.propertyChangeEvent);
        this.propertyChangeEvent = null;
        this.configurationService.addVetoableChangeListener(vetoListener);
        this.configurationService.addVetoableChangeListener(listenedPropertyName, vetoListener);
        this.configurationService.removeVetoableChangeListener(listenedPropertyName, vetoListener);
        this.configurationService.setProperty(listenedPropertyName, (Object)listenedPropertyNewValue);
        TestConfigurationService.assertNotNull((String)"No event was dispatched upon modification of prop:a.property.i.listen.to. The global listener was wrongfully removed.", (Object)this.propertyChangeEvent);
        TestConfigurationService.assertEquals((String)"wrong propertyName", (String)listenedPropertyName, (String)this.propertyChangeEvent.getPropertyName());
        TestConfigurationService.assertEquals((String)"wrong oldValue", (Object)listenedPropertyValue, (Object)this.propertyChangeEvent.getOldValue());
        TestConfigurationService.assertEquals((String)"wrong newValue", (Object)listenedPropertyNewValue, (Object)this.propertyChangeEvent.getNewValue());
    }
}

