/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import com.ircclouds.irc.api.Callback;
import com.ircclouds.irc.api.CapabilityNegotiator;
import com.ircclouds.irc.api.DCCManager;
import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.IServerParameters;
import com.ircclouds.irc.api.ctcp.DCCReceiveCallback;
import com.ircclouds.irc.api.ctcp.DCCSendCallback;
import com.ircclouds.irc.api.domain.IRCChannel;
import com.ircclouds.irc.api.filters.IMessageFilter;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.state.IIRCState;
import java.io.File;
import java.net.Proxy;
import java.net.SocketAddress;

public class SynchronizedIRCApi
implements IRCApi {
    private final IRCApi irc;

    public SynchronizedIRCApi(IRCApi irc) {
        if (irc == null) {
            throw new IllegalArgumentException("irc instance cannot be null");
        }
        this.irc = irc;
    }

    public synchronized void connect(IServerParameters aServerParameters, Callback<IIRCState> aCallback) {
        this.irc.connect(aServerParameters, aCallback);
    }

    public synchronized void connect(IServerParameters aServerParameters, Callback<IIRCState> aCallback, CapabilityNegotiator negotiator) {
        this.irc.connect(aServerParameters, aCallback, negotiator);
    }

    public synchronized void disconnect() {
        this.irc.disconnect();
    }

    public synchronized void disconnect(String aQuitMessage) {
        this.irc.disconnect(aQuitMessage);
    }

    public synchronized void joinChannel(String aChannelName) {
        this.irc.joinChannel(aChannelName);
    }

    public synchronized void joinChannel(String aChannelName, Callback<IRCChannel> aCallback) {
        this.irc.joinChannel(aChannelName, aCallback);
    }

    public synchronized void joinChannel(String aChannelName, String aKey) {
        this.irc.joinChannel(aChannelName, aKey);
    }

    public synchronized void joinChannel(String aChannelName, String aKey, Callback<IRCChannel> aCallback) {
        this.irc.joinChannel(aChannelName, aKey, aCallback);
    }

    public synchronized void leaveChannel(String aChannelName) {
        this.irc.leaveChannel(aChannelName);
    }

    public synchronized void leaveChannel(String aChannelName, Callback<String> aCallback) {
        this.irc.leaveChannel(aChannelName, aCallback);
    }

    public synchronized void leaveChannel(String aChannelName, String aPartMessage) {
        this.irc.leaveChannel(aChannelName, aPartMessage);
    }

    public synchronized void leaveChannel(String aChannelName, String aPartMessage, Callback<String> aCallback) {
        this.irc.leaveChannel(aChannelName, aPartMessage, aCallback);
    }

    public synchronized void changeNick(String aNewNick) {
        this.irc.changeNick(aNewNick);
    }

    public synchronized void changeNick(String aNewNick, Callback<String> aCallback) {
        this.irc.changeNick(aNewNick, aCallback);
    }

    public synchronized void message(String aTarget, String aMessage) {
        this.irc.message(aTarget, aMessage);
    }

    public synchronized void message(String aTarget, String aMessage, Callback<String> aCallback) {
        this.irc.message(aTarget, aMessage, aCallback);
    }

    public synchronized void act(String aTarget, String aMessage) {
        this.irc.act(aTarget, aMessage);
    }

    public synchronized void act(String aTarget, String aMessage, Callback<String> aCallback) {
        this.irc.act(aTarget, aMessage, aCallback);
    }

    public synchronized void notice(String aTarget, String aMessage) {
        this.irc.notice(aTarget, aMessage);
    }

    public synchronized void notice(String aTarget, String aMessage, Callback<String> aCallback) {
        this.irc.notice(aTarget, aMessage, aCallback);
    }

    public synchronized void kick(String aChannel, String aNick) {
        this.irc.kick(aChannel, aNick);
    }

    public synchronized void kick(String aChannel, String aNick, String aKickMessage) {
        this.irc.kick(aChannel, aNick, aKickMessage);
    }

    public synchronized void kick(String aChannel, String aNick, Callback<String> aCallback) {
        this.irc.kick(aChannel, aNick, aCallback);
    }

    public synchronized void kick(String aChannel, String aNick, String aKickMessage, Callback<String> aCallback) {
        this.irc.kick(aChannel, aNick, aKickMessage, aCallback);
    }

    public synchronized void changeTopic(String aChannel, String aTopic) {
        this.irc.changeTopic(aChannel, aTopic);
    }

    public synchronized void changeMode(String aModeString) {
        this.irc.changeMode(aModeString);
    }

    public synchronized void rawMessage(String aMessage) {
        this.irc.rawMessage(aMessage);
    }

    public synchronized void dccSend(String aNick, File aFile, DCCSendCallback aCallback) {
        this.irc.dccSend(aNick, aFile, aCallback);
    }

    public synchronized void dccSend(String aNick, File aFile, Integer aTimeout, DCCSendCallback aCallback) {
        this.irc.dccSend(aNick, aFile, aTimeout, aCallback);
    }

    public synchronized void dccSend(String aNick, Integer aListeningPort, File aFile, DCCSendCallback aCallback) {
        this.irc.dccSend(aNick, aListeningPort, aFile, aCallback);
    }

    public synchronized void dccSend(String aNick, File aFile, Integer aListeningPort, Integer aTimeout, DCCSendCallback aCallback) {
        this.irc.dccSend(aNick, aFile, aListeningPort, aTimeout, aCallback);
    }

    public synchronized void dccAccept(String aNick, File aFile, Integer aPort, Integer aResumePosition, DCCSendCallback aCallback) {
        this.irc.dccAccept(aNick, aFile, aPort, aResumePosition, aCallback);
    }

    public synchronized void dccAccept(String aNick, File aFile, Integer aPort, Integer aResumePosition, Integer aTimeout, DCCSendCallback aCallback) {
        this.irc.dccAccept(aNick, aFile, aPort, aResumePosition, aTimeout, aCallback);
    }

    public synchronized void dccReceive(File aFile, Integer aSize, SocketAddress aAddress, DCCReceiveCallback aCallback) {
        this.irc.dccReceive(aFile, aSize, aAddress, aCallback);
    }

    public synchronized void dccReceive(File aFile, Integer aSize, SocketAddress aAddress, DCCReceiveCallback aCallback, Proxy aProxy) {
        this.irc.dccReceive(aFile, aSize, aAddress, aCallback, aProxy);
    }

    public synchronized void dccResume(File aFile, Integer aResumePosition, Integer aSize, SocketAddress aAddress, DCCReceiveCallback aCallback) {
        this.irc.dccResume(aFile, aResumePosition, aSize, aAddress, aCallback);
    }

    public synchronized void dccResume(File aFile, Integer aResumePosition, Integer aSize, SocketAddress aAddress, DCCReceiveCallback aCallback, Proxy aProxy) {
        this.irc.dccResume(aFile, aResumePosition, aSize, aAddress, aCallback, aProxy);
    }

    public synchronized DCCManager getDCCManager() {
        return this.irc.getDCCManager();
    }

    public synchronized void addListener(IMessageListener aListener) {
        this.irc.addListener(aListener);
    }

    public synchronized void deleteListener(IMessageListener aListener) {
        this.irc.deleteListener(aListener);
    }

    public synchronized void setMessageFilter(IMessageFilter aFilter) {
        this.irc.setMessageFilter(aFilter);
    }
}

