/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.util.ArrayList;
import java.util.Iterator;
import net.java.sip.communicator.impl.protocol.irc.ContactIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;

public class ContactGroupIrcImpl
implements ContactGroup {
    private final ProtocolProviderServiceIrcImpl provider;
    private String name;
    private final ArrayList<ContactGroupIrcImpl> subgroups = new ArrayList();
    private final ArrayList<ContactIrcImpl> contacts = new ArrayList();
    private ContactGroup parent;
    private boolean persistent;

    ContactGroupIrcImpl(ProtocolProviderServiceIrcImpl provider) {
        this(provider, null, "root");
    }

    public ContactGroupIrcImpl(ProtocolProviderServiceIrcImpl provider, ContactGroupIrcImpl parentGroup, String name) {
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.provider = provider;
        this.parent = parentGroup;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
        this.persistent = true;
    }

    public Iterator<ContactGroup> subgroups() {
        return new ArrayList<ContactGroupIrcImpl>(this.subgroups).iterator();
    }

    public int countSubgroups() {
        return this.subgroups.size();
    }

    public ContactGroup getGroup(int index) {
        return this.subgroups.get(index);
    }

    public ContactGroup getGroup(String groupName) {
        if (groupName == null) {
            return null;
        }
        for (ContactGroupIrcImpl group : this.subgroups) {
            if (!groupName.equals(group.getGroupName())) continue;
            return group;
        }
        return null;
    }

    public Iterator<Contact> contacts() {
        return new ArrayList<ContactIrcImpl>(this.contacts).iterator();
    }

    public int countContacts() {
        return this.contacts.size();
    }

    public ContactIrcImpl getContact(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        for (ContactIrcImpl contact : this.contacts) {
            if (!id.equals(contact.getAddress())) continue;
            return contact;
        }
        return null;
    }

    public ContactIrcImpl findContact(String id) {
        ContactIrcImpl contact = this.getContact(id);
        if (contact != null) {
            return contact;
        }
        for (ContactGroupIrcImpl subgroup : this.subgroups) {
            contact = subgroup.findContact(id);
            if (contact == null) continue;
            return contact;
        }
        return null;
    }

    public boolean canContainSubgroups() {
        return true;
    }

    public String getGroupName() {
        return this.name;
    }

    public void setGroupName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
    }

    public ProtocolProviderServiceIrcImpl getProtocolProvider() {
        return this.provider;
    }

    public ContactGroup getParentContactGroup() {
        return this.parent;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public String getUID() {
        return this.name;
    }

    public boolean isResolved() {
        return true;
    }

    public String getPersistentData() {
        return null;
    }

    public void addContact(ContactIrcImpl contact) {
        if (contact == null) {
            throw new IllegalArgumentException("contact cannot be null");
        }
        this.contacts.add(contact);
    }

    public void removeContact(ContactIrcImpl contact) {
        if (contact == null) {
            throw new IllegalArgumentException("contact cannot be null");
        }
        this.contacts.remove((Object)contact);
    }

    public void addSubGroup(ContactGroupIrcImpl group) {
        if (group == null) {
            throw new IllegalArgumentException("group cannot be null");
        }
        this.subgroups.add(group);
    }

    public void removeSubGroup(ContactGroupIrcImpl group) {
        if (group == null) {
            throw new IllegalArgumentException("group cannot be null");
        }
        this.subgroups.remove(group);
    }
}

