/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.filters.IntFilter;
import com.puppycrawl.tools.checkstyle.filters.IntMatchFilter;
import com.puppycrawl.tools.checkstyle.filters.IntRangeFilter;
import java.util.Set;
import java.util.StringTokenizer;

class CSVFilter
implements IntFilter {
    private final Set<IntFilter> mFilters = Sets.newHashSet();

    public void addFilter(IntFilter aFilter) {
        this.mFilters.add(aFilter);
    }

    protected Set<IntFilter> getFilters() {
        return this.mFilters;
    }

    public CSVFilter(String aPattern) throws NumberFormatException {
        StringTokenizer tokenizer = new StringTokenizer(aPattern, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            int index = token.indexOf("-");
            if (index == -1) {
                int matchValue = Integer.parseInt(token);
                this.addFilter(new IntMatchFilter(matchValue));
                continue;
            }
            int lowerBound = Integer.parseInt(token.substring(0, index));
            int upperBound = Integer.parseInt(token.substring(index + 1));
            this.addFilter(new IntRangeFilter(lowerBound, upperBound));
        }
    }

    @Override
    public boolean accept(int aInt) {
        for (IntFilter filter : this.getFilters()) {
            if (!filter.accept(aInt)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.mFilters.toString();
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public boolean equals(Object aObject) {
        if (aObject instanceof CSVFilter) {
            CSVFilter other = (CSVFilter)aObject;
            return this.mFilters.equals(other.mFilters);
        }
        return false;
    }
}

