/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.collect.ImmutableSortedSet;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.HtmlTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.TagParser;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class JavadocStyleCheck
extends Check {
    private static final String UNCLOSED_HTML = "javadoc.unclosedhtml";
    private static final String EXTRA_HTML = "javadoc.extrahtml";
    private static final Set<String> SINGLE_TAGS = ImmutableSortedSet.of((Comparable)((Object)"br"), (Comparable)((Object)"li"), (Comparable)((Object)"dt"), (Comparable)((Object)"dd"), (Comparable)((Object)"hr"), (Comparable)((Object)"img"), (Comparable[])new String[]{"p", "td", "tr", "th"});
    private static final Set<String> ALLOWED_TAGS = ImmutableSortedSet.of((Comparable)((Object)"a"), (Comparable)((Object)"abbr"), (Comparable)((Object)"acronym"), (Comparable)((Object)"address"), (Comparable)((Object)"area"), (Comparable)((Object)"b"), (Comparable[])new String[]{"bdo", "big", "blockquote", "br", "caption", "cite", "code", "colgroup", "dd", "del", "div", "dfn", "dl", "dt", "em", "fieldset", "font", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "ins", "kbd", "li", "ol", "p", "pre", "q", "samp", "small", "span", "strong", "style", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "tt", "u", "ul"});
    private Scope mScope = Scope.PRIVATE;
    private Scope mExcludeScope;
    private String mEndOfSentenceFormat = "([.?!][ \t\n\r\f<])|([.?!]$)";
    private Pattern mEndOfSentencePattern;
    private boolean mCheckFirstSentence = true;
    private boolean mCheckHtml = true;
    private boolean mCheckEmptyJavadoc;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{15, 14, 161, 158, 9, 8, 10, 159, 165, 16};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        if (this.shouldCheck(aAST)) {
            FileContents contents = this.getFileContents();
            TextBlock cmt = contents.getJavadocBefore(aAST.getFirstChild().getLineNo());
            this.checkComment(aAST, cmt);
        }
    }

    private boolean shouldCheck(DetailAST aAST) {
        if (aAST.getType() == 16) {
            return this.getFileContents().inPackageInfo();
        }
        if (ScopeUtils.inCodeBlock(aAST)) {
            return false;
        }
        Scope declaredScope = aAST.getType() == 159 ? Scope.PUBLIC : ScopeUtils.getScopeFromMods(aAST.findFirstToken(5));
        Scope scope = ScopeUtils.inInterfaceOrAnnotationBlock(aAST) ? Scope.PUBLIC : declaredScope;
        Scope surroundingScope = ScopeUtils.getSurroundingScope(aAST);
        return scope.isIn(this.mScope) && (surroundingScope == null || surroundingScope.isIn(this.mScope)) && (this.mExcludeScope == null || !scope.isIn(this.mExcludeScope) || surroundingScope != null && !surroundingScope.isIn(this.mExcludeScope));
    }

    private void checkComment(DetailAST aAST, TextBlock aComment) {
        if (aComment == null) {
            if (this.getFileContents().inPackageInfo()) {
                this.log(aAST.getLineNo(), "javadoc.missing", new Object[0]);
            }
            return;
        }
        if (this.mCheckFirstSentence) {
            this.checkFirstSentence(aAST, aComment);
        }
        if (this.mCheckHtml) {
            this.checkHtml(aAST, aComment);
        }
        if (this.mCheckEmptyJavadoc) {
            this.checkEmptyJavadoc(aComment);
        }
    }

    private void checkFirstSentence(DetailAST aAST, TextBlock aComment) {
        String commentText = this.getCommentText(aComment.getText());
        if (!(commentText.length() == 0 || this.getEndOfSentencePattern().matcher(commentText).find() || "{@inheritDoc}".equals(commentText) && JavadocTagInfo.INHERIT_DOC.isValidOn(aAST))) {
            this.log(aComment.getStartLineNo(), "javadoc.noperiod", new Object[0]);
        }
    }

    private void checkEmptyJavadoc(TextBlock aComment) {
        String commentText = this.getCommentText(aComment.getText());
        if (commentText.length() == 0) {
            this.log(aComment.getStartLineNo(), "javadoc.empty", new Object[0]);
        }
    }

    private String getCommentText(String[] aComments) {
        StringBuffer buffer = new StringBuffer();
        for (String line : aComments) {
            int textStart = this.findTextStart(line);
            if (textStart == -1) continue;
            if (line.charAt(textStart) == '@') break;
            buffer.append(line.substring(textStart));
            this.trimTail(buffer);
            buffer.append('\n');
        }
        return buffer.toString().trim();
    }

    private int findTextStart(String aLine) {
        int textStart = -1;
        for (int i = 0; i < aLine.length(); ++i) {
            if (Character.isWhitespace(aLine.charAt(i))) continue;
            if (aLine.regionMatches(i, "/**", 0, "/**".length())) {
                i += 2;
                continue;
            }
            if (aLine.regionMatches(i, "*/", 0, 2)) {
                ++i;
                continue;
            }
            if (aLine.charAt(i) == '*') continue;
            textStart = i;
            break;
        }
        return textStart;
    }

    private void trimTail(StringBuffer aBuffer) {
        for (int i = aBuffer.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(aBuffer.charAt(i))) {
                aBuffer.deleteCharAt(i);
                continue;
            }
            if (i <= 0 || aBuffer.charAt(i - 1) != '*' || aBuffer.charAt(i) != '/') break;
            aBuffer.deleteCharAt(i);
            aBuffer.deleteCharAt(i - 1);
            --i;
            while (aBuffer.charAt(i - 1) == '*') {
                aBuffer.deleteCharAt(i - 1);
                --i;
            }
        }
    }

    private void checkHtml(DetailAST aAST, TextBlock aComment) {
        int lineno = aComment.getStartLineNo();
        FastStack<HtmlTag> htmlStack = FastStack.newInstance();
        String[] text = aComment.getText();
        List<String> typeParameters = CheckUtils.getTypeParameterNames(aAST);
        TagParser parser = null;
        parser = new TagParser(text, lineno);
        while (parser.hasNextTag()) {
            HtmlTag tag = parser.nextTag();
            if (tag.isIncompleteTag()) {
                this.log(tag.getLineno(), "javadoc.incompleteTag", text[tag.getLineno() - lineno]);
                return;
            }
            if (tag.isClosedTag()) continue;
            if (!tag.isCloseTag()) {
                if (!this.isAllowedTag(tag)) continue;
                htmlStack.push(tag);
                continue;
            }
            if (this.isExtraHtml(tag.getId(), htmlStack)) {
                this.log(tag.getLineno(), tag.getPosition(), EXTRA_HTML, tag);
                continue;
            }
            this.checkUnclosedTags(htmlStack, tag.getId());
        }
        String lastFound = "";
        for (HtmlTag htag : htmlStack) {
            if (this.isSingleTag(htag) || htag.getId().equals(lastFound) || typeParameters.contains(htag.getId())) continue;
            this.log(htag.getLineno(), htag.getPosition(), UNCLOSED_HTML, htag);
            lastFound = htag.getId();
        }
    }

    private void checkUnclosedTags(FastStack<HtmlTag> aHtmlStack, String aToken) {
        FastStack<HtmlTag> unclosedTags = FastStack.newInstance();
        HtmlTag lastOpenTag = aHtmlStack.pop();
        while (!aToken.equalsIgnoreCase(lastOpenTag.getId())) {
            if (this.isSingleTag(lastOpenTag)) {
                lastOpenTag = aHtmlStack.pop();
                continue;
            }
            unclosedTags.push(lastOpenTag);
            lastOpenTag = aHtmlStack.pop();
        }
        String lastFound = "";
        for (HtmlTag htag : unclosedTags) {
            lastOpenTag = htag;
            if (lastOpenTag.getId().equals(lastFound)) continue;
            lastFound = lastOpenTag.getId();
            this.log(lastOpenTag.getLineno(), lastOpenTag.getPosition(), UNCLOSED_HTML, lastOpenTag);
        }
    }

    private boolean isSingleTag(HtmlTag aTag) {
        return SINGLE_TAGS.contains(aTag.getId().toLowerCase());
    }

    private boolean isAllowedTag(HtmlTag aTag) {
        return ALLOWED_TAGS.contains(aTag.getId().toLowerCase());
    }

    private boolean isExtraHtml(String aToken, FastStack<HtmlTag> aHtmlStack) {
        boolean isExtra = true;
        for (HtmlTag td : aHtmlStack) {
            if (!aToken.equalsIgnoreCase(td.getId())) continue;
            isExtra = false;
            break;
        }
        return isExtra;
    }

    public void setScope(String aFrom) {
        this.mScope = Scope.getInstance(aFrom);
    }

    public void setExcludeScope(String aScope) {
        this.mExcludeScope = Scope.getInstance(aScope);
    }

    public void setEndOfSentenceFormat(String aFormat) {
        this.mEndOfSentenceFormat = aFormat;
    }

    private Pattern getEndOfSentencePattern() {
        if (this.mEndOfSentencePattern == null) {
            this.mEndOfSentencePattern = Pattern.compile(this.mEndOfSentenceFormat);
        }
        return this.mEndOfSentencePattern;
    }

    public void setCheckFirstSentence(boolean aFlag) {
        this.mCheckFirstSentence = aFlag;
    }

    public void setCheckHtml(boolean aFlag) {
        this.mCheckHtml = aFlag;
    }

    public void setCheckEmptyJavadoc(boolean aFlag) {
        this.mCheckEmptyJavadoc = aFlag;
    }
}

