/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnStatusHandler
implements ISVNStatusHandler,
ISVNEventHandler {
    private List<ScmFile> files = new ArrayList<ScmFile>();

    public void handleStatus(SVNStatus status) {
        SVNStatusType contentsStatus = status.getContentsStatus();
        ScmFileStatus scmStatus = null;
        if (contentsStatus == SVNStatusType.STATUS_MODIFIED) {
            scmStatus = ScmFileStatus.MODIFIED;
        } else if (contentsStatus == SVNStatusType.STATUS_CONFLICTED) {
            scmStatus = ScmFileStatus.CONFLICT;
        } else if (contentsStatus == SVNStatusType.STATUS_MERGED) {
            scmStatus = ScmFileStatus.PATCHED;
        } else if (contentsStatus == SVNStatusType.STATUS_DELETED) {
            scmStatus = ScmFileStatus.DELETED;
        } else if (contentsStatus == SVNStatusType.STATUS_ADDED) {
            scmStatus = ScmFileStatus.ADDED;
        } else if (contentsStatus == SVNStatusType.STATUS_UNVERSIONED) {
            scmStatus = ScmFileStatus.UNKNOWN;
        } else if (contentsStatus == SVNStatusType.STATUS_EXTERNAL) {
            scmStatus = ScmFileStatus.UNKNOWN;
        } else if (contentsStatus == SVNStatusType.STATUS_IGNORED) {
            scmStatus = null;
        } else if (contentsStatus == SVNStatusType.STATUS_MISSING || contentsStatus == SVNStatusType.STATUS_INCOMPLETE) {
            scmStatus = ScmFileStatus.UNKNOWN;
        } else if (contentsStatus == SVNStatusType.STATUS_OBSTRUCTED) {
            scmStatus = ScmFileStatus.CONFLICT;
        } else if (contentsStatus == SVNStatusType.STATUS_REPLACED) {
            scmStatus = ScmFileStatus.ADDED;
        } else if (contentsStatus == SVNStatusType.STATUS_NONE || contentsStatus == SVNStatusType.STATUS_NORMAL) {
            scmStatus = null;
        }
        SVNStatusType propertiesStatus = status.getPropertiesStatus();
        if (scmStatus == null && propertiesStatus == SVNStatusType.STATUS_MODIFIED) {
            scmStatus = ScmFileStatus.MODIFIED;
        } else if (scmStatus == null && propertiesStatus == SVNStatusType.STATUS_CONFLICTED) {
            scmStatus = ScmFileStatus.CONFLICT;
        }
        if (scmStatus != null && status.getKind() != SVNNodeKind.DIR) {
            this.files.add(new ScmFile(status.getFile().getAbsolutePath(), scmStatus));
        }
    }

    public void handleEvent(SVNEvent event, double progress) {
    }

    public void checkCancelled() throws SVNCancelException {
    }

    public List<ScmFile> getFiles() {
        return this.files;
    }
}

