/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.blame;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;

public class PerforceFilelogConsumer
extends AbstractConsumer {
    private static final String PERFORCE_TIMESTAMP_PATTERN = "yyyy/MM/dd";
    private static final String LINE_PATTERN = "#(\\d+).*on (.*) by (.*)@";
    private RE lineRegexp;
    private Map<String, Date> dates = new HashMap<String, Date>();
    private Map<String, String> authors = new HashMap<String, String>();

    public PerforceFilelogConsumer(ScmLogger logger) {
        super(logger);
        this.lineRegexp = new RE(LINE_PATTERN);
    }

    public void consumeLine(String line) {
        if (this.lineRegexp.match(line)) {
            String revision = this.lineRegexp.getParen(1);
            String dateTimeStr = this.lineRegexp.getParen(2);
            String author = this.lineRegexp.getParen(3);
            Date dateTime = this.parseDate(dateTimeStr, null, PERFORCE_TIMESTAMP_PATTERN);
            this.dates.put(revision, dateTime);
            this.authors.put(revision, author);
        }
    }

    public String getAuthor(String revision) {
        return this.authors.get(revision);
    }

    public Date getDate(String revision) {
        return this.dates.get(revision);
    }
}

