/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.header;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.rat.header.CharFilter;
import org.apache.rat.header.FilteringSequenceFactory;
import org.apache.rat.header.HeaderBean;

public class HeaderMatcher {
    private final FilteringSequenceFactory factory;
    private final HeaderBean[] headers;
    private CharSequence read;
    private int lines;

    public HeaderMatcher(CharFilter filter, int capacity) {
        this(filter, capacity, null);
    }

    public HeaderMatcher(CharFilter filter, int capacity, HeaderBean[] headers) {
        this.factory = new FilteringSequenceFactory(capacity, filter);
        this.read = null;
        this.headers = headers;
    }

    public void read(Reader reader) throws IOException {
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        this.read = this.factory.filter(lineNumberReader);
        this.lines = lineNumberReader.read() == -1 ? lineNumberReader.getLineNumber() : -1;
        if (this.headers != null) {
            for (HeaderBean headerBean : this.headers) {
                Pattern headerPattern;
                if (headerBean == null || (headerPattern = headerBean.getHeaderPattern()) == null) continue;
                boolean matches = this.matches(headerPattern);
                headerBean.setMatch(matches);
            }
        }
    }

    public boolean matches(Pattern pattern) {
        boolean result = false;
        if (this.read != null) {
            Matcher matcher = pattern.matcher(this.read);
            result = matcher.matches();
        }
        return result;
    }

    public int lines() {
        return this.lines;
    }
}

