/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.siterenderer.ModuleReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteRenderingContext {
    private String inputEncoding = "UTF-8";
    private String outputEncoding = "UTF-8";
    private String templateName;
    private ClassLoader templateClassLoader;
    private Map<String, ?> templateProperties;
    private Locale locale = Locale.getDefault();
    private List<Locale> siteLocales = new ArrayList<Locale>();
    private DecorationModel decoration;
    private String defaultWindowTitle;
    private File skinJarFile;
    private boolean usingDefaultTemplate;
    private List<File> siteDirectories = new ArrayList<File>();
    private Map<String, String> moduleExcludes;
    private List<ModuleReference> modules = new ArrayList<ModuleReference>();
    private boolean validate;

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public ClassLoader getTemplateClassLoader() {
        return this.templateClassLoader;
    }

    public void setTemplateClassLoader(ClassLoader templateClassLoader) {
        this.templateClassLoader = templateClassLoader;
    }

    public Map<String, ?> getTemplateProperties() {
        return this.templateProperties;
    }

    public void setTemplateProperties(Map<String, ?> templateProperties) {
        this.templateProperties = Collections.unmodifiableMap(templateProperties);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public List<Locale> getSiteLocales() {
        return this.siteLocales;
    }

    public void addSiteLocales(List<Locale> locales) {
        this.siteLocales.addAll(locales);
    }

    public DecorationModel getDecoration() {
        return this.decoration;
    }

    public void setDecoration(DecorationModel decoration) {
        this.decoration = decoration;
    }

    public void setDefaultWindowTitle(String defaultWindowTitle) {
        this.defaultWindowTitle = defaultWindowTitle;
    }

    public String getDefaultWindowTitle() {
        return this.defaultWindowTitle;
    }

    public File getSkinJarFile() {
        return this.skinJarFile;
    }

    public void setSkinJarFile(File skinJarFile) {
        this.skinJarFile = skinJarFile;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setUsingDefaultTemplate(boolean usingDefaultTemplate) {
        this.usingDefaultTemplate = usingDefaultTemplate;
    }

    public boolean isUsingDefaultTemplate() {
        return this.usingDefaultTemplate;
    }

    public void addSiteDirectory(File file) {
        this.siteDirectories.add(file);
    }

    public void addModuleDirectory(File moduleBasedir, String moduleParserId) {
        this.modules.add(new ModuleReference(moduleParserId, moduleBasedir));
    }

    public List<File> getSiteDirectories() {
        return this.siteDirectories;
    }

    public List<ModuleReference> getModules() {
        return this.modules;
    }

    public Map<String, String> getModuleExcludes() {
        return this.moduleExcludes;
    }

    public void setModuleExcludes(Map<String, String> moduleExcludes) {
        this.moduleExcludes = moduleExcludes;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }
}

