/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.testing;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.testing.SilentLog;
import org.apache.maven.plugin.testing.stubs.DefaultArtifactHandlerStub;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.StringUtils;

public class ArtifactStubFactory {
    File workingDir;
    boolean createFiles;
    File srcFile;
    boolean createUnpackableFile;
    ArchiverManager archiverManager;

    public ArtifactStubFactory() {
        this.workingDir = null;
        this.createFiles = false;
    }

    public ArtifactStubFactory(File workingDir, boolean createFiles) {
        this.workingDir = new File(workingDir, "localTestRepo");
        this.createFiles = createFiles;
    }

    public void setUnpackableFile(ArchiverManager archiverManager) {
        this.createUnpackableFile = true;
        this.archiverManager = archiverManager;
    }

    public Artifact createArtifact(String groupId, String artifactId, String version) throws IOException {
        return this.createArtifact(groupId, artifactId, version, "compile", "jar", "");
    }

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope) throws IOException {
        return this.createArtifact(groupId, artifactId, version, scope, "jar", "");
    }

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type, String classifier) throws IOException {
        VersionRange vr = VersionRange.createFromVersion((String)version);
        return this.createArtifact(groupId, artifactId, vr, scope, type, classifier, false);
    }

    public Artifact createArtifact(String groupId, String artifactId, VersionRange versionRange, String scope, String type, String classifier, boolean optional) throws IOException {
        DefaultArtifactHandlerStub ah = new DefaultArtifactHandlerStub(type, classifier);
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, versionRange, scope, type, classifier, (ArtifactHandler)ah, optional);
        if (this.createFiles) {
            this.setArtifactFile((Artifact)artifact);
        }
        return artifact;
    }

    public void setArtifactFile(Artifact artifact) throws IOException {
        if (this.workingDir == null) {
            throw new IllegalArgumentException("The workingDir must be set if createFiles is true.");
        }
        String fileName = ArtifactStubFactory.getFormattedFileName(artifact, false);
        File theFile = new File(this.workingDir, fileName);
        theFile.getParentFile().mkdirs();
        if (this.srcFile == null) {
            theFile.createNewFile();
        } else if (this.createUnpackableFile) {
            try {
                this.createUnpackableFile(artifact, theFile);
            }
            catch (NoSuchArchiverException e) {
                e.printStackTrace();
            }
            catch (ArchiverException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            FileUtils.copyFile((File)this.srcFile, (File)theFile);
        }
        artifact.setFile(theFile);
    }

    public static String getUnpackableFileName(Artifact artifact) {
        return "" + artifact.getGroupId() + "-" + artifact.getArtifactId() + "-" + artifact.getVersion() + "-" + artifact.getClassifier() + "-" + artifact.getType() + ".txt";
    }

    public void createUnpackableFile(Artifact artifact, File destFile) throws NoSuchArchiverException, ArchiverException, IOException {
        Archiver archiver = this.archiverManager.getArchiver(destFile);
        archiver.setDestFile(destFile);
        archiver.addFile(this.srcFile, ArtifactStubFactory.getUnpackableFileName(artifact));
        try {
            ArtifactStubFactory.setVariableValueToObject(archiver, "logger", new SilentLog());
        }
        catch (IllegalAccessException e) {
            System.out.println("Unable to override logger with silent log.");
            e.printStackTrace();
        }
        if (archiver instanceof WarArchiver) {
            WarArchiver war = (WarArchiver)archiver;
            war.setIgnoreWebxml(false);
        }
        archiver.createArchive();
    }

    public Artifact getReleaseArtifact() throws IOException {
        return this.createArtifact("testGroupId", "release", "1.0");
    }

    public Artifact getSnapshotArtifact() throws IOException {
        return this.createArtifact("testGroupId", "snapshot", "2.0-SNAPSHOT");
    }

    public Set getReleaseAndSnapshotArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.add(this.getReleaseArtifact());
        set.add(this.getSnapshotArtifact());
        return set;
    }

    public Set getScopedArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.add(this.createArtifact("g", "compile", "1.0", "compile"));
        set.add(this.createArtifact("g", "provided", "1.0", "provided"));
        set.add(this.createArtifact("g", "test", "1.0", "test"));
        set.add(this.createArtifact("g", "runtime", "1.0", "runtime"));
        set.add(this.createArtifact("g", "system", "1.0", "system"));
        return set;
    }

    public Set getTypedArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.add(this.createArtifact("g", "a", "1.0", "compile", "war", null));
        set.add(this.createArtifact("g", "b", "1.0", "compile", "jar", null));
        set.add(this.createArtifact("g", "c", "1.0", "compile", "sources", null));
        set.add(this.createArtifact("g", "d", "1.0", "compile", "zip", null));
        set.add(this.createArtifact("g", "e", "1.0", "compile", "rar", null));
        return set;
    }

    public Set getClassifiedArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.add(this.createArtifact("g", "a", "1.0", "compile", "jar", "one"));
        set.add(this.createArtifact("g", "b", "1.0", "compile", "jar", "two"));
        set.add(this.createArtifact("g", "c", "1.0", "compile", "jar", "three"));
        set.add(this.createArtifact("g", "d", "1.0", "compile", "jar", "four"));
        return set;
    }

    public Set getTypedArchiveArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.add(this.createArtifact("g", "a", "1.0", "compile", "war", null));
        set.add(this.createArtifact("g", "b", "1.0", "compile", "jar", null));
        set.add(this.createArtifact("g", "d", "1.0", "compile", "zip", null));
        set.add(this.createArtifact("g", "e", "1.0", "compile", "rar", null));
        return set;
    }

    public Set getArtifactArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.add(this.createArtifact("g", "one", "1.0", "compile", "jar", "a"));
        set.add(this.createArtifact("g", "two", "1.0", "compile", "jar", "a"));
        set.add(this.createArtifact("g", "three", "1.0", "compile", "jar", "a"));
        set.add(this.createArtifact("g", "four", "1.0", "compile", "jar", "a"));
        return set;
    }

    public Set getGroupIdArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.add(this.createArtifact("one", "group-one", "1.0", "compile", "jar", "a"));
        set.add(this.createArtifact("two", "group-two", "1.0", "compile", "jar", "a"));
        set.add(this.createArtifact("three", "group-three", "1.0", "compile", "jar", "a"));
        set.add(this.createArtifact("four", "group-four", "1.0", "compile", "jar", "a"));
        return set;
    }

    public Set getMixedArtifacts() throws IOException {
        HashSet set = new HashSet();
        set.addAll(this.getTypedArtifacts());
        set.addAll(this.getScopedArtifacts());
        set.addAll(this.getReleaseAndSnapshotArtifacts());
        return set;
    }

    public boolean isCreateFiles() {
        return this.createFiles;
    }

    public void setCreateFiles(boolean createFiles) {
        this.createFiles = createFiles;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public File getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(File srcFile) {
        this.srcFile = srcFile;
    }

    public static void setVariableValueToObject(Object object, String variable, Object value) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        ((AccessibleObject)field).setAccessible(true);
        field.set(object, value);
    }

    public static String getFormattedFileName(Artifact artifact, boolean removeVersion) {
        String destFileName = null;
        if (artifact.getFile() != null && !removeVersion) {
            destFileName = artifact.getFile().getName();
        } else {
            String versionString = null;
            versionString = !removeVersion ? "-" + artifact.getVersion() : "";
            String classifierString = "";
            if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
                classifierString = "-" + artifact.getClassifier();
            }
            destFileName = artifact.getArtifactId() + versionString + classifierString + "." + artifact.getArtifactHandler().getExtension();
        }
        return destFileName;
    }
}

