/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;

public class InterpolatorFilterReaderLineEnding
extends FilterReader {
    private Interpolator interpolator;
    private RecursionInterceptor recursionInterceptor;
    private String replaceData = null;
    private int replaceIndex = 0;
    public static final String DEFAULT_BEGIN_TOKEN = "${";
    public static final String DEFAULT_END_TOKEN = "}";
    private String beginToken;
    private String endToken;
    private boolean interpolateWithPrefixPattern = true;
    private String escapeString;
    private boolean useEscape = false;
    private boolean preserveEscapeString = false;
    private boolean supportMultiLineFiltering;
    private int markLength = 16;
    private boolean eof = false;

    public InterpolatorFilterReaderLineEnding(Reader in, Interpolator interpolator, String beginToken, String endToken, boolean supportMultiLineFiltering) {
        this(in, interpolator, beginToken, endToken, (RecursionInterceptor)new SimpleRecursionInterceptor(), supportMultiLineFiltering);
    }

    private InterpolatorFilterReaderLineEnding(Reader in, Interpolator interpolator, String beginToken, String endToken, RecursionInterceptor ri, boolean supportMultiLineFiltering) {
        super(new BufferedReader(in));
        this.interpolator = interpolator;
        this.beginToken = beginToken;
        this.endToken = endToken;
        this.recursionInterceptor = ri;
        this.supportMultiLineFiltering = supportMultiLineFiltering;
        this.calculateMarkLength();
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        for (long i = 0L; i < n; ++i) {
            if (this.read() != -1) continue;
            return i;
        }
        return n;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int ch = this.read();
            if (ch == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cbuf[off + i] = (char)ch;
        }
        return len;
    }

    public int read() throws IOException {
        int endTokenSize;
        if (this.replaceIndex > 0) {
            return this.replaceData.charAt(this.replaceData.length() - this.replaceIndex--);
        }
        if (this.eof) {
            return -1;
        }
        this.in.mark(this.markLength);
        int ch = this.in.read();
        if (ch == -1 || ch == 10 && !this.supportMultiLineFiltering) {
            return ch;
        }
        boolean inEscape = this.useEscape && ch == this.escapeString.charAt(0);
        StringBuffer key = new StringBuffer();
        if (inEscape) {
            for (int i = 0; i < this.escapeString.length(); ++i) {
                key.append((char)ch);
                if (ch != this.escapeString.charAt(i) || ch == -1 || ch == 10 && !this.supportMultiLineFiltering) {
                    this.in.reset();
                    inEscape = false;
                    key.setLength(0);
                    break;
                }
                ch = this.in.read();
            }
        }
        boolean foundToken = false;
        for (int i = 0; i < this.beginToken.length() && ch == this.beginToken.charAt(i) && ch != -1 && (ch != 10 || this.supportMultiLineFiltering); ++i) {
            if (i == this.beginToken.length() - 1) {
                foundToken = true;
            }
            ch = this.in.read();
        }
        this.in.reset();
        this.in.skip(key.length());
        ch = this.in.read();
        if (inEscape) {
            if (this.beginToken != null && !this.preserveEscapeString) {
                key.setLength(0);
            }
            key.append((char)ch);
            this.replaceData = key.toString();
            this.replaceIndex = key.length();
            return this.read();
        }
        if (!foundToken) {
            this.in.reset();
            return this.in.read();
        }
        key.append(this.beginToken);
        this.in.reset();
        this.in.skip(this.beginToken.length());
        ch = this.in.read();
        int end = endTokenSize = this.endToken.length();
        while (ch != -1) {
            if (ch == 10 && !this.supportMultiLineFiltering) {
                key.append((char)ch);
                break;
            }
            key.append((char)ch);
            if (ch == this.endToken.charAt(endTokenSize - end)) {
                if (--end == 0) {
                    break;
                }
            } else {
                end = endTokenSize;
            }
            ch = this.in.read();
        }
        String value = null;
        if (end == 0) {
            try {
                value = this.interpolateWithPrefixPattern ? this.interpolator.interpolate(key.toString(), "", this.recursionInterceptor) : this.interpolator.interpolate(key.toString(), this.recursionInterceptor);
            }
            catch (InterpolationException e) {
                IllegalArgumentException error = new IllegalArgumentException(e.getMessage());
                error.initCause(e);
                throw error;
            }
        }
        if (value != null) {
            this.replaceData = value;
            this.replaceIndex = value.length();
        } else {
            this.replaceData = key.toString();
            this.replaceIndex = key.length();
        }
        if (ch == -1) {
            this.eof = true;
        }
        return this.read();
    }

    public boolean isInterpolateWithPrefixPattern() {
        return this.interpolateWithPrefixPattern;
    }

    public void setInterpolateWithPrefixPattern(boolean interpolateWithPrefixPattern) {
        this.interpolateWithPrefixPattern = interpolateWithPrefixPattern;
    }

    public String getEscapeString() {
        return this.escapeString;
    }

    public void setEscapeString(String escapeString) {
        if (escapeString != null && escapeString.length() >= 1) {
            this.escapeString = escapeString;
            this.useEscape = escapeString != null && escapeString.length() >= 1;
            this.calculateMarkLength();
        }
    }

    public boolean isPreserveEscapeString() {
        return this.preserveEscapeString;
    }

    public void setPreserveEscapeString(boolean preserveEscapeString) {
        this.preserveEscapeString = preserveEscapeString;
    }

    public RecursionInterceptor getRecursionInterceptor() {
        return this.recursionInterceptor;
    }

    public InterpolatorFilterReaderLineEnding setRecursionInterceptor(RecursionInterceptor recursionInterceptor) {
        this.recursionInterceptor = recursionInterceptor;
        return this;
    }

    private void calculateMarkLength() {
        this.markLength = 16;
        if (this.escapeString != null) {
            this.markLength += this.escapeString.length();
        }
        if (this.beginToken != null) {
            this.markLength += this.beginToken.length();
        }
        if (this.endToken != null) {
            this.markLength += this.endToken.length();
        }
    }
}

