/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework;

import java.io.Serializable;
import java.util.StringTokenizer;

public final class Version
implements Comparable,
Serializable {
    private int m_major;
    private int m_minor;
    private int m_micro;

    public static Version getVersion(String string) throws NumberFormatException, IllegalArgumentException {
        int n;
        if (string == null) {
            throw new NullPointerException("version");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
        }
        n = -1;
        if (0 < stringArray.length) {
            n = Integer.parseInt(stringArray[0]);
        }
        int n2 = 0;
        if (1 < stringArray.length) {
            n2 = Integer.parseInt(stringArray[1]);
        }
        int n3 = 0;
        if (2 < stringArray.length) {
            n3 = Integer.parseInt(stringArray[2]);
        }
        return new Version(n, n2, n3);
    }

    public Version(int n, int n2, int n3) {
        this.m_major = n;
        this.m_minor = n2;
        this.m_micro = n3;
    }

    public int getMajor() {
        return this.m_major;
    }

    public int getMinor() {
        return this.m_minor;
    }

    public int getMicro() {
        return this.m_micro;
    }

    public boolean equals(Version version) {
        boolean bl;
        if (version == null) {
            return false;
        }
        boolean bl2 = bl = this.getMajor() == version.getMajor();
        if (bl) {
            boolean bl3 = bl = this.getMinor() == version.getMinor();
        }
        if (bl) {
            bl = this.getMicro() == version.getMicro();
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Version) {
            bl = this.equals((Version)object);
        }
        return bl;
    }

    public int hashCode() {
        int n = this.getMajor();
        n >>>= 17;
        n += this.getMinor();
        n >>>= 17;
        return n += this.getMicro();
    }

    public boolean complies(Version version) {
        if (version == null) {
            return false;
        }
        if (version.m_major == -1) {
            return true;
        }
        if (this.m_major != version.m_major) {
            return false;
        }
        if (this.m_minor < version.m_minor) {
            return false;
        }
        return this.m_minor != version.m_minor || this.m_micro >= version.m_micro;
    }

    public String toString() {
        return this.m_major + "." + this.m_minor + "." + this.m_micro;
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new NullPointerException("o");
        }
        Version version = (Version)object;
        int n = 0;
        if (this.getMajor() < version.getMajor()) {
            n = -1;
        }
        if (0 == n && this.getMajor() > version.getMajor()) {
            n = 1;
        }
        if (0 == n && this.getMinor() < version.getMinor()) {
            n = -1;
        }
        if (0 == n && this.getMinor() > version.getMinor()) {
            n = 1;
        }
        if (0 == n && this.getMicro() < version.getMicro()) {
            n = -1;
        }
        if (0 == n && this.getMicro() > version.getMicro()) {
            n = 1;
        }
        return n;
    }
}

