/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public abstract class AbstractConfiguration
implements Configuration {
    protected abstract String getPrefix() throws ConfigurationException;

    @Override
    public int getValueAsInteger() throws ConfigurationException {
        String string = this.getValue().trim();
        try {
            if (string.startsWith("0x")) {
                return Integer.parseInt(string.substring(2), 16);
            }
            if (string.startsWith("0o")) {
                return Integer.parseInt(string.substring(2), 8);
            }
            if (string.startsWith("0b")) {
                return Integer.parseInt(string.substring(2), 2);
            }
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            String string2 = "Cannot parse the value \"" + string + "\" as an integer in the configuration element \"" + this.getName() + "\" at " + this.getLocation();
            throw new ConfigurationException(string2);
        }
    }

    @Override
    public int getValueAsInteger(int n) {
        try {
            return this.getValueAsInteger();
        }
        catch (ConfigurationException configurationException) {
            return n;
        }
    }

    @Override
    public long getValueAsLong() throws ConfigurationException {
        String string = this.getValue().trim();
        try {
            if (string.startsWith("0x")) {
                return Long.parseLong(string.substring(2), 16);
            }
            if (string.startsWith("0o")) {
                return Long.parseLong(string.substring(2), 8);
            }
            if (string.startsWith("0b")) {
                return Long.parseLong(string.substring(2), 2);
            }
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            String string2 = "Cannot parse the value \"" + string + "\" as a long in the configuration element \"" + this.getName() + "\" at " + this.getLocation();
            throw new ConfigurationException(string2);
        }
    }

    @Override
    public long getValueAsLong(long l) {
        try {
            return this.getValueAsLong();
        }
        catch (ConfigurationException configurationException) {
            return l;
        }
    }

    @Override
    public float getValueAsFloat() throws ConfigurationException {
        String string = this.getValue().trim();
        try {
            return Float.parseFloat(string);
        }
        catch (Exception exception) {
            String string2 = "Cannot parse the value \"" + string + "\" as a float in the configuration element \"" + this.getName() + "\" at " + this.getLocation();
            throw new ConfigurationException(string2);
        }
    }

    @Override
    public float getValueAsFloat(float f) {
        try {
            return this.getValueAsFloat();
        }
        catch (ConfigurationException configurationException) {
            return f;
        }
    }

    @Override
    public boolean getValueAsBoolean() throws ConfigurationException {
        String string = this.getValue().trim();
        if (this.isTrue(string)) {
            return true;
        }
        if (this.isFalse(string)) {
            return false;
        }
        String string2 = "Cannot parse the value \"" + string + "\" as a boolean in the configuration element \"" + this.getName() + "\" at " + this.getLocation();
        throw new ConfigurationException(string2);
    }

    @Override
    public boolean getValueAsBoolean(boolean bl) {
        try {
            return this.getValueAsBoolean();
        }
        catch (ConfigurationException configurationException) {
            return bl;
        }
    }

    @Override
    public String getValue(String string) {
        try {
            return this.getValue();
        }
        catch (ConfigurationException configurationException) {
            return string;
        }
    }

    @Override
    public int getAttributeAsInteger(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string).trim();
        try {
            if (string2.startsWith("0x")) {
                return Integer.parseInt(string2.substring(2), 16);
            }
            if (string2.startsWith("0o")) {
                return Integer.parseInt(string2.substring(2), 8);
            }
            if (string2.startsWith("0b")) {
                return Integer.parseInt(string2.substring(2), 2);
            }
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            String string3 = "Cannot parse the value \"" + string2 + "\" as an integer in the attribute \"" + string + "\" at " + this.getLocation();
            throw new ConfigurationException(string3);
        }
    }

    @Override
    public int getAttributeAsInteger(String string, int n) {
        try {
            return this.getAttributeAsInteger(string);
        }
        catch (ConfigurationException configurationException) {
            return n;
        }
    }

    @Override
    public long getAttributeAsLong(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string);
        try {
            if (string2.startsWith("0x")) {
                return Long.parseLong(string2.substring(2), 16);
            }
            if (string2.startsWith("0o")) {
                return Long.parseLong(string2.substring(2), 8);
            }
            if (string2.startsWith("0b")) {
                return Long.parseLong(string2.substring(2), 2);
            }
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            String string3 = "Cannot parse the value \"" + string2 + "\" as a long in the attribute \"" + string + "\" at " + this.getLocation();
            throw new ConfigurationException(string3);
        }
    }

    @Override
    public long getAttributeAsLong(String string, long l) {
        try {
            return this.getAttributeAsLong(string);
        }
        catch (ConfigurationException configurationException) {
            return l;
        }
    }

    @Override
    public float getAttributeAsFloat(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string);
        try {
            return Float.parseFloat(string2);
        }
        catch (Exception exception) {
            String string3 = "Cannot parse the value \"" + string2 + "\" as a float in the attribute \"" + string + "\" at " + this.getLocation();
            throw new ConfigurationException(string3);
        }
    }

    @Override
    public float getAttributeAsFloat(String string, float f) {
        try {
            return this.getAttributeAsFloat(string);
        }
        catch (ConfigurationException configurationException) {
            return f;
        }
    }

    @Override
    public boolean getAttributeAsBoolean(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string);
        if (this.isTrue(string2)) {
            return true;
        }
        if (this.isFalse(string2)) {
            return false;
        }
        String string3 = "Cannot parse the value \"" + string2 + "\" as a boolean in the attribute \"" + string + "\" at " + this.getLocation();
        throw new ConfigurationException(string3);
    }

    private boolean isTrue(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("1");
    }

    private boolean isFalse(String string) {
        return string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("0");
    }

    @Override
    public boolean getAttributeAsBoolean(String string, boolean bl) {
        try {
            return this.getAttributeAsBoolean(string);
        }
        catch (ConfigurationException configurationException) {
            return bl;
        }
    }

    @Override
    public String getAttribute(String string, String string2) {
        try {
            return this.getAttribute(string);
        }
        catch (ConfigurationException configurationException) {
            return string2;
        }
    }

    @Override
    public Configuration getChild(String string) {
        return this.getChild(string, true);
    }

    @Override
    public Configuration getChild(String string, boolean bl) {
        Configuration[] configurationArray = this.getChildren(string);
        if (configurationArray.length > 0) {
            return configurationArray[0];
        }
        if (bl) {
            return new DefaultConfiguration(string, "-");
        }
        return null;
    }

    public String toString() {
        return this.getName() + "::" + this.getValue("<no value>") + ":@" + this.getLocation();
    }
}

