/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.component;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceSelector;

public class WrapperComponentSelector
implements ComponentSelector {
    private final ServiceSelector m_selector;
    private final String m_key;

    public WrapperComponentSelector(String string, ServiceSelector serviceSelector) {
        if (null == string) {
            throw new NullPointerException("key");
        }
        if (null == serviceSelector) {
            throw new NullPointerException("selector");
        }
        this.m_key = string + "/";
        this.m_selector = serviceSelector;
    }

    public Component select(Object object) throws ComponentException {
        try {
            Object object2 = this.m_selector.select(object);
            if (object2 instanceof Component) {
                return (Component)object2;
            }
        }
        catch (ServiceException serviceException) {
            throw new ComponentException(this.m_key + object, serviceException.getMessage(), (Throwable)serviceException);
        }
        throw new ComponentException(this.m_key + object, "Role does not implement the Component interface and thus can not be accessed via ComponentSelector");
    }

    public boolean hasComponent(Object object) {
        return this.m_selector.isSelectable(object);
    }

    public void release(Component component) {
        this.m_selector.release((Object)component);
    }

    ServiceSelector getWrappedSelector() {
        return this.m_selector;
    }
}

