/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.component;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.WrapperComponentSelector;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;

public class WrapperComponentManager
implements ComponentManager {
    private final ServiceManager m_manager;

    public WrapperComponentManager(ServiceManager serviceManager) {
        if (null == serviceManager) {
            throw new NullPointerException("manager");
        }
        this.m_manager = serviceManager;
    }

    public Component lookup(String string) throws ComponentException {
        try {
            Object object = this.m_manager.lookup(string);
            if (object instanceof ServiceSelector) {
                return new WrapperComponentSelector(string, (ServiceSelector)object);
            }
            if (object instanceof Component) {
                return (Component)object;
            }
        }
        catch (ServiceException serviceException) {
            throw new ComponentException(serviceException.getKey(), serviceException.getMessage(), serviceException.getCause());
        }
        throw new ComponentException(string, "Role does not implement the Component interface and thus can not be accessed via ComponentManager");
    }

    public boolean hasComponent(String string) {
        return this.m_manager.hasService(string);
    }

    public void release(Component component) {
        if (component instanceof WrapperComponentSelector) {
            WrapperComponentSelector wrapperComponentSelector = (WrapperComponentSelector)component;
            this.m_manager.release((Object)wrapperComponentSelector.getWrappedSelector());
        } else {
            this.m_manager.release((Object)component);
        }
    }
}

