/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;

class SingleInstanceLock {
    JNLPFile jnlpFile;
    File lockFile = null;
    public static final int INVALID_PORT = Integer.MIN_VALUE;
    int port = Integer.MIN_VALUE;

    public SingleInstanceLock(JNLPFile jnlpFile) {
        this.jnlpFile = jnlpFile;
        this.lockFile = this.getLockFile();
    }

    public void createWithPort(int localPort) throws IOException {
        FileUtils.createRestrictedFile(this.lockFile, true);
        BufferedWriter lockFileWriter = new BufferedWriter(new FileWriter(this.lockFile, false));
        lockFileWriter.write(String.valueOf(localPort));
        lockFileWriter.newLine();
        lockFileWriter.flush();
        lockFileWriter.close();
    }

    public boolean isValid() {
        return this.exists() && this.getPort() != Integer.MIN_VALUE && !this.isPortFree(this.getPort());
    }

    public int getPort() {
        if (!this.exists()) {
            return Integer.MIN_VALUE;
        }
        try {
            this.parseFile();
        }
        catch (NumberFormatException e) {
            this.port = Integer.MIN_VALUE;
        }
        catch (IOException e) {
            this.port = Integer.MIN_VALUE;
        }
        return this.port;
    }

    private boolean exists() {
        return this.lockFile.exists();
    }

    private boolean isPortFree(int port) {
        try {
            ServerSocket socket = new ServerSocket(port);
            socket.close();
            return true;
        }
        catch (BindException e) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File getLockFile() {
        File baseDir = PathsAndFiles.LOCKS_DIR.getFile();
        if (!baseDir.isDirectory()) {
            if (!baseDir.getParentFile().isDirectory() && !baseDir.getParentFile().mkdirs()) {
                throw new RuntimeException(Translator.R("RNoLockDir", baseDir));
            }
            try {
                FileUtils.createRestrictedDirectory(baseDir);
            }
            catch (IOException e) {
                throw new RuntimeException(Translator.R("RNoLockDir", baseDir));
            }
        }
        String lockFileName = this.getLockFileName();
        File applicationLockFile = new File(baseDir, lockFileName);
        return applicationLockFile;
    }

    private String getLockFileName() {
        String initialName = "";
        initialName = this.jnlpFile.getSourceLocation() != null ? initialName + this.jnlpFile.getSourceLocation() : initialName + this.jnlpFile.getFileLocation();
        if (this.jnlpFile.getFileVersion() != null) {
            initialName = initialName + this.jnlpFile.getFileVersion().toString();
        }
        initialName = initialName + this.getCurrentDisplay();
        return FileUtils.sanitizeFileName(initialName);
    }

    private void parseFile() throws NumberFormatException, IOException {
        BufferedReader lockFileReader = new BufferedReader(new FileReader(this.lockFile));
        int port = Integer.valueOf(lockFileReader.readLine());
        lockFileReader.close();
        this.port = port;
    }

    private String getCurrentDisplay() {
        String display = System.getenv("DISPLAY");
        return display == null ? "" : display;
    }
}

