/*

    This file was generated with gl3w_gen.py, part of gl3w
    (hosted at https://github.com/skaslev/gl3w)

    This is free and unencumbered software released into the public domain.

    Anyone is free to copy, modify, publish, use, compile, sell, or
    distribute this software, either in source code form or as a compiled
    binary, for any purpose, commercial or non-commercial, and by any
    means.

    In jurisdictions that recognize copyright laws, the author or authors
    of this software dedicate any and all copyright interest in the
    software to the public domain. We make this dedication for the benefit
    of the public at large and to the detriment of our heirs and
    successors. We intend this dedication to be an overt act of
    relinquishment in perpetuity of all present and future rights to this
    software under copyright law.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
    IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
    ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __gl3w_h_
#define __gl3w_h_

#include <GL/glcorearb.h>

#ifndef __gl_h_
#define __gl_h_
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void (*GL3WglProc)(void);
typedef GL3WglProc (*GL3WGetProcAddressProc)(const char *proc);

/* gl3w api */
int gl3wInit(void);
int gl3wInit2(GL3WGetProcAddressProc proc);
int gl3wIsSupported(int major, int minor);
GL3WglProc gl3wGetProcAddress(const char *proc);

/* OpenGL functions */
extern PFNGLACTIVESHADERPROGRAMPROC                         gl3wActiveShaderProgram;
extern PFNGLACTIVETEXTUREPROC                               gl3wActiveTexture;
extern PFNGLATTACHSHADERPROC                                gl3wAttachShader;
extern PFNGLBEGINCONDITIONALRENDERPROC                      gl3wBeginConditionalRender;
extern PFNGLBEGINQUERYPROC                                  gl3wBeginQuery;
extern PFNGLBEGINQUERYINDEXEDPROC                           gl3wBeginQueryIndexed;
extern PFNGLBEGINTRANSFORMFEEDBACKPROC                      gl3wBeginTransformFeedback;
extern PFNGLBINDATTRIBLOCATIONPROC                          gl3wBindAttribLocation;
extern PFNGLBINDBUFFERPROC                                  gl3wBindBuffer;
extern PFNGLBINDBUFFERBASEPROC                              gl3wBindBufferBase;
extern PFNGLBINDBUFFERRANGEPROC                             gl3wBindBufferRange;
extern PFNGLBINDBUFFERSBASEPROC                             gl3wBindBuffersBase;
extern PFNGLBINDBUFFERSRANGEPROC                            gl3wBindBuffersRange;
extern PFNGLBINDFRAGDATALOCATIONPROC                        gl3wBindFragDataLocation;
extern PFNGLBINDFRAGDATALOCATIONINDEXEDPROC                 gl3wBindFragDataLocationIndexed;
extern PFNGLBINDFRAMEBUFFERPROC                             gl3wBindFramebuffer;
extern PFNGLBINDIMAGETEXTUREPROC                            gl3wBindImageTexture;
extern PFNGLBINDIMAGETEXTURESPROC                           gl3wBindImageTextures;
extern PFNGLBINDPROGRAMPIPELINEPROC                         gl3wBindProgramPipeline;
extern PFNGLBINDRENDERBUFFERPROC                            gl3wBindRenderbuffer;
extern PFNGLBINDSAMPLERPROC                                 gl3wBindSampler;
extern PFNGLBINDSAMPLERSPROC                                gl3wBindSamplers;
extern PFNGLBINDTEXTUREPROC                                 gl3wBindTexture;
extern PFNGLBINDTEXTURESPROC                                gl3wBindTextures;
extern PFNGLBINDTRANSFORMFEEDBACKPROC                       gl3wBindTransformFeedback;
extern PFNGLBINDVERTEXARRAYPROC                             gl3wBindVertexArray;
extern PFNGLBINDVERTEXBUFFERPROC                            gl3wBindVertexBuffer;
extern PFNGLBINDVERTEXBUFFERSPROC                           gl3wBindVertexBuffers;
extern PFNGLBLENDCOLORPROC                                  gl3wBlendColor;
extern PFNGLBLENDEQUATIONPROC                               gl3wBlendEquation;
extern PFNGLBLENDEQUATIONSEPARATEPROC                       gl3wBlendEquationSeparate;
extern PFNGLBLENDEQUATIONSEPARATEIPROC                      gl3wBlendEquationSeparatei;
extern PFNGLBLENDEQUATIONSEPARATEIARBPROC                   gl3wBlendEquationSeparateiARB;
extern PFNGLBLENDEQUATIONIPROC                              gl3wBlendEquationi;
extern PFNGLBLENDEQUATIONIARBPROC                           gl3wBlendEquationiARB;
extern PFNGLBLENDFUNCPROC                                   gl3wBlendFunc;
extern PFNGLBLENDFUNCSEPARATEPROC                           gl3wBlendFuncSeparate;
extern PFNGLBLENDFUNCSEPARATEIPROC                          gl3wBlendFuncSeparatei;
extern PFNGLBLENDFUNCSEPARATEIARBPROC                       gl3wBlendFuncSeparateiARB;
extern PFNGLBLENDFUNCIPROC                                  gl3wBlendFunci;
extern PFNGLBLENDFUNCIARBPROC                               gl3wBlendFunciARB;
extern PFNGLBLITFRAMEBUFFERPROC                             gl3wBlitFramebuffer;
extern PFNGLBUFFERDATAPROC                                  gl3wBufferData;
extern PFNGLBUFFERSTORAGEPROC                               gl3wBufferStorage;
extern PFNGLBUFFERSUBDATAPROC                               gl3wBufferSubData;
extern PFNGLCHECKFRAMEBUFFERSTATUSPROC                      gl3wCheckFramebufferStatus;
extern PFNGLCLAMPCOLORPROC                                  gl3wClampColor;
extern PFNGLCLEARPROC                                       gl3wClear;
extern PFNGLCLEARBUFFERDATAPROC                             gl3wClearBufferData;
extern PFNGLCLEARBUFFERSUBDATAPROC                          gl3wClearBufferSubData;
extern PFNGLCLEARBUFFERFIPROC                               gl3wClearBufferfi;
extern PFNGLCLEARBUFFERFVPROC                               gl3wClearBufferfv;
extern PFNGLCLEARBUFFERIVPROC                               gl3wClearBufferiv;
extern PFNGLCLEARBUFFERUIVPROC                              gl3wClearBufferuiv;
extern PFNGLCLEARCOLORPROC                                  gl3wClearColor;
extern PFNGLCLEARDEPTHPROC                                  gl3wClearDepth;
extern PFNGLCLEARDEPTHFPROC                                 gl3wClearDepthf;
extern PFNGLCLEARSTENCILPROC                                gl3wClearStencil;
extern PFNGLCLEARTEXIMAGEPROC                               gl3wClearTexImage;
extern PFNGLCLEARTEXSUBIMAGEPROC                            gl3wClearTexSubImage;
extern PFNGLCLIENTWAITSYNCPROC                              gl3wClientWaitSync;
extern PFNGLCOLORMASKPROC                                   gl3wColorMask;
extern PFNGLCOLORMASKIPROC                                  gl3wColorMaski;
extern PFNGLCOMPILESHADERPROC                               gl3wCompileShader;
extern PFNGLCOMPILESHADERINCLUDEARBPROC                     gl3wCompileShaderIncludeARB;
extern PFNGLCOMPRESSEDTEXIMAGE1DPROC                        gl3wCompressedTexImage1D;
extern PFNGLCOMPRESSEDTEXIMAGE2DPROC                        gl3wCompressedTexImage2D;
extern PFNGLCOMPRESSEDTEXIMAGE3DPROC                        gl3wCompressedTexImage3D;
extern PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC                     gl3wCompressedTexSubImage1D;
extern PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC                     gl3wCompressedTexSubImage2D;
extern PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC                     gl3wCompressedTexSubImage3D;
extern PFNGLCOPYBUFFERSUBDATAPROC                           gl3wCopyBufferSubData;
extern PFNGLCOPYIMAGESUBDATAPROC                            gl3wCopyImageSubData;
extern PFNGLCOPYTEXIMAGE1DPROC                              gl3wCopyTexImage1D;
extern PFNGLCOPYTEXIMAGE2DPROC                              gl3wCopyTexImage2D;
extern PFNGLCOPYTEXSUBIMAGE1DPROC                           gl3wCopyTexSubImage1D;
extern PFNGLCOPYTEXSUBIMAGE2DPROC                           gl3wCopyTexSubImage2D;
extern PFNGLCOPYTEXSUBIMAGE3DPROC                           gl3wCopyTexSubImage3D;
extern PFNGLCREATEPROGRAMPROC                               gl3wCreateProgram;
extern PFNGLCREATESHADERPROC                                gl3wCreateShader;
extern PFNGLCREATESHADERPROGRAMVPROC                        gl3wCreateShaderProgramv;
extern PFNGLCREATESYNCFROMCLEVENTARBPROC                    gl3wCreateSyncFromCLeventARB;
extern PFNGLCULLFACEPROC                                    gl3wCullFace;
extern PFNGLDEBUGMESSAGECALLBACKPROC                        gl3wDebugMessageCallback;
extern PFNGLDEBUGMESSAGECALLBACKARBPROC                     gl3wDebugMessageCallbackARB;
extern PFNGLDEBUGMESSAGECONTROLPROC                         gl3wDebugMessageControl;
extern PFNGLDEBUGMESSAGECONTROLARBPROC                      gl3wDebugMessageControlARB;
extern PFNGLDEBUGMESSAGEINSERTPROC                          gl3wDebugMessageInsert;
extern PFNGLDEBUGMESSAGEINSERTARBPROC                       gl3wDebugMessageInsertARB;
extern PFNGLDELETEBUFFERSPROC                               gl3wDeleteBuffers;
extern PFNGLDELETEFRAMEBUFFERSPROC                          gl3wDeleteFramebuffers;
extern PFNGLDELETENAMEDSTRINGARBPROC                        gl3wDeleteNamedStringARB;
extern PFNGLDELETEPROGRAMPROC                               gl3wDeleteProgram;
extern PFNGLDELETEPROGRAMPIPELINESPROC                      gl3wDeleteProgramPipelines;
extern PFNGLDELETEQUERIESPROC                               gl3wDeleteQueries;
extern PFNGLDELETERENDERBUFFERSPROC                         gl3wDeleteRenderbuffers;
extern PFNGLDELETESAMPLERSPROC                              gl3wDeleteSamplers;
extern PFNGLDELETESHADERPROC                                gl3wDeleteShader;
extern PFNGLDELETESYNCPROC                                  gl3wDeleteSync;
extern PFNGLDELETETEXTURESPROC                              gl3wDeleteTextures;
extern PFNGLDELETETRANSFORMFEEDBACKSPROC                    gl3wDeleteTransformFeedbacks;
extern PFNGLDELETEVERTEXARRAYSPROC                          gl3wDeleteVertexArrays;
extern PFNGLDEPTHFUNCPROC                                   gl3wDepthFunc;
extern PFNGLDEPTHMASKPROC                                   gl3wDepthMask;
extern PFNGLDEPTHRANGEPROC                                  gl3wDepthRange;
extern PFNGLDEPTHRANGEARRAYVPROC                            gl3wDepthRangeArrayv;
extern PFNGLDEPTHRANGEINDEXEDPROC                           gl3wDepthRangeIndexed;
extern PFNGLDEPTHRANGEFPROC                                 gl3wDepthRangef;
extern PFNGLDETACHSHADERPROC                                gl3wDetachShader;
extern PFNGLDISABLEPROC                                     gl3wDisable;
extern PFNGLDISABLEVERTEXATTRIBARRAYPROC                    gl3wDisableVertexAttribArray;
extern PFNGLDISABLEIPROC                                    gl3wDisablei;
extern PFNGLDISPATCHCOMPUTEPROC                             gl3wDispatchCompute;
extern PFNGLDISPATCHCOMPUTEGROUPSIZEARBPROC                 gl3wDispatchComputeGroupSizeARB;
extern PFNGLDISPATCHCOMPUTEINDIRECTPROC                     gl3wDispatchComputeIndirect;
extern PFNGLDRAWARRAYSPROC                                  gl3wDrawArrays;
extern PFNGLDRAWARRAYSINDIRECTPROC                          gl3wDrawArraysIndirect;
extern PFNGLDRAWARRAYSINSTANCEDPROC                         gl3wDrawArraysInstanced;
extern PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC             gl3wDrawArraysInstancedBaseInstance;
extern PFNGLDRAWBUFFERPROC                                  gl3wDrawBuffer;
extern PFNGLDRAWBUFFERSPROC                                 gl3wDrawBuffers;
extern PFNGLDRAWELEMENTSPROC                                gl3wDrawElements;
extern PFNGLDRAWELEMENTSBASEVERTEXPROC                      gl3wDrawElementsBaseVertex;
extern PFNGLDRAWELEMENTSINDIRECTPROC                        gl3wDrawElementsIndirect;
extern PFNGLDRAWELEMENTSINSTANCEDPROC                       gl3wDrawElementsInstanced;
extern PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC           gl3wDrawElementsInstancedBaseInstance;
extern PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC             gl3wDrawElementsInstancedBaseVertex;
extern PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC gl3wDrawElementsInstancedBaseVertexBaseInstance;
extern PFNGLDRAWRANGEELEMENTSPROC                           gl3wDrawRangeElements;
extern PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC                 gl3wDrawRangeElementsBaseVertex;
extern PFNGLDRAWTRANSFORMFEEDBACKPROC                       gl3wDrawTransformFeedback;
extern PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC              gl3wDrawTransformFeedbackInstanced;
extern PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC                 gl3wDrawTransformFeedbackStream;
extern PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC        gl3wDrawTransformFeedbackStreamInstanced;
extern PFNGLENABLEPROC                                      gl3wEnable;
extern PFNGLENABLEVERTEXATTRIBARRAYPROC                     gl3wEnableVertexAttribArray;
extern PFNGLENABLEIPROC                                     gl3wEnablei;
extern PFNGLENDCONDITIONALRENDERPROC                        gl3wEndConditionalRender;
extern PFNGLENDQUERYPROC                                    gl3wEndQuery;
extern PFNGLENDQUERYINDEXEDPROC                             gl3wEndQueryIndexed;
extern PFNGLENDTRANSFORMFEEDBACKPROC                        gl3wEndTransformFeedback;
extern PFNGLFENCESYNCPROC                                   gl3wFenceSync;
extern PFNGLFINISHPROC                                      gl3wFinish;
extern PFNGLFLUSHPROC                                       gl3wFlush;
extern PFNGLFLUSHMAPPEDBUFFERRANGEPROC                      gl3wFlushMappedBufferRange;
extern PFNGLFRAMEBUFFERPARAMETERIPROC                       gl3wFramebufferParameteri;
extern PFNGLFRAMEBUFFERRENDERBUFFERPROC                     gl3wFramebufferRenderbuffer;
extern PFNGLFRAMEBUFFERTEXTUREPROC                          gl3wFramebufferTexture;
extern PFNGLFRAMEBUFFERTEXTURE1DPROC                        gl3wFramebufferTexture1D;
extern PFNGLFRAMEBUFFERTEXTURE2DPROC                        gl3wFramebufferTexture2D;
extern PFNGLFRAMEBUFFERTEXTURE3DPROC                        gl3wFramebufferTexture3D;
extern PFNGLFRAMEBUFFERTEXTURELAYERPROC                     gl3wFramebufferTextureLayer;
extern PFNGLFRONTFACEPROC                                   gl3wFrontFace;
extern PFNGLGENBUFFERSPROC                                  gl3wGenBuffers;
extern PFNGLGENFRAMEBUFFERSPROC                             gl3wGenFramebuffers;
extern PFNGLGENPROGRAMPIPELINESPROC                         gl3wGenProgramPipelines;
extern PFNGLGENQUERIESPROC                                  gl3wGenQueries;
extern PFNGLGENRENDERBUFFERSPROC                            gl3wGenRenderbuffers;
extern PFNGLGENSAMPLERSPROC                                 gl3wGenSamplers;
extern PFNGLGENTEXTURESPROC                                 gl3wGenTextures;
extern PFNGLGENTRANSFORMFEEDBACKSPROC                       gl3wGenTransformFeedbacks;
extern PFNGLGENVERTEXARRAYSPROC                             gl3wGenVertexArrays;
extern PFNGLGENERATEMIPMAPPROC                              gl3wGenerateMipmap;
extern PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC              gl3wGetActiveAtomicCounterBufferiv;
extern PFNGLGETACTIVEATTRIBPROC                             gl3wGetActiveAttrib;
extern PFNGLGETACTIVESUBROUTINENAMEPROC                     gl3wGetActiveSubroutineName;
extern PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC              gl3wGetActiveSubroutineUniformName;
extern PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC                gl3wGetActiveSubroutineUniformiv;
extern PFNGLGETACTIVEUNIFORMPROC                            gl3wGetActiveUniform;
extern PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC                   gl3wGetActiveUniformBlockName;
extern PFNGLGETACTIVEUNIFORMBLOCKIVPROC                     gl3wGetActiveUniformBlockiv;
extern PFNGLGETACTIVEUNIFORMNAMEPROC                        gl3wGetActiveUniformName;
extern PFNGLGETACTIVEUNIFORMSIVPROC                         gl3wGetActiveUniformsiv;
extern PFNGLGETATTACHEDSHADERSPROC                          gl3wGetAttachedShaders;
extern PFNGLGETATTRIBLOCATIONPROC                           gl3wGetAttribLocation;
extern PFNGLGETBOOLEANI_VPROC                               gl3wGetBooleani_v;
extern PFNGLGETBOOLEANVPROC                                 gl3wGetBooleanv;
extern PFNGLGETBUFFERPARAMETERI64VPROC                      gl3wGetBufferParameteri64v;
extern PFNGLGETBUFFERPARAMETERIVPROC                        gl3wGetBufferParameteriv;
extern PFNGLGETBUFFERPOINTERVPROC                           gl3wGetBufferPointerv;
extern PFNGLGETBUFFERSUBDATAPROC                            gl3wGetBufferSubData;
extern PFNGLGETCOMPRESSEDTEXIMAGEPROC                       gl3wGetCompressedTexImage;
extern PFNGLGETDEBUGMESSAGELOGPROC                          gl3wGetDebugMessageLog;
extern PFNGLGETDEBUGMESSAGELOGARBPROC                       gl3wGetDebugMessageLogARB;
extern PFNGLGETDOUBLEI_VPROC                                gl3wGetDoublei_v;
extern PFNGLGETDOUBLEVPROC                                  gl3wGetDoublev;
extern PFNGLGETERRORPROC                                    gl3wGetError;
extern PFNGLGETFLOATI_VPROC                                 gl3wGetFloati_v;
extern PFNGLGETFLOATVPROC                                   gl3wGetFloatv;
extern PFNGLGETFRAGDATAINDEXPROC                            gl3wGetFragDataIndex;
extern PFNGLGETFRAGDATALOCATIONPROC                         gl3wGetFragDataLocation;
extern PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC         gl3wGetFramebufferAttachmentParameteriv;
extern PFNGLGETFRAMEBUFFERPARAMETERIVPROC                   gl3wGetFramebufferParameteriv;
extern PFNGLGETGRAPHICSRESETSTATUSARBPROC                   gl3wGetGraphicsResetStatusARB;
extern PFNGLGETIMAGEHANDLEARBPROC                           gl3wGetImageHandleARB;
extern PFNGLGETINTEGER64I_VPROC                             gl3wGetInteger64i_v;
extern PFNGLGETINTEGER64VPROC                               gl3wGetInteger64v;
extern PFNGLGETINTEGERI_VPROC                               gl3wGetIntegeri_v;
extern PFNGLGETINTEGERVPROC                                 gl3wGetIntegerv;
extern PFNGLGETINTERNALFORMATI64VPROC                       gl3wGetInternalformati64v;
extern PFNGLGETINTERNALFORMATIVPROC                         gl3wGetInternalformativ;
extern PFNGLGETMULTISAMPLEFVPROC                            gl3wGetMultisamplefv;
extern PFNGLGETNAMEDSTRINGARBPROC                           gl3wGetNamedStringARB;
extern PFNGLGETNAMEDSTRINGIVARBPROC                         gl3wGetNamedStringivARB;
extern PFNGLGETOBJECTLABELPROC                              gl3wGetObjectLabel;
extern PFNGLGETOBJECTPTRLABELPROC                           gl3wGetObjectPtrLabel;
extern PFNGLGETPOINTERVPROC                                 gl3wGetPointerv;
extern PFNGLGETPROGRAMBINARYPROC                            gl3wGetProgramBinary;
extern PFNGLGETPROGRAMINFOLOGPROC                           gl3wGetProgramInfoLog;
extern PFNGLGETPROGRAMINTERFACEIVPROC                       gl3wGetProgramInterfaceiv;
extern PFNGLGETPROGRAMPIPELINEINFOLOGPROC                   gl3wGetProgramPipelineInfoLog;
extern PFNGLGETPROGRAMPIPELINEIVPROC                        gl3wGetProgramPipelineiv;
extern PFNGLGETPROGRAMRESOURCEINDEXPROC                     gl3wGetProgramResourceIndex;
extern PFNGLGETPROGRAMRESOURCELOCATIONPROC                  gl3wGetProgramResourceLocation;
extern PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC             gl3wGetProgramResourceLocationIndex;
extern PFNGLGETPROGRAMRESOURCENAMEPROC                      gl3wGetProgramResourceName;
extern PFNGLGETPROGRAMRESOURCEIVPROC                        gl3wGetProgramResourceiv;
extern PFNGLGETPROGRAMSTAGEIVPROC                           gl3wGetProgramStageiv;
extern PFNGLGETPROGRAMIVPROC                                gl3wGetProgramiv;
extern PFNGLGETQUERYINDEXEDIVPROC                           gl3wGetQueryIndexediv;
extern PFNGLGETQUERYOBJECTI64VPROC                          gl3wGetQueryObjecti64v;
extern PFNGLGETQUERYOBJECTIVPROC                            gl3wGetQueryObjectiv;
extern PFNGLGETQUERYOBJECTUI64VPROC                         gl3wGetQueryObjectui64v;
extern PFNGLGETQUERYOBJECTUIVPROC                           gl3wGetQueryObjectuiv;
extern PFNGLGETQUERYIVPROC                                  gl3wGetQueryiv;
extern PFNGLGETRENDERBUFFERPARAMETERIVPROC                  gl3wGetRenderbufferParameteriv;
extern PFNGLGETSAMPLERPARAMETERIIVPROC                      gl3wGetSamplerParameterIiv;
extern PFNGLGETSAMPLERPARAMETERIUIVPROC                     gl3wGetSamplerParameterIuiv;
extern PFNGLGETSAMPLERPARAMETERFVPROC                       gl3wGetSamplerParameterfv;
extern PFNGLGETSAMPLERPARAMETERIVPROC                       gl3wGetSamplerParameteriv;
extern PFNGLGETSHADERINFOLOGPROC                            gl3wGetShaderInfoLog;
extern PFNGLGETSHADERPRECISIONFORMATPROC                    gl3wGetShaderPrecisionFormat;
extern PFNGLGETSHADERSOURCEPROC                             gl3wGetShaderSource;
extern PFNGLGETSHADERIVPROC                                 gl3wGetShaderiv;
extern PFNGLGETSTRINGPROC                                   gl3wGetString;
extern PFNGLGETSTRINGIPROC                                  gl3wGetStringi;
extern PFNGLGETSUBROUTINEINDEXPROC                          gl3wGetSubroutineIndex;
extern PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC                gl3wGetSubroutineUniformLocation;
extern PFNGLGETSYNCIVPROC                                   gl3wGetSynciv;
extern PFNGLGETTEXIMAGEPROC                                 gl3wGetTexImage;
extern PFNGLGETTEXLEVELPARAMETERFVPROC                      gl3wGetTexLevelParameterfv;
extern PFNGLGETTEXLEVELPARAMETERIVPROC                      gl3wGetTexLevelParameteriv;
extern PFNGLGETTEXPARAMETERIIVPROC                          gl3wGetTexParameterIiv;
extern PFNGLGETTEXPARAMETERIUIVPROC                         gl3wGetTexParameterIuiv;
extern PFNGLGETTEXPARAMETERFVPROC                           gl3wGetTexParameterfv;
extern PFNGLGETTEXPARAMETERIVPROC                           gl3wGetTexParameteriv;
extern PFNGLGETTEXTUREHANDLEARBPROC                         gl3wGetTextureHandleARB;
extern PFNGLGETTEXTURESAMPLERHANDLEARBPROC                  gl3wGetTextureSamplerHandleARB;
extern PFNGLGETTRANSFORMFEEDBACKVARYINGPROC                 gl3wGetTransformFeedbackVarying;
extern PFNGLGETUNIFORMBLOCKINDEXPROC                        gl3wGetUniformBlockIndex;
extern PFNGLGETUNIFORMINDICESPROC                           gl3wGetUniformIndices;
extern PFNGLGETUNIFORMLOCATIONPROC                          gl3wGetUniformLocation;
extern PFNGLGETUNIFORMSUBROUTINEUIVPROC                     gl3wGetUniformSubroutineuiv;
extern PFNGLGETUNIFORMDVPROC                                gl3wGetUniformdv;
extern PFNGLGETUNIFORMFVPROC                                gl3wGetUniformfv;
extern PFNGLGETUNIFORMIVPROC                                gl3wGetUniformiv;
extern PFNGLGETUNIFORMUIVPROC                               gl3wGetUniformuiv;
extern PFNGLGETVERTEXATTRIBIIVPROC                          gl3wGetVertexAttribIiv;
extern PFNGLGETVERTEXATTRIBIUIVPROC                         gl3wGetVertexAttribIuiv;
extern PFNGLGETVERTEXATTRIBLDVPROC                          gl3wGetVertexAttribLdv;
extern PFNGLGETVERTEXATTRIBLUI64VARBPROC                    gl3wGetVertexAttribLui64vARB;
extern PFNGLGETVERTEXATTRIBPOINTERVPROC                     gl3wGetVertexAttribPointerv;
extern PFNGLGETVERTEXATTRIBDVPROC                           gl3wGetVertexAttribdv;
extern PFNGLGETVERTEXATTRIBFVPROC                           gl3wGetVertexAttribfv;
extern PFNGLGETVERTEXATTRIBIVPROC                           gl3wGetVertexAttribiv;
extern PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC                   gl3wGetnCompressedTexImageARB;
extern PFNGLGETNTEXIMAGEARBPROC                             gl3wGetnTexImageARB;
extern PFNGLGETNUNIFORMDVARBPROC                            gl3wGetnUniformdvARB;
extern PFNGLGETNUNIFORMFVARBPROC                            gl3wGetnUniformfvARB;
extern PFNGLGETNUNIFORMIVARBPROC                            gl3wGetnUniformivARB;
extern PFNGLGETNUNIFORMUIVARBPROC                           gl3wGetnUniformuivARB;
extern PFNGLHINTPROC                                        gl3wHint;
extern PFNGLINVALIDATEBUFFERDATAPROC                        gl3wInvalidateBufferData;
extern PFNGLINVALIDATEBUFFERSUBDATAPROC                     gl3wInvalidateBufferSubData;
extern PFNGLINVALIDATEFRAMEBUFFERPROC                       gl3wInvalidateFramebuffer;
extern PFNGLINVALIDATESUBFRAMEBUFFERPROC                    gl3wInvalidateSubFramebuffer;
extern PFNGLINVALIDATETEXIMAGEPROC                          gl3wInvalidateTexImage;
extern PFNGLINVALIDATETEXSUBIMAGEPROC                       gl3wInvalidateTexSubImage;
extern PFNGLISBUFFERPROC                                    gl3wIsBuffer;
extern PFNGLISENABLEDPROC                                   gl3wIsEnabled;
extern PFNGLISENABLEDIPROC                                  gl3wIsEnabledi;
extern PFNGLISFRAMEBUFFERPROC                               gl3wIsFramebuffer;
extern PFNGLISIMAGEHANDLERESIDENTARBPROC                    gl3wIsImageHandleResidentARB;
extern PFNGLISNAMEDSTRINGARBPROC                            gl3wIsNamedStringARB;
extern PFNGLISPROGRAMPROC                                   gl3wIsProgram;
extern PFNGLISPROGRAMPIPELINEPROC                           gl3wIsProgramPipeline;
extern PFNGLISQUERYPROC                                     gl3wIsQuery;
extern PFNGLISRENDERBUFFERPROC                              gl3wIsRenderbuffer;
extern PFNGLISSAMPLERPROC                                   gl3wIsSampler;
extern PFNGLISSHADERPROC                                    gl3wIsShader;
extern PFNGLISSYNCPROC                                      gl3wIsSync;
extern PFNGLISTEXTUREPROC                                   gl3wIsTexture;
extern PFNGLISTEXTUREHANDLERESIDENTARBPROC                  gl3wIsTextureHandleResidentARB;
extern PFNGLISTRANSFORMFEEDBACKPROC                         gl3wIsTransformFeedback;
extern PFNGLISVERTEXARRAYPROC                               gl3wIsVertexArray;
extern PFNGLLINEWIDTHPROC                                   gl3wLineWidth;
extern PFNGLLINKPROGRAMPROC                                 gl3wLinkProgram;
extern PFNGLLOGICOPPROC                                     gl3wLogicOp;
extern PFNGLMAKEIMAGEHANDLENONRESIDENTARBPROC               gl3wMakeImageHandleNonResidentARB;
extern PFNGLMAKEIMAGEHANDLERESIDENTARBPROC                  gl3wMakeImageHandleResidentARB;
extern PFNGLMAKETEXTUREHANDLENONRESIDENTARBPROC             gl3wMakeTextureHandleNonResidentARB;
extern PFNGLMAKETEXTUREHANDLERESIDENTARBPROC                gl3wMakeTextureHandleResidentARB;
extern PFNGLMAPBUFFERPROC                                   gl3wMapBuffer;
extern PFNGLMAPBUFFERRANGEPROC                              gl3wMapBufferRange;
extern PFNGLMEMORYBARRIERPROC                               gl3wMemoryBarrier;
extern PFNGLMINSAMPLESHADINGPROC                            gl3wMinSampleShading;
extern PFNGLMINSAMPLESHADINGARBPROC                         gl3wMinSampleShadingARB;
extern PFNGLMULTIDRAWARRAYSPROC                             gl3wMultiDrawArrays;
extern PFNGLMULTIDRAWARRAYSINDIRECTPROC                     gl3wMultiDrawArraysIndirect;
extern PFNGLMULTIDRAWARRAYSINDIRECTCOUNTARBPROC             gl3wMultiDrawArraysIndirectCountARB;
extern PFNGLMULTIDRAWELEMENTSPROC                           gl3wMultiDrawElements;
extern PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC                 gl3wMultiDrawElementsBaseVertex;
extern PFNGLMULTIDRAWELEMENTSINDIRECTPROC                   gl3wMultiDrawElementsIndirect;
extern PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTARBPROC           gl3wMultiDrawElementsIndirectCountARB;
extern PFNGLNAMEDSTRINGARBPROC                              gl3wNamedStringARB;
extern PFNGLOBJECTLABELPROC                                 gl3wObjectLabel;
extern PFNGLOBJECTPTRLABELPROC                              gl3wObjectPtrLabel;
extern PFNGLPATCHPARAMETERFVPROC                            gl3wPatchParameterfv;
extern PFNGLPATCHPARAMETERIPROC                             gl3wPatchParameteri;
extern PFNGLPAUSETRANSFORMFEEDBACKPROC                      gl3wPauseTransformFeedback;
extern PFNGLPIXELSTOREFPROC                                 gl3wPixelStoref;
extern PFNGLPIXELSTOREIPROC                                 gl3wPixelStorei;
extern PFNGLPOINTPARAMETERFPROC                             gl3wPointParameterf;
extern PFNGLPOINTPARAMETERFVPROC                            gl3wPointParameterfv;
extern PFNGLPOINTPARAMETERIPROC                             gl3wPointParameteri;
extern PFNGLPOINTPARAMETERIVPROC                            gl3wPointParameteriv;
extern PFNGLPOINTSIZEPROC                                   gl3wPointSize;
extern PFNGLPOLYGONMODEPROC                                 gl3wPolygonMode;
extern PFNGLPOLYGONOFFSETPROC                               gl3wPolygonOffset;
extern PFNGLPOPDEBUGGROUPPROC                               gl3wPopDebugGroup;
extern PFNGLPRIMITIVERESTARTINDEXPROC                       gl3wPrimitiveRestartIndex;
extern PFNGLPROGRAMBINARYPROC                               gl3wProgramBinary;
extern PFNGLPROGRAMPARAMETERIPROC                           gl3wProgramParameteri;
extern PFNGLPROGRAMUNIFORM1DPROC                            gl3wProgramUniform1d;
extern PFNGLPROGRAMUNIFORM1DVPROC                           gl3wProgramUniform1dv;
extern PFNGLPROGRAMUNIFORM1FPROC                            gl3wProgramUniform1f;
extern PFNGLPROGRAMUNIFORM1FVPROC                           gl3wProgramUniform1fv;
extern PFNGLPROGRAMUNIFORM1IPROC                            gl3wProgramUniform1i;
extern PFNGLPROGRAMUNIFORM1IVPROC                           gl3wProgramUniform1iv;
extern PFNGLPROGRAMUNIFORM1UIPROC                           gl3wProgramUniform1ui;
extern PFNGLPROGRAMUNIFORM1UIVPROC                          gl3wProgramUniform1uiv;
extern PFNGLPROGRAMUNIFORM2DPROC                            gl3wProgramUniform2d;
extern PFNGLPROGRAMUNIFORM2DVPROC                           gl3wProgramUniform2dv;
extern PFNGLPROGRAMUNIFORM2FPROC                            gl3wProgramUniform2f;
extern PFNGLPROGRAMUNIFORM2FVPROC                           gl3wProgramUniform2fv;
extern PFNGLPROGRAMUNIFORM2IPROC                            gl3wProgramUniform2i;
extern PFNGLPROGRAMUNIFORM2IVPROC                           gl3wProgramUniform2iv;
extern PFNGLPROGRAMUNIFORM2UIPROC                           gl3wProgramUniform2ui;
extern PFNGLPROGRAMUNIFORM2UIVPROC                          gl3wProgramUniform2uiv;
extern PFNGLPROGRAMUNIFORM3DPROC                            gl3wProgramUniform3d;
extern PFNGLPROGRAMUNIFORM3DVPROC                           gl3wProgramUniform3dv;
extern PFNGLPROGRAMUNIFORM3FPROC                            gl3wProgramUniform3f;
extern PFNGLPROGRAMUNIFORM3FVPROC                           gl3wProgramUniform3fv;
extern PFNGLPROGRAMUNIFORM3IPROC                            gl3wProgramUniform3i;
extern PFNGLPROGRAMUNIFORM3IVPROC                           gl3wProgramUniform3iv;
extern PFNGLPROGRAMUNIFORM3UIPROC                           gl3wProgramUniform3ui;
extern PFNGLPROGRAMUNIFORM3UIVPROC                          gl3wProgramUniform3uiv;
extern PFNGLPROGRAMUNIFORM4DPROC                            gl3wProgramUniform4d;
extern PFNGLPROGRAMUNIFORM4DVPROC                           gl3wProgramUniform4dv;
extern PFNGLPROGRAMUNIFORM4FPROC                            gl3wProgramUniform4f;
extern PFNGLPROGRAMUNIFORM4FVPROC                           gl3wProgramUniform4fv;
extern PFNGLPROGRAMUNIFORM4IPROC                            gl3wProgramUniform4i;
extern PFNGLPROGRAMUNIFORM4IVPROC                           gl3wProgramUniform4iv;
extern PFNGLPROGRAMUNIFORM4UIPROC                           gl3wProgramUniform4ui;
extern PFNGLPROGRAMUNIFORM4UIVPROC                          gl3wProgramUniform4uiv;
extern PFNGLPROGRAMUNIFORMHANDLEUI64ARBPROC                 gl3wProgramUniformHandleui64ARB;
extern PFNGLPROGRAMUNIFORMHANDLEUI64VARBPROC                gl3wProgramUniformHandleui64vARB;
extern PFNGLPROGRAMUNIFORMMATRIX2DVPROC                     gl3wProgramUniformMatrix2dv;
extern PFNGLPROGRAMUNIFORMMATRIX2FVPROC                     gl3wProgramUniformMatrix2fv;
extern PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC                   gl3wProgramUniformMatrix2x3dv;
extern PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC                   gl3wProgramUniformMatrix2x3fv;
extern PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC                   gl3wProgramUniformMatrix2x4dv;
extern PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC                   gl3wProgramUniformMatrix2x4fv;
extern PFNGLPROGRAMUNIFORMMATRIX3DVPROC                     gl3wProgramUniformMatrix3dv;
extern PFNGLPROGRAMUNIFORMMATRIX3FVPROC                     gl3wProgramUniformMatrix3fv;
extern PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC                   gl3wProgramUniformMatrix3x2dv;
extern PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC                   gl3wProgramUniformMatrix3x2fv;
extern PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC                   gl3wProgramUniformMatrix3x4dv;
extern PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC                   gl3wProgramUniformMatrix3x4fv;
extern PFNGLPROGRAMUNIFORMMATRIX4DVPROC                     gl3wProgramUniformMatrix4dv;
extern PFNGLPROGRAMUNIFORMMATRIX4FVPROC                     gl3wProgramUniformMatrix4fv;
extern PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC                   gl3wProgramUniformMatrix4x2dv;
extern PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC                   gl3wProgramUniformMatrix4x2fv;
extern PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC                   gl3wProgramUniformMatrix4x3dv;
extern PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC                   gl3wProgramUniformMatrix4x3fv;
extern PFNGLPROVOKINGVERTEXPROC                             gl3wProvokingVertex;
extern PFNGLPUSHDEBUGGROUPPROC                              gl3wPushDebugGroup;
extern PFNGLQUERYCOUNTERPROC                                gl3wQueryCounter;
extern PFNGLREADBUFFERPROC                                  gl3wReadBuffer;
extern PFNGLREADPIXELSPROC                                  gl3wReadPixels;
extern PFNGLREADNPIXELSARBPROC                              gl3wReadnPixelsARB;
extern PFNGLRELEASESHADERCOMPILERPROC                       gl3wReleaseShaderCompiler;
extern PFNGLRENDERBUFFERSTORAGEPROC                         gl3wRenderbufferStorage;
extern PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC              gl3wRenderbufferStorageMultisample;
extern PFNGLRESUMETRANSFORMFEEDBACKPROC                     gl3wResumeTransformFeedback;
extern PFNGLSAMPLECOVERAGEPROC                              gl3wSampleCoverage;
extern PFNGLSAMPLEMASKIPROC                                 gl3wSampleMaski;
extern PFNGLSAMPLERPARAMETERIIVPROC                         gl3wSamplerParameterIiv;
extern PFNGLSAMPLERPARAMETERIUIVPROC                        gl3wSamplerParameterIuiv;
extern PFNGLSAMPLERPARAMETERFPROC                           gl3wSamplerParameterf;
extern PFNGLSAMPLERPARAMETERFVPROC                          gl3wSamplerParameterfv;
extern PFNGLSAMPLERPARAMETERIPROC                           gl3wSamplerParameteri;
extern PFNGLSAMPLERPARAMETERIVPROC                          gl3wSamplerParameteriv;
extern PFNGLSCISSORPROC                                     gl3wScissor;
extern PFNGLSCISSORARRAYVPROC                               gl3wScissorArrayv;
extern PFNGLSCISSORINDEXEDPROC                              gl3wScissorIndexed;
extern PFNGLSCISSORINDEXEDVPROC                             gl3wScissorIndexedv;
extern PFNGLSHADERBINARYPROC                                gl3wShaderBinary;
extern PFNGLSHADERSOURCEPROC                                gl3wShaderSource;
extern PFNGLSHADERSTORAGEBLOCKBINDINGPROC                   gl3wShaderStorageBlockBinding;
extern PFNGLSTENCILFUNCPROC                                 gl3wStencilFunc;
extern PFNGLSTENCILFUNCSEPARATEPROC                         gl3wStencilFuncSeparate;
extern PFNGLSTENCILMASKPROC                                 gl3wStencilMask;
extern PFNGLSTENCILMASKSEPARATEPROC                         gl3wStencilMaskSeparate;
extern PFNGLSTENCILOPPROC                                   gl3wStencilOp;
extern PFNGLSTENCILOPSEPARATEPROC                           gl3wStencilOpSeparate;
extern PFNGLTEXBUFFERPROC                                   gl3wTexBuffer;
extern PFNGLTEXBUFFERRANGEPROC                              gl3wTexBufferRange;
extern PFNGLTEXIMAGE1DPROC                                  gl3wTexImage1D;
extern PFNGLTEXIMAGE2DPROC                                  gl3wTexImage2D;
extern PFNGLTEXIMAGE2DMULTISAMPLEPROC                       gl3wTexImage2DMultisample;
extern PFNGLTEXIMAGE3DPROC                                  gl3wTexImage3D;
extern PFNGLTEXIMAGE3DMULTISAMPLEPROC                       gl3wTexImage3DMultisample;
extern PFNGLTEXPAGECOMMITMENTARBPROC                        gl3wTexPageCommitmentARB;
extern PFNGLTEXPARAMETERIIVPROC                             gl3wTexParameterIiv;
extern PFNGLTEXPARAMETERIUIVPROC                            gl3wTexParameterIuiv;
extern PFNGLTEXPARAMETERFPROC                               gl3wTexParameterf;
extern PFNGLTEXPARAMETERFVPROC                              gl3wTexParameterfv;
extern PFNGLTEXPARAMETERIPROC                               gl3wTexParameteri;
extern PFNGLTEXPARAMETERIVPROC                              gl3wTexParameteriv;
extern PFNGLTEXSTORAGE1DPROC                                gl3wTexStorage1D;
extern PFNGLTEXSTORAGE2DPROC                                gl3wTexStorage2D;
extern PFNGLTEXSTORAGE2DMULTISAMPLEPROC                     gl3wTexStorage2DMultisample;
extern PFNGLTEXSTORAGE3DPROC                                gl3wTexStorage3D;
extern PFNGLTEXSTORAGE3DMULTISAMPLEPROC                     gl3wTexStorage3DMultisample;
extern PFNGLTEXSUBIMAGE1DPROC                               gl3wTexSubImage1D;
extern PFNGLTEXSUBIMAGE2DPROC                               gl3wTexSubImage2D;
extern PFNGLTEXSUBIMAGE3DPROC                               gl3wTexSubImage3D;
extern PFNGLTEXTUREVIEWPROC                                 gl3wTextureView;
extern PFNGLTRANSFORMFEEDBACKVARYINGSPROC                   gl3wTransformFeedbackVaryings;
extern PFNGLUNIFORM1DPROC                                   gl3wUniform1d;
extern PFNGLUNIFORM1DVPROC                                  gl3wUniform1dv;
extern PFNGLUNIFORM1FPROC                                   gl3wUniform1f;
extern PFNGLUNIFORM1FVPROC                                  gl3wUniform1fv;
extern PFNGLUNIFORM1IPROC                                   gl3wUniform1i;
extern PFNGLUNIFORM1IVPROC                                  gl3wUniform1iv;
extern PFNGLUNIFORM1UIPROC                                  gl3wUniform1ui;
extern PFNGLUNIFORM1UIVPROC                                 gl3wUniform1uiv;
extern PFNGLUNIFORM2DPROC                                   gl3wUniform2d;
extern PFNGLUNIFORM2DVPROC                                  gl3wUniform2dv;
extern PFNGLUNIFORM2FPROC                                   gl3wUniform2f;
extern PFNGLUNIFORM2FVPROC                                  gl3wUniform2fv;
extern PFNGLUNIFORM2IPROC                                   gl3wUniform2i;
extern PFNGLUNIFORM2IVPROC                                  gl3wUniform2iv;
extern PFNGLUNIFORM2UIPROC                                  gl3wUniform2ui;
extern PFNGLUNIFORM2UIVPROC                                 gl3wUniform2uiv;
extern PFNGLUNIFORM3DPROC                                   gl3wUniform3d;
extern PFNGLUNIFORM3DVPROC                                  gl3wUniform3dv;
extern PFNGLUNIFORM3FPROC                                   gl3wUniform3f;
extern PFNGLUNIFORM3FVPROC                                  gl3wUniform3fv;
extern PFNGLUNIFORM3IPROC                                   gl3wUniform3i;
extern PFNGLUNIFORM3IVPROC                                  gl3wUniform3iv;
extern PFNGLUNIFORM3UIPROC                                  gl3wUniform3ui;
extern PFNGLUNIFORM3UIVPROC                                 gl3wUniform3uiv;
extern PFNGLUNIFORM4DPROC                                   gl3wUniform4d;
extern PFNGLUNIFORM4DVPROC                                  gl3wUniform4dv;
extern PFNGLUNIFORM4FPROC                                   gl3wUniform4f;
extern PFNGLUNIFORM4FVPROC                                  gl3wUniform4fv;
extern PFNGLUNIFORM4IPROC                                   gl3wUniform4i;
extern PFNGLUNIFORM4IVPROC                                  gl3wUniform4iv;
extern PFNGLUNIFORM4UIPROC                                  gl3wUniform4ui;
extern PFNGLUNIFORM4UIVPROC                                 gl3wUniform4uiv;
extern PFNGLUNIFORMBLOCKBINDINGPROC                         gl3wUniformBlockBinding;
extern PFNGLUNIFORMHANDLEUI64ARBPROC                        gl3wUniformHandleui64ARB;
extern PFNGLUNIFORMHANDLEUI64VARBPROC                       gl3wUniformHandleui64vARB;
extern PFNGLUNIFORMMATRIX2DVPROC                            gl3wUniformMatrix2dv;
extern PFNGLUNIFORMMATRIX2FVPROC                            gl3wUniformMatrix2fv;
extern PFNGLUNIFORMMATRIX2X3DVPROC                          gl3wUniformMatrix2x3dv;
extern PFNGLUNIFORMMATRIX2X3FVPROC                          gl3wUniformMatrix2x3fv;
extern PFNGLUNIFORMMATRIX2X4DVPROC                          gl3wUniformMatrix2x4dv;
extern PFNGLUNIFORMMATRIX2X4FVPROC                          gl3wUniformMatrix2x4fv;
extern PFNGLUNIFORMMATRIX3DVPROC                            gl3wUniformMatrix3dv;
extern PFNGLUNIFORMMATRIX3FVPROC                            gl3wUniformMatrix3fv;
extern PFNGLUNIFORMMATRIX3X2DVPROC                          gl3wUniformMatrix3x2dv;
extern PFNGLUNIFORMMATRIX3X2FVPROC                          gl3wUniformMatrix3x2fv;
extern PFNGLUNIFORMMATRIX3X4DVPROC                          gl3wUniformMatrix3x4dv;
extern PFNGLUNIFORMMATRIX3X4FVPROC                          gl3wUniformMatrix3x4fv;
extern PFNGLUNIFORMMATRIX4DVPROC                            gl3wUniformMatrix4dv;
extern PFNGLUNIFORMMATRIX4FVPROC                            gl3wUniformMatrix4fv;
extern PFNGLUNIFORMMATRIX4X2DVPROC                          gl3wUniformMatrix4x2dv;
extern PFNGLUNIFORMMATRIX4X2FVPROC                          gl3wUniformMatrix4x2fv;
extern PFNGLUNIFORMMATRIX4X3DVPROC                          gl3wUniformMatrix4x3dv;
extern PFNGLUNIFORMMATRIX4X3FVPROC                          gl3wUniformMatrix4x3fv;
extern PFNGLUNIFORMSUBROUTINESUIVPROC                       gl3wUniformSubroutinesuiv;
extern PFNGLUNMAPBUFFERPROC                                 gl3wUnmapBuffer;
extern PFNGLUSEPROGRAMPROC                                  gl3wUseProgram;
extern PFNGLUSEPROGRAMSTAGESPROC                            gl3wUseProgramStages;
extern PFNGLVALIDATEPROGRAMPROC                             gl3wValidateProgram;
extern PFNGLVALIDATEPROGRAMPIPELINEPROC                     gl3wValidateProgramPipeline;
extern PFNGLVERTEXATTRIB1DPROC                              gl3wVertexAttrib1d;
extern PFNGLVERTEXATTRIB1DVPROC                             gl3wVertexAttrib1dv;
extern PFNGLVERTEXATTRIB1FPROC                              gl3wVertexAttrib1f;
extern PFNGLVERTEXATTRIB1FVPROC                             gl3wVertexAttrib1fv;
extern PFNGLVERTEXATTRIB1SPROC                              gl3wVertexAttrib1s;
extern PFNGLVERTEXATTRIB1SVPROC                             gl3wVertexAttrib1sv;
extern PFNGLVERTEXATTRIB2DPROC                              gl3wVertexAttrib2d;
extern PFNGLVERTEXATTRIB2DVPROC                             gl3wVertexAttrib2dv;
extern PFNGLVERTEXATTRIB2FPROC                              gl3wVertexAttrib2f;
extern PFNGLVERTEXATTRIB2FVPROC                             gl3wVertexAttrib2fv;
extern PFNGLVERTEXATTRIB2SPROC                              gl3wVertexAttrib2s;
extern PFNGLVERTEXATTRIB2SVPROC                             gl3wVertexAttrib2sv;
extern PFNGLVERTEXATTRIB3DPROC                              gl3wVertexAttrib3d;
extern PFNGLVERTEXATTRIB3DVPROC                             gl3wVertexAttrib3dv;
extern PFNGLVERTEXATTRIB3FPROC                              gl3wVertexAttrib3f;
extern PFNGLVERTEXATTRIB3FVPROC                             gl3wVertexAttrib3fv;
extern PFNGLVERTEXATTRIB3SPROC                              gl3wVertexAttrib3s;
extern PFNGLVERTEXATTRIB3SVPROC                             gl3wVertexAttrib3sv;
extern PFNGLVERTEXATTRIB4NBVPROC                            gl3wVertexAttrib4Nbv;
extern PFNGLVERTEXATTRIB4NIVPROC                            gl3wVertexAttrib4Niv;
extern PFNGLVERTEXATTRIB4NSVPROC                            gl3wVertexAttrib4Nsv;
extern PFNGLVERTEXATTRIB4NUBPROC                            gl3wVertexAttrib4Nub;
extern PFNGLVERTEXATTRIB4NUBVPROC                           gl3wVertexAttrib4Nubv;
extern PFNGLVERTEXATTRIB4NUIVPROC                           gl3wVertexAttrib4Nuiv;
extern PFNGLVERTEXATTRIB4NUSVPROC                           gl3wVertexAttrib4Nusv;
extern PFNGLVERTEXATTRIB4BVPROC                             gl3wVertexAttrib4bv;
extern PFNGLVERTEXATTRIB4DPROC                              gl3wVertexAttrib4d;
extern PFNGLVERTEXATTRIB4DVPROC                             gl3wVertexAttrib4dv;
extern PFNGLVERTEXATTRIB4FPROC                              gl3wVertexAttrib4f;
extern PFNGLVERTEXATTRIB4FVPROC                             gl3wVertexAttrib4fv;
extern PFNGLVERTEXATTRIB4IVPROC                             gl3wVertexAttrib4iv;
extern PFNGLVERTEXATTRIB4SPROC                              gl3wVertexAttrib4s;
extern PFNGLVERTEXATTRIB4SVPROC                             gl3wVertexAttrib4sv;
extern PFNGLVERTEXATTRIB4UBVPROC                            gl3wVertexAttrib4ubv;
extern PFNGLVERTEXATTRIB4UIVPROC                            gl3wVertexAttrib4uiv;
extern PFNGLVERTEXATTRIB4USVPROC                            gl3wVertexAttrib4usv;
extern PFNGLVERTEXATTRIBBINDINGPROC                         gl3wVertexAttribBinding;
extern PFNGLVERTEXATTRIBDIVISORPROC                         gl3wVertexAttribDivisor;
extern PFNGLVERTEXATTRIBFORMATPROC                          gl3wVertexAttribFormat;
extern PFNGLVERTEXATTRIBI1IPROC                             gl3wVertexAttribI1i;
extern PFNGLVERTEXATTRIBI1IVPROC                            gl3wVertexAttribI1iv;
extern PFNGLVERTEXATTRIBI1UIPROC                            gl3wVertexAttribI1ui;
extern PFNGLVERTEXATTRIBI1UIVPROC                           gl3wVertexAttribI1uiv;
extern PFNGLVERTEXATTRIBI2IPROC                             gl3wVertexAttribI2i;
extern PFNGLVERTEXATTRIBI2IVPROC                            gl3wVertexAttribI2iv;
extern PFNGLVERTEXATTRIBI2UIPROC                            gl3wVertexAttribI2ui;
extern PFNGLVERTEXATTRIBI2UIVPROC                           gl3wVertexAttribI2uiv;
extern PFNGLVERTEXATTRIBI3IPROC                             gl3wVertexAttribI3i;
extern PFNGLVERTEXATTRIBI3IVPROC                            gl3wVertexAttribI3iv;
extern PFNGLVERTEXATTRIBI3UIPROC                            gl3wVertexAttribI3ui;
extern PFNGLVERTEXATTRIBI3UIVPROC                           gl3wVertexAttribI3uiv;
extern PFNGLVERTEXATTRIBI4BVPROC                            gl3wVertexAttribI4bv;
extern PFNGLVERTEXATTRIBI4IPROC                             gl3wVertexAttribI4i;
extern PFNGLVERTEXATTRIBI4IVPROC                            gl3wVertexAttribI4iv;
extern PFNGLVERTEXATTRIBI4SVPROC                            gl3wVertexAttribI4sv;
extern PFNGLVERTEXATTRIBI4UBVPROC                           gl3wVertexAttribI4ubv;
extern PFNGLVERTEXATTRIBI4UIPROC                            gl3wVertexAttribI4ui;
extern PFNGLVERTEXATTRIBI4UIVPROC                           gl3wVertexAttribI4uiv;
extern PFNGLVERTEXATTRIBI4USVPROC                           gl3wVertexAttribI4usv;
extern PFNGLVERTEXATTRIBIFORMATPROC                         gl3wVertexAttribIFormat;
extern PFNGLVERTEXATTRIBIPOINTERPROC                        gl3wVertexAttribIPointer;
extern PFNGLVERTEXATTRIBL1DPROC                             gl3wVertexAttribL1d;
extern PFNGLVERTEXATTRIBL1DVPROC                            gl3wVertexAttribL1dv;
extern PFNGLVERTEXATTRIBL1UI64ARBPROC                       gl3wVertexAttribL1ui64ARB;
extern PFNGLVERTEXATTRIBL1UI64VARBPROC                      gl3wVertexAttribL1ui64vARB;
extern PFNGLVERTEXATTRIBL2DPROC                             gl3wVertexAttribL2d;
extern PFNGLVERTEXATTRIBL2DVPROC                            gl3wVertexAttribL2dv;
extern PFNGLVERTEXATTRIBL3DPROC                             gl3wVertexAttribL3d;
extern PFNGLVERTEXATTRIBL3DVPROC                            gl3wVertexAttribL3dv;
extern PFNGLVERTEXATTRIBL4DPROC                             gl3wVertexAttribL4d;
extern PFNGLVERTEXATTRIBL4DVPROC                            gl3wVertexAttribL4dv;
extern PFNGLVERTEXATTRIBLFORMATPROC                         gl3wVertexAttribLFormat;
extern PFNGLVERTEXATTRIBLPOINTERPROC                        gl3wVertexAttribLPointer;
extern PFNGLVERTEXATTRIBP1UIPROC                            gl3wVertexAttribP1ui;
extern PFNGLVERTEXATTRIBP1UIVPROC                           gl3wVertexAttribP1uiv;
extern PFNGLVERTEXATTRIBP2UIPROC                            gl3wVertexAttribP2ui;
extern PFNGLVERTEXATTRIBP2UIVPROC                           gl3wVertexAttribP2uiv;
extern PFNGLVERTEXATTRIBP3UIPROC                            gl3wVertexAttribP3ui;
extern PFNGLVERTEXATTRIBP3UIVPROC                           gl3wVertexAttribP3uiv;
extern PFNGLVERTEXATTRIBP4UIPROC                            gl3wVertexAttribP4ui;
extern PFNGLVERTEXATTRIBP4UIVPROC                           gl3wVertexAttribP4uiv;
extern PFNGLVERTEXATTRIBPOINTERPROC                         gl3wVertexAttribPointer;
extern PFNGLVERTEXBINDINGDIVISORPROC                        gl3wVertexBindingDivisor;
extern PFNGLVIEWPORTPROC                                    gl3wViewport;
extern PFNGLVIEWPORTARRAYVPROC                              gl3wViewportArrayv;
extern PFNGLVIEWPORTINDEXEDFPROC                            gl3wViewportIndexedf;
extern PFNGLVIEWPORTINDEXEDFVPROC                           gl3wViewportIndexedfv;
extern PFNGLWAITSYNCPROC                                    gl3wWaitSync;

#define glActiveShaderProgram                         gl3wActiveShaderProgram
#define glActiveTexture                               gl3wActiveTexture
#define glAttachShader                                gl3wAttachShader
#define glBeginConditionalRender                      gl3wBeginConditionalRender
#define glBeginQuery                                  gl3wBeginQuery
#define glBeginQueryIndexed                           gl3wBeginQueryIndexed
#define glBeginTransformFeedback                      gl3wBeginTransformFeedback
#define glBindAttribLocation                          gl3wBindAttribLocation
#define glBindBuffer                                  gl3wBindBuffer
#define glBindBufferBase                              gl3wBindBufferBase
#define glBindBufferRange                             gl3wBindBufferRange
#define glBindBuffersBase                             gl3wBindBuffersBase
#define glBindBuffersRange                            gl3wBindBuffersRange
#define glBindFragDataLocation                        gl3wBindFragDataLocation
#define glBindFragDataLocationIndexed                 gl3wBindFragDataLocationIndexed
#define glBindFramebuffer                             gl3wBindFramebuffer
#define glBindImageTexture                            gl3wBindImageTexture
#define glBindImageTextures                           gl3wBindImageTextures
#define glBindProgramPipeline                         gl3wBindProgramPipeline
#define glBindRenderbuffer                            gl3wBindRenderbuffer
#define glBindSampler                                 gl3wBindSampler
#define glBindSamplers                                gl3wBindSamplers
#define glBindTexture                                 gl3wBindTexture
#define glBindTextures                                gl3wBindTextures
#define glBindTransformFeedback                       gl3wBindTransformFeedback
#define glBindVertexArray                             gl3wBindVertexArray
#define glBindVertexBuffer                            gl3wBindVertexBuffer
#define glBindVertexBuffers                           gl3wBindVertexBuffers
#define glBlendColor                                  gl3wBlendColor
#define glBlendEquation                               gl3wBlendEquation
#define glBlendEquationSeparate                       gl3wBlendEquationSeparate
#define glBlendEquationSeparatei                      gl3wBlendEquationSeparatei
#define glBlendEquationSeparateiARB                   gl3wBlendEquationSeparateiARB
#define glBlendEquationi                              gl3wBlendEquationi
#define glBlendEquationiARB                           gl3wBlendEquationiARB
#define glBlendFunc                                   gl3wBlendFunc
#define glBlendFuncSeparate                           gl3wBlendFuncSeparate
#define glBlendFuncSeparatei                          gl3wBlendFuncSeparatei
#define glBlendFuncSeparateiARB                       gl3wBlendFuncSeparateiARB
#define glBlendFunci                                  gl3wBlendFunci
#define glBlendFunciARB                               gl3wBlendFunciARB
#define glBlitFramebuffer                             gl3wBlitFramebuffer
#define glBufferData                                  gl3wBufferData
#define glBufferStorage                               gl3wBufferStorage
#define glBufferSubData                               gl3wBufferSubData
#define glCheckFramebufferStatus                      gl3wCheckFramebufferStatus
#define glClampColor                                  gl3wClampColor
#define glClear                                       gl3wClear
#define glClearBufferData                             gl3wClearBufferData
#define glClearBufferSubData                          gl3wClearBufferSubData
#define glClearBufferfi                               gl3wClearBufferfi
#define glClearBufferfv                               gl3wClearBufferfv
#define glClearBufferiv                               gl3wClearBufferiv
#define glClearBufferuiv                              gl3wClearBufferuiv
#define glClearColor                                  gl3wClearColor
#define glClearDepth                                  gl3wClearDepth
#define glClearDepthf                                 gl3wClearDepthf
#define glClearStencil                                gl3wClearStencil
#define glClearTexImage                               gl3wClearTexImage
#define glClearTexSubImage                            gl3wClearTexSubImage
#define glClientWaitSync                              gl3wClientWaitSync
#define glColorMask                                   gl3wColorMask
#define glColorMaski                                  gl3wColorMaski
#define glCompileShader                               gl3wCompileShader
#define glCompileShaderIncludeARB                     gl3wCompileShaderIncludeARB
#define glCompressedTexImage1D                        gl3wCompressedTexImage1D
#define glCompressedTexImage2D                        gl3wCompressedTexImage2D
#define glCompressedTexImage3D                        gl3wCompressedTexImage3D
#define glCompressedTexSubImage1D                     gl3wCompressedTexSubImage1D
#define glCompressedTexSubImage2D                     gl3wCompressedTexSubImage2D
#define glCompressedTexSubImage3D                     gl3wCompressedTexSubImage3D
#define glCopyBufferSubData                           gl3wCopyBufferSubData
#define glCopyImageSubData                            gl3wCopyImageSubData
#define glCopyTexImage1D                              gl3wCopyTexImage1D
#define glCopyTexImage2D                              gl3wCopyTexImage2D
#define glCopyTexSubImage1D                           gl3wCopyTexSubImage1D
#define glCopyTexSubImage2D                           gl3wCopyTexSubImage2D
#define glCopyTexSubImage3D                           gl3wCopyTexSubImage3D
#define glCreateProgram                               gl3wCreateProgram
#define glCreateShader                                gl3wCreateShader
#define glCreateShaderProgramv                        gl3wCreateShaderProgramv
#define glCreateSyncFromCLeventARB                    gl3wCreateSyncFromCLeventARB
#define glCullFace                                    gl3wCullFace
#define glDebugMessageCallback                        gl3wDebugMessageCallback
#define glDebugMessageCallbackARB                     gl3wDebugMessageCallbackARB
#define glDebugMessageControl                         gl3wDebugMessageControl
#define glDebugMessageControlARB                      gl3wDebugMessageControlARB
#define glDebugMessageInsert                          gl3wDebugMessageInsert
#define glDebugMessageInsertARB                       gl3wDebugMessageInsertARB
#define glDeleteBuffers                               gl3wDeleteBuffers
#define glDeleteFramebuffers                          gl3wDeleteFramebuffers
#define glDeleteNamedStringARB                        gl3wDeleteNamedStringARB
#define glDeleteProgram                               gl3wDeleteProgram
#define glDeleteProgramPipelines                      gl3wDeleteProgramPipelines
#define glDeleteQueries                               gl3wDeleteQueries
#define glDeleteRenderbuffers                         gl3wDeleteRenderbuffers
#define glDeleteSamplers                              gl3wDeleteSamplers
#define glDeleteShader                                gl3wDeleteShader
#define glDeleteSync                                  gl3wDeleteSync
#define glDeleteTextures                              gl3wDeleteTextures
#define glDeleteTransformFeedbacks                    gl3wDeleteTransformFeedbacks
#define glDeleteVertexArrays                          gl3wDeleteVertexArrays
#define glDepthFunc                                   gl3wDepthFunc
#define glDepthMask                                   gl3wDepthMask
#define glDepthRange                                  gl3wDepthRange
#define glDepthRangeArrayv                            gl3wDepthRangeArrayv
#define glDepthRangeIndexed                           gl3wDepthRangeIndexed
#define glDepthRangef                                 gl3wDepthRangef
#define glDetachShader                                gl3wDetachShader
#define glDisable                                     gl3wDisable
#define glDisableVertexAttribArray                    gl3wDisableVertexAttribArray
#define glDisablei                                    gl3wDisablei
#define glDispatchCompute                             gl3wDispatchCompute
#define glDispatchComputeGroupSizeARB                 gl3wDispatchComputeGroupSizeARB
#define glDispatchComputeIndirect                     gl3wDispatchComputeIndirect
#define glDrawArrays                                  gl3wDrawArrays
#define glDrawArraysIndirect                          gl3wDrawArraysIndirect
#define glDrawArraysInstanced                         gl3wDrawArraysInstanced
#define glDrawArraysInstancedBaseInstance             gl3wDrawArraysInstancedBaseInstance
#define glDrawBuffer                                  gl3wDrawBuffer
#define glDrawBuffers                                 gl3wDrawBuffers
#define glDrawElements                                gl3wDrawElements
#define glDrawElementsBaseVertex                      gl3wDrawElementsBaseVertex
#define glDrawElementsIndirect                        gl3wDrawElementsIndirect
#define glDrawElementsInstanced                       gl3wDrawElementsInstanced
#define glDrawElementsInstancedBaseInstance           gl3wDrawElementsInstancedBaseInstance
#define glDrawElementsInstancedBaseVertex             gl3wDrawElementsInstancedBaseVertex
#define glDrawElementsInstancedBaseVertexBaseInstance gl3wDrawElementsInstancedBaseVertexBaseInstance
#define glDrawRangeElements                           gl3wDrawRangeElements
#define glDrawRangeElementsBaseVertex                 gl3wDrawRangeElementsBaseVertex
#define glDrawTransformFeedback                       gl3wDrawTransformFeedback
#define glDrawTransformFeedbackInstanced              gl3wDrawTransformFeedbackInstanced
#define glDrawTransformFeedbackStream                 gl3wDrawTransformFeedbackStream
#define glDrawTransformFeedbackStreamInstanced        gl3wDrawTransformFeedbackStreamInstanced
#define glEnable                                      gl3wEnable
#define glEnableVertexAttribArray                     gl3wEnableVertexAttribArray
#define glEnablei                                     gl3wEnablei
#define glEndConditionalRender                        gl3wEndConditionalRender
#define glEndQuery                                    gl3wEndQuery
#define glEndQueryIndexed                             gl3wEndQueryIndexed
#define glEndTransformFeedback                        gl3wEndTransformFeedback
#define glFenceSync                                   gl3wFenceSync
#define glFinish                                      gl3wFinish
#define glFlush                                       gl3wFlush
#define glFlushMappedBufferRange                      gl3wFlushMappedBufferRange
#define glFramebufferParameteri                       gl3wFramebufferParameteri
#define glFramebufferRenderbuffer                     gl3wFramebufferRenderbuffer
#define glFramebufferTexture                          gl3wFramebufferTexture
#define glFramebufferTexture1D                        gl3wFramebufferTexture1D
#define glFramebufferTexture2D                        gl3wFramebufferTexture2D
#define glFramebufferTexture3D                        gl3wFramebufferTexture3D
#define glFramebufferTextureLayer                     gl3wFramebufferTextureLayer
#define glFrontFace                                   gl3wFrontFace
#define glGenBuffers                                  gl3wGenBuffers
#define glGenFramebuffers                             gl3wGenFramebuffers
#define glGenProgramPipelines                         gl3wGenProgramPipelines
#define glGenQueries                                  gl3wGenQueries
#define glGenRenderbuffers                            gl3wGenRenderbuffers
#define glGenSamplers                                 gl3wGenSamplers
#define glGenTextures                                 gl3wGenTextures
#define glGenTransformFeedbacks                       gl3wGenTransformFeedbacks
#define glGenVertexArrays                             gl3wGenVertexArrays
#define glGenerateMipmap                              gl3wGenerateMipmap
#define glGetActiveAtomicCounterBufferiv              gl3wGetActiveAtomicCounterBufferiv
#define glGetActiveAttrib                             gl3wGetActiveAttrib
#define glGetActiveSubroutineName                     gl3wGetActiveSubroutineName
#define glGetActiveSubroutineUniformName              gl3wGetActiveSubroutineUniformName
#define glGetActiveSubroutineUniformiv                gl3wGetActiveSubroutineUniformiv
#define glGetActiveUniform                            gl3wGetActiveUniform
#define glGetActiveUniformBlockName                   gl3wGetActiveUniformBlockName
#define glGetActiveUniformBlockiv                     gl3wGetActiveUniformBlockiv
#define glGetActiveUniformName                        gl3wGetActiveUniformName
#define glGetActiveUniformsiv                         gl3wGetActiveUniformsiv
#define glGetAttachedShaders                          gl3wGetAttachedShaders
#define glGetAttribLocation                           gl3wGetAttribLocation
#define glGetBooleani_v                               gl3wGetBooleani_v
#define glGetBooleanv                                 gl3wGetBooleanv
#define glGetBufferParameteri64v                      gl3wGetBufferParameteri64v
#define glGetBufferParameteriv                        gl3wGetBufferParameteriv
#define glGetBufferPointerv                           gl3wGetBufferPointerv
#define glGetBufferSubData                            gl3wGetBufferSubData
#define glGetCompressedTexImage                       gl3wGetCompressedTexImage
#define glGetDebugMessageLog                          gl3wGetDebugMessageLog
#define glGetDebugMessageLogARB                       gl3wGetDebugMessageLogARB
#define glGetDoublei_v                                gl3wGetDoublei_v
#define glGetDoublev                                  gl3wGetDoublev
#define glGetError                                    gl3wGetError
#define glGetFloati_v                                 gl3wGetFloati_v
#define glGetFloatv                                   gl3wGetFloatv
#define glGetFragDataIndex                            gl3wGetFragDataIndex
#define glGetFragDataLocation                         gl3wGetFragDataLocation
#define glGetFramebufferAttachmentParameteriv         gl3wGetFramebufferAttachmentParameteriv
#define glGetFramebufferParameteriv                   gl3wGetFramebufferParameteriv
#define glGetGraphicsResetStatusARB                   gl3wGetGraphicsResetStatusARB
#define glGetImageHandleARB                           gl3wGetImageHandleARB
#define glGetInteger64i_v                             gl3wGetInteger64i_v
#define glGetInteger64v                               gl3wGetInteger64v
#define glGetIntegeri_v                               gl3wGetIntegeri_v
#define glGetIntegerv                                 gl3wGetIntegerv
#define glGetInternalformati64v                       gl3wGetInternalformati64v
#define glGetInternalformativ                         gl3wGetInternalformativ
#define glGetMultisamplefv                            gl3wGetMultisamplefv
#define glGetNamedStringARB                           gl3wGetNamedStringARB
#define glGetNamedStringivARB                         gl3wGetNamedStringivARB
#define glGetObjectLabel                              gl3wGetObjectLabel
#define glGetObjectPtrLabel                           gl3wGetObjectPtrLabel
#define glGetPointerv                                 gl3wGetPointerv
#define glGetProgramBinary                            gl3wGetProgramBinary
#define glGetProgramInfoLog                           gl3wGetProgramInfoLog
#define glGetProgramInterfaceiv                       gl3wGetProgramInterfaceiv
#define glGetProgramPipelineInfoLog                   gl3wGetProgramPipelineInfoLog
#define glGetProgramPipelineiv                        gl3wGetProgramPipelineiv
#define glGetProgramResourceIndex                     gl3wGetProgramResourceIndex
#define glGetProgramResourceLocation                  gl3wGetProgramResourceLocation
#define glGetProgramResourceLocationIndex             gl3wGetProgramResourceLocationIndex
#define glGetProgramResourceName                      gl3wGetProgramResourceName
#define glGetProgramResourceiv                        gl3wGetProgramResourceiv
#define glGetProgramStageiv                           gl3wGetProgramStageiv
#define glGetProgramiv                                gl3wGetProgramiv
#define glGetQueryIndexediv                           gl3wGetQueryIndexediv
#define glGetQueryObjecti64v                          gl3wGetQueryObjecti64v
#define glGetQueryObjectiv                            gl3wGetQueryObjectiv
#define glGetQueryObjectui64v                         gl3wGetQueryObjectui64v
#define glGetQueryObjectuiv                           gl3wGetQueryObjectuiv
#define glGetQueryiv                                  gl3wGetQueryiv
#define glGetRenderbufferParameteriv                  gl3wGetRenderbufferParameteriv
#define glGetSamplerParameterIiv                      gl3wGetSamplerParameterIiv
#define glGetSamplerParameterIuiv                     gl3wGetSamplerParameterIuiv
#define glGetSamplerParameterfv                       gl3wGetSamplerParameterfv
#define glGetSamplerParameteriv                       gl3wGetSamplerParameteriv
#define glGetShaderInfoLog                            gl3wGetShaderInfoLog
#define glGetShaderPrecisionFormat                    gl3wGetShaderPrecisionFormat
#define glGetShaderSource                             gl3wGetShaderSource
#define glGetShaderiv                                 gl3wGetShaderiv
#define glGetString                                   gl3wGetString
#define glGetStringi                                  gl3wGetStringi
#define glGetSubroutineIndex                          gl3wGetSubroutineIndex
#define glGetSubroutineUniformLocation                gl3wGetSubroutineUniformLocation
#define glGetSynciv                                   gl3wGetSynciv
#define glGetTexImage                                 gl3wGetTexImage
#define glGetTexLevelParameterfv                      gl3wGetTexLevelParameterfv
#define glGetTexLevelParameteriv                      gl3wGetTexLevelParameteriv
#define glGetTexParameterIiv                          gl3wGetTexParameterIiv
#define glGetTexParameterIuiv                         gl3wGetTexParameterIuiv
#define glGetTexParameterfv                           gl3wGetTexParameterfv
#define glGetTexParameteriv                           gl3wGetTexParameteriv
#define glGetTextureHandleARB                         gl3wGetTextureHandleARB
#define glGetTextureSamplerHandleARB                  gl3wGetTextureSamplerHandleARB
#define glGetTransformFeedbackVarying                 gl3wGetTransformFeedbackVarying
#define glGetUniformBlockIndex                        gl3wGetUniformBlockIndex
#define glGetUniformIndices                           gl3wGetUniformIndices
#define glGetUniformLocation                          gl3wGetUniformLocation
#define glGetUniformSubroutineuiv                     gl3wGetUniformSubroutineuiv
#define glGetUniformdv                                gl3wGetUniformdv
#define glGetUniformfv                                gl3wGetUniformfv
#define glGetUniformiv                                gl3wGetUniformiv
#define glGetUniformuiv                               gl3wGetUniformuiv
#define glGetVertexAttribIiv                          gl3wGetVertexAttribIiv
#define glGetVertexAttribIuiv                         gl3wGetVertexAttribIuiv
#define glGetVertexAttribLdv                          gl3wGetVertexAttribLdv
#define glGetVertexAttribLui64vARB                    gl3wGetVertexAttribLui64vARB
#define glGetVertexAttribPointerv                     gl3wGetVertexAttribPointerv
#define glGetVertexAttribdv                           gl3wGetVertexAttribdv
#define glGetVertexAttribfv                           gl3wGetVertexAttribfv
#define glGetVertexAttribiv                           gl3wGetVertexAttribiv
#define glGetnCompressedTexImageARB                   gl3wGetnCompressedTexImageARB
#define glGetnTexImageARB                             gl3wGetnTexImageARB
#define glGetnUniformdvARB                            gl3wGetnUniformdvARB
#define glGetnUniformfvARB                            gl3wGetnUniformfvARB
#define glGetnUniformivARB                            gl3wGetnUniformivARB
#define glGetnUniformuivARB                           gl3wGetnUniformuivARB
#define glHint                                        gl3wHint
#define glInvalidateBufferData                        gl3wInvalidateBufferData
#define glInvalidateBufferSubData                     gl3wInvalidateBufferSubData
#define glInvalidateFramebuffer                       gl3wInvalidateFramebuffer
#define glInvalidateSubFramebuffer                    gl3wInvalidateSubFramebuffer
#define glInvalidateTexImage                          gl3wInvalidateTexImage
#define glInvalidateTexSubImage                       gl3wInvalidateTexSubImage
#define glIsBuffer                                    gl3wIsBuffer
#define glIsEnabled                                   gl3wIsEnabled
#define glIsEnabledi                                  gl3wIsEnabledi
#define glIsFramebuffer                               gl3wIsFramebuffer
#define glIsImageHandleResidentARB                    gl3wIsImageHandleResidentARB
#define glIsNamedStringARB                            gl3wIsNamedStringARB
#define glIsProgram                                   gl3wIsProgram
#define glIsProgramPipeline                           gl3wIsProgramPipeline
#define glIsQuery                                     gl3wIsQuery
#define glIsRenderbuffer                              gl3wIsRenderbuffer
#define glIsSampler                                   gl3wIsSampler
#define glIsShader                                    gl3wIsShader
#define glIsSync                                      gl3wIsSync
#define glIsTexture                                   gl3wIsTexture
#define glIsTextureHandleResidentARB                  gl3wIsTextureHandleResidentARB
#define glIsTransformFeedback                         gl3wIsTransformFeedback
#define glIsVertexArray                               gl3wIsVertexArray
#define glLineWidth                                   gl3wLineWidth
#define glLinkProgram                                 gl3wLinkProgram
#define glLogicOp                                     gl3wLogicOp
#define glMakeImageHandleNonResidentARB               gl3wMakeImageHandleNonResidentARB
#define glMakeImageHandleResidentARB                  gl3wMakeImageHandleResidentARB
#define glMakeTextureHandleNonResidentARB             gl3wMakeTextureHandleNonResidentARB
#define glMakeTextureHandleResidentARB                gl3wMakeTextureHandleResidentARB
#define glMapBuffer                                   gl3wMapBuffer
#define glMapBufferRange                              gl3wMapBufferRange
#define glMemoryBarrier                               gl3wMemoryBarrier
#define glMinSampleShading                            gl3wMinSampleShading
#define glMinSampleShadingARB                         gl3wMinSampleShadingARB
#define glMultiDrawArrays                             gl3wMultiDrawArrays
#define glMultiDrawArraysIndirect                     gl3wMultiDrawArraysIndirect
#define glMultiDrawArraysIndirectCountARB             gl3wMultiDrawArraysIndirectCountARB
#define glMultiDrawElements                           gl3wMultiDrawElements
#define glMultiDrawElementsBaseVertex                 gl3wMultiDrawElementsBaseVertex
#define glMultiDrawElementsIndirect                   gl3wMultiDrawElementsIndirect
#define glMultiDrawElementsIndirectCountARB           gl3wMultiDrawElementsIndirectCountARB
#define glNamedStringARB                              gl3wNamedStringARB
#define glObjectLabel                                 gl3wObjectLabel
#define glObjectPtrLabel                              gl3wObjectPtrLabel
#define glPatchParameterfv                            gl3wPatchParameterfv
#define glPatchParameteri                             gl3wPatchParameteri
#define glPauseTransformFeedback                      gl3wPauseTransformFeedback
#define glPixelStoref                                 gl3wPixelStoref
#define glPixelStorei                                 gl3wPixelStorei
#define glPointParameterf                             gl3wPointParameterf
#define glPointParameterfv                            gl3wPointParameterfv
#define glPointParameteri                             gl3wPointParameteri
#define glPointParameteriv                            gl3wPointParameteriv
#define glPointSize                                   gl3wPointSize
#define glPolygonMode                                 gl3wPolygonMode
#define glPolygonOffset                               gl3wPolygonOffset
#define glPopDebugGroup                               gl3wPopDebugGroup
#define glPrimitiveRestartIndex                       gl3wPrimitiveRestartIndex
#define glProgramBinary                               gl3wProgramBinary
#define glProgramParameteri                           gl3wProgramParameteri
#define glProgramUniform1d                            gl3wProgramUniform1d
#define glProgramUniform1dv                           gl3wProgramUniform1dv
#define glProgramUniform1f                            gl3wProgramUniform1f
#define glProgramUniform1fv                           gl3wProgramUniform1fv
#define glProgramUniform1i                            gl3wProgramUniform1i
#define glProgramUniform1iv                           gl3wProgramUniform1iv
#define glProgramUniform1ui                           gl3wProgramUniform1ui
#define glProgramUniform1uiv                          gl3wProgramUniform1uiv
#define glProgramUniform2d                            gl3wProgramUniform2d
#define glProgramUniform2dv                           gl3wProgramUniform2dv
#define glProgramUniform2f                            gl3wProgramUniform2f
#define glProgramUniform2fv                           gl3wProgramUniform2fv
#define glProgramUniform2i                            gl3wProgramUniform2i
#define glProgramUniform2iv                           gl3wProgramUniform2iv
#define glProgramUniform2ui                           gl3wProgramUniform2ui
#define glProgramUniform2uiv                          gl3wProgramUniform2uiv
#define glProgramUniform3d                            gl3wProgramUniform3d
#define glProgramUniform3dv                           gl3wProgramUniform3dv
#define glProgramUniform3f                            gl3wProgramUniform3f
#define glProgramUniform3fv                           gl3wProgramUniform3fv
#define glProgramUniform3i                            gl3wProgramUniform3i
#define glProgramUniform3iv                           gl3wProgramUniform3iv
#define glProgramUniform3ui                           gl3wProgramUniform3ui
#define glProgramUniform3uiv                          gl3wProgramUniform3uiv
#define glProgramUniform4d                            gl3wProgramUniform4d
#define glProgramUniform4dv                           gl3wProgramUniform4dv
#define glProgramUniform4f                            gl3wProgramUniform4f
#define glProgramUniform4fv                           gl3wProgramUniform4fv
#define glProgramUniform4i                            gl3wProgramUniform4i
#define glProgramUniform4iv                           gl3wProgramUniform4iv
#define glProgramUniform4ui                           gl3wProgramUniform4ui
#define glProgramUniform4uiv                          gl3wProgramUniform4uiv
#define glProgramUniformHandleui64ARB                 gl3wProgramUniformHandleui64ARB
#define glProgramUniformHandleui64vARB                gl3wProgramUniformHandleui64vARB
#define glProgramUniformMatrix2dv                     gl3wProgramUniformMatrix2dv
#define glProgramUniformMatrix2fv                     gl3wProgramUniformMatrix2fv
#define glProgramUniformMatrix2x3dv                   gl3wProgramUniformMatrix2x3dv
#define glProgramUniformMatrix2x3fv                   gl3wProgramUniformMatrix2x3fv
#define glProgramUniformMatrix2x4dv                   gl3wProgramUniformMatrix2x4dv
#define glProgramUniformMatrix2x4fv                   gl3wProgramUniformMatrix2x4fv
#define glProgramUniformMatrix3dv                     gl3wProgramUniformMatrix3dv
#define glProgramUniformMatrix3fv                     gl3wProgramUniformMatrix3fv
#define glProgramUniformMatrix3x2dv                   gl3wProgramUniformMatrix3x2dv
#define glProgramUniformMatrix3x2fv                   gl3wProgramUniformMatrix3x2fv
#define glProgramUniformMatrix3x4dv                   gl3wProgramUniformMatrix3x4dv
#define glProgramUniformMatrix3x4fv                   gl3wProgramUniformMatrix3x4fv
#define glProgramUniformMatrix4dv                     gl3wProgramUniformMatrix4dv
#define glProgramUniformMatrix4fv                     gl3wProgramUniformMatrix4fv
#define glProgramUniformMatrix4x2dv                   gl3wProgramUniformMatrix4x2dv
#define glProgramUniformMatrix4x2fv                   gl3wProgramUniformMatrix4x2fv
#define glProgramUniformMatrix4x3dv                   gl3wProgramUniformMatrix4x3dv
#define glProgramUniformMatrix4x3fv                   gl3wProgramUniformMatrix4x3fv
#define glProvokingVertex                             gl3wProvokingVertex
#define glPushDebugGroup                              gl3wPushDebugGroup
#define glQueryCounter                                gl3wQueryCounter
#define glReadBuffer                                  gl3wReadBuffer
#define glReadPixels                                  gl3wReadPixels
#define glReadnPixelsARB                              gl3wReadnPixelsARB
#define glReleaseShaderCompiler                       gl3wReleaseShaderCompiler
#define glRenderbufferStorage                         gl3wRenderbufferStorage
#define glRenderbufferStorageMultisample              gl3wRenderbufferStorageMultisample
#define glResumeTransformFeedback                     gl3wResumeTransformFeedback
#define glSampleCoverage                              gl3wSampleCoverage
#define glSampleMaski                                 gl3wSampleMaski
#define glSamplerParameterIiv                         gl3wSamplerParameterIiv
#define glSamplerParameterIuiv                        gl3wSamplerParameterIuiv
#define glSamplerParameterf                           gl3wSamplerParameterf
#define glSamplerParameterfv                          gl3wSamplerParameterfv
#define glSamplerParameteri                           gl3wSamplerParameteri
#define glSamplerParameteriv                          gl3wSamplerParameteriv
#define glScissor                                     gl3wScissor
#define glScissorArrayv                               gl3wScissorArrayv
#define glScissorIndexed                              gl3wScissorIndexed
#define glScissorIndexedv                             gl3wScissorIndexedv
#define glShaderBinary                                gl3wShaderBinary
#define glShaderSource                                gl3wShaderSource
#define glShaderStorageBlockBinding                   gl3wShaderStorageBlockBinding
#define glStencilFunc                                 gl3wStencilFunc
#define glStencilFuncSeparate                         gl3wStencilFuncSeparate
#define glStencilMask                                 gl3wStencilMask
#define glStencilMaskSeparate                         gl3wStencilMaskSeparate
#define glStencilOp                                   gl3wStencilOp
#define glStencilOpSeparate                           gl3wStencilOpSeparate
#define glTexBuffer                                   gl3wTexBuffer
#define glTexBufferRange                              gl3wTexBufferRange
#define glTexImage1D                                  gl3wTexImage1D
#define glTexImage2D                                  gl3wTexImage2D
#define glTexImage2DMultisample                       gl3wTexImage2DMultisample
#define glTexImage3D                                  gl3wTexImage3D
#define glTexImage3DMultisample                       gl3wTexImage3DMultisample
#define glTexPageCommitmentARB                        gl3wTexPageCommitmentARB
#define glTexParameterIiv                             gl3wTexParameterIiv
#define glTexParameterIuiv                            gl3wTexParameterIuiv
#define glTexParameterf                               gl3wTexParameterf
#define glTexParameterfv                              gl3wTexParameterfv
#define glTexParameteri                               gl3wTexParameteri
#define glTexParameteriv                              gl3wTexParameteriv
#define glTexStorage1D                                gl3wTexStorage1D
#define glTexStorage2D                                gl3wTexStorage2D
#define glTexStorage2DMultisample                     gl3wTexStorage2DMultisample
#define glTexStorage3D                                gl3wTexStorage3D
#define glTexStorage3DMultisample                     gl3wTexStorage3DMultisample
#define glTexSubImage1D                               gl3wTexSubImage1D
#define glTexSubImage2D                               gl3wTexSubImage2D
#define glTexSubImage3D                               gl3wTexSubImage3D
#define glTextureView                                 gl3wTextureView
#define glTransformFeedbackVaryings                   gl3wTransformFeedbackVaryings
#define glUniform1d                                   gl3wUniform1d
#define glUniform1dv                                  gl3wUniform1dv
#define glUniform1f                                   gl3wUniform1f
#define glUniform1fv                                  gl3wUniform1fv
#define glUniform1i                                   gl3wUniform1i
#define glUniform1iv                                  gl3wUniform1iv
#define glUniform1ui                                  gl3wUniform1ui
#define glUniform1uiv                                 gl3wUniform1uiv
#define glUniform2d                                   gl3wUniform2d
#define glUniform2dv                                  gl3wUniform2dv
#define glUniform2f                                   gl3wUniform2f
#define glUniform2fv                                  gl3wUniform2fv
#define glUniform2i                                   gl3wUniform2i
#define glUniform2iv                                  gl3wUniform2iv
#define glUniform2ui                                  gl3wUniform2ui
#define glUniform2uiv                                 gl3wUniform2uiv
#define glUniform3d                                   gl3wUniform3d
#define glUniform3dv                                  gl3wUniform3dv
#define glUniform3f                                   gl3wUniform3f
#define glUniform3fv                                  gl3wUniform3fv
#define glUniform3i                                   gl3wUniform3i
#define glUniform3iv                                  gl3wUniform3iv
#define glUniform3ui                                  gl3wUniform3ui
#define glUniform3uiv                                 gl3wUniform3uiv
#define glUniform4d                                   gl3wUniform4d
#define glUniform4dv                                  gl3wUniform4dv
#define glUniform4f                                   gl3wUniform4f
#define glUniform4fv                                  gl3wUniform4fv
#define glUniform4i                                   gl3wUniform4i
#define glUniform4iv                                  gl3wUniform4iv
#define glUniform4ui                                  gl3wUniform4ui
#define glUniform4uiv                                 gl3wUniform4uiv
#define glUniformBlockBinding                         gl3wUniformBlockBinding
#define glUniformHandleui64ARB                        gl3wUniformHandleui64ARB
#define glUniformHandleui64vARB                       gl3wUniformHandleui64vARB
#define glUniformMatrix2dv                            gl3wUniformMatrix2dv
#define glUniformMatrix2fv                            gl3wUniformMatrix2fv
#define glUniformMatrix2x3dv                          gl3wUniformMatrix2x3dv
#define glUniformMatrix2x3fv                          gl3wUniformMatrix2x3fv
#define glUniformMatrix2x4dv                          gl3wUniformMatrix2x4dv
#define glUniformMatrix2x4fv                          gl3wUniformMatrix2x4fv
#define glUniformMatrix3dv                            gl3wUniformMatrix3dv
#define glUniformMatrix3fv                            gl3wUniformMatrix3fv
#define glUniformMatrix3x2dv                          gl3wUniformMatrix3x2dv
#define glUniformMatrix3x2fv                          gl3wUniformMatrix3x2fv
#define glUniformMatrix3x4dv                          gl3wUniformMatrix3x4dv
#define glUniformMatrix3x4fv                          gl3wUniformMatrix3x4fv
#define glUniformMatrix4dv                            gl3wUniformMatrix4dv
#define glUniformMatrix4fv                            gl3wUniformMatrix4fv
#define glUniformMatrix4x2dv                          gl3wUniformMatrix4x2dv
#define glUniformMatrix4x2fv                          gl3wUniformMatrix4x2fv
#define glUniformMatrix4x3dv                          gl3wUniformMatrix4x3dv
#define glUniformMatrix4x3fv                          gl3wUniformMatrix4x3fv
#define glUniformSubroutinesuiv                       gl3wUniformSubroutinesuiv
#define glUnmapBuffer                                 gl3wUnmapBuffer
#define glUseProgram                                  gl3wUseProgram
#define glUseProgramStages                            gl3wUseProgramStages
#define glValidateProgram                             gl3wValidateProgram
#define glValidateProgramPipeline                     gl3wValidateProgramPipeline
#define glVertexAttrib1d                              gl3wVertexAttrib1d
#define glVertexAttrib1dv                             gl3wVertexAttrib1dv
#define glVertexAttrib1f                              gl3wVertexAttrib1f
#define glVertexAttrib1fv                             gl3wVertexAttrib1fv
#define glVertexAttrib1s                              gl3wVertexAttrib1s
#define glVertexAttrib1sv                             gl3wVertexAttrib1sv
#define glVertexAttrib2d                              gl3wVertexAttrib2d
#define glVertexAttrib2dv                             gl3wVertexAttrib2dv
#define glVertexAttrib2f                              gl3wVertexAttrib2f
#define glVertexAttrib2fv                             gl3wVertexAttrib2fv
#define glVertexAttrib2s                              gl3wVertexAttrib2s
#define glVertexAttrib2sv                             gl3wVertexAttrib2sv
#define glVertexAttrib3d                              gl3wVertexAttrib3d
#define glVertexAttrib3dv                             gl3wVertexAttrib3dv
#define glVertexAttrib3f                              gl3wVertexAttrib3f
#define glVertexAttrib3fv                             gl3wVertexAttrib3fv
#define glVertexAttrib3s                              gl3wVertexAttrib3s
#define glVertexAttrib3sv                             gl3wVertexAttrib3sv
#define glVertexAttrib4Nbv                            gl3wVertexAttrib4Nbv
#define glVertexAttrib4Niv                            gl3wVertexAttrib4Niv
#define glVertexAttrib4Nsv                            gl3wVertexAttrib4Nsv
#define glVertexAttrib4Nub                            gl3wVertexAttrib4Nub
#define glVertexAttrib4Nubv                           gl3wVertexAttrib4Nubv
#define glVertexAttrib4Nuiv                           gl3wVertexAttrib4Nuiv
#define glVertexAttrib4Nusv                           gl3wVertexAttrib4Nusv
#define glVertexAttrib4bv                             gl3wVertexAttrib4bv
#define glVertexAttrib4d                              gl3wVertexAttrib4d
#define glVertexAttrib4dv                             gl3wVertexAttrib4dv
#define glVertexAttrib4f                              gl3wVertexAttrib4f
#define glVertexAttrib4fv                             gl3wVertexAttrib4fv
#define glVertexAttrib4iv                             gl3wVertexAttrib4iv
#define glVertexAttrib4s                              gl3wVertexAttrib4s
#define glVertexAttrib4sv                             gl3wVertexAttrib4sv
#define glVertexAttrib4ubv                            gl3wVertexAttrib4ubv
#define glVertexAttrib4uiv                            gl3wVertexAttrib4uiv
#define glVertexAttrib4usv                            gl3wVertexAttrib4usv
#define glVertexAttribBinding                         gl3wVertexAttribBinding
#define glVertexAttribDivisor                         gl3wVertexAttribDivisor
#define glVertexAttribFormat                          gl3wVertexAttribFormat
#define glVertexAttribI1i                             gl3wVertexAttribI1i
#define glVertexAttribI1iv                            gl3wVertexAttribI1iv
#define glVertexAttribI1ui                            gl3wVertexAttribI1ui
#define glVertexAttribI1uiv                           gl3wVertexAttribI1uiv
#define glVertexAttribI2i                             gl3wVertexAttribI2i
#define glVertexAttribI2iv                            gl3wVertexAttribI2iv
#define glVertexAttribI2ui                            gl3wVertexAttribI2ui
#define glVertexAttribI2uiv                           gl3wVertexAttribI2uiv
#define glVertexAttribI3i                             gl3wVertexAttribI3i
#define glVertexAttribI3iv                            gl3wVertexAttribI3iv
#define glVertexAttribI3ui                            gl3wVertexAttribI3ui
#define glVertexAttribI3uiv                           gl3wVertexAttribI3uiv
#define glVertexAttribI4bv                            gl3wVertexAttribI4bv
#define glVertexAttribI4i                             gl3wVertexAttribI4i
#define glVertexAttribI4iv                            gl3wVertexAttribI4iv
#define glVertexAttribI4sv                            gl3wVertexAttribI4sv
#define glVertexAttribI4ubv                           gl3wVertexAttribI4ubv
#define glVertexAttribI4ui                            gl3wVertexAttribI4ui
#define glVertexAttribI4uiv                           gl3wVertexAttribI4uiv
#define glVertexAttribI4usv                           gl3wVertexAttribI4usv
#define glVertexAttribIFormat                         gl3wVertexAttribIFormat
#define glVertexAttribIPointer                        gl3wVertexAttribIPointer
#define glVertexAttribL1d                             gl3wVertexAttribL1d
#define glVertexAttribL1dv                            gl3wVertexAttribL1dv
#define glVertexAttribL1ui64ARB                       gl3wVertexAttribL1ui64ARB
#define glVertexAttribL1ui64vARB                      gl3wVertexAttribL1ui64vARB
#define glVertexAttribL2d                             gl3wVertexAttribL2d
#define glVertexAttribL2dv                            gl3wVertexAttribL2dv
#define glVertexAttribL3d                             gl3wVertexAttribL3d
#define glVertexAttribL3dv                            gl3wVertexAttribL3dv
#define glVertexAttribL4d                             gl3wVertexAttribL4d
#define glVertexAttribL4dv                            gl3wVertexAttribL4dv
#define glVertexAttribLFormat                         gl3wVertexAttribLFormat
#define glVertexAttribLPointer                        gl3wVertexAttribLPointer
#define glVertexAttribP1ui                            gl3wVertexAttribP1ui
#define glVertexAttribP1uiv                           gl3wVertexAttribP1uiv
#define glVertexAttribP2ui                            gl3wVertexAttribP2ui
#define glVertexAttribP2uiv                           gl3wVertexAttribP2uiv
#define glVertexAttribP3ui                            gl3wVertexAttribP3ui
#define glVertexAttribP3uiv                           gl3wVertexAttribP3uiv
#define glVertexAttribP4ui                            gl3wVertexAttribP4ui
#define glVertexAttribP4uiv                           gl3wVertexAttribP4uiv
#define glVertexAttribPointer                         gl3wVertexAttribPointer
#define glVertexBindingDivisor                        gl3wVertexBindingDivisor
#define glViewport                                    gl3wViewport
#define glViewportArrayv                              gl3wViewportArrayv
#define glViewportIndexedf                            gl3wViewportIndexedf
#define glViewportIndexedfv                           gl3wViewportIndexedfv
#define glWaitSync                                    gl3wWaitSync

#ifdef __cplusplus
}
#endif

#endif
