/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;

class HeaderCheckWorker {
    public static final int DEFAULT_NUMBER_OF_RETAINED_HEADER_LINES = 50;
    private final int numberOfRetainedHeaderLines;
    private final BufferedReader reader;
    private final IHeaderMatcher matcher;
    private final Document subject;
    private boolean match = false;
    private int headerLinesToRead;
    private boolean finished = false;

    public HeaderCheckWorker(Reader reader, int numberOfRetainedHeaderLine, IHeaderMatcher matcher, Document name) {
        this(new BufferedReader(reader), numberOfRetainedHeaderLine, matcher, name);
    }

    public HeaderCheckWorker(Reader reader, IHeaderMatcher matcher, Document name) {
        this(new BufferedReader(reader), matcher, name);
    }

    public HeaderCheckWorker(BufferedReader reader, IHeaderMatcher matcher, Document name) {
        this(reader, 50, matcher, name);
    }

    public HeaderCheckWorker(BufferedReader reader, int numberOfRetainedHeaderLine, IHeaderMatcher matcher, Document name) {
        this.reader = reader;
        this.numberOfRetainedHeaderLines = numberOfRetainedHeaderLine;
        this.matcher = matcher;
        this.subject = name;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void read() throws RatHeaderAnalysisException {
        if (!this.finished) {
            StringBuilder headers = new StringBuilder();
            this.headerLinesToRead = this.numberOfRetainedHeaderLines;
            try {
                while (this.readLine(headers)) {
                }
                if (!this.match) {
                    String notes = headers.toString();
                    MetaData metaData = this.subject.getMetaData();
                    metaData.set(new MetaData.Datum("http://org/apache/rat/meta-data#HeaderSample", notes));
                    metaData.set(new MetaData.Datum("http://org/apache/rat/meta-data#HeaderCategory", "?????"));
                    metaData.set(MetaData.RAT_LICENSE_FAMILY_NAME_DATUM_UNKNOWN);
                }
            }
            catch (IOException e) {
                throw new RatHeaderAnalysisException("Cannot read header for " + this.subject, e);
            }
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.matcher.reset();
        }
        this.finished = true;
    }

    boolean readLine(StringBuilder headers) throws IOException, RatHeaderAnalysisException {
        boolean result;
        String line = this.reader.readLine();
        boolean bl = result = line != null;
        if (result) {
            if (this.headerLinesToRead-- > 0) {
                headers.append(line);
                headers.append('\n');
            }
            this.match = this.matcher.match(this.subject, line);
            result = !this.match;
        }
        return result;
    }
}

