/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.maven.Maven;
import org.apache.maven.SettingsConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.cli.BatchModeDownloadMonitor;
import org.apache.maven.cli.ConsoleDownloadMonitor;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.monitor.event.DefaultEventDispatcher;
import org.apache.maven.monitor.event.DefaultEventMonitor;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.monitor.event.EventMonitor;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.reactor.MavenExecutionException;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.RuntimeInfo;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.embed.Embedder;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenCli {
    private static Embedder embedder;
    static /* synthetic */ Class class$org$apache$maven$cli$MavenCli;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static int main(String[] args, ClassWorld classWorld) {
        block29: {
            cliManager = new CLIManager();
            try {
                commandLine = cliManager.parse(args);
            }
            catch (ParseException e) {
                System.err.println("Unable to parse command line options: " + e.getMessage());
                cliManager.displayHelp();
                return 1;
            }
            if (System.getProperty("java.class.version", "44.0").compareTo("48.0") < 0) {
                System.err.println("Sorry, but JDK 1.4 or above is required to execute Maven");
                System.err.println("You appear to be using Java version: " + System.getProperty("java.version", "<unknown>"));
                return 1;
            }
            debug = commandLine.hasOption('X');
            v0 = showErrors = debug != false || commandLine.hasOption('e') != false;
            if (showErrors) {
                System.out.println("+ Error stacktraces are turned on.");
            }
            if (commandLine.hasOption('h')) {
                cliManager.displayHelp();
                return 0;
            }
            if (commandLine.hasOption('v')) {
                MavenCli.showVersion();
                return 0;
            }
            eventDispatcher = new DefaultEventDispatcher();
            MavenCli.embedder = new Embedder();
            try {
                MavenCli.embedder.start(classWorld);
            }
            catch (PlexusContainerException e) {
                MavenCli.showFatalError("Unable to start the embedded plexus container", (Exception)e, showErrors);
                return 1;
            }
            executionProperties = MavenCli.getExecutionProperties(commandLine);
            try {
                settings = MavenCli.buildSettings(commandLine);
            }
            catch (SettingsConfigurationException e) {
                MavenCli.showError("Error reading settings.xml: " + e.getMessage(), e, showErrors);
                return 1;
            }
            catch (ComponentLookupException e) {
                MavenCli.showFatalError("Unable to read settings.xml", (Exception)e, showErrors);
                return 1;
            }
            maven = null;
            request = null;
            loggerManager = null;
            try {
                loggerManager = (LoggerManager)MavenCli.embedder.lookup(LoggerManager.ROLE);
                if (debug) {
                    loggerManager.setThreshold(0);
                }
                profileManager = new DefaultProfileManager(MavenCli.embedder.getContainer());
                if (commandLine.hasOption('P')) {
                    profilesLine = commandLine.getOptionValue('P');
                    profileTokens = new StringTokenizer(profilesLine, ",");
                    while (profileTokens.hasMoreTokens()) {
                        profileAction = profileTokens.nextToken().trim();
                        if (profileAction.startsWith("-")) {
                            profileManager.explicitlyDeactivate(profileAction.substring(1));
                            continue;
                        }
                        if (profileAction.startsWith("+")) {
                            profileManager.explicitlyActivate(profileAction.substring(1));
                            continue;
                        }
                        profileManager.explicitlyActivate(profileAction);
                    }
                }
                request = MavenCli.createRequest(commandLine, settings, (EventDispatcher)eventDispatcher, loggerManager, (ProfileManager)profileManager, executionProperties, showErrors);
                MavenCli.setProjectFileOptions(commandLine, request);
                maven = MavenCli.createMavenInstance(settings.isInteractiveMode());
                var17_23 = null;
                ** if (loggerManager == null) goto lbl-1000
            }
            catch (Throwable var16_29) {
                var17_25 = null;
                if (loggerManager != null) {
                    try {
                        MavenCli.embedder.release((Object)loggerManager);
                    }
                    catch (ComponentLifecycleException e) {
                        MavenCli.showFatalError("Error releasing logging manager", (Exception)e, showErrors);
                    }
                }
                throw var16_29;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    MavenCli.embedder.release((Object)loggerManager);
                }
                catch (ComponentLifecycleException e) {
                    MavenCli.showFatalError("Error releasing logging manager", (Exception)e, showErrors);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block29;
                catch (ComponentLookupException e) {
                    MavenCli.showFatalError("Unable to configure the Maven application", (Exception)e, showErrors);
                    var13_20 = 1;
                    var17_24 = null;
                    if (loggerManager != null) {
                        try {
                            MavenCli.embedder.release((Object)loggerManager);
                        }
                        catch (ComponentLifecycleException e) {
                            MavenCli.showFatalError("Error releasing logging manager", (Exception)e, showErrors);
                        }
                    }
                    return var13_20;
                }
            }
        }
        try {
            maven.execute(request);
        }
        catch (MavenExecutionException e) {
            return 1;
        }
        return 0;
    }

    private static Settings buildSettings(CommandLine commandLine) throws ComponentLookupException, SettingsConfigurationException {
        String userSettingsPath = null;
        if (commandLine.hasOption('s')) {
            userSettingsPath = commandLine.getOptionValue('s');
        }
        Settings settings = null;
        MavenSettingsBuilder settingsBuilder = (MavenSettingsBuilder)embedder.lookup(MavenSettingsBuilder.ROLE);
        try {
            if (userSettingsPath != null) {
                File userSettingsFile = new File(userSettingsPath);
                if (userSettingsFile.exists() && !userSettingsFile.isDirectory()) {
                    settings = settingsBuilder.buildSettings(userSettingsFile);
                } else {
                    System.out.println("WARNING: Alternate user settings file: " + userSettingsPath + " is invalid. Using default path.");
                }
            }
            if (settings == null) {
                settings = settingsBuilder.buildSettings();
            }
        }
        catch (IOException e) {
            throw new SettingsConfigurationException("Error reading settings file", e);
        }
        catch (XmlPullParserException e) {
            throw new SettingsConfigurationException(e.getMessage(), e.getDetail(), e.getLineNumber(), e.getColumnNumber());
        }
        if (commandLine.hasOption('B')) {
            settings.setInteractiveMode(false);
        }
        if (commandLine.hasOption("npr")) {
            settings.setUsePluginRegistry(false);
        }
        settings.setRuntimeInfo(MavenCli.createRuntimeInfo(commandLine, settings));
        return settings;
    }

    private static RuntimeInfo createRuntimeInfo(CommandLine commandLine, Settings settings) {
        RuntimeInfo runtimeInfo = new RuntimeInfo(settings);
        if (commandLine.hasOption("cpu") || commandLine.hasOption("up")) {
            runtimeInfo.setPluginUpdateOverride(Boolean.TRUE);
        } else if (commandLine.hasOption("npu")) {
            runtimeInfo.setPluginUpdateOverride(Boolean.FALSE);
        }
        return runtimeInfo;
    }

    private static void showFatalError(String message, Exception e, boolean show) {
        System.err.println("FATAL ERROR: " + message);
        if (show) {
            System.err.println("Error stacktrace:");
            e.printStackTrace();
        } else {
            System.err.println("For more information, run with the -e flag");
        }
    }

    private static void showError(String message, Exception e, boolean show) {
        System.err.println(message);
        if (show) {
            System.err.println("Error stacktrace:");
            e.printStackTrace();
        }
    }

    private static MavenExecutionRequest createRequest(CommandLine commandLine, Settings settings, EventDispatcher eventDispatcher, LoggerManager loggerManager, ProfileManager profileManager, Properties executionProperties, boolean showErrors) throws ComponentLookupException {
        ArtifactRepository localRepository = MavenCli.createLocalRepository(embedder, settings, commandLine);
        File userDir = new File(System.getProperty("user.dir"));
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest(localRepository, settings, eventDispatcher, commandLine.getArgList(), userDir.getPath(), profileManager, executionProperties, showErrors);
        Logger logger = loggerManager.getLoggerForComponent(Mojo.ROLE);
        if (logger != null) {
            request.addEventMonitor((EventMonitor)new DefaultEventMonitor(logger));
        }
        if (commandLine.hasOption('N')) {
            request.setRecursive(false);
        }
        if (commandLine.hasOption("ff")) {
            request.setFailureBehavior("fail-fast");
        } else if (commandLine.hasOption("fae")) {
            request.setFailureBehavior("fail-at-end");
        } else if (commandLine.hasOption("fn")) {
            request.setFailureBehavior("fail-never");
        }
        return request;
    }

    private static void setProjectFileOptions(CommandLine commandLine, MavenExecutionRequest request) {
        if (commandLine.hasOption('r')) {
            request.setReactorActive(true);
        } else if (commandLine.hasOption('f')) {
            request.setPomFile(commandLine.getOptionValue('f'));
        }
    }

    private static Maven createMavenInstance(boolean interactive) throws ComponentLookupException {
        WagonManager wagonManager = (WagonManager)embedder.lookup(WagonManager.ROLE);
        if (interactive) {
            wagonManager.setDownloadMonitor((TransferListener)new ConsoleDownloadMonitor());
        } else {
            wagonManager.setDownloadMonitor((TransferListener)new BatchModeDownloadMonitor());
        }
        wagonManager.setInteractive(interactive);
        return (Maven)embedder.lookup(Maven.ROLE);
    }

    private static ArtifactRepository createLocalRepository(Embedder embedder, Settings settings, CommandLine commandLine) throws ComponentLookupException {
        ArtifactRepositoryLayout repositoryLayout = (ArtifactRepositoryLayout)embedder.lookup(ArtifactRepositoryLayout.ROLE, "default");
        ArtifactRepositoryFactory artifactRepositoryFactory = (ArtifactRepositoryFactory)embedder.lookup(ArtifactRepositoryFactory.ROLE);
        String url = settings.getLocalRepository();
        if (!url.startsWith("file:")) {
            url = "file://" + url;
        }
        DefaultArtifactRepository localRepository = new DefaultArtifactRepository("local", url, repositoryLayout);
        boolean snapshotPolicySet = false;
        if (commandLine.hasOption('o')) {
            settings.setOffline(true);
            snapshotPolicySet = true;
        }
        if (!snapshotPolicySet && commandLine.hasOption('U')) {
            artifactRepositoryFactory.setGlobalUpdatePolicy("always");
        }
        if (commandLine.hasOption('C')) {
            System.out.println("+ Enabling strict checksum verification on all artifact downloads.");
            artifactRepositoryFactory.setGlobalChecksumPolicy("fail");
        } else if (commandLine.hasOption('c')) {
            System.out.println("+ Disabling strict checksum verification on all artifact downloads.");
            artifactRepositoryFactory.setGlobalChecksumPolicy("warn");
        }
        return localRepository;
    }

    private static void showVersion() {
        try {
            Properties properties = new Properties();
            InputStream resourceAsStream = (class$org$apache$maven$cli$MavenCli == null ? (class$org$apache$maven$cli$MavenCli = MavenCli.class$("org.apache.maven.cli.MavenCli")) : class$org$apache$maven$cli$MavenCli).getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-core/pom.properties");
            properties.load(resourceAsStream);
            if (properties.getProperty("builtOn") != null) {
                System.out.println("Maven version: " + properties.getProperty("version", "unknown") + " built on " + properties.getProperty("builtOn"));
            } else {
                System.out.println("Maven version: " + properties.getProperty("version", "unknown"));
            }
        }
        catch (IOException e) {
            System.err.println("Unable determine version from JAR file: " + e.getMessage());
        }
    }

    private static Properties getExecutionProperties(CommandLine commandLine) {
        Properties executionProperties = new Properties();
        if (commandLine.hasOption('D')) {
            String[] defStrs = commandLine.getOptionValues('D');
            for (int i = 0; i < defStrs.length; ++i) {
                MavenCli.setCliProperty(defStrs[i], executionProperties);
            }
        }
        ((Hashtable)executionProperties).putAll(System.getProperties());
        return executionProperties;
    }

    private static void setCliProperty(String property, Properties executionProperties) {
        String value;
        String name;
        int i = property.indexOf("=");
        if (i <= 0) {
            name = property.trim();
            value = "true";
        } else {
            name = property.substring(0, i).trim();
            value = property.substring(i + 1).trim();
        }
        executionProperties.setProperty(name, value);
        System.setProperty(name, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class CLIManager {
        public static final char ALTERNATE_POM_FILE = 'f';
        public static final char BATCH_MODE = 'B';
        public static final char SET_SYSTEM_PROPERTY = 'D';
        public static final char OFFLINE = 'o';
        public static final char REACTOR = 'r';
        public static final char DEBUG = 'X';
        public static final char ERRORS = 'e';
        public static final char HELP = 'h';
        public static final char VERSION = 'v';
        private Options options = new Options();
        public static final char NON_RECURSIVE = 'N';
        public static final char UPDATE_SNAPSHOTS = 'U';
        public static final char ACTIVATE_PROFILES = 'P';
        public static final String FORCE_PLUGIN_UPDATES = "cpu";
        public static final String FORCE_PLUGIN_UPDATES2 = "up";
        public static final String SUPPRESS_PLUGIN_UPDATES = "npu";
        public static final String SUPPRESS_PLUGIN_REGISTRY = "npr";
        public static final char CHECKSUM_FAILURE_POLICY = 'C';
        public static final char CHECKSUM_WARNING_POLICY = 'c';
        private static final char ALTERNATE_USER_SETTINGS = 's';
        private static final String FAIL_FAST = "ff";
        private static final String FAIL_AT_END = "fae";
        private static final String FAIL_NEVER = "fn";

        public CLIManager() {
            OptionBuilder.withLongOpt((String)"file");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Force the use of an alternate POM file.");
            this.options.addOption(OptionBuilder.create((char)'f'));
            OptionBuilder.withLongOpt((String)"define");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Define a system property");
            this.options.addOption(OptionBuilder.create((char)'D'));
            OptionBuilder.withLongOpt((String)"offline");
            OptionBuilder.withDescription((String)"Work offline");
            this.options.addOption(OptionBuilder.create((char)'o'));
            OptionBuilder.withLongOpt((String)"help");
            OptionBuilder.withDescription((String)"Display help information");
            this.options.addOption(OptionBuilder.create((char)'h'));
            OptionBuilder.withLongOpt((String)"version");
            OptionBuilder.withDescription((String)"Display version information");
            this.options.addOption(OptionBuilder.create((char)'v'));
            OptionBuilder.withLongOpt((String)"debug");
            OptionBuilder.withDescription((String)"Produce execution debug output");
            this.options.addOption(OptionBuilder.create((char)'X'));
            OptionBuilder.withLongOpt((String)"errors");
            OptionBuilder.withDescription((String)"Produce execution error messages");
            this.options.addOption(OptionBuilder.create((char)'e'));
            OptionBuilder.withLongOpt((String)"reactor");
            OptionBuilder.withDescription((String)"Execute goals for project found in the reactor");
            this.options.addOption(OptionBuilder.create((char)'r'));
            OptionBuilder.withLongOpt((String)"non-recursive");
            OptionBuilder.withDescription((String)"Do not recurse into sub-projects");
            this.options.addOption(OptionBuilder.create((char)'N'));
            OptionBuilder.withLongOpt((String)"update-snapshots");
            OptionBuilder.withDescription((String)"Update all snapshots regardless of repository policies");
            this.options.addOption(OptionBuilder.create((char)'U'));
            OptionBuilder.withLongOpt((String)"activate-profiles");
            OptionBuilder.withDescription((String)"Comma-delimited list of profiles to activate");
            OptionBuilder.hasArg();
            this.options.addOption(OptionBuilder.create((char)'P'));
            OptionBuilder.withLongOpt((String)"batch-mode");
            OptionBuilder.withDescription((String)"Run in non-interactive (batch) mode");
            this.options.addOption(OptionBuilder.create((char)'B'));
            OptionBuilder.withLongOpt((String)"check-plugin-updates");
            OptionBuilder.withDescription((String)"Force upToDate check for any relevant registered plugins");
            this.options.addOption(OptionBuilder.create((String)FORCE_PLUGIN_UPDATES));
            OptionBuilder.withLongOpt((String)"update-plugins");
            OptionBuilder.withDescription((String)"Synonym for cpu");
            this.options.addOption(OptionBuilder.create((String)FORCE_PLUGIN_UPDATES2));
            OptionBuilder.withLongOpt((String)"no-plugin-updates");
            OptionBuilder.withDescription((String)"Suppress upToDate check for any relevant registered plugins");
            this.options.addOption(OptionBuilder.create((String)SUPPRESS_PLUGIN_UPDATES));
            OptionBuilder.withLongOpt((String)"no-plugin-registry");
            OptionBuilder.withDescription((String)"Don't use ~/.m2/plugin-registry.xml for plugin versions");
            this.options.addOption(OptionBuilder.create((String)SUPPRESS_PLUGIN_REGISTRY));
            OptionBuilder.withLongOpt((String)"strict-checksums");
            OptionBuilder.withDescription((String)"Fail the build if checksums don't match");
            this.options.addOption(OptionBuilder.create((char)'C'));
            OptionBuilder.withLongOpt((String)"lax-checksums");
            OptionBuilder.withDescription((String)"Warn if checksums don't match");
            this.options.addOption(OptionBuilder.create((char)'c'));
            OptionBuilder.withLongOpt((String)"settings");
            OptionBuilder.withDescription((String)"Alternate path for the user settings file");
            OptionBuilder.hasArg();
            this.options.addOption(OptionBuilder.create((char)'s'));
            OptionBuilder.withLongOpt((String)"fail-fast");
            OptionBuilder.withDescription((String)"Stop at first failure in reactorized builds");
            this.options.addOption(OptionBuilder.create((String)FAIL_FAST));
            OptionBuilder.withLongOpt((String)"fail-at-end");
            OptionBuilder.withDescription((String)"Only fail the build afterwards; allow all non-impacted builds to continue");
            this.options.addOption(OptionBuilder.create((String)FAIL_AT_END));
            OptionBuilder.withLongOpt((String)"fail-never");
            OptionBuilder.withDescription((String)"NEVER fail the build, regardless of project result");
            this.options.addOption(OptionBuilder.create((String)FAIL_NEVER));
        }

        public CommandLine parse(String[] args) throws ParseException {
            GnuParser parser = new GnuParser();
            return parser.parse(this.options, args);
        }

        public void displayHelp() {
            System.out.println();
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("mvn [options] [<goal(s)>] [<phase(s)>]", "\nOptions:", this.options, "\n");
        }
    }
}

