/*
 * Decompiled with CFR 0.152.
 */
package jspecview.js2d;

import javajs.api.GenericColor;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.SB;
import org.jmol.awtjs.swing.AbstractTableModel;
import org.jmol.awtjs.swing.TableColumn;

class DialogTableModel
implements AbstractTableModel {
    String[] columnNames;
    Object[][] data;
    boolean asString;
    int[] widths;
    private int thisCol;
    private boolean tableCellAlignLeft;

    DialogTableModel(String[] columnNames, Object[][] data, boolean asString, boolean tableCellAlignLeft) {
        this.columnNames = columnNames;
        this.data = data;
        this.asString = asString;
        this.widths = data.length == 0 ? new int[]{} : new int[data[0].length];
        this.tableCellAlignLeft = tableCellAlignLeft;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        Object o = this.data[row][col];
        return this.asString ? " " + o + " " : o;
    }

    public TableColumn getColumn(int i) {
        this.thisCol = i;
        return this;
    }

    public void setPreferredWidth(int n) {
        this.widths[this.thisCol] = n;
    }

    public void toHTML(SB sb, String id, BS selectedRows) {
        if (this.data == null || this.data[0] == null || this.data[0].length == 0) {
            return;
        }
        int nrows = this.data.length;
        int ncols = this.columnNames.length;
        for (int i = -1; i < nrows; ++i) {
            String rowid = id + "_" + i;
            sb.append("\n<tr id='" + rowid + "' class='JTable_" + (i == -1 ? "header" : "row") + "' style='height:25px'>");
            for (int j = 0; j < ncols; ++j) {
                if (i == -1) {
                    this.getCellHtml(sb, id + "_h" + j, i, j, this.columnNames[j], false);
                    continue;
                }
                this.getCellHtml(sb, rowid + "_" + j, i, j, this.data[i][j], selectedRows.get(i));
            }
            sb.append("</tr>");
        }
    }

    private void getCellHtml(SB sb, String id, int iRow, int iCol, Object o, boolean isSelected) {
        String style = this.getCellStyle(id, iRow, iCol, o, isSelected);
        sb.append("<td id='" + id + "'" + style + " onclick=SwingController.click(this)>" + o + "</td>");
    }

    private String getCellStyle(String id, int iRow, int iCol, Object o, boolean isSelected) {
        String style = "padding:1px 1px 1px 1px";
        if (iRow < 0) {
            style = style + ";font-weight:bold";
        } else if (o instanceof GenericColor) {
            style = style + ";background-color:" + CU.toCSSString((GenericColor)((GenericColor)o));
        } else {
            if (this.asString) {
                o = " " + o + " ";
            }
            style = style + ";text-align:";
            style = this.tableCellAlignLeft ? style + "left" : (iCol == 0 ? style + "center" : style + "right");
            style = style + ";border:" + (isSelected ? 3 : 1) + "px solid #000";
        }
        return " style='" + style + "'";
    }
}

