/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import javajs.util.CU;
import jspecview.api.VisibleInterface;
import jspecview.common.Coordinate;
import jspecview.common.Spectrum;

public class Visible
implements VisibleInterface {
    @Override
    public int getColour(Spectrum spec, boolean useFitted) {
        Coordinate[] xyCoords = spec.getXYCoords();
        boolean isAbsorbance = spec.isAbsorbance();
        double[] xyzd = new double[4];
        Visible.getXYZfitted(xyCoords, isAbsorbance, xyzd);
        xyzd[0] = xyzd[0] / xyzd[3];
        xyzd[1] = xyzd[1] / xyzd[3];
        xyzd[2] = xyzd[2] / xyzd[3];
        double[] rgb = new double[]{xyzd[0] * 3.241 + xyzd[1] * -1.5374 + xyzd[2] * -0.4986, xyzd[0] * -0.9692 + xyzd[1] * 1.876 + xyzd[2] * 0.0416, xyzd[0] * 0.0556 + xyzd[1] * -0.204 + xyzd[2] * 1.057};
        double gamma = 2.4;
        for (int i = 0; i < 3; ++i) {
            rgb[i] = rgb[i] > 0.00304 ? 1.055 * Math.pow(rgb[i], 1.0 / gamma) - 0.055 : 12.92 * rgb[i];
        }
        int c = CU.rgb((int)Visible.fix(rgb[0]), (int)Visible.fix(rgb[1]), (int)Visible.fix(rgb[2]));
        return c;
    }

    private static int fix(double d) {
        return d <= 0.0 ? 0 : (d >= 1.0 ? 255 : (int)Math.round(255.0 * d));
    }

    private static void getXYZfitted(Coordinate[] xyCoords, boolean isAbsorbance, double[] xyzd) {
        int i = xyCoords.length;
        while (--i >= 0) {
            double x = xyCoords[i].getXVal();
            if (x < 400.0 || x > 700.0) continue;
            double cie = Visible.gauss(85.7145, 2.05719E-5, x - 607.263) + Visible.gauss(57.7256, 1.26451E-4, x - 457.096);
            double xb = Visible.gauss(1.06561, 5.00819E-4, x - 598.623) + Visible.gauss(0.283831, 0.00292745, x - 435.734) + Visible.gauss(0.113771, 0.00192849, x - 549.271) + Visible.gauss(0.239103, 0.00255944, x - 460.547);
            double yb = Visible.gauss(0.239617, 0.00117296, x - 530.517) + Visible.gauss(0.910377, 3.00984E-4, x - 565.635) + Visible.gauss(0.0311013, 0.00152386, x - 463.833);
            double zb = Visible.gauss(0.988366, 0.00220336, x - 456.345) + Visible.gauss(0.381551, 8.48554E-4, x - 450.871) + Visible.gauss(0.355693, 6.28546E-4, x - 470.668) + Visible.gauss(0.81862, 0.00471059, x - 433.144);
            double y = xyCoords[i].getYVal();
            if (isAbsorbance) {
                y = Math.pow(10.0, -Math.max(y, 0.0));
            }
            xyzd[0] = xyzd[0] + y * xb * cie;
            xyzd[1] = xyzd[1] + y * yb * cie;
            xyzd[2] = xyzd[2] + y * zb * cie;
            xyzd[3] = xyzd[3] + yb * cie;
        }
    }

    private static double gauss(double a, double b, double x) {
        return a * Math.exp(-b * x * x);
    }
}

