/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.xmlgraphics.util.io.ASCII85Constants;

public class ASCII85InputStream
extends InputStream
implements ASCII85Constants {
    private InputStream in;
    private boolean eodReached;
    private int[] b = new int[4];
    private int bSize;
    private int bIndex;

    public ASCII85InputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    @Override
    public int read() throws IOException {
        int n;
        if (this.bIndex >= this.bSize) {
            if (this.eodReached) {
                return -1;
            }
            this.readNextTuple();
            if (this.bSize == 0) {
                if (!this.eodReached) {
                    throw new IllegalStateException("Internal error");
                }
                return -1;
            }
        }
        n = (n = this.b[this.bIndex]) < 0 ? 256 + n : n;
        ++this.bIndex;
        return n;
    }

    private int filteredRead() throws IOException {
        int n;
        block4: while (true) {
            n = this.in.read();
            switch (n) {
                case 0: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    continue block4;
                }
                case 122: 
                case 126: {
                    return n;
                }
            }
            break;
        }
        if (n >= 33 && n <= 117) {
            return n;
        }
        throw new IOException("Illegal character detected: " + n);
    }

    private void handleEOD() throws IOException {
        int n = this.in.read();
        if (n != EOD[1]) {
            throw new IOException("'>' expected after '~' (EOD)");
        }
        this.eodReached = true;
        this.bSize = 0;
        this.bIndex = 0;
    }

    private void readNextTuple() throws IOException {
        long l = 0L;
        int n = this.filteredRead();
        if (n == 122) {
            Arrays.fill(this.b, 0);
            this.bSize = 4;
            this.bIndex = 0;
        } else if (n == EOD[0]) {
            this.handleEOD();
        } else {
            int n2;
            int n3 = 0;
            l = (long)(n - 33) * POW85[n3];
            ++n3;
            while (n3 < 5) {
                n = this.filteredRead();
                if (n == EOD[0]) {
                    this.handleEOD();
                    break;
                }
                if (n == 122) {
                    throw new IOException("Illegal 'z' within tuple");
                }
                l += (long)(n - 33) * POW85[n3];
                ++n3;
            }
            if ((n2 = n3) == 1) {
                throw new IOException("Only one character in tuple");
            }
            while (n3 < 5) {
                l += POW85[n3 - 1];
                ++n3;
            }
            if (l > 0xFFFFFFFFL) {
                throw new IOException("Illegal tuple (> 2^32 - 1)");
            }
            this.b[0] = (byte)(l >> 24 & 0xFFL);
            this.b[1] = (byte)(l >> 16 & 0xFFL);
            this.b[2] = (byte)(l >> 8 & 0xFFL);
            this.b[3] = (byte)(l & 0xFFL);
            this.bSize = n2 - 1;
            this.bIndex = 0;
        }
    }
}

