/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import org.apache.xmlgraphics.ps.PSGenerator;

public class PSResource
implements Comparable {
    public static final String TYPE_FILE = "file";
    public static final String TYPE_FONT = "font";
    public static final String TYPE_PROCSET = "procset";
    public static final String TYPE_PATTERN = "pattern";
    public static final String TYPE_FORM = "form";
    public static final String TYPE_ENCODING = "encoding";
    public static final String TYPE_CMAP = "cmap";
    public static final String TYPE_CIDFONT = "cidfont";
    private String type;
    private String name;

    public PSResource(String string, String string2) {
        this.type = string;
        this.name = string2;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceSpecification() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getType()).append(" ").append(PSGenerator.convertStringToDSC(this.getName()));
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PSResource) {
            PSResource pSResource = (PSResource)object;
            return pSResource.toString().equals(this.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int compareTo(Object object) {
        PSResource pSResource = (PSResource)object;
        if (this == pSResource) {
            return 0;
        }
        int n = this.getType().compareTo(pSResource.getType());
        if (n == 0) {
            n = this.getName().compareTo(pSResource.getName());
        }
        return n;
    }

    public String toString() {
        return this.getResourceSpecification();
    }
}

