/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl.imageio;

import javax.imageio.metadata.IIOMetadata;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ImageIOUtil {
    public static final Object IMAGEIO_METADATA = IIOMetadata.class;

    private ImageIOUtil() {
    }

    public static void extractResolution(IIOMetadata iIOMetadata, ImageSize imageSize) {
        Element element;
        Element element2;
        if (iIOMetadata != null && iIOMetadata.isStandardMetadataFormatSupported() && (element2 = ImageIOUtil.getChild(element = (Element)iIOMetadata.getAsTree("javax_imageio_1.0"), "Dimension")) != null) {
            float f;
            double d = imageSize.getDpiHorizontal();
            double d2 = imageSize.getDpiVertical();
            Element element3 = ImageIOUtil.getChild(element2, "HorizontalPixelSize");
            if (element3 != null && (f = Float.parseFloat(element3.getAttribute("value"))) != 0.0f && !Float.isInfinite(f)) {
                d = 25.4f / f;
            }
            if ((element3 = ImageIOUtil.getChild(element2, "VerticalPixelSize")) != null && (f = Float.parseFloat(element3.getAttribute("value"))) != 0.0f && !Float.isInfinite(f)) {
                d2 = 25.4f / f;
            }
            imageSize.setResolution(d, d2);
            imageSize.calcSizeFromPixels();
        }
    }

    public static Element getChild(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static void dumpMetadataToSystemOut(IIOMetadata iIOMetadata) {
        String[] stringArray = iIOMetadata.getMetadataFormatNames();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("--->" + stringArray[i]);
            ImageIOUtil.dumpNodeToSystemOut(iIOMetadata.getAsTree(stringArray[i]));
        }
    }

    private static void dumpNodeToSystemOut(Node node) {
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(node);
            StreamResult streamResult = new StreamResult(System.out);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
    }
}

