/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader;

import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import org.apache.xmlgraphics.java2d.Dimension2DDouble;
import org.apache.xmlgraphics.util.UnitConv;

public class ImageSize {
    private int widthPx;
    private int heightPx;
    private int widthMpt;
    private int heightMpt;
    private int baselinePositionFromBottomMpt;
    private double dpiHorizontal;
    private double dpiVertical;

    public ImageSize(int n, int n2, double d, double d2) {
        this.setSizeInPixels(n, n2);
        this.setResolution(d, d2);
    }

    public ImageSize(int n, int n2, double d) {
        this(n, n2, d, d);
    }

    public ImageSize() {
    }

    public void setSizeInPixels(int n, int n2) {
        this.widthPx = n;
        this.heightPx = n2;
    }

    public void setSizeInMillipoints(int n, int n2) {
        this.widthMpt = n;
        this.heightMpt = n2;
    }

    public void setResolution(double d, double d2) {
        this.dpiHorizontal = d;
        this.dpiVertical = d2;
    }

    public void setResolution(double d) {
        this.setResolution(d, d);
    }

    public void setBaselinePositionFromBottom(int n) {
        this.baselinePositionFromBottomMpt = n;
    }

    public int getBaselinePositionFromBottom() {
        return this.baselinePositionFromBottomMpt;
    }

    public int getWidthPx() {
        return this.widthPx;
    }

    public int getHeightPx() {
        return this.heightPx;
    }

    public int getWidthMpt() {
        return this.widthMpt;
    }

    public int getHeightMpt() {
        return this.heightMpt;
    }

    public double getDpiHorizontal() {
        return this.dpiHorizontal;
    }

    public double getDpiVertical() {
        return this.dpiVertical;
    }

    public Dimension getDimensionMpt() {
        return new Dimension(this.getWidthMpt(), this.getHeightMpt());
    }

    public Dimension2D getDimensionPt() {
        return new Dimension2DDouble((double)this.getWidthMpt() / 1000.0, (double)this.getHeightMpt() / 1000.0);
    }

    public Dimension getDimensionPx() {
        return new Dimension(this.getWidthPx(), this.getHeightPx());
    }

    private void checkResolutionAvailable() {
        if (this.dpiHorizontal == 0.0 || this.dpiVertical == 0.0) {
            throw new IllegalStateException("The resolution must be set");
        }
    }

    public void calcSizeFromPixels() {
        this.checkResolutionAvailable();
        this.widthMpt = (int)Math.round(UnitConv.in2mpt((double)this.widthPx / this.dpiHorizontal));
        this.heightMpt = (int)Math.round(UnitConv.in2mpt((double)this.heightPx / this.dpiVertical));
    }

    public void calcPixelsFromSize() {
        this.checkResolutionAvailable();
        this.widthPx = (int)Math.round(UnitConv.mpt2in((double)this.widthMpt * this.dpiHorizontal));
        this.heightPx = (int)Math.round(UnitConv.mpt2in((double)this.heightMpt * this.dpiVertical));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Size: ");
        stringBuffer.append(this.getWidthMpt()).append('x').append(this.getHeightMpt()).append(" mpt");
        stringBuffer.append(" (");
        stringBuffer.append(this.getWidthPx()).append('x').append(this.getHeightPx()).append(" px");
        stringBuffer.append(" at ").append(this.getDpiHorizontal()).append('x').append(this.getDpiVertical());
        stringBuffer.append(" dpi");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

