/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.tiff;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.HashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.xmlgraphics.image.codec.tiff.TIFFDecodeParam;
import org.apache.xmlgraphics.image.codec.tiff.TIFFDirectory;
import org.apache.xmlgraphics.image.codec.tiff.TIFFFaxDecoder;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.codec.tiff.TIFFLZWDecoder;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;
import org.apache.xmlgraphics.image.codec.util.SeekableStream;
import org.apache.xmlgraphics.image.rendered.AbstractRed;
import org.apache.xmlgraphics.image.rendered.CachableRed;

public class TIFFImage
extends AbstractRed {
    public static final int COMP_NONE = 1;
    public static final int COMP_FAX_G3_1D = 2;
    public static final int COMP_FAX_G3_2D = 3;
    public static final int COMP_FAX_G4_2D = 4;
    public static final int COMP_LZW = 5;
    public static final int COMP_JPEG_OLD = 6;
    public static final int COMP_JPEG_TTN2 = 7;
    public static final int COMP_PACKBITS = 32773;
    public static final int COMP_DEFLATE = 32946;
    private static final int TYPE_UNSUPPORTED = -1;
    private static final int TYPE_BILEVEL = 0;
    private static final int TYPE_GRAY_4BIT = 1;
    private static final int TYPE_GRAY = 2;
    private static final int TYPE_GRAY_ALPHA = 3;
    private static final int TYPE_PALETTE = 4;
    private static final int TYPE_RGB = 5;
    private static final int TYPE_RGB_ALPHA = 6;
    private static final int TYPE_YCBCR_SUB = 7;
    private static final int TYPE_GENERIC = 8;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    SeekableStream stream;
    int tileSize;
    int tilesX;
    int tilesY;
    long[] tileOffsets;
    long[] tileByteCounts;
    char[] colormap;
    int sampleSize;
    int compression;
    byte[] palette;
    int numBands;
    int chromaSubH;
    int chromaSubV;
    long tiffT4Options;
    long tiffT6Options;
    int fillOrder;
    int predictor;
    Inflater inflater;
    boolean isBigEndian;
    int imageType;
    boolean isWhiteZero;
    int dataType;
    boolean decodePaletteAsShorts;
    boolean tiled;
    private TIFFFaxDecoder decoder;
    private TIFFLZWDecoder lzwDecoder;

    private void inflate(byte[] byArray, byte[] byArray2) {
        this.inflater.setInput(byArray);
        try {
            this.inflater.inflate(byArray2);
        }
        catch (DataFormatException dataFormatException) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage17") + ": " + dataFormatException.getMessage());
        }
        this.inflater.reset();
    }

    private static SampleModel createPixelInterleavedSampleModel(int n, int n2, int n3, int n4) {
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = i;
        }
        return new PixelInterleavedSampleModel(n, n2, n3, n4, n2 * n4, nArray);
    }

    private long[] getFieldAsLongs(TIFFField tIFFField) {
        long[] lArray = null;
        if (tIFFField.getType() == 3) {
            char[] cArray = tIFFField.getAsChars();
            lArray = new long[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                lArray[i] = cArray[i] & 0xFFFF;
            }
        } else if (tIFFField.getType() == 4) {
            lArray = tIFFField.getAsLongs();
        } else {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage18") + ": " + tIFFField.getType());
        }
        return lArray;
    }

    public TIFFImage(SeekableStream seekableStream, TIFFDecodeParam tIFFDecodeParam, int n) throws IOException {
        Object object;
        Object object2;
        TIFFField tIFFField;
        int n2;
        int n3;
        int n4;
        int n5;
        char[] cArray;
        char[] cArray2;
        this.stream = seekableStream;
        if (tIFFDecodeParam == null) {
            tIFFDecodeParam = new TIFFDecodeParam();
        }
        this.decodePaletteAsShorts = tIFFDecodeParam.getDecodePaletteAsShorts();
        TIFFDirectory tIFFDirectory = tIFFDecodeParam.getIFDOffset() == null ? new TIFFDirectory(seekableStream, n) : new TIFFDirectory(seekableStream, tIFFDecodeParam.getIFDOffset(), n);
        TIFFField tIFFField2 = tIFFDirectory.getField(277);
        int n6 = tIFFField2 == null ? 1 : (int)tIFFField2.getAsLong(0);
        TIFFField tIFFField3 = tIFFDirectory.getField(284);
        if (tIFFField3 == null) {
            char[] cArray3 = new char[1];
            cArray2 = cArray3;
            cArray3[0] = '\u0001';
        } else {
            cArray2 = cArray = tIFFField3.getAsChars();
        }
        if (cArray[0] != '\u0001' && n6 != 1) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage0"));
        }
        TIFFField tIFFField4 = tIFFDirectory.getField(258);
        char[] cArray4 = null;
        if (tIFFField4 != null) {
            cArray4 = tIFFField4.getAsChars();
        } else {
            cArray4 = new char[]{'\u0001'};
            for (int i = 1; i < cArray4.length; ++i) {
                if (cArray4[i] == cArray4[0]) continue;
                throw new RuntimeException(PropertyUtil.getString("TIFFImage1"));
            }
        }
        this.sampleSize = cArray4[0];
        TIFFField tIFFField5 = tIFFDirectory.getField(339);
        char[] cArray5 = null;
        if (tIFFField5 != null) {
            cArray5 = tIFFField5.getAsChars();
            for (n5 = 1; n5 < cArray5.length; ++n5) {
                if (cArray5[n5] == cArray5[0]) continue;
                throw new RuntimeException(PropertyUtil.getString("TIFFImage2"));
            }
        } else {
            cArray5 = new char[]{'\u0001'};
        }
        n5 = 0;
        switch (this.sampleSize) {
            case 1: 
            case 4: 
            case 8: {
                if (cArray5[0] == '\u0003') break;
                this.dataType = 0;
                n5 = 1;
                break;
            }
            case 16: {
                if (cArray5[0] == '\u0003') break;
                this.dataType = cArray5[0] == '\u0002' ? 2 : 1;
                n5 = 1;
                break;
            }
            case 32: {
                if (cArray5[0] == '\u0003') {
                    n5 = 0;
                    break;
                }
                this.dataType = 3;
                n5 = 1;
            }
        }
        if (n5 == 0) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage3"));
        }
        TIFFField tIFFField6 = tIFFDirectory.getField(259);
        this.compression = tIFFField6 == null ? 1 : tIFFField6.getAsInt(0);
        TIFFField tIFFField7 = tIFFDirectory.getField(262);
        int n7 = tIFFField7 == null ? 0 : tIFFField7.getAsInt(0);
        this.imageType = -1;
        switch (n7) {
            case 0: {
                this.isWhiteZero = true;
            }
            case 1: {
                if (this.sampleSize == 1 && n6 == 1) {
                    this.imageType = 0;
                    break;
                }
                if (this.sampleSize == 4 && n6 == 1) {
                    this.imageType = 1;
                    break;
                }
                if (this.sampleSize % 8 != 0) break;
                if (n6 == 1) {
                    this.imageType = 2;
                    break;
                }
                if (n6 == 2) {
                    this.imageType = 3;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 2: {
                if (this.sampleSize % 8 != 0) break;
                if (n6 == 3) {
                    this.imageType = 5;
                    break;
                }
                if (n6 == 4) {
                    this.imageType = 6;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 3: {
                if (n6 != true || this.sampleSize != 4 && this.sampleSize != 8 && this.sampleSize != 16) break;
                this.imageType = 4;
                break;
            }
            case 4: {
                if (this.sampleSize != 1 || n6 != true) break;
                this.imageType = 0;
                break;
            }
            default: {
                if (this.sampleSize % 8 != 0) break;
                this.imageType = 8;
            }
        }
        if (this.imageType == -1) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage4") + ": " + this.imageType);
        }
        Rectangle rectangle = new Rectangle(0, 0, (int)tIFFDirectory.getFieldAsLong(256), (int)tIFFDirectory.getFieldAsLong(257));
        this.numBands = n6;
        TIFFField tIFFField8 = tIFFDirectory.getField(338);
        int n8 = n4 = tIFFField8 == null ? 0 : (int)tIFFField8.getAsLong(0);
        if (tIFFDirectory.getField(324) != null) {
            this.tiled = true;
            n3 = (int)tIFFDirectory.getFieldAsLong(322);
            n2 = (int)tIFFDirectory.getFieldAsLong(323);
            this.tileOffsets = tIFFDirectory.getField(324).getAsLongs();
            this.tileByteCounts = this.getFieldAsLongs(tIFFDirectory.getField(325));
        } else {
            this.tiled = false;
            n3 = tIFFDirectory.getField(322) != null ? (int)tIFFDirectory.getFieldAsLong(322) : rectangle.width;
            tIFFField = tIFFDirectory.getField(278);
            if (tIFFField == null) {
                n2 = tIFFDirectory.getField(323) != null ? (int)tIFFDirectory.getFieldAsLong(323) : rectangle.height;
            } else {
                long l = tIFFField.getAsLong(0);
                long l2 = 1L;
                n2 = l == (l2 = (l2 << 32) - 1L) ? rectangle.height : (int)l;
            }
            object2 = tIFFDirectory.getField(273);
            if (object2 == null) {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage5"));
            }
            this.tileOffsets = this.getFieldAsLongs((TIFFField)object2);
            object = tIFFDirectory.getField(279);
            if (object == null) {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage6"));
            }
            this.tileByteCounts = this.getFieldAsLongs((TIFFField)object);
        }
        this.tilesX = (rectangle.width + n3 - 1) / n3;
        this.tilesY = (rectangle.height + n2 - 1) / n2;
        this.tileSize = n3 * n2 * this.numBands;
        this.isBigEndian = tIFFDirectory.isBigEndian();
        tIFFField = tIFFDirectory.getField(266);
        this.fillOrder = tIFFField != null ? tIFFField.getAsInt(0) : 1;
        switch (this.compression) {
            case 1: 
            case 32773: {
                break;
            }
            case 32946: {
                this.inflater = new Inflater();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.sampleSize != 1) {
                    throw new RuntimeException(PropertyUtil.getString("TIFFImage7"));
                }
                if (this.compression == 3) {
                    object2 = tIFFDirectory.getField(292);
                    this.tiffT4Options = object2 != null ? ((TIFFField)object2).getAsLong(0) : 0L;
                }
                if (this.compression == 4) {
                    object2 = tIFFDirectory.getField(293);
                    this.tiffT6Options = object2 != null ? ((TIFFField)object2).getAsLong(0) : 0L;
                }
                this.decoder = new TIFFFaxDecoder(this.fillOrder, n3, n2);
                break;
            }
            case 5: {
                object2 = tIFFDirectory.getField(317);
                if (object2 == null) {
                    this.predictor = 1;
                } else {
                    this.predictor = ((TIFFField)object2).getAsInt(0);
                    if (this.predictor != 1 && this.predictor != 2) {
                        throw new RuntimeException(PropertyUtil.getString("TIFFImage8"));
                    }
                    if (this.predictor == 2 && this.sampleSize != 8) {
                        throw new RuntimeException(PropertyUtil.getString("TIFFImage9"));
                    }
                }
                this.lzwDecoder = new TIFFLZWDecoder(n3, this.predictor, n6);
                break;
            }
            case 6: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage15"));
            }
            default: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage10") + ": " + this.compression);
            }
        }
        object2 = null;
        object = null;
        switch (this.imageType) {
            case 0: 
            case 1: {
                object = new MultiPixelPackedSampleModel(this.dataType, n3, n2, this.sampleSize);
                if (this.imageType == 0) {
                    byte[] byArray = new byte[]{(byte)(this.isWhiteZero ? 255 : 0), (byte)(this.isWhiteZero ? 0 : 255)};
                    object2 = new IndexColorModel(1, 2, byArray, byArray, byArray);
                    break;
                }
                byte[] byArray = new byte[16];
                if (this.isWhiteZero) {
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = (byte)(255 - 16 * i);
                    }
                } else {
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = (byte)(16 * i);
                    }
                }
                object2 = new IndexColorModel(4, 16, byArray, byArray, byArray);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                int n9;
                int[] nArray = new int[this.numBands];
                for (n9 = 0; n9 < this.numBands; ++n9) {
                    nArray[n9] = this.numBands - 1 - n9;
                }
                object = new PixelInterleavedSampleModel(this.dataType, n3, n2, this.numBands, this.numBands * n3, nArray);
                if (this.imageType == 2) {
                    object2 = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{this.sampleSize}, false, false, 1, this.dataType);
                    break;
                }
                if (this.imageType == 5) {
                    object2 = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{this.sampleSize, this.sampleSize, this.sampleSize}, false, false, 1, this.dataType);
                    break;
                }
                n9 = 1;
                if (n4 == 1) {
                    n9 = 3;
                } else if (n4 == 2) {
                    n9 = 2;
                }
                object2 = this.createAlphaComponentColorModel(this.dataType, this.numBands, n4 == 1, n9);
                break;
            }
            case 7: 
            case 8: {
                int[] nArray = new int[this.numBands];
                for (int i = 0; i < this.numBands; ++i) {
                    nArray[i] = i;
                }
                object = new PixelInterleavedSampleModel(this.dataType, n3, n2, this.numBands, this.numBands * n3, nArray);
                object2 = null;
                break;
            }
            case 4: {
                TIFFField tIFFField9 = tIFFDirectory.getField(320);
                if (tIFFField9 == null) {
                    throw new RuntimeException(PropertyUtil.getString("TIFFImage11"));
                }
                this.colormap = tIFFField9.getAsChars();
                if (this.decodePaletteAsShorts) {
                    this.numBands = 3;
                    if (this.dataType == 0) {
                        this.dataType = 1;
                    }
                    object = TIFFImage.createPixelInterleavedSampleModel(this.dataType, n3, n2, this.numBands);
                    object2 = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{16, 16, 16}, false, false, 1, this.dataType);
                    break;
                }
                this.numBands = 1;
                if (this.sampleSize == 4) {
                    object = new MultiPixelPackedSampleModel(0, n3, n2, this.sampleSize);
                } else if (this.sampleSize == 8) {
                    object = TIFFImage.createPixelInterleavedSampleModel(0, n3, n2, this.numBands);
                } else if (this.sampleSize == 16) {
                    this.dataType = 1;
                    object = TIFFImage.createPixelInterleavedSampleModel(1, n3, n2, this.numBands);
                }
                int n10 = this.colormap.length / 3;
                byte[] byArray = new byte[n10];
                byte[] byArray2 = new byte[n10];
                byte[] byArray3 = new byte[n10];
                int n11 = n10;
                int n12 = n10 * 2;
                if (this.dataType == 2) {
                    for (int i = 0; i < n10; ++i) {
                        byArray[i] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[i]);
                        byArray2[i] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n11 + i]);
                        byArray3[i] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n12 + i]);
                    }
                } else {
                    for (int i = 0; i < n10; ++i) {
                        byArray[i] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[i] & 0xFFFF);
                        byArray2[i] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n11 + i] & 0xFFFF);
                        byArray3[i] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n12 + i] & 0xFFFF);
                    }
                }
                object2 = new IndexColorModel(this.sampleSize, n10, byArray, byArray2, byArray3);
                break;
            }
            default: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage4") + ": " + this.imageType);
            }
        }
        HashMap<String, TIFFDirectory> hashMap = new HashMap<String, TIFFDirectory>();
        hashMap.put("tiff_directory", tIFFDirectory);
        this.init((CachableRed)null, rectangle, (ColorModel)object2, (SampleModel)object, 0, 0, hashMap);
    }

    public TIFFDirectory getPrivateIFD(long l) throws IOException {
        return new TIFFDirectory(this.stream, l, 0);
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRaster(writableRaster);
        return writableRaster;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized Raster getTile(int n, int n2) {
        byte[] byArray;
        if (n < 0 || n >= this.tilesX || n2 < 0 || n2 >= this.tilesY) {
            throw new IllegalArgumentException(PropertyUtil.getString("TIFFImage12"));
        }
        byte[] byArray2 = null;
        short[] sArray = null;
        int[] nArray = null;
        SampleModel sampleModel = this.getSampleModel();
        WritableRaster writableRaster = this.makeTile(n, n2);
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n3 = sampleModel.getDataType();
        if (n3 == 0) {
            byArray2 = ((DataBufferByte)dataBuffer).getData();
        } else if (n3 == 1) {
            sArray = ((DataBufferUShort)dataBuffer).getData();
        } else if (n3 == 2) {
            sArray = ((DataBufferShort)dataBuffer).getData();
        } else if (n3 == 3) {
            nArray = ((DataBufferInt)dataBuffer).getData();
        }
        long l = 0L;
        try {
            l = this.stream.getFilePointer();
            this.stream.seek(this.tileOffsets[n2 * this.tilesX + n]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
        }
        int n4 = (int)this.tileByteCounts[n2 * this.tilesX + n];
        Rectangle rectangle = !this.tiled ? writableRaster.getBounds() : new Rectangle(writableRaster.getMinX(), writableRaster.getMinY(), this.tileWidth, this.tileHeight);
        int n5 = rectangle.width * rectangle.height * this.numBands;
        Object object = byArray = (Object)(this.compression != 1 || this.imageType == 4 ? new byte[n4] : null);
        if (this.imageType == 0) {
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    int n6 = rectangle.width % 8 == 0 ? rectangle.width / 8 * rectangle.height : (rectangle.width / 8 + 1) * rectangle.height;
                    this.decodePackbits(byArray, n6, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                } else if (this.compression == 2) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decoder.decode1D(byArray2, byArray, 0, rectangle.height);
                } else if (this.compression == 3) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decoder.decode2D(byArray2, byArray, 0, rectangle.height, this.tiffT4Options);
                } else if (this.compression == 4) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decoder.decodeT6(byArray2, byArray, 0, rectangle.height, this.tiffT6Options);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    this.inflate(byArray, byArray2);
                } else if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n4);
                }
                this.stream.seek(l);
                return writableRaster;
            }
            catch (IOException iOException) {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
            }
        }
        if (this.imageType == 4) {
            if (this.sampleSize == 16) {
                if (this.decodePaletteAsShorts) {
                    short[] sArray2 = null;
                    int n7 = n5 / 3;
                    int n8 = n7 * 2;
                    try {
                        byte[] byArray3;
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray3 = new byte[n8];
                            this.decodePackbits(byArray, n8, byArray3);
                            sArray2 = new short[n7];
                            this.interpretBytesAsShorts(byArray3, sArray2, n7);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray3 = new byte[n8];
                            this.lzwDecoder.decode(byArray, byArray3, rectangle.height);
                            sArray2 = new short[n7];
                            this.interpretBytesAsShorts(byArray3, sArray2, n7);
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray3 = new byte[n8];
                            this.inflate(byArray, byArray3);
                            sArray2 = new short[n7];
                            this.interpretBytesAsShorts(byArray3, sArray2, n7);
                        } else if (this.compression == 1) {
                            sArray2 = new short[n4 / 2];
                            this.readShorts(n4 / 2, sArray2);
                        }
                        this.stream.seek(l);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
                    }
                    if (n3 == 1) {
                        int n9 = 0;
                        int n10 = this.colormap.length / 3;
                        int n11 = n10 * 2;
                        for (int i = 0; i < n7; ++i) {
                            int n12 = sArray2[i] & 0xFFFF;
                            char c = this.colormap[n12 + n11];
                            sArray[n9++] = (short)(c & 0xFFFF);
                            c = this.colormap[n12 + n10];
                            sArray[n9++] = (short)(c & 0xFFFF);
                            c = this.colormap[n12];
                            sArray[n9++] = (short)(c & 0xFFFF);
                        }
                        return writableRaster;
                    } else {
                        if (n3 != 2) return writableRaster;
                        int n13 = 0;
                        int n14 = this.colormap.length / 3;
                        int n15 = n14 * 2;
                        for (int i = 0; i < n7; ++i) {
                            int n16 = sArray2[i] & 0xFFFF;
                            char c = this.colormap[n16 + n15];
                            sArray[n13++] = (short)c;
                            c = this.colormap[n16 + n14];
                            sArray[n13++] = (short)c;
                            c = this.colormap[n16];
                            sArray[n13++] = (short)c;
                        }
                    }
                    return writableRaster;
                }
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n4);
                        int n17 = n5 * 2;
                        byte[] byArray4 = new byte[n17];
                        this.decodePackbits(byArray, n17, byArray4);
                        this.interpretBytesAsShorts(byArray4, sArray, n5);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n4);
                        byte[] byArray5 = new byte[n5 * 2];
                        this.lzwDecoder.decode(byArray, byArray5, rectangle.height);
                        this.interpretBytesAsShorts(byArray5, sArray, n5);
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n4);
                        byte[] byArray6 = new byte[n5 * 2];
                        this.inflate(byArray, byArray6);
                        this.interpretBytesAsShorts(byArray6, sArray, n5);
                    } else if (this.compression == 1) {
                        this.readShorts(n4 / 2, sArray);
                    }
                    this.stream.seek(l);
                    return writableRaster;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
                }
            }
            if (this.sampleSize == 8) {
                if (this.decodePaletteAsShorts) {
                    byte[] byArray7 = null;
                    int n18 = n5 / 3;
                    try {
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray7 = new byte[n18];
                            this.decodePackbits(byArray, n18, byArray7);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray7 = new byte[n18];
                            this.lzwDecoder.decode(byArray, byArray7, rectangle.height);
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray7 = new byte[n18];
                            this.inflate(byArray, byArray7);
                        } else {
                            if (this.compression != 1) throw new RuntimeException(PropertyUtil.getString("IFFImage10") + ": " + this.compression);
                            byArray7 = new byte[n4];
                            this.stream.readFully(byArray7, 0, n4);
                        }
                        this.stream.seek(l);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
                    }
                    int n19 = 0;
                    int n20 = this.colormap.length / 3;
                    int n21 = n20 * 2;
                    for (int i = 0; i < n18; ++i) {
                        int n22 = byArray7[i] & 0xFF;
                        char c = this.colormap[n22 + n21];
                        sArray[n19++] = (short)(c & 0xFFFF);
                        c = this.colormap[n22 + n20];
                        sArray[n19++] = (short)(c & 0xFFFF);
                        c = this.colormap[n22];
                        sArray[n19++] = (short)(c & 0xFFFF);
                    }
                    return writableRaster;
                }
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n4);
                        this.decodePackbits(byArray, n5, byArray2);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n4);
                        this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n4);
                        this.inflate(byArray, byArray2);
                    } else {
                        if (this.compression != 1) throw new RuntimeException(PropertyUtil.getString("TIFFImage10") + ": " + this.compression);
                        this.stream.readFully(byArray2, 0, n4);
                    }
                    this.stream.seek(l);
                    return writableRaster;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
                }
            }
            if (this.sampleSize != 4) return writableRaster;
            int n23 = rectangle.width % 2 == 0 ? 0 : 1;
            int n24 = (rectangle.width / 2 + n23) * rectangle.height;
            if (this.decodePaletteAsShorts) {
                int n25;
                int n26;
                byte[] byArray8 = null;
                try {
                    this.stream.readFully(byArray, 0, n4);
                    this.stream.seek(l);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
                }
                if (this.compression == 32773) {
                    byArray8 = new byte[n24];
                    this.decodePackbits(byArray, n24, byArray8);
                } else if (this.compression == 5) {
                    byArray8 = new byte[n24];
                    this.lzwDecoder.decode(byArray, byArray8, rectangle.height);
                } else if (this.compression == 32946) {
                    byArray8 = new byte[n24];
                    this.inflate(byArray, byArray8);
                } else if (this.compression == 1) {
                    byArray8 = byArray;
                }
                int n27 = n5 / 3;
                byArray = new byte[n27];
                int n28 = 0;
                int n29 = 0;
                for (n26 = 0; n26 < rectangle.height; ++n26) {
                    for (n25 = 0; n25 < rectangle.width / 2; ++n25) {
                        byArray[n29++] = (byte)((byArray8[n28] & 0xF0) >> 4);
                        byArray[n29++] = (byte)(byArray8[n28++] & 0xF);
                    }
                    if (n23 != 1) continue;
                    byArray[n29++] = (byte)((byArray8[n28++] & 0xF0) >> 4);
                }
                n26 = this.colormap.length / 3;
                n25 = n26 * 2;
                int n30 = 0;
                for (int i = 0; i < n27; ++i) {
                    int n31 = byArray[i] & 0xFF;
                    char c = this.colormap[n31 + n25];
                    sArray[n30++] = (short)(c & 0xFFFF);
                    c = this.colormap[n31 + n26];
                    sArray[n30++] = (short)(c & 0xFFFF);
                    c = this.colormap[n31];
                    sArray[n30++] = (short)(c & 0xFFFF);
                }
                return writableRaster;
            }
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decodePackbits(byArray, n24, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    this.inflate(byArray, byArray2);
                } else if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n4);
                }
                this.stream.seek(l);
                return writableRaster;
            }
            catch (IOException iOException) {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
            }
        }
        if (this.imageType == 1) {
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    int n32 = rectangle.width % 8 == 0 ? rectangle.width / 2 * rectangle.height : (rectangle.width / 2 + 1) * rectangle.height;
                    this.decodePackbits(byArray, n32, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    this.inflate(byArray, byArray2);
                } else {
                    this.stream.readFully(byArray2, 0, n4);
                }
                this.stream.seek(l);
                return writableRaster;
            }
            catch (IOException iOException) {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
            }
        }
        try {
            byte[] byArray9;
            if (this.sampleSize == 8) {
                if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n4);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decodePackbits(byArray, n5, byArray2);
                } else {
                    if (this.compression != 32946) throw new RuntimeException(PropertyUtil.getString("TIFFImage10") + ": " + this.compression);
                    this.stream.readFully(byArray, 0, n4);
                    this.inflate(byArray, byArray2);
                }
            } else if (this.sampleSize == 16) {
                if (this.compression == 1) {
                    this.readShorts(n4 / 2, sArray);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    byte[] byArray10 = new byte[n5 * 2];
                    this.lzwDecoder.decode(byArray, byArray10, rectangle.height);
                    this.interpretBytesAsShorts(byArray10, sArray, n5);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    int n33 = n5 * 2;
                    byArray9 = new byte[n33];
                    this.decodePackbits(byArray, n33, byArray9);
                    this.interpretBytesAsShorts(byArray9, sArray, n5);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    byte[] byArray11 = new byte[n5 * 2];
                    this.inflate(byArray, byArray11);
                    this.interpretBytesAsShorts(byArray11, sArray, n5);
                }
            } else if (this.sampleSize == 32 && n3 == 3) {
                if (this.compression == 1) {
                    this.readInts(n4 / 4, nArray);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    byte[] byArray12 = new byte[n5 * 4];
                    this.lzwDecoder.decode(byArray, byArray12, rectangle.height);
                    this.interpretBytesAsInts(byArray12, nArray, n5);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    int n34 = n5 * 4;
                    byArray9 = new byte[n34];
                    this.decodePackbits(byArray, n34, byArray9);
                    this.interpretBytesAsInts(byArray9, nArray, n5);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    byte[] byArray13 = new byte[n5 * 4];
                    this.inflate(byArray, byArray13);
                    this.interpretBytesAsInts(byArray13, nArray, n5);
                }
            }
            this.stream.seek(l);
        }
        catch (IOException iOException) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
        }
        switch (this.imageType) {
            case 2: 
            case 3: {
                if (!this.isWhiteZero) return writableRaster;
                if (n3 == 0 && !(this.getColorModel() instanceof IndexColorModel)) {
                    for (int i = 0; i < byArray2.length; i += this.numBands) {
                        byArray2[i] = (byte)(255 - byArray2[i]);
                    }
                    return writableRaster;
                } else if (n3 == 1) {
                    int n35 = 65535;
                    for (int i = 0; i < sArray.length; i += this.numBands) {
                        sArray[i] = (short)(n35 - sArray[i]);
                    }
                    return writableRaster;
                } else if (n3 == 2) {
                    for (int i = 0; i < sArray.length; i += this.numBands) {
                        sArray[i] = ~sArray[i];
                    }
                    return writableRaster;
                } else {
                    if (n3 != 3) return writableRaster;
                    long l2 = 0xFFFFFFFFL;
                    for (int i = 0; i < nArray.length; i += this.numBands) {
                        nArray[i] = (int)(l2 - (long)nArray[i]);
                    }
                }
                return writableRaster;
            }
            case 5: {
                if (this.sampleSize == 8 && this.compression != 7) {
                    for (int i = 0; i < n5; i += 3) {
                        byte by = byArray2[i];
                        byArray2[i] = byArray2[i + 2];
                        byArray2[i + 2] = by;
                    }
                    return writableRaster;
                } else if (this.sampleSize == 16) {
                    for (int i = 0; i < n5; i += 3) {
                        short s = sArray[i];
                        sArray[i] = sArray[i + 2];
                        sArray[i + 2] = s;
                    }
                    return writableRaster;
                } else {
                    if (this.sampleSize != 32 || n3 != 3) return writableRaster;
                    for (int i = 0; i < n5; i += 3) {
                        int n36 = nArray[i];
                        nArray[i] = nArray[i + 2];
                        nArray[i + 2] = n36;
                    }
                }
                return writableRaster;
            }
            case 6: {
                if (this.sampleSize == 8) {
                    for (int i = 0; i < n5; i += 4) {
                        byte by = byArray2[i];
                        byArray2[i] = byArray2[i + 3];
                        byArray2[i + 3] = by;
                        by = byArray2[i + 1];
                        byArray2[i + 1] = byArray2[i + 2];
                        byArray2[i + 2] = by;
                    }
                    return writableRaster;
                } else if (this.sampleSize == 16) {
                    for (int i = 0; i < n5; i += 4) {
                        short s = sArray[i];
                        sArray[i] = sArray[i + 3];
                        sArray[i + 3] = s;
                        s = sArray[i + 1];
                        sArray[i + 1] = sArray[i + 2];
                        sArray[i + 2] = s;
                    }
                    return writableRaster;
                } else {
                    if (this.sampleSize != 32 || n3 != 3) return writableRaster;
                    for (int i = 0; i < n5; i += 4) {
                        int n37 = nArray[i];
                        nArray[i] = nArray[i + 3];
                        nArray[i + 3] = n37;
                        n37 = nArray[i + 1];
                        nArray[i + 1] = nArray[i + 2];
                        nArray[i + 2] = n37;
                    }
                }
                return writableRaster;
            }
            case 7: {
                int n38 = this.chromaSubH * this.chromaSubV;
                int n39 = rectangle.width / this.chromaSubH;
                int n40 = rectangle.height / this.chromaSubV;
                byte[] byArray14 = new byte[n39 * n40 * (n38 + 2)];
                System.arraycopy(byArray2, 0, byArray14, 0, byArray14.length);
                int n41 = n38 * 3;
                int[] nArray2 = new int[n41];
                int n42 = 0;
                int n43 = n38;
                int n44 = n43 + 1;
                int n45 = rectangle.y;
                for (int i = 0; i < n40; ++i) {
                    int n46 = rectangle.x;
                    for (int j = 0; j < n39; ++j) {
                        int n47 = byArray14[n42 + n43];
                        int n48 = byArray14[n42 + n44];
                        int n49 = 0;
                        while (n49 < n41) {
                            nArray2[n49++] = byArray14[n42++];
                            nArray2[n49++] = n47;
                            nArray2[n49++] = n48;
                        }
                        n42 += 2;
                        writableRaster.setPixels(n46, n45, this.chromaSubH, this.chromaSubV, nArray2);
                        n46 += this.chromaSubH;
                    }
                    n45 += this.chromaSubV;
                }
                return writableRaster;
            }
        }
        return writableRaster;
    }

    private void readShorts(int n, short[] sArray) {
        int n2 = 2 * n;
        byte[] byArray = new byte[n2];
        try {
            this.stream.readFully(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
        }
        this.interpretBytesAsShorts(byArray, sArray, n);
    }

    private void readInts(int n, int[] nArray) {
        int n2 = 4 * n;
        byte[] byArray = new byte[n2];
        try {
            this.stream.readFully(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
        }
        this.interpretBytesAsInts(byArray, nArray, n);
    }

    private void interpretBytesAsShorts(byte[] byArray, short[] sArray, int n) {
        int n2 = 0;
        if (this.isBigEndian) {
            for (int i = 0; i < n; ++i) {
                int n3 = byArray[n2++] & 0xFF;
                int n4 = byArray[n2++] & 0xFF;
                sArray[i] = (short)((n3 << 8) + n4);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n5 = byArray[n2++] & 0xFF;
                int n6 = byArray[n2++] & 0xFF;
                sArray[i] = (short)((n6 << 8) + n5);
            }
        }
    }

    private void interpretBytesAsInts(byte[] byArray, int[] nArray, int n) {
        int n2 = 0;
        if (this.isBigEndian) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                nArray[i] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private byte[] decodePackbits(byte[] byArray, int n, byte[] byArray2) {
        if (byArray2 == null) {
            byArray2 = new byte[n];
        }
        int n2 = 0;
        int n3 = 0;
        try {
            block2: while (n3 < n) {
                int n4;
                byte by;
                if ((by = byArray[n2++]) >= 0 && by <= 127) {
                    n4 = 0;
                    while (true) {
                        if (n4 >= by + 1) continue block2;
                        byArray2[n3++] = byArray[n2++];
                        ++n4;
                    }
                }
                if (by <= -1 && by >= -127) {
                    byte by2 = byArray[n2++];
                    n4 = 0;
                    while (true) {
                        if (n4 >= -by + 1) continue block2;
                        byArray2[n3++] = by2;
                        ++n4;
                    }
                }
                ++n2;
            }
            return byArray2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage14") + ": " + arrayIndexOutOfBoundsException.getMessage());
        }
    }

    private ComponentColorModel createAlphaComponentColorModel(int n, int n2, boolean bl, int n3) {
        ComponentColorModel componentColorModel = null;
        int[] nArray = null;
        ColorSpace colorSpace = null;
        switch (n2) {
            case 2: {
                colorSpace = ColorSpace.getInstance(1003);
                break;
            }
            case 4: {
                colorSpace = ColorSpace.getInstance(1000);
                break;
            }
            default: {
                throw new IllegalArgumentException(PropertyUtil.getString("TIFFImage19") + ": " + n2);
            }
        }
        int n4 = 0;
        switch (n) {
            case 0: {
                n4 = 8;
                break;
            }
            case 1: 
            case 2: {
                n4 = 16;
                break;
            }
            case 3: {
                n4 = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException(PropertyUtil.getString("TIFFImage20") + ": " + n);
            }
        }
        nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n4;
        }
        componentColorModel = new ComponentColorModel(colorSpace, nArray, true, bl, n3, n);
        return componentColorModel;
    }
}

