/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.tiff;

import java.awt.color.ColorSpace;
import org.apache.xmlgraphics.image.codec.tiff.TIFFEncodeParam;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;

enum ImageType {
    UNSUPPORTED(-1),
    BILEVEL_WHITE_IS_ZERO(0),
    BILEVEL_BLACK_IS_ZERO(1),
    GRAY(1),
    PALETTE(3),
    RGB(2),
    CMYK(5),
    YCBCR(6),
    CIELAB(8),
    GENERIC(1);

    private final int photometricInterpretation;

    private ImageType(int n2) {
        this.photometricInterpretation = n2;
    }

    int getPhotometricInterpretation() {
        return this.photometricInterpretation;
    }

    static ImageType getTypeFromRGB(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        if (n3 == 1) {
            if (n2 == 1) {
                if (n != 2) {
                    throw new IllegalArgumentException(PropertyUtil.getString("TIFFImageEncoder7"));
                }
                if (ImageType.isBlackZero(byArray, byArray2, byArray3)) {
                    return BILEVEL_BLACK_IS_ZERO;
                }
                if (ImageType.isWhiteZero(byArray, byArray2, byArray3)) {
                    return BILEVEL_WHITE_IS_ZERO;
                }
            }
            return PALETTE;
        }
        return UNSUPPORTED;
    }

    private static boolean rgbIsValueAt(byte[] byArray, byte[] byArray2, byte[] byArray3, byte by, int n) {
        return byArray[n] == by && byArray2[n] == by && byArray3[n] == by;
    }

    private static boolean bilevelColorValue(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2) {
        return ImageType.rgbIsValueAt(byArray, byArray2, byArray3, (byte)n, 0) && ImageType.rgbIsValueAt(byArray, byArray2, byArray3, (byte)n2, 1);
    }

    private static boolean isBlackZero(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return ImageType.bilevelColorValue(byArray, byArray2, byArray3, 0, 255);
    }

    private static boolean isWhiteZero(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return ImageType.bilevelColorValue(byArray, byArray2, byArray3, 255, 0);
    }

    static ImageType getTypeFromColorSpace(ColorSpace colorSpace, TIFFEncodeParam tIFFEncodeParam) {
        switch (colorSpace.getType()) {
            case 9: {
                return CMYK;
            }
            case 6: {
                return GRAY;
            }
            case 1: {
                return CIELAB;
            }
            case 5: {
                if (tIFFEncodeParam.getJPEGCompressRGBToYCbCr()) {
                    return YCBCR;
                }
                return RGB;
            }
            case 3: {
                return YCBCR;
            }
        }
        return GENERIC;
    }
}

