/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.png;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlgraphics.image.codec.png.CRC;

class IDATOutputStream
extends FilterOutputStream {
    private static final byte[] TYPE_SIGNATURE = new byte[]{73, 68, 65, 84};
    private int bytesWritten;
    private int segmentLength;
    private byte[] buffer;

    public IDATOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.segmentLength = n;
        this.buffer = new byte[n];
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    private void writeInt(int n) throws IOException {
        this.out.write(n >> 24);
        this.out.write(n >> 16 & 0xFF);
        this.out.write(n >> 8 & 0xFF);
        this.out.write(n & 0xFF);
    }

    @Override
    public void flush() throws IOException {
        if (this.bytesWritten == 0) {
            return;
        }
        this.writeInt(this.bytesWritten);
        this.out.write(TYPE_SIGNATURE);
        this.out.write(this.buffer, 0, this.bytesWritten);
        int n = -1;
        n = CRC.updateCRC(n, TYPE_SIGNATURE, 0, 4);
        n = CRC.updateCRC(n, this.buffer, 0, this.bytesWritten);
        this.writeInt(~n);
        this.bytesWritten = 0;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = Math.min(this.segmentLength - this.bytesWritten, n2);
            System.arraycopy(byArray, n, this.buffer, this.bytesWritten, n3);
            n += n3;
            n2 -= n3;
            this.bytesWritten += n3;
            if (this.bytesWritten != this.segmentLength) continue;
            this.flush();
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.buffer[this.bytesWritten++] = (byte)n;
        if (this.bytesWritten == this.segmentLength) {
            this.flush();
        }
    }
}

