/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.logger;

import org.apache.avalon.framework.ExceptionUtil;
import org.apache.avalon.framework.logger.Logger;
import org.apache.log.LogEvent;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.util.StackIntrospector;

public class AvalonFormatter
extends ExtendedPatternFormatter {
    private static final int TYPE_CLASS = 9;
    private static final String TYPE_CLASS_STR = "class";
    private static final String TYPE_CLASS_SHORT_STR = "short";
    public static final int DEFAULT_STACK_DEPTH = 8;
    public static final boolean DEFAULT_PRINT_CASCADING = true;
    private final int m_stackDepth;
    private final boolean m_printCascading;

    public AvalonFormatter(String string) {
        this(string, 8, true);
    }

    public AvalonFormatter(String string, int n, boolean bl) {
        super(string);
        this.m_stackDepth = n;
        this.m_printCascading = bl;
    }

    protected String getStackTrace(Throwable throwable, String string) {
        if (null == throwable) {
            return "";
        }
        return ExceptionUtil.printStackTrace(throwable, this.m_stackDepth, this.m_printCascading);
    }

    protected int getTypeIdFor(String string) {
        if (string.equalsIgnoreCase(TYPE_CLASS_STR)) {
            return 9;
        }
        return super.getTypeIdFor(string);
    }

    protected String formatPatternRun(LogEvent logEvent, PatternFormatter.PatternRun patternRun) {
        switch (patternRun.m_type) {
            case 9: {
                return this.getClass(patternRun.m_format);
            }
        }
        return super.formatPatternRun(logEvent, patternRun);
    }

    private String getClass(String string) {
        int n;
        Class clazz = StackIntrospector.getCallerClass(Logger.class);
        if (null == clazz) {
            return "Unknown-class";
        }
        String string2 = clazz.getName();
        if (TYPE_CLASS_SHORT_STR.equalsIgnoreCase(string) && (n = string2.lastIndexOf(46)) >= 0) {
            string2 = string2.substring(n + 1);
        }
        return string2;
    }
}

