/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnusedImportsCheck
extends Check {
    private static final Pattern CLASS_NAME = Pattern.compile("((:?[\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)");
    private static final Pattern FIRST_CLASS_NAME = Pattern.compile("^" + CLASS_NAME);
    private static final Pattern ARGUMENT_NAME = Pattern.compile("[(,]\\s*" + CLASS_NAME.pattern());
    private boolean mCollect;
    private boolean mProcessJavadoc;
    private final Set<FullIdent> mImports = Sets.newHashSet();
    private final Set<String> mReferenced = Sets.newHashSet();

    public void setProcessJavadoc(boolean aValue) {
        this.mProcessJavadoc = aValue;
    }

    @Override
    public void beginTree(DetailAST aRootAST) {
        this.mCollect = false;
        this.mImports.clear();
        this.mReferenced.clear();
    }

    @Override
    public void finishTree(DetailAST aRootAST) {
        for (FullIdent imp : this.mImports) {
            if (this.mReferenced.contains(Utils.baseClassname(imp.getText()))) continue;
            this.log(imp.getLineNo(), imp.getColumnNo(), "import.unused", imp.getText());
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{59, 31, 156, 16, 161, 165, 158, 159, 14, 15, 9, 8, 10};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 59) {
            if (this.mCollect) {
                this.processIdent(aAST);
            }
        } else if (aAST.getType() == 31) {
            this.processImport(aAST);
        } else if (aAST.getType() == 156) {
            this.processStaticImport(aAST);
        } else {
            this.mCollect = true;
            if (this.mProcessJavadoc) {
                this.processJavadoc(aAST);
            }
        }
    }

    private void processIdent(DetailAST aAST) {
        DetailAST parent = aAST.getParent();
        int parentType = parent.getType();
        if (parentType != 60 && parentType != 9 || parentType == 60 && aAST.getNextSibling() != null) {
            this.mReferenced.add(aAST.getText());
        }
    }

    private void processImport(DetailAST aAST) {
        FullIdent name = FullIdent.createFullIdentBelow(aAST);
        if (name != null && !name.getText().endsWith(".*")) {
            this.mImports.add(name);
        }
    }

    private void processStaticImport(DetailAST aAST) {
        FullIdent name = FullIdent.createFullIdent(aAST.getFirstChild().getNextSibling());
        if (name != null && !name.getText().endsWith(".*")) {
            this.mImports.add(name);
        }
    }

    private void processJavadoc(DetailAST aAST) {
        int lineNo;
        FileContents contents = this.getFileContents();
        TextBlock cmt = contents.getJavadocBefore(lineNo = aAST.getLineNo());
        if (cmt != null) {
            this.mReferenced.addAll(this.processJavadoc(cmt));
        }
    }

    private Set<String> processJavadoc(TextBlock aCmt) {
        HashSet<String> references = new HashSet<String>();
        for (JavadocTag tag : this.getValidTags(aCmt, JavadocUtils.JavadocTagType.INLINE)) {
            if (!tag.canReferenceImports()) continue;
            references.addAll(this.processJavadocTag(tag));
        }
        for (JavadocTag tag : this.getValidTags(aCmt, JavadocUtils.JavadocTagType.BLOCK)) {
            if (!tag.canReferenceImports()) continue;
            references.addAll(this.matchPattern(tag.getArg1(), FIRST_CLASS_NAME));
        }
        return references;
    }

    private List<JavadocTag> getValidTags(TextBlock aCmt, JavadocUtils.JavadocTagType aTagType) {
        return JavadocUtils.getJavadocTags(aCmt, aTagType).getValidTags();
    }

    private Set<String> processJavadocTag(JavadocTag aTag) {
        HashSet<String> references = new HashSet<String>();
        String identifier = aTag.getArg1().trim();
        for (Pattern pattern : new Pattern[]{FIRST_CLASS_NAME, ARGUMENT_NAME}) {
            references.addAll(this.matchPattern(identifier, pattern));
        }
        return references;
    }

    private Set<String> matchPattern(String aIdentifier, Pattern aPattern) {
        HashSet<String> references = new HashSet<String>();
        Matcher matcher = aPattern.matcher(aIdentifier);
        while (matcher.find()) {
            references.add(matcher.group(1));
        }
        return references;
    }
}

