/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessages;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.Set;

public abstract class Check
extends AbstractViolationReporter {
    private static final int DEFAULT_TAB_WIDTH = 8;
    private FileContents mFileContents;
    private final Set<String> mTokens = Sets.newHashSet();
    private LocalizedMessages mMessages;
    private int mTabWidth = 8;
    private ClassLoader mLoader;

    public boolean isCommentNodesRequired() {
        return false;
    }

    public abstract int[] getDefaultTokens();

    public int[] getAcceptableTokens() {
        int[] defaultTokens = this.getDefaultTokens();
        int[] copy = new int[defaultTokens.length];
        System.arraycopy(defaultTokens, 0, copy, 0, defaultTokens.length);
        return copy;
    }

    public int[] getRequiredTokens() {
        return new int[0];
    }

    public final void setTokens(String[] aStrRep) {
        for (String s : aStrRep) {
            this.mTokens.add(s);
        }
    }

    public final Set<String> getTokenNames() {
        return this.mTokens;
    }

    public final void setMessages(LocalizedMessages aMessages) {
        this.mMessages = aMessages;
    }

    public void init() {
    }

    public void destroy() {
    }

    public void beginTree(DetailAST aRootAST) {
    }

    public void finishTree(DetailAST aRootAST) {
    }

    public void visitToken(DetailAST aAST) {
    }

    public void leaveToken(DetailAST aAST) {
    }

    public final String[] getLines() {
        return this.getFileContents().getLines();
    }

    public final String getLine(int aIndex) {
        return this.getFileContents().getLine(aIndex);
    }

    public final void setFileContents(FileContents aContents) {
        this.mFileContents = aContents;
    }

    public final FileContents getFileContents() {
        return this.mFileContents;
    }

    public final void setClassLoader(ClassLoader aLoader) {
        this.mLoader = aLoader;
    }

    public final ClassLoader getClassLoader() {
        return this.mLoader;
    }

    protected final int getTabWidth() {
        return this.mTabWidth;
    }

    public final void setTabWidth(int aTabWidth) {
        this.mTabWidth = aTabWidth;
    }

    @Override
    public final void log(int aLine, String aKey, Object ... aArgs) {
        this.mMessages.add(new LocalizedMessage(aLine, this.getMessageBundle(), aKey, aArgs, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(aKey)));
    }

    @Override
    public final void log(int aLineNo, int aColNo, String aKey, Object ... aArgs) {
        int col = 1 + Utils.lengthExpandedTabs(this.getLines()[aLineNo - 1], aColNo, this.getTabWidth());
        this.mMessages.add(new LocalizedMessage(aLineNo, col, this.getMessageBundle(), aKey, aArgs, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(aKey)));
    }
}

