/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javajs.api.GenericColor;
import javajs.util.CU;
import javajs.util.Lst;
import jspecview.api.JSVPanel;
import jspecview.common.PanelData;
import jspecview.common.Parameters;
import jspecview.common.ScriptToken;

public abstract class ColorParameters
extends Parameters {
    public String titleFontName;
    public String displayFontName;
    public Map<ScriptToken, GenericColor> elementColors;
    public GenericColor[] plotColors;
    public boolean isDefault;
    public static GenericColor BLACK;
    public static GenericColor RED;
    public static GenericColor LIGHT_GRAY;
    public static GenericColor DARK_GRAY;
    public static GenericColor BLUE;
    public static GenericColor WHITE;
    public static final GenericColor[] defaultPlotColors;
    public static final String[] defaultPlotColorNames;

    protected abstract GenericColor getColor3(int var1, int var2, int var3);

    protected abstract GenericColor getColor1(int var1);

    protected abstract boolean isValidFontName(String var1);

    public ColorParameters() {
        BLACK = this.getColor3(0, 0, 0);
        RED = this.getColor3(255, 0, 0);
        LIGHT_GRAY = this.getColor3(200, 200, 200);
        DARK_GRAY = this.getColor3(80, 80, 80);
        BLUE = this.getColor3(0, 0, 255);
        WHITE = this.getColor3(255, 255, 255);
        this.elementColors = new Hashtable<ScriptToken, GenericColor>();
        this.setColor(ScriptToken.TITLECOLOR, BLACK);
        this.setColor(ScriptToken.UNITSCOLOR, RED);
        this.setColor(ScriptToken.SCALECOLOR, BLACK);
        this.setColor(ScriptToken.COORDINATESCOLOR, RED);
        this.setColor(ScriptToken.GRIDCOLOR, LIGHT_GRAY);
        this.setColor(ScriptToken.PLOTCOLOR, BLUE);
        this.setColor(ScriptToken.PLOTAREACOLOR, WHITE);
        this.setColor(ScriptToken.BACKGROUNDCOLOR, this.getColor3(192, 192, 192));
        this.setColor(ScriptToken.INTEGRALPLOTCOLOR, RED);
        this.setColor(ScriptToken.PEAKTABCOLOR, RED);
        this.setColor(ScriptToken.HIGHLIGHTCOLOR, DARK_GRAY);
        for (int i = 0; i < 8; ++i) {
            ColorParameters.defaultPlotColors[i] = this.getColorFromString(defaultPlotColorNames[i]);
        }
        this.plotColors = new GenericColor[8];
        System.arraycopy(defaultPlotColors, 0, this.plotColors, 0, 8);
    }

    public void setFor(JSVPanel jsvp, ColorParameters ds, boolean includeMeasures) {
        PanelData pd;
        if (ds == null) {
            ds = this;
        }
        if (includeMeasures) {
            jsvp.getPanelData().setBooleans(ds, null);
        }
        if ((pd = jsvp.getPanelData()).getCurrentPlotColor(1) != null) {
            pd.setPlotColors(this.plotColors);
        }
        pd.setColorOrFont(ds, null);
    }

    public void set(PanelData pd, ScriptToken st, String value) {
        Object param = null;
        switch (st) {
            default: {
                this.setP(pd, st, value);
                return;
            }
            case PLOTCOLORS: {
                if (pd == null) {
                    this.getPlotColors(value);
                } else {
                    pd.setPlotColors(this.getPlotColors(value));
                }
                return;
            }
            case BACKGROUNDCOLOR: 
            case COORDINATESCOLOR: 
            case GRIDCOLOR: 
            case HIGHLIGHTCOLOR: 
            case INTEGRALPLOTCOLOR: 
            case PEAKTABCOLOR: 
            case PLOTAREACOLOR: 
            case PLOTCOLOR: 
            case SCALECOLOR: 
            case TITLECOLOR: 
            case UNITSCOLOR: {
                param = this.setColorFromString(st, value);
                break;
            }
            case TITLEFONTNAME: 
            case DISPLAYFONTNAME: {
                param = this.getFontName(st, value);
            }
        }
        if (pd == null) {
            return;
        }
        if (param != null) {
            pd.setColorOrFont(this, st);
        }
    }

    public GenericColor getElementColor(ScriptToken st) {
        return this.elementColors.get((Object)st);
    }

    public GenericColor setColor(ScriptToken st, GenericColor color) {
        if (color != null) {
            this.elementColors.put(st, color);
        }
        return color;
    }

    public abstract ColorParameters copy(String var1);

    public ColorParameters copy() {
        return this.copy(this.name);
    }

    public ColorParameters setElementColors(ColorParameters p) {
        this.displayFontName = p.displayFontName;
        for (Map.Entry<ScriptToken, GenericColor> entry : p.elementColors.entrySet()) {
            this.setColor(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public GenericColor getColorFromString(String name) {
        return this.getColor1(CU.getArgbFromString((String)name));
    }

    protected GenericColor[] getPlotColors(String plotColorsStr) {
        if (plotColorsStr == null) {
            this.plotColors[0] = this.getElementColor(ScriptToken.PLOTCOLOR);
            return this.plotColors;
        }
        StringTokenizer st = new StringTokenizer(plotColorsStr, ",;.- ");
        Lst colors = new Lst();
        try {
            while (st.hasMoreTokens()) {
                colors.addLast((Object)this.getColorFromString(st.nextToken()));
            }
        }
        catch (Exception e) {
            return null;
        }
        return (GenericColor[])colors.toArray((Object[])new GenericColor[colors.size()]);
    }

    protected GenericColor setColorFromString(ScriptToken st, String value) {
        return this.setColor(st, this.getColorFromString(value));
    }

    public String getFontName(ScriptToken st, String value) {
        boolean isValid = this.isValidFontName(value);
        switch (st) {
            case TITLEFONTNAME: {
                return isValid ? (this.titleFontName = value) : this.titleFontName;
            }
            case DISPLAYFONTNAME: {
                return isValid ? (this.displayFontName = value) : this.displayFontName;
            }
        }
        return null;
    }

    static {
        defaultPlotColors = new GenericColor[8];
        defaultPlotColorNames = new String[]{"black", "darkGreen", "darkred", "orange", "magenta", "cyan", "maroon", "darkGray"};
    }
}

