/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import org.apache.xmlgraphics.java2d.color.ColorSpaceOrigin;
import org.apache.xmlgraphics.java2d.color.RenderingIntent;

public class ICCColorSpaceWithIntent
extends ICC_ColorSpace
implements ColorSpaceOrigin {
    private static final long serialVersionUID = -3338065900662625221L;
    static final ColorSpace SRGB = ColorSpace.getInstance(1000);
    private RenderingIntent intent;
    private String profileName;
    private String profileURI;

    public ICCColorSpaceWithIntent(ICC_Profile iCC_Profile, RenderingIntent renderingIntent, String string, String string2) {
        super(iCC_Profile);
        this.intent = renderingIntent;
        if (renderingIntent != RenderingIntent.AUTO) {
            byte[] byArray = iCC_Profile.getData(1751474532);
            byArray[64] = (byte)renderingIntent.getIntegerValue();
        }
        this.profileName = string;
        this.profileURI = string2;
    }

    public float[] intendedToRGB(float[] fArray) {
        switch (this.intent) {
            case ABSOLUTE_COLORIMETRIC: {
                return this.absoluteColorimetricToRGB(fArray);
            }
            case PERCEPTUAL: 
            case AUTO: {
                return this.perceptualToRGB(fArray);
            }
            case RELATIVE_COLORIMETRIC: {
                return this.relativeColorimetricToRGB(fArray);
            }
            case SATURATION: {
                return this.saturationToRGB(fArray);
            }
        }
        throw new RuntimeException("invalid intent:" + (Object)((Object)this.intent));
    }

    private float[] perceptualToRGB(float[] fArray) {
        return this.toRGB(fArray);
    }

    private float[] relativeColorimetricToRGB(float[] fArray) {
        float[] fArray2 = this.toCIEXYZ(fArray);
        return SRGB.fromCIEXYZ(fArray2);
    }

    private float[] absoluteColorimetricToRGB(float[] fArray) {
        return this.perceptualToRGB(fArray);
    }

    private float[] saturationToRGB(float[] fArray) {
        return this.perceptualToRGB(fArray);
    }

    @Override
    public String getProfileName() {
        return this.profileName;
    }

    @Override
    public String getProfileURI() {
        return this.profileURI;
    }
}

