/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.codec.tiff.TIFFDirectory;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.codec.util.SeekableStream;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;
import org.apache.xmlgraphics.image.loader.impl.JPEGConstants;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.image.loader.util.SeekableStreamAdapter;
import org.apache.xmlgraphics.io.XmlSourceUtil;
import org.apache.xmlgraphics.util.io.SubInputStream;

public class ImageLoaderRawCCITTFax
extends AbstractImageLoader
implements JPEGConstants {
    private static final int COMPRESSION_CCITT_1D = 2;
    private static final int COMPRESSION_FAX_GROUP3 = 3;
    private static final int COMPRESSION_FAX_GROUP4 = 4;
    protected static final Log log = LogFactory.getLog(ImageLoaderRawCCITTFax.class);

    @Override
    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.RAW_CCITTFAX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image loadImage(ImageInfo imageInfo, Map map, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        long l;
        long l2;
        Object object;
        InputStream inputStream;
        if (!"image/tiff".equals(imageInfo.getMimeType())) {
            throw new IllegalArgumentException("ImageInfo must be from a image with MIME type: image/tiff");
        }
        int n = 1;
        int n2 = 1;
        Source source = imageSessionContext.needSource(imageInfo.getOriginalURI());
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        imageInputStream.mark();
        try {
            int n3;
            inputStream = new SeekableStreamAdapter(imageInputStream);
            TIFFDirectory tIFFDirectory = new TIFFDirectory((SeekableStream)inputStream, 0);
            object = tIFFDirectory.getField(259);
            if (object != null) {
                n2 = ((TIFFField)object).getAsInt(0);
                switch (n2) {
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 3: {
                        long l3;
                        n2 = 2;
                        object = tIFFDirectory.getField(292);
                        if (object == null || ((l3 = ((TIFFField)object).getAsLong(0)) & 1L) == 0L) break;
                        n2 = 3;
                        break;
                    }
                    default: {
                        log.debug((Object)("Unsupported compression " + n2));
                        throw new ImageException("ImageLoader doesn't support TIFF compression: " + n2);
                    }
                }
            }
            if ((object = tIFFDirectory.getField(266)) != null) {
                n = ((TIFFField)object).getAsInt(0);
            }
            if ((n3 = (object = tIFFDirectory.getField(278)) == null ? 1 : (int)((long)imageInfo.getSize().getHeightPx() / ((TIFFField)object).getAsLong(0))) > 1) {
                log.debug((Object)"More than one strip found in TIFF image.");
                throw new ImageException("ImageLoader doesn't support multiple strips");
            }
            l2 = tIFFDirectory.getField(273).getAsLong(0);
            l = tIFFDirectory.getField(279).getAsLong(0);
        }
        finally {
            imageInputStream.reset();
        }
        imageInputStream.seek(l2);
        inputStream = new SubInputStream(XmlSourceUtil.needInputStream(source), l, true);
        if (n == 2) {
            inputStream = new FillOrderChangeInputStream(inputStream);
        }
        object = new ImageRawCCITTFax(imageInfo, inputStream, n2);
        XmlSourceUtil.removeStreams(source);
        return object;
    }

    private static class FillOrderChangeInputStream
    extends FilterInputStream {
        private static final byte[] FLIP_TABLE = new byte[]{0, -128, 64, -64, 32, -96, 96, -32, 16, -112, 80, -48, 48, -80, 112, -16, 8, -120, 72, -56, 40, -88, 104, -24, 24, -104, 88, -40, 56, -72, 120, -8, 4, -124, 68, -60, 36, -92, 100, -28, 20, -108, 84, -44, 52, -76, 116, -12, 12, -116, 76, -52, 44, -84, 108, -20, 28, -100, 92, -36, 60, -68, 124, -4, 2, -126, 66, -62, 34, -94, 98, -30, 18, -110, 82, -46, 50, -78, 114, -14, 10, -118, 74, -54, 42, -86, 106, -22, 26, -102, 90, -38, 58, -70, 122, -6, 6, -122, 70, -58, 38, -90, 102, -26, 22, -106, 86, -42, 54, -74, 118, -10, 14, -114, 78, -50, 46, -82, 110, -18, 30, -98, 94, -34, 62, -66, 126, -2, 1, -127, 65, -63, 33, -95, 97, -31, 17, -111, 81, -47, 49, -79, 113, -15, 9, -119, 73, -55, 41, -87, 105, -23, 25, -103, 89, -39, 57, -71, 121, -7, 5, -123, 69, -59, 37, -91, 101, -27, 21, -107, 85, -43, 53, -75, 117, -11, 13, -115, 77, -51, 45, -83, 109, -19, 29, -99, 93, -35, 61, -67, 125, -3, 3, -125, 67, -61, 35, -93, 99, -29, 19, -109, 83, -45, 51, -77, 115, -13, 11, -117, 75, -53, 43, -85, 107, -21, 27, -101, 91, -37, 59, -69, 123, -5, 7, -121, 71, -57, 39, -89, 103, -25, 23, -105, 87, -41, 55, -73, 119, -9, 15, -113, 79, -49, 47, -81, 111, -17, 31, -97, 95, -33, 63, -65, 127, -1};

        protected FillOrderChangeInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 > 0) {
                int n4 = n + n3;
                for (int i = n; i < n4; ++i) {
                    byArray[i] = FLIP_TABLE[byArray[i] & 0xFF];
                }
            }
            return n3;
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            if (n < 0) {
                return n;
            }
            return FLIP_TABLE[n] & 0xFF;
        }
    }
}

