/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.png;

import java.awt.Color;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.xmlgraphics.image.codec.png.PNGChunk;
import org.apache.xmlgraphics.image.codec.png.PNGDecodeParam;
import org.apache.xmlgraphics.image.codec.png.PNGEncodeParam;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;
import org.apache.xmlgraphics.image.codec.util.SimpleRenderedImage;
import org.apache.xmlgraphics.image.loader.impl.PNGConstants;

class PNGImage
extends SimpleRenderedImage
implements PNGConstants {
    private static final String[] colorTypeNames = new String[]{"Grayscale", "Error", "Truecolor", "Index", "Grayscale with alpha", "Error", "Truecolor with alpha"};
    private int[][] bandOffsets = new int[][]{null, {0}, {0, 1}, {0, 1, 2}, {0, 1, 2, 3}};
    private int bitDepth;
    private int colorType;
    private int compressionMethod;
    private int filterMethod;
    private int interlaceMethod;
    private int paletteEntries;
    private byte[] redPalette;
    private byte[] greenPalette;
    private byte[] bluePalette;
    private byte[] alphaPalette;
    private int bkgdRed;
    private int bkgdGreen;
    private int bkgdBlue;
    private int grayTransparentAlpha;
    private int redTransparentAlpha;
    private int greenTransparentAlpha;
    private int blueTransparentAlpha;
    private int maxOpacity;
    private int[] significantBits;
    private boolean suppressAlpha;
    private boolean expandPalette;
    private boolean output8BitGray;
    private boolean outputHasAlphaPalette;
    private boolean performGammaCorrection;
    private boolean expandGrayAlpha;
    private boolean generateEncodeParam;
    private PNGDecodeParam decodeParam;
    private PNGEncodeParam encodeParam;
    private boolean emitProperties = true;
    private float fileGamma = 0.45455f;
    private float userExponent = 1.0f;
    private float displayExponent = 2.2f;
    private float[] chromaticity;
    private int sRGBRenderingIntent = -1;
    private int postProcess = 0;
    protected int xPixelsPerUnit;
    protected int yPixelsPerUnit;
    protected int unitSpecifier;
    private static final int POST_NONE = 0;
    private static final int POST_GAMMA = 1;
    private static final int POST_GRAY_LUT = 2;
    private static final int POST_GRAY_LUT_ADD_TRANS = 3;
    private static final int POST_PALETTE_TO_RGB = 4;
    private static final int POST_PALETTE_TO_RGBA = 5;
    private static final int POST_ADD_GRAY_TRANS = 6;
    private static final int POST_ADD_RGB_TRANS = 7;
    private static final int POST_REMOVE_GRAY_TRANS = 8;
    private static final int POST_REMOVE_RGB_TRANS = 9;
    private static final int POST_EXP_MASK = 16;
    private static final int POST_GRAY_ALPHA_EXP = 16;
    private static final int POST_GAMMA_EXP = 17;
    private static final int POST_GRAY_LUT_ADD_TRANS_EXP = 19;
    private static final int POST_ADD_GRAY_TRANS_EXP = 22;
    private List<InputStream> streamVec = new ArrayList<InputStream>();
    private DataInputStream dataStream;
    private int bytesPerPixel;
    private int inputBands;
    private int outputBands;
    private int chunkIndex;
    private List textKeys = new ArrayList();
    private List textStrings = new ArrayList();
    private List ztextKeys = new ArrayList();
    private List ztextStrings = new ArrayList();
    private WritableRaster theTile;
    private int[] gammaLut;
    private final byte[][] expandBits = new byte[][]{null, {0, -1}, {0, 85, -86, -1}, null, {0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1}};
    private int[] grayLut;
    private static final int[] GrayBits8 = new int[]{8};
    private static final ComponentColorModel colorModelGray8 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits8, false, false, 1, 0);
    private static final int[] GrayAlphaBits8 = new int[]{8, 8};
    private static final ComponentColorModel colorModelGrayAlpha8 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits8, true, false, 3, 0);
    private static final int[] GrayBits16 = new int[]{16};
    private static final ComponentColorModel colorModelGray16 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits16, false, false, 1, 1);
    private static final int[] GrayAlphaBits16 = new int[]{16, 16};
    private static final ComponentColorModel colorModelGrayAlpha16 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits16, true, false, 3, 1);
    private static final int[] GrayBits32 = new int[]{32};
    private static final ComponentColorModel colorModelGray32 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits32, false, false, 1, 3);
    private static final int[] GrayAlphaBits32 = new int[]{32, 32};
    private static final ComponentColorModel colorModelGrayAlpha32 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits32, true, false, 3, 3);
    private static final int[] RGBBits8 = new int[]{8, 8, 8};
    private static final ComponentColorModel colorModelRGB8 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits8, false, false, 1, 0);
    private static final int[] RGBABits8 = new int[]{8, 8, 8, 8};
    private static final ComponentColorModel colorModelRGBA8 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits8, true, false, 3, 0);
    private static final int[] RGBBits16 = new int[]{16, 16, 16};
    private static final ComponentColorModel colorModelRGB16 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits16, false, false, 1, 1);
    private static final int[] RGBABits16 = new int[]{16, 16, 16, 16};
    private static final ComponentColorModel colorModelRGBA16 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits16, true, false, 3, 1);
    private static final int[] RGBBits32 = new int[]{32, 32, 32};
    private static final ComponentColorModel colorModelRGB32 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits32, false, false, 1, 3);
    private static final int[] RGBABits32 = new int[]{32, 32, 32, 32};
    private static final ComponentColorModel colorModelRGBA32 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits32, true, false, 3, 3);

    private void initGammaLut(int n) {
        double d = (double)this.userExponent / (double)(this.fileGamma * this.displayExponent);
        int n2 = 1 << n;
        int n3 = n == 16 ? 65535 : 255;
        this.gammaLut = new int[n2];
        for (int i = 0; i < n2; ++i) {
            double d2 = (double)i / (double)(n2 - 1);
            double d3 = Math.pow(d2, d);
            int n4 = (int)(d3 * (double)n3 + 0.5);
            if (n4 > n3) {
                n4 = n3;
            }
            this.gammaLut[i] = n4;
        }
    }

    private void initGrayLut(int n) {
        int n2 = 1 << n;
        this.grayLut = new int[n2];
        if (this.performGammaCorrection) {
            System.arraycopy(this.gammaLut, 0, this.grayLut, 0, n2);
        } else {
            for (int i = 0; i < n2; ++i) {
                this.grayLut[i] = this.expandBits[n][i];
            }
        }
    }

    public PNGImage(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        long l = dataInputStream.readLong();
        if (l != -8552249625308161526L) {
            throw new IOException("Not a png file");
        }
        while (true) {
            PNGChunk pNGChunk;
            String string;
            if ((string = PNGChunk.getChunkType(dataInputStream)).equals(PNGChunk.ChunkType.IHDR.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_IHDR_chunk(pNGChunk);
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.pHYs.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_pHYs_chunk(pNGChunk);
                return;
            }
            if (string.equals(PNGChunk.ChunkType.IEND.name())) {
                return;
            }
            PNGChunk.readChunk(dataInputStream);
        }
    }

    public PNGImage(InputStream inputStream, PNGDecodeParam pNGDecodeParam) throws IOException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (pNGDecodeParam == null) {
            pNGDecodeParam = new PNGDecodeParam();
        }
        this.decodeParam = pNGDecodeParam;
        this.suppressAlpha = pNGDecodeParam.getSuppressAlpha();
        this.expandPalette = pNGDecodeParam.getExpandPalette();
        this.output8BitGray = pNGDecodeParam.getOutput8BitGray();
        this.expandGrayAlpha = pNGDecodeParam.getExpandGrayAlpha();
        if (pNGDecodeParam.getPerformGammaCorrection()) {
            this.userExponent = pNGDecodeParam.getUserExponent();
            this.displayExponent = pNGDecodeParam.getDisplayExponent();
            this.performGammaCorrection = true;
            this.output8BitGray = true;
        }
        this.generateEncodeParam = pNGDecodeParam.getGenerateEncodeParam();
        if (this.emitProperties) {
            this.properties.put("file_type", "PNG v. 1.0");
        }
        try {
            long l = dataInputStream.readLong();
            if (l != -8552249625308161526L) {
                String string = PropertyUtil.getString("PNGImageDecoder0");
                throw new RuntimeException(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string = PropertyUtil.getString("PNGImageDecoder1");
            throw new RuntimeException(string);
        }
        while (true) {
            Object object;
            PNGChunk pNGChunk;
            String string;
            if ((string = PNGChunk.getChunkType(dataInputStream)).equals(PNGChunk.ChunkType.IHDR.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_IHDR_chunk(pNGChunk);
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.PLTE.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_PLTE_chunk(pNGChunk);
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.IDAT.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.streamVec.add(new ByteArrayInputStream(pNGChunk.getData()));
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.IEND.name())) {
                PNGChunk pNGChunk2 = PNGChunk.readChunk(dataInputStream);
                try {
                    this.parse_IEND_chunk(pNGChunk2);
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    object = PropertyUtil.getString("PNGImageDecoder2");
                    throw new RuntimeException((String)object);
                }
            }
            if (string.equals(PNGChunk.ChunkType.bKGD.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_bKGD_chunk(pNGChunk);
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.cHRM.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_cHRM_chunk(pNGChunk);
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.gAMA.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_gAMA_chunk(pNGChunk);
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.hIST.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_hIST_chunk(pNGChunk);
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.iCCP.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_iCCP_chunk(pNGChunk);
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.pHYs.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_pHYs_chunk(pNGChunk);
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.sBIT.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_sBIT_chunk(pNGChunk);
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.sRGB.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_sRGB_chunk(pNGChunk);
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.tEXt.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_tEXt_chunk(pNGChunk);
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.tIME.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_tIME_chunk(pNGChunk);
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.tRNS.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_tRNS_chunk(pNGChunk);
                continue;
            }
            if (string.equals(PNGChunk.ChunkType.zTXt.name())) {
                pNGChunk = PNGChunk.readChunk(dataInputStream);
                this.parse_zTXt_chunk(pNGChunk);
                continue;
            }
            pNGChunk = PNGChunk.readChunk(dataInputStream);
            String string2 = pNGChunk.getTypeString();
            object = pNGChunk.getData();
            if (this.encodeParam != null) {
                this.encodeParam.addPrivateChunk(string2, (byte[])object);
            }
            if (!this.emitProperties) continue;
            String string3 = "chunk_" + this.chunkIndex++ + ':' + string2;
            this.properties.put(string3.toLowerCase(Locale.getDefault()), object);
        }
        if (this.significantBits == null) {
            this.significantBits = new int[this.inputBands];
            for (int i = 0; i < this.inputBands; ++i) {
                this.significantBits[i] = this.bitDepth;
            }
            if (this.emitProperties) {
                this.properties.put("significant_bits", this.significantBits);
            }
        }
    }

    private void parse_IHDR_chunk(PNGChunk pNGChunk) {
        this.tileWidth = this.width = pNGChunk.getInt4(0);
        this.tileHeight = this.height = pNGChunk.getInt4(4);
        this.bitDepth = pNGChunk.getInt1(8);
        if (this.bitDepth != 1 && this.bitDepth != 2 && this.bitDepth != 4 && this.bitDepth != 8 && this.bitDepth != 16) {
            String string = PropertyUtil.getString("PNGImageDecoder3");
            throw new RuntimeException(string);
        }
        this.maxOpacity = (1 << this.bitDepth) - 1;
        this.colorType = pNGChunk.getInt1(9);
        if (this.colorType != 0 && this.colorType != 2 && this.colorType != 3 && this.colorType != 4 && this.colorType != 6) {
            System.out.println(PropertyUtil.getString("PNGImageDecoder4"));
        }
        if (this.colorType == 2 && this.bitDepth < 8) {
            String string = PropertyUtil.getString("PNGImageDecoder5");
            throw new RuntimeException(string);
        }
        if (this.colorType == 3 && this.bitDepth == 16) {
            String string = PropertyUtil.getString("PNGImageDecoder6");
            throw new RuntimeException(string);
        }
        if (this.colorType == 4 && this.bitDepth < 8) {
            String string = PropertyUtil.getString("PNGImageDecoder7");
            throw new RuntimeException(string);
        }
        if (this.colorType == 6 && this.bitDepth < 8) {
            String string = PropertyUtil.getString("PNGImageDecoder8");
            throw new RuntimeException(string);
        }
        if (this.emitProperties) {
            this.properties.put("color_type", colorTypeNames[this.colorType]);
        }
        if (this.generateEncodeParam) {
            this.encodeParam = this.colorType == 3 ? new PNGEncodeParam.Palette() : (this.colorType == 0 || this.colorType == 4 ? new PNGEncodeParam.Gray() : new PNGEncodeParam.RGB());
            this.decodeParam.setEncodeParam(this.encodeParam);
        }
        if (this.encodeParam != null) {
            this.encodeParam.setBitDepth(this.bitDepth);
        }
        if (this.emitProperties) {
            this.properties.put("bit_depth", this.bitDepth);
        }
        if (this.performGammaCorrection) {
            float f = 0.45454544f * (this.displayExponent / this.userExponent);
            if (this.encodeParam != null) {
                this.encodeParam.setGamma(f);
            }
            if (this.emitProperties) {
                this.properties.put("gamma", Float.valueOf(f));
            }
        }
        this.compressionMethod = pNGChunk.getInt1(10);
        if (this.compressionMethod != 0) {
            String string = PropertyUtil.getString("PNGImageDecoder9");
            throw new RuntimeException(string);
        }
        this.filterMethod = pNGChunk.getInt1(11);
        if (this.filterMethod != 0) {
            String string = PropertyUtil.getString("PNGImageDecoder10");
            throw new RuntimeException(string);
        }
        this.interlaceMethod = pNGChunk.getInt1(12);
        if (this.interlaceMethod == 0) {
            if (this.encodeParam != null) {
                this.encodeParam.setInterlacing(false);
            }
            if (this.emitProperties) {
                this.properties.put("interlace_method", "None");
            }
        } else if (this.interlaceMethod == 1) {
            if (this.encodeParam != null) {
                this.encodeParam.setInterlacing(true);
            }
            if (this.emitProperties) {
                this.properties.put("interlace_method", "Adam7");
            }
        } else {
            String string = PropertyUtil.getString("PNGImageDecoder11");
            throw new RuntimeException(string);
        }
        this.bytesPerPixel = this.bitDepth == 16 ? 2 : 1;
        switch (this.colorType) {
            case 0: {
                this.inputBands = 1;
                this.outputBands = 1;
                if (this.output8BitGray && this.bitDepth < 8) {
                    this.postProcess = 2;
                    break;
                }
                if (this.performGammaCorrection) {
                    this.postProcess = 1;
                    break;
                }
                this.postProcess = 0;
                break;
            }
            case 2: {
                this.inputBands = 3;
                this.bytesPerPixel *= 3;
                this.outputBands = 3;
                if (this.performGammaCorrection) {
                    this.postProcess = 1;
                    break;
                }
                this.postProcess = 0;
                break;
            }
            case 3: {
                this.inputBands = 1;
                this.bytesPerPixel = 1;
                int n = this.outputBands = this.expandPalette ? 3 : 1;
                if (this.expandPalette) {
                    this.postProcess = 4;
                    break;
                }
                this.postProcess = 0;
                break;
            }
            case 4: {
                this.inputBands = 2;
                this.bytesPerPixel *= 2;
                if (this.suppressAlpha) {
                    this.outputBands = 1;
                    this.postProcess = 8;
                    break;
                }
                this.postProcess = this.performGammaCorrection ? 1 : 0;
                if (this.expandGrayAlpha) {
                    this.postProcess |= 0x10;
                    this.outputBands = 4;
                    break;
                }
                this.outputBands = 2;
                break;
            }
            case 6: {
                this.inputBands = 4;
                this.bytesPerPixel *= 4;
                int n = this.outputBands = !this.suppressAlpha ? 4 : 3;
                this.postProcess = this.suppressAlpha ? 9 : (this.performGammaCorrection ? 1 : 0);
            }
        }
    }

    private void parse_IEND_chunk(PNGChunk pNGChunk) throws Exception {
        Object object;
        String[] stringArray;
        int n;
        int n2 = this.textKeys.size();
        String[] stringArray2 = new String[2 * n2];
        for (n = 0; n < n2; ++n) {
            stringArray = (String[])this.textKeys.get(n);
            String string = (String)this.textStrings.get(n);
            stringArray2[2 * n] = stringArray;
            stringArray2[2 * n + 1] = string;
            if (!this.emitProperties) continue;
            object = "text_" + n + ':' + (String)stringArray;
            this.properties.put(((String)object).toLowerCase(Locale.getDefault()), string);
        }
        if (this.encodeParam != null) {
            this.encodeParam.setText(stringArray2);
        }
        n = this.ztextKeys.size();
        stringArray = new String[2 * n];
        for (int i = 0; i < n; ++i) {
            object = (String)this.ztextKeys.get(i);
            String string = (String)this.ztextStrings.get(i);
            stringArray[2 * i] = object;
            stringArray[2 * i + 1] = string;
            if (!this.emitProperties) continue;
            String string2 = "ztext_" + i + ':' + (String)object;
            this.properties.put(string2.toLowerCase(Locale.getDefault()), string);
        }
        if (this.encodeParam != null) {
            this.encodeParam.setCompressedText(stringArray);
        }
        SequenceInputStream sequenceInputStream = new SequenceInputStream(Collections.enumeration(this.streamVec));
        object = new InflaterInputStream(sequenceInputStream, new Inflater());
        this.dataStream = new DataInputStream((InputStream)object);
        int n3 = this.bitDepth;
        if (this.colorType == 0 && this.bitDepth < 8 && this.output8BitGray) {
            n3 = 8;
        }
        if (this.colorType == 3 && this.expandPalette) {
            n3 = 8;
        }
        int n4 = (this.outputBands * this.width * n3 + 7) / 8;
        int n5 = n3 == 16 ? n4 / 2 : n4;
        this.theTile = this.createRaster(this.width, this.height, this.outputBands, n5, n3);
        if (this.performGammaCorrection && this.gammaLut == null) {
            this.initGammaLut(this.bitDepth);
        }
        if (this.postProcess == 2 || this.postProcess == 3 || this.postProcess == 19) {
            this.initGrayLut(this.bitDepth);
        }
        this.decodeImage(this.interlaceMethod == 1);
        this.sampleModel = this.theTile.getSampleModel();
        if (this.colorType == 3 && !this.expandPalette) {
            this.colorModel = this.outputHasAlphaPalette ? new IndexColorModel(this.bitDepth, this.paletteEntries, this.redPalette, this.greenPalette, this.bluePalette, this.alphaPalette) : new IndexColorModel(this.bitDepth, this.paletteEntries, this.redPalette, this.greenPalette, this.bluePalette);
        } else if (this.colorType == 0 && this.bitDepth < 8 && !this.output8BitGray) {
            byte[] byArray = this.expandBits[this.bitDepth];
            this.colorModel = new IndexColorModel(this.bitDepth, byArray.length, byArray, byArray, byArray);
        } else {
            this.colorModel = PNGImage.createComponentColorModel(this.sampleModel);
        }
    }

    public static ColorModel createComponentColorModel(SampleModel sampleModel) {
        int n = sampleModel.getDataType();
        int n2 = sampleModel.getNumBands();
        ComponentColorModel componentColorModel = null;
        if (n == 0) {
            switch (n2) {
                case 1: {
                    componentColorModel = colorModelGray8;
                    break;
                }
                case 2: {
                    componentColorModel = colorModelGrayAlpha8;
                    break;
                }
                case 3: {
                    componentColorModel = colorModelRGB8;
                    break;
                }
                case 4: {
                    componentColorModel = colorModelRGBA8;
                }
            }
        } else if (n == 1) {
            switch (n2) {
                case 1: {
                    componentColorModel = colorModelGray16;
                    break;
                }
                case 2: {
                    componentColorModel = colorModelGrayAlpha16;
                    break;
                }
                case 3: {
                    componentColorModel = colorModelRGB16;
                    break;
                }
                case 4: {
                    componentColorModel = colorModelRGBA16;
                }
            }
        } else if (n == 3) {
            switch (n2) {
                case 1: {
                    componentColorModel = colorModelGray32;
                    break;
                }
                case 2: {
                    componentColorModel = colorModelGrayAlpha32;
                    break;
                }
                case 3: {
                    componentColorModel = colorModelRGB32;
                    break;
                }
                case 4: {
                    componentColorModel = colorModelRGBA32;
                }
            }
        }
        return componentColorModel;
    }

    private void parse_PLTE_chunk(PNGChunk pNGChunk) {
        this.paletteEntries = pNGChunk.getLength() / 3;
        this.redPalette = new byte[this.paletteEntries];
        this.greenPalette = new byte[this.paletteEntries];
        this.bluePalette = new byte[this.paletteEntries];
        int n = 0;
        if (this.performGammaCorrection) {
            if (this.gammaLut == null) {
                this.initGammaLut(this.bitDepth == 16 ? 16 : 8);
            }
            for (int i = 0; i < this.paletteEntries; ++i) {
                byte by = pNGChunk.getByte(n++);
                byte by2 = pNGChunk.getByte(n++);
                byte by3 = pNGChunk.getByte(n++);
                this.redPalette[i] = (byte)this.gammaLut[by & 0xFF];
                this.greenPalette[i] = (byte)this.gammaLut[by2 & 0xFF];
                this.bluePalette[i] = (byte)this.gammaLut[by3 & 0xFF];
            }
        } else {
            for (int i = 0; i < this.paletteEntries; ++i) {
                this.redPalette[i] = pNGChunk.getByte(n++);
                this.greenPalette[i] = pNGChunk.getByte(n++);
                this.bluePalette[i] = pNGChunk.getByte(n++);
            }
        }
    }

    private void parse_bKGD_chunk(PNGChunk pNGChunk) {
        int n;
        int n2;
        switch (this.colorType) {
            case 3: {
                n2 = pNGChunk.getByte(0) & 0xFF;
                this.bkgdRed = this.redPalette[n2] & 0xFF;
                this.bkgdGreen = this.greenPalette[n2] & 0xFF;
                this.bkgdBlue = this.bluePalette[n2] & 0xFF;
                if (this.encodeParam == null) break;
                ((PNGEncodeParam.Palette)this.encodeParam).setBackgroundPaletteIndex(n2);
                break;
            }
            case 0: 
            case 4: {
                this.bkgdGreen = this.bkgdBlue = (n = pNGChunk.getInt2(0));
                this.bkgdRed = this.bkgdBlue;
                if (this.encodeParam == null) break;
                ((PNGEncodeParam.Gray)this.encodeParam).setBackgroundGray(n);
                break;
            }
            case 2: 
            case 6: {
                this.bkgdRed = pNGChunk.getInt2(0);
                this.bkgdGreen = pNGChunk.getInt2(2);
                this.bkgdBlue = pNGChunk.getInt2(4);
                int[] nArray = new int[]{this.bkgdRed, this.bkgdGreen, this.bkgdBlue};
                if (this.encodeParam == null) break;
                ((PNGEncodeParam.RGB)this.encodeParam).setBackgroundRGB(nArray);
            }
        }
        n2 = 0;
        n = 0;
        int n3 = 0;
        if (this.bitDepth < 8) {
            n2 = this.expandBits[this.bitDepth][this.bkgdRed];
            n = this.expandBits[this.bitDepth][this.bkgdGreen];
            n3 = this.expandBits[this.bitDepth][this.bkgdBlue];
        } else if (this.bitDepth == 8) {
            n2 = this.bkgdRed;
            n = this.bkgdGreen;
            n3 = this.bkgdBlue;
        } else if (this.bitDepth == 16) {
            n2 = this.bkgdRed >> 8;
            n = this.bkgdGreen >> 8;
            n3 = this.bkgdBlue >> 8;
        }
        if (this.emitProperties) {
            this.properties.put("background_color", new Color(n2, n, n3));
        }
    }

    private void parse_cHRM_chunk(PNGChunk pNGChunk) {
        if (this.sRGBRenderingIntent != -1) {
            return;
        }
        this.chromaticity = new float[8];
        this.chromaticity[0] = (float)pNGChunk.getInt4(0) / 100000.0f;
        this.chromaticity[1] = (float)pNGChunk.getInt4(4) / 100000.0f;
        this.chromaticity[2] = (float)pNGChunk.getInt4(8) / 100000.0f;
        this.chromaticity[3] = (float)pNGChunk.getInt4(12) / 100000.0f;
        this.chromaticity[4] = (float)pNGChunk.getInt4(16) / 100000.0f;
        this.chromaticity[5] = (float)pNGChunk.getInt4(20) / 100000.0f;
        this.chromaticity[6] = (float)pNGChunk.getInt4(24) / 100000.0f;
        this.chromaticity[7] = (float)pNGChunk.getInt4(28) / 100000.0f;
        if (this.encodeParam != null) {
            this.encodeParam.setChromaticity(this.chromaticity);
        }
        if (this.emitProperties) {
            this.properties.put("white_point_x", Float.valueOf(this.chromaticity[0]));
            this.properties.put("white_point_y", Float.valueOf(this.chromaticity[1]));
            this.properties.put("red_x", Float.valueOf(this.chromaticity[2]));
            this.properties.put("red_y", Float.valueOf(this.chromaticity[3]));
            this.properties.put("green_x", Float.valueOf(this.chromaticity[4]));
            this.properties.put("green_y", Float.valueOf(this.chromaticity[5]));
            this.properties.put("blue_x", Float.valueOf(this.chromaticity[6]));
            this.properties.put("blue_y", Float.valueOf(this.chromaticity[7]));
        }
    }

    private void parse_gAMA_chunk(PNGChunk pNGChunk) {
        float f;
        if (this.sRGBRenderingIntent != -1) {
            return;
        }
        this.fileGamma = (float)pNGChunk.getInt4(0) / 100000.0f;
        float f2 = f = this.performGammaCorrection ? this.displayExponent / this.userExponent : 1.0f;
        if (this.encodeParam != null) {
            this.encodeParam.setGamma(this.fileGamma * f);
        }
        if (this.emitProperties) {
            this.properties.put("gamma", Float.valueOf(this.fileGamma * f));
        }
    }

    private void parse_hIST_chunk(PNGChunk pNGChunk) {
        if (this.redPalette == null) {
            String string = PropertyUtil.getString("PNGImageDecoder18");
            throw new RuntimeException(string);
        }
        int n = this.redPalette.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = pNGChunk.getInt2(2 * i);
        }
        if (this.encodeParam != null) {
            this.encodeParam.setPaletteHistogram(nArray);
        }
    }

    private void parse_iCCP_chunk(PNGChunk pNGChunk) {
    }

    private void parse_pHYs_chunk(PNGChunk pNGChunk) {
        this.xPixelsPerUnit = pNGChunk.getInt4(0);
        this.yPixelsPerUnit = pNGChunk.getInt4(4);
        this.unitSpecifier = pNGChunk.getInt1(8);
        if (this.encodeParam != null) {
            this.encodeParam.setPhysicalDimension(this.xPixelsPerUnit, this.yPixelsPerUnit, this.unitSpecifier);
        }
        if (this.emitProperties) {
            this.properties.put("x_pixels_per_unit", this.xPixelsPerUnit);
            this.properties.put("y_pixels_per_unit", this.yPixelsPerUnit);
            this.properties.put("pixel_aspect_ratio", Float.valueOf((float)this.xPixelsPerUnit / (float)this.yPixelsPerUnit));
            if (this.unitSpecifier == 1) {
                this.properties.put("pixel_units", "Meters");
            } else if (this.unitSpecifier != 0) {
                String string = PropertyUtil.getString("PNGImageDecoder12");
                throw new RuntimeException(string);
            }
        }
    }

    private void parse_sBIT_chunk(PNGChunk pNGChunk) {
        this.significantBits = this.colorType == 3 ? new int[3] : new int[this.inputBands];
        for (int i = 0; i < this.significantBits.length; ++i) {
            int n;
            int n2 = pNGChunk.getByte(i);
            int n3 = n = this.colorType == 3 ? 8 : this.bitDepth;
            if (n2 <= 0 || n2 > n) {
                String string = PropertyUtil.getString("PNGImageDecoder13");
                throw new RuntimeException(string);
            }
            this.significantBits[i] = n2;
        }
        if (this.encodeParam != null) {
            this.encodeParam.setSignificantBits(this.significantBits);
        }
        if (this.emitProperties) {
            this.properties.put("significant_bits", this.significantBits);
        }
    }

    private void parse_sRGB_chunk(PNGChunk pNGChunk) {
        this.sRGBRenderingIntent = pNGChunk.getByte(0);
        this.fileGamma = 0.45455f;
        this.chromaticity = new float[8];
        this.chromaticity[0] = 3.127f;
        this.chromaticity[1] = 3.29f;
        this.chromaticity[2] = 6.4f;
        this.chromaticity[3] = 3.3f;
        this.chromaticity[4] = 3.0f;
        this.chromaticity[5] = 6.0f;
        this.chromaticity[6] = 1.5f;
        this.chromaticity[7] = 0.6f;
        if (this.performGammaCorrection) {
            float f = this.fileGamma * (this.displayExponent / this.userExponent);
            if (this.encodeParam != null) {
                this.encodeParam.setGamma(f);
                this.encodeParam.setChromaticity(this.chromaticity);
            }
            if (this.emitProperties) {
                this.properties.put("gamma", Float.valueOf(f));
                this.properties.put("white_point_x", Float.valueOf(this.chromaticity[0]));
                this.properties.put("white_point_y", Float.valueOf(this.chromaticity[1]));
                this.properties.put("red_x", Float.valueOf(this.chromaticity[2]));
                this.properties.put("red_y", Float.valueOf(this.chromaticity[3]));
                this.properties.put("green_x", Float.valueOf(this.chromaticity[4]));
                this.properties.put("green_y", Float.valueOf(this.chromaticity[5]));
                this.properties.put("blue_x", Float.valueOf(this.chromaticity[6]));
                this.properties.put("blue_y", Float.valueOf(this.chromaticity[7]));
            }
        }
    }

    private void parse_tEXt_chunk(PNGChunk pNGChunk) {
        byte by;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((by = pNGChunk.getByte(n++)) != 0) {
            stringBuffer.append((char)by);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < pNGChunk.getLength(); ++i) {
            stringBuilder.append((char)pNGChunk.getByte(i));
        }
        this.textKeys.add(stringBuffer.toString());
        this.textStrings.add(stringBuilder.toString());
    }

    private void parse_tIME_chunk(PNGChunk pNGChunk) {
        int n = pNGChunk.getInt2(0);
        int n2 = pNGChunk.getInt1(2) - 1;
        int n3 = pNGChunk.getInt1(3);
        int n4 = pNGChunk.getInt1(4);
        int n5 = pNGChunk.getInt1(5);
        int n6 = pNGChunk.getInt1(6);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.set(n, n2, n3, n4, n5, n6);
        Date date = gregorianCalendar.getTime();
        if (this.encodeParam != null) {
            this.encodeParam.setModificationTime(date);
        }
        if (this.emitProperties) {
            this.properties.put("timestamp", date);
        }
    }

    private void parse_tRNS_chunk(PNGChunk pNGChunk) {
        if (this.colorType == 3) {
            int n;
            int n2 = pNGChunk.getLength();
            if (n2 > this.paletteEntries) {
                String string = PropertyUtil.getString("PNGImageDecoder14");
                throw new RuntimeException(string);
            }
            this.alphaPalette = new byte[this.paletteEntries];
            for (n = 0; n < n2; ++n) {
                this.alphaPalette[n] = pNGChunk.getByte(n);
            }
            for (n = n2; n < this.paletteEntries; ++n) {
                this.alphaPalette[n] = -1;
            }
            if (!this.suppressAlpha) {
                if (this.expandPalette) {
                    this.postProcess = 5;
                    this.outputBands = 4;
                } else {
                    this.outputHasAlphaPalette = true;
                }
            }
        } else if (this.colorType == 0) {
            this.grayTransparentAlpha = pNGChunk.getInt2(0);
            if (!this.suppressAlpha) {
                if (this.bitDepth < 8) {
                    this.output8BitGray = true;
                    this.maxOpacity = 255;
                    this.postProcess = 3;
                } else {
                    this.postProcess = 6;
                }
                if (this.expandGrayAlpha) {
                    this.outputBands = 4;
                    this.postProcess |= 0x10;
                } else {
                    this.outputBands = 2;
                }
                if (this.encodeParam != null) {
                    ((PNGEncodeParam.Gray)this.encodeParam).setTransparentGray(this.grayTransparentAlpha);
                }
            }
        } else if (this.colorType == 2) {
            this.redTransparentAlpha = pNGChunk.getInt2(0);
            this.greenTransparentAlpha = pNGChunk.getInt2(2);
            this.blueTransparentAlpha = pNGChunk.getInt2(4);
            if (!this.suppressAlpha) {
                this.outputBands = 4;
                this.postProcess = 7;
                if (this.encodeParam != null) {
                    int[] nArray = new int[]{this.redTransparentAlpha, this.greenTransparentAlpha, this.blueTransparentAlpha};
                    ((PNGEncodeParam.RGB)this.encodeParam).setTransparentRGB(nArray);
                }
            }
        } else if (this.colorType == 4 || this.colorType == 6) {
            String string = PropertyUtil.getString("PNGImageDecoder15");
            throw new RuntimeException(string);
        }
    }

    private void parse_zTXt_chunk(PNGChunk pNGChunk) {
        byte by;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((by = pNGChunk.getByte(n++)) != 0) {
            stringBuffer.append((char)by);
        }
        pNGChunk.getByte(n++);
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            int n2;
            int n3 = pNGChunk.getLength() - n;
            byte[] byArray = pNGChunk.getData();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n3);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
            while ((n2 = ((InputStream)inflaterInputStream).read()) != -1) {
                stringBuffer2.append((char)n2);
            }
            this.ztextKeys.add(stringBuffer.toString());
            this.ztextStrings.add(stringBuffer2.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private WritableRaster createRaster(int n, int n2, int n3, int n4, int n5) {
        WritableRaster writableRaster = null;
        Point point = new Point(0, 0);
        if (n5 < 8 && n3 == 1) {
            DataBufferByte dataBufferByte = new DataBufferByte(n2 * n4);
            writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n5, point);
        } else if (n5 <= 8) {
            DataBufferByte dataBufferByte = new DataBufferByte(n2 * n4);
            writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n4, n3, this.bandOffsets[n3], point);
        } else {
            DataBufferUShort dataBufferUShort = new DataBufferUShort(n2 * n4);
            writableRaster = Raster.createInterleavedRaster(dataBufferUShort, n, n2, n4, n3, this.bandOffsets[n3], point);
        }
        return writableRaster;
    }

    private static void decodeSubFilter(byte[] byArray, int n, int n2) {
        for (int i = n2; i < n; ++i) {
            int n3 = byArray[i] & 0xFF;
            byArray[i] = (byte)(n3 += byArray[i - n2] & 0xFF);
        }
    }

    private static void decodeUpFilter(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            int n3 = byArray2[i] & 0xFF;
            byArray[i] = (byte)(n2 + n3);
        }
    }

    private static void decodeAverageFilter(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = byArray[n5] & 0xFF;
            n3 = byArray2[n5] & 0xFF;
            byArray[n5] = (byte)(n4 + n3 / 2);
        }
        for (n5 = n2; n5 < n; ++n5) {
            n4 = byArray[n5] & 0xFF;
            int n6 = byArray[n5 - n2] & 0xFF;
            n3 = byArray2[n5] & 0xFF;
            byArray[n5] = (byte)(n4 + (n6 + n3) / 2);
        }
    }

    private static void decodePaethFilter(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = byArray[n5] & 0xFF;
            n3 = byArray2[n5] & 0xFF;
            byArray[n5] = (byte)(n4 + n3);
        }
        for (n5 = n2; n5 < n; ++n5) {
            n4 = byArray[n5] & 0xFF;
            int n6 = byArray[n5 - n2] & 0xFF;
            n3 = byArray2[n5] & 0xFF;
            int n7 = byArray2[n5 - n2] & 0xFF;
            byArray[n5] = (byte)(n4 + PNGEncodeParam.paethPredictor(n6, n3, n7));
        }
    }

    private void processPixels(int n, Raster raster, WritableRaster writableRaster, int n2, int n3, int n4, int n5) {
        int[] nArray = raster.getPixel(0, 0, (int[])null);
        int[] nArray2 = writableRaster.getPixel(0, 0, (int[])null);
        int n6 = n2;
        switch (n) {
            case 0: {
                for (int i = 0; i < n5; ++i) {
                    raster.getPixel(i, 0, nArray);
                    writableRaster.setPixel(n6, n4, nArray);
                    n6 += n3;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < n5; ++i) {
                    raster.getPixel(i, 0, nArray);
                    for (int j = 0; j < this.inputBands; ++j) {
                        int n7 = nArray[j];
                        nArray[j] = this.gammaLut[n7];
                    }
                    writableRaster.setPixel(n6, n4, nArray);
                    n6 += n3;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n5; ++i) {
                    raster.getPixel(i, 0, nArray);
                    nArray2[0] = this.grayLut[nArray[0]];
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < n5; ++i) {
                    raster.getPixel(i, 0, nArray);
                    int n8 = nArray[0];
                    nArray2[0] = this.grayLut[n8];
                    nArray2[1] = n8 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n5; ++i) {
                    raster.getPixel(i, 0, nArray);
                    int n9 = nArray[0];
                    nArray2[0] = this.redPalette[n9];
                    nArray2[1] = this.greenPalette[n9];
                    nArray2[2] = this.bluePalette[n9];
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                }
                break;
            }
            case 5: {
                for (int i = 0; i < n5; ++i) {
                    raster.getPixel(i, 0, nArray);
                    int n10 = nArray[0];
                    nArray2[0] = this.redPalette[n10];
                    nArray2[1] = this.greenPalette[n10];
                    nArray2[2] = this.bluePalette[n10];
                    nArray2[3] = this.alphaPalette[n10];
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < n5; ++i) {
                    raster.getPixel(i, 0, nArray);
                    int n11 = nArray[0];
                    if (this.performGammaCorrection) {
                        n11 = this.gammaLut[n11];
                    }
                    nArray2[0] = n11;
                    nArray2[1] = n11 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                }
                break;
            }
            case 7: {
                for (int i = 0; i < n5; ++i) {
                    raster.getPixel(i, 0, nArray);
                    int n12 = nArray[0];
                    int n13 = nArray[1];
                    int n14 = nArray[2];
                    if (this.performGammaCorrection) {
                        nArray2[0] = this.gammaLut[n12];
                        nArray2[1] = this.gammaLut[n13];
                        nArray2[2] = this.gammaLut[n14];
                    } else {
                        nArray2[0] = n12;
                        nArray2[1] = n13;
                        nArray2[2] = n14;
                    }
                    nArray2[3] = n12 == this.redTransparentAlpha && n13 == this.greenTransparentAlpha && n14 == this.blueTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                }
                break;
            }
            case 8: {
                for (int i = 0; i < n5; ++i) {
                    raster.getPixel(i, 0, nArray);
                    int n15 = nArray[0];
                    nArray2[0] = this.performGammaCorrection ? this.gammaLut[n15] : n15;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                }
                break;
            }
            case 9: {
                for (int i = 0; i < n5; ++i) {
                    raster.getPixel(i, 0, nArray);
                    int n16 = nArray[0];
                    int n17 = nArray[1];
                    int n18 = nArray[2];
                    if (this.performGammaCorrection) {
                        nArray2[0] = this.gammaLut[n16];
                        nArray2[1] = this.gammaLut[n17];
                        nArray2[2] = this.gammaLut[n18];
                    } else {
                        nArray2[0] = n16;
                        nArray2[1] = n17;
                        nArray2[2] = n18;
                    }
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                }
                break;
            }
            case 17: {
                for (int i = 0; i < n5; ++i) {
                    int n19;
                    raster.getPixel(i, 0, nArray);
                    int n20 = nArray[0];
                    int n21 = nArray[1];
                    nArray2[0] = n19 = this.gammaLut[n20];
                    nArray2[1] = n19;
                    nArray2[2] = n19;
                    nArray2[3] = n21;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                }
                break;
            }
            case 16: {
                for (int i = 0; i < n5; ++i) {
                    raster.getPixel(i, 0, nArray);
                    int n22 = nArray[0];
                    int n23 = nArray[1];
                    nArray2[0] = n22;
                    nArray2[1] = n22;
                    nArray2[2] = n22;
                    nArray2[3] = n23;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                }
                break;
            }
            case 22: {
                for (int i = 0; i < n5; ++i) {
                    raster.getPixel(i, 0, nArray);
                    int n24 = nArray[0];
                    if (this.performGammaCorrection) {
                        n24 = this.gammaLut[n24];
                    }
                    nArray2[0] = n24;
                    nArray2[1] = n24;
                    nArray2[2] = n24;
                    nArray2[3] = n24 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                }
                break;
            }
            case 19: {
                for (int i = 0; i < n5; ++i) {
                    int n25;
                    raster.getPixel(i, 0, nArray);
                    int n26 = nArray[0];
                    nArray2[0] = n25 = this.grayLut[n26];
                    nArray2[1] = n25;
                    nArray2[2] = n25;
                    nArray2[3] = n26 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                }
                break;
            }
        }
    }

    private void decodePass(WritableRaster writableRaster, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == 0 || n6 == 0) {
            return;
        }
        int n7 = (this.inputBands * n5 * this.bitDepth + 7) / 8;
        int n8 = this.bitDepth == 16 ? n7 / 2 : n7;
        Object object = new byte[n7];
        byte[] byArray = new byte[n7];
        WritableRaster writableRaster2 = this.createRaster(n5, 1, this.inputBands, n8, this.bitDepth);
        DataBuffer dataBuffer = writableRaster2.getDataBuffer();
        int n9 = dataBuffer.getDataType();
        byte[] byArray2 = null;
        short[] sArray = null;
        if (n9 == 0) {
            byArray2 = ((DataBufferByte)dataBuffer).getData();
        } else {
            sArray = ((DataBufferUShort)dataBuffer).getData();
        }
        int n10 = 0;
        int n11 = n2;
        while (n10 < n6) {
            Object object2;
            int n12 = 0;
            try {
                n12 = this.dataStream.read();
                this.dataStream.readFully((byte[])object, 0, n7);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            switch (n12) {
                case 0: {
                    break;
                }
                case 1: {
                    PNGImage.decodeSubFilter(object, n7, this.bytesPerPixel);
                    break;
                }
                case 2: {
                    PNGImage.decodeUpFilter(object, byArray, n7);
                    break;
                }
                case 3: {
                    PNGImage.decodeAverageFilter(object, byArray, n7, this.bytesPerPixel);
                    break;
                }
                case 4: {
                    PNGImage.decodePaethFilter(object, byArray, n7, this.bytesPerPixel);
                    break;
                }
                default: {
                    object2 = PropertyUtil.getString("PNGImageDecoder16");
                    throw new RuntimeException((String)object2);
                }
            }
            if (this.bitDepth < 16) {
                System.arraycopy(object, 0, byArray2, 0, n7);
            } else {
                int n13 = 0;
                for (int i = 0; i < n8; ++i) {
                    sArray[i] = (short)(object[n13] << 8 | object[n13 + 1] & 0xFF);
                    n13 += 2;
                }
            }
            this.processPixels(this.postProcess, writableRaster2, writableRaster, n, n3, n11, n5);
            object2 = byArray;
            byArray = object;
            object = object2;
            ++n10;
            n11 += n4;
        }
    }

    private void decodeImage(boolean bl) {
        if (!bl) {
            this.decodePass(this.theTile, 0, 0, 1, 1, this.width, this.height);
        } else {
            this.decodePass(this.theTile, 0, 0, 8, 8, (this.width + 7) / 8, (this.height + 7) / 8);
            this.decodePass(this.theTile, 4, 0, 8, 8, (this.width + 3) / 8, (this.height + 7) / 8);
            this.decodePass(this.theTile, 0, 4, 4, 8, (this.width + 3) / 4, (this.height + 3) / 8);
            this.decodePass(this.theTile, 2, 0, 4, 4, (this.width + 1) / 4, (this.height + 3) / 4);
            this.decodePass(this.theTile, 0, 2, 2, 4, (this.width + 1) / 2, (this.height + 1) / 4);
            this.decodePass(this.theTile, 1, 0, 2, 2, this.width / 2, (this.height + 1) / 2);
            this.decodePass(this.theTile, 0, 1, 1, 2, this.width, this.height / 2);
        }
    }

    @Override
    public Raster getTile(int n, int n2) {
        if (n != 0 || n2 != 0) {
            String string = PropertyUtil.getString("PNGImageDecoder17");
            throw new IllegalArgumentException(string);
        }
        return this.theTile;
    }
}

